/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.SurrogateSearchRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomHeadersRoot
extends HeadersRoot
implements SurrogateSearchRoot {
    @Nullable
    private final VirtualFile myRoot;
    @NotNull
    protected final List<VirtualFile> myHeaders;
    private final HeadersSearchPath.Kind myKind;
    private final int myHashCodeCache;

    protected CustomHeadersRoot(@NotNull Project project, @Nullable VirtualFile root, @NotNull Collection<VirtualFile> headers, @NotNull HeadersSearchPath.Kind kind) {
        if (project == null) {
            CustomHeadersRoot.$$$reportNull$$$0(0);
        }
        if (headers == null) {
            CustomHeadersRoot.$$$reportNull$$$0(1);
        }
        if (kind == null) {
            CustomHeadersRoot.$$$reportNull$$$0(2);
        }
        super(project);
        this.myRoot = root;
        ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>(headers);
        this.myHeaders = ContainerUtil.unmodifiableOrEmptyList(filesList);
        this.myKind = kind;
        int hashCode = Objects.hashCode(this.myRoot);
        hashCode = 31 * hashCode + this.myHeaders.hashCode();
        this.myHashCodeCache = hashCode = 31 * hashCode + this.myKind.ordinal();
    }

    @Nls
    @NotNull
    public String getPresentableName() {
        String string = OCBundle.message("header.search.root.custom.headers", new Object[0]);
        if (string == null) {
            CustomHeadersRoot.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public HeadersSearchPath.Kind getKind() {
        HeadersSearchPath.Kind kind = this.myKind;
        if (kind == null) {
            CustomHeadersRoot.$$$reportNull$$$0(4);
        }
        return kind;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myRoot;
    }

    @NotNull
    public List<VirtualFile> getHeaders() {
        List<VirtualFile> list = this.myHeaders;
        if (list == null) {
            CustomHeadersRoot.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean isValid() {
        return this.myRoot == null || this.myRoot.isValid();
    }

    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor2) {
        if (processor2 == null) {
            CustomHeadersRoot.$$$reportNull$$$0(6);
        }
        if (processor2 instanceof HeadersSearchRootProcessor && ((HeadersSearchRootProcessor)processor2).shouldProcessRootsOnly()) {
            return true;
        }
        return this.processCustomFileSet(processor2, this.myHeaders, false);
    }

    public String toString() {
        return this.getName() + ", size: " + this.myHeaders.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomHeadersRoot root = (CustomHeadersRoot)o;
        return this.myKind == root.myKind && this.myHashCodeCache == root.myHashCodeCache && Objects.equals(this.myRoot, root.myRoot) && this.myHeaders.equals(root.myHeaders);
    }

    public int hashCode() {
        return this.myHashCodeCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/CustomHeadersRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/CustomHeadersRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

