/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardDetector;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclarationList;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUndefDirective;
import com.jetbrains.cidr.lang.psi.OCUnion;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OCDeclarationKind {
    Import(PluginUtils.hasAppCode() ? "Imports" : "Includes", OCIncludeDirective.class),
    Macro(OCDefineDirective.class, OCUndefDirective.class),
    Typedef(new Class[]{OCDeclaration.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCDeclaration && ((OCDeclaration)element).isTypedef();
        }
    }
    ,
    Enum("Enumerations", new Class[]{OCEnum.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            OCTypeElement typeElement;
            if (element instanceof OCDeclaration && this.isKindOf((typeElement = ((OCDeclaration)element).getTypeElement()) != null ? typeElement.getFirstChild() : null)) {
                return true;
            }
            return super.isKindOf(element);
        }
    }
    ,
    Constant(new Class[]{OCDeclaration.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            if (!(element instanceof OCDeclaration)) {
                return false;
            }
            List<OCDeclarator> declarators = ((OCDeclaration)element).getDeclarators();
            OCSymbol symbol = declarators.isEmpty() ? null : declarators.get(0).getSymbol();
            return symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isConst();
        }
    }
    ,
    Global("Global variables", new Class[]{OCDeclaration.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCDeclaration && !Typedef.isKindOf(element) && !Constant.isKindOf(element) && !Function.isKindOf(element) && !FunctionPredecl.isKindOf(element);
        }
    }
    ,
    Struct("Structs, unions and C++ classes", new Class[]{OCStruct.class, OCUnion.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            OCTypeElement typeElement;
            if (element instanceof OCDeclaration && this.isKindOf((typeElement = ((OCDeclaration)element).getTypeElement()) != null ? typeElement.getFirstChild() : null)) {
                return true;
            }
            return super.isKindOf(element);
        }
    }
    ,
    ClassPredef("Objective-C class predeclarations", true, OCClassPredeclarationList.class),
    FunctionPredecl("Function predeclarations", new Class[]{OCFunctionDeclaration.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCFunctionDeclaration && !Function.isKindOf(element);
        }
    }
    ,
    Function(OCFunctionDefinition.class),
    Class("Objective-C classes and protocols", true, OCClassDeclaration.class),
    Property(OCProperty.class),
    Synthesize(OCSynthesizePropertiesList.class),
    InitMethod("Init methods", new Class[]{OCMethod.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCMethod && OCElementUtil.startsWithWord(((OCMethod)element).getSelector(), "init");
        }
    }
    ,
    StaticMethod("Class methods", new Class[]{OCMethod.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCMethod && !((OCMethod)element).isInstanceMethod();
        }
    }
    ,
    InstanceMethod("Instance methods", new Class[]{OCMethod.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCMethod && ((OCMethod)element).isInstanceMethod();
        }
    }
    ,
    DeallocMethod("Dealloc method", new Class[]{OCMethod.class}){

        @Override
        public boolean isKindOf(PsiElement element) {
            return element instanceof OCMethod && ((OCMethod)element).getSelector().equals("dealloc");
        }
    };

    private final String myName;
    private final boolean myObjectiveC;
    private final Class<? extends OCElement>[] myClasses;
    public static final List<OCDeclarationKind> ourFileDeclarationKinds;
    public static final List<OCDeclarationKind> ourClassDeclarationKinds;
    public static final List<OCDeclarationKind> ourMethodKinds;

    @SafeVarargs
    private OCDeclarationKind(Class<? extends OCElement> ... classes) {
        this.myName = StringUtil.pluralize((String)this.name());
        this.myObjectiveC = false;
        this.myClasses = classes;
    }

    @SafeVarargs
    private OCDeclarationKind(String name, Class<? extends OCElement> ... classes) {
        this(name, false, classes);
    }

    @SafeVarargs
    private OCDeclarationKind(String name, boolean isObjectiveC, Class<? extends OCElement> ... classes) {
        this.myName = name;
        this.myObjectiveC = isObjectiveC;
        this.myClasses = classes;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isAvailable() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        return OCLanguage.enableObjectiveCSettings() || !this.myObjectiveC;
    }

    public boolean isKindOf(PsiElement element) {
        for (Class<? extends OCElement> aClass : this.myClasses) {
            if (!aClass.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    private static List<OCDeclarationKind> getKindsOrder(@NotNull PsiElement parent) {
        if (parent == null) {
            OCDeclarationKind.$$$reportNull$$$0(0);
        }
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)parent.getContainingFile(), OCCodeStyleSettings.class);
        return parent instanceof OCFile ? settings.FILE_DECLARATIONS_ORDER : settings.CLASS_DECLARATIONS_ORDER;
    }

    @Nullable
    public static OCDeclarationKind getDeclarationKind(PsiElement element) {
        for (OCDeclarationKind kind : OCDeclarationKind.values()) {
            if (!kind.isKindOf(element)) continue;
            return kind;
        }
        return null;
    }

    private static int getDefaultEndOffset(PsiElement parent) {
        if (parent instanceof OCClassDeclaration) {
            PsiElement nonEmptyElement;
            OCInstanceVariablesList child = ((OCClassDeclaration)parent).getInstanceVariablesList();
            if (child.getTextLength() == 0 && (nonEmptyElement = OCElementUtil.getPreviousNonEmptyElement(child)) != null) {
                child = nonEmptyElement;
            }
            return child.getTextOffset() + child.getTextLength();
        }
        return -1;
    }

    public int getChildrenStartOffset(@NotNull PsiElement parent) {
        if (parent == null) {
            OCDeclarationKind.$$$reportNull$$$0(1);
        }
        return this.getChildrenStartOffset(parent, false);
    }

    public int getChildrenStartOffset(@NotNull PsiElement parent, boolean includeAdjacentWhitespaces) {
        List<OCDeclarationKind> kinds;
        int index;
        if (parent == null) {
            OCDeclarationKind.$$$reportNull$$$0(2);
        }
        PsiElement[] children = parent.getChildren();
        if (!includeAdjacentWhitespaces) {
            for (PsiElement aChildren : children) {
                if (!this.isKindOf(aChildren)) continue;
                TextRange range = aChildren.getTextRange();
                return range.getStartOffset();
            }
        }
        if ((index = (kinds = OCDeclarationKind.getKindsOrder(parent)).indexOf((Object)this)) <= 0) {
            return OCDeclarationKind.getDefaultEndOffset(parent);
        }
        return kinds.get(index - 1).getChildrenEndOffset(parent);
    }

    public int getChildrenEndOffset(PsiElement parent) {
        List<OCDeclarationKind> kinds = OCDeclarationKind.getKindsOrder(parent);
        int index = kinds.indexOf((Object)this);
        PsiElement[] children = parent.getChildren();
        if (index == -1) {
            return OCDeclarationKind.getDefaultEndOffset(parent);
        }
        int endOffsetBefore = OCDeclarationKind.getEndOffsetBefore(index, parent.getContainingFile(), children, kinds);
        if (endOffsetBefore != -1) {
            return endOffsetBefore;
        }
        int endOffsetAfter = OCDeclarationKind.getEndOffsetAfter(index, children, kinds);
        if (endOffsetAfter != -1) {
            return endOffsetAfter;
        }
        return OCDeclarationKind.getDefaultEndOffset(parent);
    }

    private static int getEndOffsetBefore(int index, PsiFile file, PsiElement[] children, List<OCDeclarationKind> kinds) {
        int result = -1;
        int headerGuardEndOffset = -1;
        OCHeaderGuardInfo headerGuard = file instanceof OCFile && ((OCFile)file).isHeader() ? OCHeaderGuardDetector.findCachedHeaderGuard(file, false) : null;
        OCDefineDirective headerGuardDefineDirective = headerGuard != null ? headerGuard.getDefineDirective() : null;
        for (int i = index; i >= 0; --i) {
            OCDeclarationKind kind = kinds.get(i);
            for (int j = children.length - 1; j >= 0; --j) {
                if (!kind.isKindOf(children[j])) continue;
                int offset = children[j].getTextRange().getEndOffset() + (children[j] instanceof OCIncludeDirective ? 1 : 0);
                if (children[j] == headerGuardDefineDirective) {
                    headerGuardEndOffset = offset;
                    continue;
                }
                result = result == -1 || result < offset ? offset : result;
            }
            if (result == -1) continue;
            return result;
        }
        return headerGuardEndOffset;
    }

    private static int getEndOffsetAfter(int index, PsiElement[] children, List<OCDeclarationKind> kinds) {
        int result = -1;
        for (int i = index + 1; i < kinds.size(); ++i) {
            OCDeclarationKind kind = kinds.get(i);
            for (int j = 0; j < children.length; ++j) {
                if (!kind.isKindOf(children[j])) continue;
                int offset = j > 0 ? children[j - 1].getTextRange().getEndOffset() : children[j].getTextRange().getStartOffset();
                result = result == -1 || result > offset ? offset : result;
            }
        }
        return result;
    }

    static {
        ArrayList<OCDeclarationKind> tmpFileDeclarationKinds = new ArrayList<OCDeclarationKind>();
        ArrayList<OCDeclarationKind> tmpClassDeclarationKinds = new ArrayList<OCDeclarationKind>();
        ArrayList<OCDeclarationKind> tmpMethodKinds = new ArrayList<OCDeclarationKind>();
        for (OCDeclarationKind kind : OCDeclarationKind.values()) {
            if (!kind.isAvailable()) continue;
            if (kind.ordinal() < Property.ordinal()) {
                tmpFileDeclarationKinds.add(kind);
                continue;
            }
            tmpClassDeclarationKinds.add(kind);
        }
        tmpMethodKinds.add(InitMethod);
        tmpMethodKinds.add(StaticMethod);
        tmpMethodKinds.add(InstanceMethod);
        tmpMethodKinds.add(DeallocMethod);
        ourFileDeclarationKinds = Collections.unmodifiableList(tmpFileDeclarationKinds);
        ourClassDeclarationKinds = Collections.unmodifiableList(tmpClassDeclarationKinds);
        ourMethodKinds = Collections.unmodifiableList(tmpMethodKinds);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "parent";
        objectArray2[1] = "com/jetbrains/cidr/lang/util/OCDeclarationKind";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getKindsOrder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildrenStartOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

