/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;

public class OCCommonProcessors {

    public static class IsAssignableCondition<T>
    implements Condition<T> {
        private Class<? extends T> clazz;

        public IsAssignableCondition(Class<? extends T> clazz) {
            this.clazz = clazz;
        }

        public boolean value(T t) {
            return this.clazz.isAssignableFrom(t.getClass());
        }
    }

    public static class OrderedProcessor<T>
    implements Processor<T> {
        private Condition<? super T>[] myOrder;
        private Processor<? super T> myProcessor;
        private MultiMap<Condition<? super T>, T> myMap = new MultiMap();
        private boolean myStopAfterNonemptyCondition;
        private boolean myCancelled;
        private boolean myEmpty = true;

        @SafeVarargs
        public OrderedProcessor(Processor<? super T> processor2, Condition<? super T> ... order) {
            this.myOrder = order;
            this.myProcessor = processor2;
        }

        @SafeVarargs
        public OrderedProcessor(Processor<? super T> processor2, boolean stopAfterNonemptyCondition, Condition<? super T> ... order) {
            this.myOrder = order;
            this.myProcessor = processor2;
            this.myStopAfterNonemptyCondition = stopAfterNonemptyCondition;
        }

        public boolean process(T t) {
            if (this.myCancelled) {
                return false;
            }
            for (int i = 0; i < this.myOrder.length; ++i) {
                Condition<? super T> condition = this.myOrder[i];
                if (!condition.value(t)) continue;
                this.myMap.putValue(condition, t);
                if (i == 0) {
                    this.myEmpty = false;
                    if (!this.myProcessor.process(t)) {
                        this.myCancelled = true;
                        return false;
                    }
                }
                return true;
            }
            return true;
        }

        public boolean finish() {
            if (this.myCancelled) {
                return false;
            }
            for (int i = 1; i < this.myOrder.length; ++i) {
                if (this.myStopAfterNonemptyCondition && !this.myEmpty) {
                    return true;
                }
                for (T t : this.sort(this.myMap.get(this.myOrder[i]))) {
                    this.myEmpty = false;
                    if (this.myProcessor.process(t)) continue;
                    return false;
                }
            }
            return true;
        }

        public Collection<T> sort(Collection<T> collection) {
            return collection;
        }

        public boolean isEmpty() {
            return this.myMap.isEmpty();
        }
    }

    public static class TypeFilteredProcessor<T, S extends T>
    implements Processor<T> {
        private final Processor<? super S> myAdaptee;
        private final Class<? extends S> myClass;

        public TypeFilteredProcessor(Processor<? super S> adaptee, Class<? extends S> aClass) {
            this.myAdaptee = adaptee;
            this.myClass = aClass;
        }

        public boolean process(T t) {
            if (this.myClass.isAssignableFrom(t.getClass())) {
                return this.myAdaptee.process(t);
            }
            return true;
        }
    }

    public static class SelfAdapterProcessor<S, T extends S>
    implements Processor<T> {
        private final Processor<? super S> myAdaptee;

        public SelfAdapterProcessor(Processor<? super S> adaptee) {
            this.myAdaptee = adaptee;
        }

        public boolean process(T t) {
            return this.myAdaptee.process(t);
        }
    }
}

