/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCCppTypeidExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGenericSelectionExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementExpression;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCValueCategoryHolder;
import com.jetbrains.cidr.lang.types.visitors.OCArgumentDepLookupAccumulator;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCLValueUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCCodeInsightUtil {
    private static final Map<OCElementType, OCElementType> oppositeOperators = Map.ofEntries(Map.entry(OCLexerTokenTypes.EQEQ, OCLexerTokenTypes.EXCLEQ), Map.entry(OCLexerTokenTypes.EXCLEQ, OCLexerTokenTypes.EQEQ), Map.entry(OCLexerTokenTypes.LT, OCLexerTokenTypes.GTEQ), Map.entry(OCLexerTokenTypes.LTEQ, OCLexerTokenTypes.GT), Map.entry(OCLexerTokenTypes.GT, OCLexerTokenTypes.LTEQ), Map.entry(OCLexerTokenTypes.GTEQ, OCLexerTokenTypes.LT));
    private static final Map<OCElementType, OCElementType> flippedOperators = Map.ofEntries(Map.entry(OCLexerTokenTypes.ANDAND, OCLexerTokenTypes.ANDAND), Map.entry(OCLexerTokenTypes.OROR, OCLexerTokenTypes.OROR), Map.entry(OCLexerTokenTypes.EQEQ, OCLexerTokenTypes.EQEQ), Map.entry(OCLexerTokenTypes.EXCLEQ, OCLexerTokenTypes.EXCLEQ), Map.entry(OCLexerTokenTypes.GTEQ, OCLexerTokenTypes.LTEQ), Map.entry(OCLexerTokenTypes.LTEQ, OCLexerTokenTypes.GTEQ), Map.entry(OCLexerTokenTypes.GT, OCLexerTokenTypes.LT), Map.entry(OCLexerTokenTypes.LT, OCLexerTokenTypes.GT));
    private static final Map<OCElementType, OCElementType> inversedLogicalOperators = Map.of(OCLexerTokenTypes.ANDAND, OCLexerTokenTypes.OROR, OCLexerTokenTypes.OROR, OCLexerTokenTypes.ANDAND, OCLexerTokenTypes.OR, OCLexerTokenTypes.AND, OCLexerTokenTypes.AND, OCLexerTokenTypes.OR);
    private static final String MAX_LENGTH_KEY = "cidr.max.intellisense.file.length";

    private OCCodeInsightUtil() {
    }

    @Nullable
    private static OCLanguageKind getKind(@Nullable PsiElement element) {
        return element != null && element.isValid() ? OCPsiFile.getKind(element.getContainingFile()) : null;
    }

    public static boolean isInPlainOldC(@Nullable PsiElement element) {
        OCLanguageKind kind = OCCodeInsightUtil.getKind(element);
        return kind != null && !kind.isCpp();
    }

    public static boolean isInObjC(@Nullable PsiElement element) {
        OCLanguageKind kind = OCCodeInsightUtil.getKind(element);
        return kind != null && kind.isObjC();
    }

    public static boolean isInPlainOldC(@Nullable PsiFile file, @Nullable OCInclusionContext context) {
        if (context != null) {
            return !context.getLanguageKind().isCpp();
        }
        if (file != null) {
            return OCCodeInsightUtil.isInPlainOldC((PsiElement)file);
        }
        return true;
    }

    @Contract(value="null->false")
    public static boolean isValid(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return false;
        }
        if (!OCSearchScope.isInProjectSources(element)) {
            return false;
        }
        OCMacroRange rangeInMacroCall = OCElementUtil.getRangeInMacroCall(element);
        if (rangeInMacroCall == null) {
            return true;
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element);
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)element);
        PsiElement firstChild = PsiTreeUtil.firstChild((PsiElement)element);
        if (!(firstChild instanceof OCMacroForeignLeafElement)) {
            return false;
        }
        String macroName = ((OCMacroForeignLeafElement)firstChild).getMacroName();
        if (prevLeaf instanceof PsiErrorElement || nextLeaf instanceof PsiErrorElement) {
            return false;
        }
        if (prevLeaf instanceof OCMacroForeignLeafElement && Objects.equals(((OCMacroForeignLeafElement)prevLeaf).getMacroName(), macroName)) {
            return false;
        }
        return !(nextLeaf instanceof OCMacroForeignLeafElement) || !Objects.equals(((OCMacroForeignLeafElement)nextLeaf).getMacroName(), macroName);
    }

    @Nullable
    public static OCClassSymbol getClassInFile(OCFile file) {
        final String fileName = FileUtilRt.getNameWithoutExtension((String)file.getName());
        final OCClassSymbol[] result = new OCClassSymbol[]{null};
        file.accept(new OCRecursiveVisitor(){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (result[0] == null || Objects.equals(dcl.getName(), fileName) && (!Objects.equals(result[0].getName(), fileName) || dcl.getCategory() == null)) {
                    result[0] = dcl.getSymbol();
                }
            }
        });
        return result[0];
    }

    @Nullable
    public static OCExpression findExpressionAtRange(PsiFile file, int startOffset, int endOffset) {
        return OCCodeInsightUtil.findElementAtRange(file, startOffset, endOffset, OCExpression.class, true);
    }

    @Nullable
    public static <E extends PsiElement> E findElementAtRange(PsiFile file, TextRange range, Class<E> elementClass, boolean requireExactRange) {
        return OCCodeInsightUtil.findElementAtRange(file, range.getStartOffset(), range.getEndOffset(), elementClass, requireExactRange);
    }

    @Nullable
    public static <E extends PsiElement> E findElementAtRange(PsiFile file, int startOffset, int endOffset, Class<E> elementClass, boolean requireExactRange) {
        PsiElement nameIdentifier;
        TextRange nodeRange;
        PsiElement parent;
        PsiElement node = file.findElementAt(startOffset);
        int expansionStartOffset = -1;
        while (node != null) {
            TextRange range = node.getTextRange();
            if (range == null) {
                return null;
            }
            if (range.containsRange(startOffset, endOffset)) break;
            if (range.containsRange(expansionStartOffset, endOffset)) {
                startOffset = expansionStartOffset;
                break;
            }
            if (node instanceof OCMacroCall) {
                if ((node = ((OCMacroCall)node).getExpansionExpression()) == null || range.getStartOffset() != startOffset) continue;
                expansionStartOffset = node.getTextRange().getStartOffset();
                continue;
            }
            node = node.getParent();
        }
        if ((parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)node, (Class[])new Class[]{elementClass, OCMacroCall.class})) != null) {
            node = parent;
        }
        TextRange textRange = nodeRange = node != null ? node.getTextRange() : null;
        if (node instanceof OCMacroCall) {
            node = ((OCMacroCall)node).getExpansionExpression();
        }
        if (node instanceof OCMacroCallArgument && node.getChildren().length >= 1) {
            node = node.getChildren()[0];
        }
        if (elementClass.equals(OCExpression.class) && node instanceof OCExpressionStatement) {
            node = ((OCExpressionStatement)node).getExpression();
            nodeRange = node.getTextRange();
        }
        if (elementClass.equals(OCDeclarator.class) && node instanceof OCDeclarator && (nameIdentifier = ((OCDeclarator)node).getNameIdentifier()) != null && nameIdentifier.getTextRange().equalsToRange(startOffset, endOffset)) {
            requireExactRange = false;
        }
        if (requireExactRange && nodeRange != null && !nodeRange.equalsToRange(startOffset, endOffset)) {
            return null;
        }
        return (E)(elementClass.isInstance(node) ? node : null);
    }

    public static PsiElement @Nullable [] findStatementsAtRange(PsiFile file, int startOffset, int endOffset, boolean requireExactRange) {
        PsiElement nextSibling;
        PsiElement lastItem;
        PsiElement element1 = file.findElementAt(startOffset);
        PsiElement element2 = file.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (OCElementUtil.getElementType(element2) == OCLexerTokenTypes.EOL_COMMENT && element1 != element2) {
            if ((element2 = element2.getNextSibling()) == null || element2.getTextRange() == null) {
                return null;
            }
            endOffset = element2.getTextRange().getEndOffset();
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            return null;
        }
        while (!(parent instanceof OCBlockStatement) && !(parent instanceof OCCodeFragment)) {
            if (parent instanceof OCStatement) {
                parent = parent.getParent();
                break;
            }
            if (parent == null || parent instanceof OCFile) {
                return null;
            }
            parent = parent.getParent();
        }
        if (!parent.equals((Object)element1)) {
            while (!parent.equals((Object)element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (requireExactRange && startOffset != element1.getTextRange().getStartOffset()) {
            return null;
        }
        if (!parent.equals((Object)element2)) {
            while (!parent.equals((Object)element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (requireExactRange && endOffset != element2.getTextRange().getEndOffset() && (endOffset + 1 != element2.getTextRange().getEndOffset() || file.getText().charAt(endOffset) != ';')) {
            return null;
        }
        if (parent instanceof OCBlockStatement && (requireExactRange ? parent.getFirstChild() == element1 && parent.getLastChild() == element2 : parent.getFirstChild() == element1 || parent.getLastChild() == element2)) {
            PsiElement[] psiElementArray;
            if (parent.getParent() instanceof OCCallable) {
                psiElementArray = null;
            } else {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = parent;
            }
            return psiElementArray;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        if (element2 instanceof OCMacroCall) {
            PsiElement nextSibling2 = element2.getNextSibling();
            element2 = nextSibling2 != null ? nextSibling2 : element2;
        }
        boolean flag = false;
        for (PsiElement child : OCElementUtil.getAllChildren(parent)) {
            if (child.equals((Object)element1)) {
                flag = true;
            }
            if (flag && !(child instanceof OCMacroCall)) {
                array.add(child);
            }
            if (!child.equals((Object)element2)) continue;
            break;
        }
        if ((lastItem = (PsiElement)ContainerUtil.getLastItem(array)) instanceof OCDirective && (nextSibling = lastItem.getNextSibling()) != null && OCElementUtil.isWhitespace(nextSibling)) {
            array.add(nextSibling);
        }
        for (PsiElement element : array) {
            if (element instanceof OCStatement || !OCElementUtil.isElementSignificant(element)) continue;
            return null;
        }
        return PsiUtilCore.toPsiElementArray(array);
    }

    public static <E extends PsiElement> List<E> findElementOccurrences(@Nullable PsiElement scope, @NotNull E element) {
        if (element == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(0);
        }
        ArrayList<E> answer = new ArrayList<E>();
        if (!PsiTreeUtil.isAncestor((PsiElement)scope, element, (boolean)false)) {
            answer.add(element);
        }
        if (element instanceof OCExpression && OCElementUtil.getRangeInMacroCall(element) == null) {
            element = OCParenthesesUtils.diveIntoParentheses((OCExpression)element);
        }
        if (scope != null) {
            OCCodeInsightUtil.addOccurrencesIn(element, OCElementUtil.getElementType(element), scope, answer);
        }
        return answer;
    }

    private static <E extends PsiElement> void addOccurrencesIn(E element, IElementType elementType, PsiElement scope, List<E> answer) {
        if (OCElementUtil.getElementType(scope) == elementType && OCElementUtil.areElementsEquivalent(element, scope, false)) {
            if (scope instanceof OCExpression) {
                scope = OCParenthesesUtils.topmostParenthesized((OCExpression)scope);
            }
            answer.add(scope);
        } else {
            for (PsiElement c : scope.getChildren()) {
                OCCodeInsightUtil.addOccurrencesIn(element, elementType, c, answer);
            }
        }
    }

    public static boolean isLValue(OCExpression expr) {
        return OCLValueUtil.isLValue(expr);
    }

    public static boolean isAssignmentLHS(OCExpression expr) {
        return OCLValueUtil.isAssignmentLHS(expr);
    }

    public static boolean hasSideEffects(@NotNull PsiElement element) {
        if (element == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(1);
        }
        final Ref result = Ref.create((Object)false);
        element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitPrefixExpression(OCPrefixExpression expression) {
                if (expression.getOperationSign() == OCLexerTokenTypes.PLUSPLUS || expression.getOperationSign() == OCLexerTokenTypes.MINUSMINUS) {
                    result.set((Object)true);
                } else {
                    super.visitPrefixExpression(expression);
                }
            }

            @Override
            public void visitPostfixExpression(OCPostfixExpression expression) {
                if (expression.getOperationSign() == OCLexerTokenTypes.PLUSPLUS || expression.getOperationSign() == OCLexerTokenTypes.MINUSMINUS) {
                    result.set((Object)true);
                } else {
                    super.visitPostfixExpression(expression);
                }
            }

            @Override
            public void visitAssignmentExpression(OCAssignmentExpression expression) {
                result.set((Object)true);
            }

            @Override
            public void visitCallExpression(OCCallExpression expression) {
                result.set((Object)true);
            }

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression) {
                result.set((Object)true);
            }

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
                result.set((Object)true);
            }

            @Override
            public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
                result.set((Object)true);
            }

            @Override
            public void visitStatementExpression(OCStatementExpression statementExpression) {
                result.set((Object)true);
            }

            @Override
            public void visitCppNewExpression(OCCppNewExpression expression) {
                result.set((Object)true);
            }
        });
        return (Boolean)result.get();
    }

    public static <E extends PsiElement> void collectElements(PsiFile file, Editor editor, int offset, Class<E> elementClass, List<? super E> elements) {
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!Character.isJavaIdentifierPart(text.charAt(offset))) {
            --correctedOffset;
        }
        if (correctedOffset < 0) {
            correctedOffset = offset;
        } else if (!Character.isJavaIdentifierPart(text.charAt(correctedOffset))) {
            if (text.charAt(correctedOffset) == ';') {
                --correctedOffset;
            }
            if (text.charAt(correctedOffset) != ')') {
                correctedOffset = offset;
            }
        }
        PsiElement elementAtCaret = file.findElementAt(correctedOffset);
        PsiElement context = OCCodeInsightUtil.getElementOrMacroCall(elementAtCaret, elementClass);
        while (context != null) {
            PsiElement element;
            if (!elementClass.isInstance(context)) {
                if (!(context instanceof OCMacroCall)) break;
                if (elementClass.equals(OCExpression.class) && (element = ((OCMacroCall)context).getExpansionExpression()) != null) {
                    elements.add(element);
                }
                context = OCCodeInsightUtil.getElementOrMacroCall(context, elementClass);
                continue;
            }
            element = context;
            if (!(elements.contains(element) || element instanceof OCParenthesizedExpression || element instanceof OCAssignmentExpression || element instanceof OCExpression && ((OCExpression)element).getResolvedType().isVoid() || element instanceof OCReferenceExpression && ((OCReferenceExpression)element).getResolvedType() instanceof OCObjectType)) {
                elements.add(element);
            }
            context = OCCodeInsightUtil.getElementOrMacroCall(context, elementClass);
        }
    }

    @Nullable
    private static <E extends PsiElement> PsiElement getElementOrMacroCall(PsiElement context, Class<E> elementClass) {
        return PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{elementClass, OCMacroCall.class});
    }

    public static boolean isUniqueInScope(@Nullable OCSymbolKind symbolKind, String name, @Nullable PsiElement scope, @NotNull Project project) {
        if (project == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(2);
        }
        return OCCodeInsightUtil.resolveNameInScope(symbolKind, name, null, scope, project) == null;
    }

    public static OCSymbol resolveNameInScope(final @Nullable OCSymbolKind symbolKind, final String name, final @Nullable String categoryName, @Nullable PsiElement scope, @NotNull Project project) {
        if (project == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(3);
        }
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                if (symbol.isSynthetic()) {
                    return false;
                }
                if (categoryName != null && symbol instanceof OCClassSymbol && !categoryName.equals(((OCClassSymbol)symbol).getCategoryName())) {
                    return false;
                }
                return symbolKind == null || OCResolveUtil.isDuplicate(symbolKind, symbol.getKind());
            }
        };
        if (scope == null) {
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, (Processor<? super OCSymbol>)processor2, name);
        } else {
            OCResolveUtil.processSymbols(name, scope, (Processor<OCSymbol>)processor2);
        }
        if (processor2.isFound()) {
            return (OCSymbol)processor2.getFoundValue();
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)scope, (Class[])new Class[]{OCLocalScopeable.class, OCFile.class, OCBlockExpression.class, OCLambdaExpression.class});
        if (element == null || element instanceof OCBlockExpression || element instanceof OCLambdaExpression || symbolKind == OCSymbolKind.PARAMETER && !(element instanceof OCCallable)) {
            return null;
        }
        element.accept((PsiElementVisitor)new OCRecursiveVisitor((CommonProcessors.FindFirstProcessor)processor2, scope){
            final /* synthetic */ CommonProcessors.FindFirstProcessor val$processor;
            final /* synthetic */ PsiElement val$scope;
            {
                this.val$processor = findFirstProcessor;
                this.val$scope = psiElement;
            }

            @Override
            public void visitSymbolDeclarator(OCSymbolDeclarator declarator) {
                String symbolName;
                Object symbol = declarator.getSymbol();
                if (symbol != null && name.equals(symbolName = symbol.getName())) {
                    this.val$processor.process(symbol);
                }
            }

            @Override
            public void visitBlockStatement(OCBlockStatement stmt) {
                if (OCSymbolOffsetUtil.getComplexOffset(this.val$scope) < OCSymbolOffsetUtil.getComplexRange(stmt).getEndOffset()) {
                    super.visitBlockStatement(stmt);
                }
            }
        });
        return (OCSymbol)processor2.getFoundValue();
    }

    @Nullable
    public static Editor openInEditor(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(4);
        }
        if ((file = element.getContainingFile()) == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Project project = element.getProject();
        int offset = element instanceof PsiFile ? -1 : element.getTextOffset();
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, offset);
        return FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }

    public static boolean showCallableInEditorAndSelectBody(@NotNull PsiFile file, @NotNull Segment segment, @NotNull Condition<? super OCBlockStatement> condition) {
        if (file == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(5);
        }
        if (segment == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(6);
        }
        if (condition == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(7);
        }
        class MyVisitor
        extends OCRecursiveVisitor {
            public boolean found;
            private final TextRange myRange;
            final /* synthetic */ Condition val$condition;

            MyVisitor(TextRange textRange) {
                this.val$condition = textRange;
                super(range);
                this.found = false;
                this.myRange = range;
            }

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                if (!this.found) {
                    OCBlockStatement body;
                    if (!this.myRange.intersectsStrict(element.getTextRange())) {
                        return;
                    }
                    OCCallable callable = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{OCCallable.class});
                    if (callable != null && (body = callable.getBody()) != null && this.val$condition.value((Object)body)) {
                        this.found = true;
                        Editor editor = OCCodeInsightUtil.openInEditor(body);
                        if (editor != null) {
                            OCCodeInsightUtil.selectBody(editor, body);
                        }
                    }
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/util/OCCodeInsightUtil$1MyVisitor", "visitElement"));
            }
        }
        MyVisitor visitor = new MyVisitor(TextRange.create((Segment)segment), condition);
        file.accept((PsiElementVisitor)visitor);
        return visitor.found;
    }

    public static void selectBody(Editor editor, OCBlockStatement body) {
        if (body == null) {
            return;
        }
        ASTNode firstNode = body.getNode().getFirstChildNode().getTreeNext();
        ASTNode lastNode = body.getNode().getLastChildNode().getTreePrev();
        while (OCLexerTokenTypes.WHITESPACES.contains(firstNode.getElementType())) {
            firstNode = firstNode.getTreeNext();
        }
        while (OCLexerTokenTypes.WHITESPACES.contains(lastNode.getElementType())) {
            lastNode = lastNode.getTreePrev();
        }
        if (firstNode != body.getNode().getLastChildNode()) {
            OCCodeInsightUtil.selectRange(editor, firstNode.getStartOffset(), lastNode.getTextRange().getEndOffset());
        } else {
            OCCodeInsightUtil.selectRange(editor, body.getTextOffset() + 1, body.getTextOffset() + 1);
        }
    }

    public static void selectElement(PsiElement element) {
        if (element == null) {
            return;
        }
        Editor editor = EditorHelper.openInEditor((PsiElement)element);
        if (editor != null) {
            OCCodeInsightUtil.selectRange(editor, element.getTextRange().getStartOffset(), element.getTextRange().getEndOffset());
        }
    }

    public static void selectRange(Editor editor, int startOffset, int endOffset) {
        editor.getCaretModel().moveToOffset(startOffset);
        editor.getSelectionModel().setSelection(startOffset, endOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    public static String getClassNameWithCategory(String className, String categoryName) {
        if (categoryName == null) {
            return className;
        }
        return className + " + " + (categoryName.isEmpty() ? "()" : categoryName);
    }

    @Nullable
    public static OCClassDeclaration getPrivateCategory(OCClassDeclarationBase declaration) {
        for (PsiElement child : declaration.getContainingFile().getChildren()) {
            if (!(child instanceof OCClassDeclaration)) continue;
            OCClassDeclaration category = (OCClassDeclaration)child;
            if (!declaration.getName().equals(category.getName()) || !"".equals(category.getCategory())) continue;
            return category;
        }
        return null;
    }

    @NotNull
    public static Pair<MemberBeginEndSearchResult, OCType> getReturnTypeOfBeginEndPair(OCExpression expr, @NotNull OCStructType structType, @NotNull OCFile file) {
        if (structType == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(8);
        }
        if (file == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(9);
        }
        OCResolveContext context = OCResolveContext.forPsi(file);
        CVQualifiers cvQualifiers = OCCodeInsightUtil.getCVQualifiers(expr, structType);
        OCType leftType = structType.cloneWithAddedCVQualifiers(cvQualifiers, file.getProject());
        Collection<OCSymbol> beginSymbols = structType.collectMethods("begin", context);
        OCSymbol beginSymbol = OCResolveOverloadsUtil.resolveOverloads(beginSymbols, new OCArgumentsList(Collections.emptyList(), null), leftType, null, null, true, true, context, expr);
        Collection<OCSymbol> endSymbols = structType.collectMethods("end", context);
        OCSymbol endSymbol = OCResolveOverloadsUtil.resolveOverloads(endSymbols, new OCArgumentsList(Collections.emptyList(), null), leftType, null, null, true, true, context, expr);
        if (beginSymbol == null && endSymbol == null) {
            Pair pair = Pair.create((Object)((Object)MemberBeginEndSearchResult.NONE), null);
            if (pair == null) {
                OCCodeInsightUtil.$$$reportNull$$$0(10);
            }
            return pair;
        }
        if (beginSymbol == null || endSymbol == null) {
            Pair pair = Pair.create((Object)((Object)MemberBeginEndSearchResult.INVALID), null);
            if (pair == null) {
                OCCodeInsightUtil.$$$reportNull$$$0(11);
            }
            return pair;
        }
        assert (beginSymbol instanceof OCFunctionSymbol);
        OCType beginReturnType = beginSymbol.getEffectiveType(context.getProject()).resolve(context);
        assert (endSymbol instanceof OCFunctionSymbol);
        OCType endReturnType = beginSymbol.getEffectiveType(context.getProject()).resolve(context);
        if (endReturnType.equals(beginReturnType, context)) {
            Pair pair = Pair.create((Object)((Object)MemberBeginEndSearchResult.OK), (Object)beginReturnType);
            if (pair == null) {
                OCCodeInsightUtil.$$$reportNull$$$0(12);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)((Object)MemberBeginEndSearchResult.NONE), null);
        if (pair == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(13);
        }
        return pair;
    }

    public static boolean isCodeInsightAvailable(@NotNull VirtualFile file, @NotNull Project project) {
        long textLength;
        if (file == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(15);
        }
        if ((textLength = file.getLength()) < 0L) {
            return false;
        }
        if (textLength <= (long)OCCodeInsightUtil.getMaxFileLength()) {
            return true;
        }
        return OCCodeInsightUtil.isLibraryFile(project, file);
    }

    private static boolean isKnownSignificantLongFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(16);
        }
        return StringUtil.startsWithIgnoreCase((String)virtualFile.getName(), (String)"catch.h");
    }

    public static boolean isCodeInsightAvailable(@NotNull PsiFile file) {
        long textLength;
        if (file == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(17);
        }
        if ((textLength = file.getViewProvider().getVirtualFile().getLength()) < 0L) {
            return false;
        }
        if (textLength <= (long)OCCodeInsightUtil.getMaxFileLength()) {
            return true;
        }
        return OCCodeInsightUtil.isLibraryFile(file.getProject(), OCFileUtil.getVirtualFile(file));
    }

    private static boolean isLibraryFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(18);
        }
        if (virtualFile == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(19);
        }
        return OCCodeInsightUtil.isKnownSignificantLongFile(virtualFile) || ProjectScope.getLibrariesScope((Project)project).contains(virtualFile);
    }

    public static boolean isCodeInsightAvailable(int fileLength, boolean isLibraryFile) {
        return fileLength >= 0 && (isLibraryFile || fileLength <= OCCodeInsightUtil.getMaxFileLength());
    }

    public static boolean isPreProcessable(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(20);
        }
        if (project == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(21);
        }
        return FileSymbolTableHelper.isPreProcessable(file, project);
    }

    public static int getMaxFileLength() {
        return Registry.intValue((String)MAX_LENGTH_KEY, (int)500000);
    }

    public static void setMaxFileLength(int newValue) {
        if (newValue > 0) {
            Registry.get((String)MAX_LENGTH_KEY).setValue(newValue);
        }
    }

    public static void resetMaxFileLength() {
        Registry.get((String)MAX_LENGTH_KEY).resetToDefault();
    }

    public static boolean isNonStaticFieldAccess(@NotNull OCDeclaratorSymbol symbol, @NotNull OCStructSymbol parent, @NotNull OCExpression expression) {
        if (symbol == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(22);
        }
        if (parent == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(23);
        }
        if (expression == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(24);
        }
        return !symbol.isFriendOrStatic() && !symbol.isMutable() && OCCodeInsightUtil.isMemberAccess(symbol, parent, expression);
    }

    public static boolean isMemberAccess(@NotNull OCSymbolWithQualifiedName symbol, @NotNull OCStructSymbol parent, @NotNull OCExpression expression) {
        if (symbol == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(25);
        }
        if (parent == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(26);
        }
        if (expression == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(27);
        }
        if (symbol instanceof OCThisSelfSuperSymbol) {
            return true;
        }
        if (!(symbol instanceof OCFunctionSymbol) && symbol.getKind() != OCSymbolKind.STRUCT_FIELD) {
            return false;
        }
        OCResolveContext context = OCResolveContext.forPsi(expression);
        OCSymbolWithQualifiedName memberParent = symbol.getResolvedOwner(context);
        if (!(memberParent instanceof OCStructSymbol) || !((OCStructSymbol)memberParent).isAncestor(parent, context)) {
            return false;
        }
        return expression instanceof OCReferenceExpression || expression instanceof OCQualifiedExpression && ((OCQualifiedExpression)expression).getQualifier() instanceof OCReferenceExpression && ((OCReferenceExpression)((OCQualifiedExpression)expression).getQualifier()).isCppThis();
    }

    @Nullable
    public static CVQualifiers getOuterFunctionCVQualifiers(@NotNull OCDeclaratorSymbol symbol, @NotNull OCExpression expression, @Nullable Ref<? super OCFunctionSymbol> functionSymbolRef) {
        OCSymbolWithQualifiedName parent;
        OCFunctionDefinition function;
        OCFunctionSymbol functionSymbol;
        if (symbol == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(28);
        }
        if (expression == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(29);
        }
        OCFunctionSymbol oCFunctionSymbol = functionSymbol = (function = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)expression, OCFunctionDefinition.class)) != null ? function.getSymbol() : null;
        if (functionSymbolRef != null) {
            functionSymbolRef.set((Object)functionSymbol);
        }
        if (functionSymbol != null && (parent = functionSymbol.getResolvedOwner(OCResolveContext.forPsi(expression))) instanceof OCStructSymbol && OCCodeInsightUtil.isNonStaticFieldAccess(symbol, (OCStructSymbol)parent, expression)) {
            return functionSymbol.getType().getCVQualifiers();
        }
        return null;
    }

    @NotNull
    public static CVQualifiers getCVQualifiers(OCExpression expression, OCType type) {
        boolean considerOuterFunction = type instanceof OCStructType;
        CVQualifiers modifiers = type.getTerminalType().getCVQualifiers();
        if (considerOuterFunction && expression instanceof OCReferenceExpression) {
            CVQualifiers functionCVQualifiers;
            OCSymbol symbol = ((OCReferenceExpression)expression).resolveToSymbol();
            CVQualifiers cVQualifiers = functionCVQualifiers = symbol instanceof OCDeclaratorSymbol ? OCCodeInsightUtil.getOuterFunctionCVQualifiers((OCDeclaratorSymbol)symbol, expression, null) : null;
            if (functionCVQualifiers != null) {
                modifiers = modifiers.or(functionCVQualifiers);
            }
        }
        CVQualifiers cVQualifiers = modifiers;
        if (cVQualifiers == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(30);
        }
        return cVQualifiers;
    }

    public static boolean isLikeNull(@Nullable String literal) {
        return "nil".equals(literal) || "NULL".equals(literal) || "nullptr".equals(literal);
    }

    public static boolean isStdInitializerListType(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(31);
        }
        if (OCCompilerFeaturesHelper.supportsInitializerLists(context.getFile()) && type instanceof OCStructType) {
            OCStructSymbol symbol = ((OCStructType)type).getSymbol();
            OCQualifiedName name = symbol.getResolvedQualifiedNameWithoutArguments(context);
            return name != null && name.getFullName(context).equals("::std::initializer_list");
        }
        return false;
    }

    @Nullable
    public static OCType getStdInitializerListTemplateParameter(OCType type, @NotNull OCResolveContext context) {
        OCStructSymbol paramTypeSymbol;
        if (context == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(32);
        }
        if (OCCodeInsightUtil.isStdInitializerListType(type, context) && (paramTypeSymbol = ((OCStructType)type).getSymbol()).getTemplateParameters().size() == 1) {
            OCTypeParameterSymbol parameterSymbol = paramTypeSymbol.getTemplateParameters().get(0);
            OCTypeArgument paramSubstitution = paramTypeSymbol.getSubstitution().getSubstitutionFor(parameterSymbol);
            if (paramSubstitution instanceof OCType) {
                return (OCType)paramSubstitution;
            }
        }
        return null;
    }

    public static boolean isSimpleDeclaration(String declarationText, String name) {
        return "<unnamed>".equals(name) || declarationText.endsWith(name);
    }

    public static boolean typeHasBeginEnd(@NotNull OCExpression expr, OCType type) {
        if (expr == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(33);
        }
        OCFile file = expr.getContainingOCFile();
        OCResolveContext context = OCResolveContext.forPsi(expr);
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type instanceof OCArrayType) {
            return true;
        }
        if (type instanceof OCBracedInitListType && expr instanceof OCCompoundInitializer) {
            List<OCExpression> initializers = ((OCCompoundInitializer)expr).getInitializerExpressions();
            return !initializers.isEmpty();
        }
        if (type instanceof OCStructType) {
            Collection<OCSymbol> beginSymbols = ((OCStructType)type).collectMethods("begin", context);
            Collection<OCSymbol> endSymbols = ((OCStructType)type).collectMethods("end", context);
            if (!beginSymbols.isEmpty() && !endSymbols.isEmpty()) {
                return true;
            }
        }
        OCSymbol begin = OCCodeInsightUtil.getGlobalBeginOrEnd("begin", type, expr, file, context);
        OCSymbol end = OCCodeInsightUtil.getGlobalBeginOrEnd("end", type, expr, file, context);
        return begin != null && end != null;
    }

    @Nullable
    public static OCType getCollectionElementType(@NotNull OCExpression expr, OCType type) {
        if (expr == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(34);
        }
        OCFile file = expr.getContainingOCFile();
        OCResolveContext context = OCResolveContext.forPsi(expr);
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        OCType iteratorType = null;
        if (type instanceof OCArrayType) {
            iteratorType = type;
        } else {
            if (type instanceof OCBracedInitListType && expr instanceof OCCompoundInitializer) {
                List<OCExpression> initializers = ((OCCompoundInitializer)expr).getInitializerExpressions();
                if (initializers.isEmpty()) {
                    return null;
                }
                return initializers.get(0).getResolvedType(context).cloneWithConstModifier(context.getProject());
            }
            Pair<MemberBeginEndSearchResult, OCType> result = type instanceof OCStructType ? OCCodeInsightUtil.getReturnTypeOfBeginEndPair(expr, (OCStructType)type, file) : Pair.create((Object)((Object)MemberBeginEndSearchResult.NONE), null);
            switch (((MemberBeginEndSearchResult)((Object)result.getFirst())).ordinal()) {
                case 0: {
                    OCSymbol begin = OCCodeInsightUtil.getGlobalBeginOrEnd("begin", type, expr, file, context);
                    OCSymbol end = OCCodeInsightUtil.getGlobalBeginOrEnd("end", type, expr, file, context);
                    if (begin != null && end != null) {
                        OCType endReturnType;
                        assert (begin instanceof OCFunctionSymbol);
                        assert (end instanceof OCFunctionSymbol);
                        OCType beginReturnType = begin.getEffectiveType(context.getProject()).resolve(context);
                        if (beginReturnType.equals(endReturnType = end.getEffectiveType(context.getProject()).resolve(context), context)) {
                            iteratorType = beginReturnType;
                        }
                    }
                }
                case 1: {
                    break;
                }
                case 2: {
                    iteratorType = (OCType)result.getSecond();
                }
            }
        }
        return OCCodeInsightUtil.getDereferencedType(expr, iteratorType);
    }

    @Nullable
    private static OCSymbol getGlobalBeginOrEnd(@NotNull String methodName, @NotNull OCType type, @NotNull OCExpression expr, @NotNull OCFile file, @NotNull OCResolveContext context) {
        if (methodName == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(35);
        }
        if (type == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(36);
        }
        if (expr == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(37);
        }
        if (file == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(38);
        }
        if (context == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(39);
        }
        OCQualifiedName beginName = OCQualifiedName.interned(methodName);
        List<OCSymbol> symbols = new ArrayList<OCSymbol>(OCSymbolReference.getDummyGlobalReference(beginName).resolveToSymbols(OCResolveContext.forPsi(file)));
        symbols = ContainerUtil.filter(symbols, symbol -> symbol instanceof OCFunctionSymbol);
        List<OCType> argTypes = Collections.singletonList(type);
        Collection<OCSymbol> symbolsWithADL = OCArgumentDepLookupAccumulator.doArgDepLookup(symbols, argTypes, Collections.singletonList(expr), beginName, context);
        OCArgumentsList<OCValueCategoryHolder> arguments = new OCArgumentsList<OCValueCategoryHolder>(argTypes, Collections.singletonList(new OCValueCategoryHolder(type, OCExprValueCategory.LValue)));
        return OCResolveOverloadsUtil.resolveOverloads(symbolsWithADL, arguments, null, null, null, true, true, context, expr);
    }

    @Nullable
    public static OCType getDereferencedType(@NotNull OCExpression expr, @Nullable OCType iteratorType) {
        if (expr == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(40);
        }
        if (iteratorType instanceof OCPointerType) {
            return ((OCPointerType)iteratorType).getRefType();
        }
        if (iteratorType instanceof OCStructType) {
            OCFunctionSymbol operator = OCOperatorReference.resolveOperator("*", OCOperatorReference.OperatorPlacement.PREFIX, expr, (OCStructType)iteratorType);
            return operator != null ? operator.getEffectiveType(expr).resolve(expr) : null;
        }
        if (iteratorType instanceof OCMagicType) {
            return new OCMagicType();
        }
        return null;
    }

    public static boolean isUnnamed(OCDeclaratorSymbol field) {
        OCType fieldType = field.getType();
        return fieldType instanceof OCStructType && ((OCStructType)fieldType).isUnnamed();
    }

    @Nullable
    public static OCElementType getOppositeOperator(@NotNull OCElementType operator) {
        if (operator == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(41);
        }
        return oppositeOperators.get(operator);
    }

    @Nullable
    public static OCElementType getFlippedOperator(@NotNull OCElementType operator) {
        if (operator == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(42);
        }
        return flippedOperators.get(operator);
    }

    @Nullable
    public static OCElementType getInversedLogicalOperator(@NotNull OCElementType operator) {
        if (operator == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(43);
        }
        return inversedLogicalOperators.get(operator);
    }

    public static boolean insideLoopHeader(@NotNull PsiElement element) {
        OCLoopStatement parent;
        if (element == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(44);
        }
        if ((parent = (OCLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCLoopStatement.class)) instanceof OCForeachStatement) {
            OCForeachStatement foreachStatement = (OCForeachStatement)parent;
            return PsiTreeUtil.isAncestor((PsiElement)foreachStatement.getVariableDeclaration(), (PsiElement)element, (boolean)false);
        }
        if (parent instanceof OCForStatement) {
            OCForStatement forStatement = (OCForStatement)parent;
            return PsiTreeUtil.isAncestor((PsiElement)forStatement.getInitializer(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)forStatement.getCondition(), (PsiElement)element, (boolean)false);
        }
        if (parent != null) {
            return PsiTreeUtil.isAncestor((PsiElement)parent.getCondition(), (PsiElement)element, (boolean)false);
        }
        return false;
    }

    public static boolean insideConditionalHeader(@NotNull PsiElement element) {
        OCStatement parent;
        if (element == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(45);
        }
        if ((parent = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCIfStatement.class, OCSwitchStatement.class})) instanceof OCIfStatement) {
            OCIfStatement ifStatement = (OCIfStatement)parent;
            return PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)element, (boolean)false);
        }
        if (parent instanceof OCSwitchStatement) {
            OCSwitchStatement switchStatement = (OCSwitchStatement)parent;
            return PsiTreeUtil.isAncestor((PsiElement)switchStatement.getExpression(), (PsiElement)element, (boolean)false);
        }
        return false;
    }

    public static Set<PsiNamedElement> collectDeclarators(@NotNull PsiElement element) {
        if (element == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(46);
        }
        final HashSet<PsiNamedElement> declarators = new HashSet<PsiNamedElement>();
        element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitDeclarator(OCDeclarator declarator) {
                super.visitDeclarator(declarator);
                if (declarator.getSymbol() != null && !declarator.getSymbol().isUnnamed()) {
                    declarators.add(declarator);
                }
            }

            @Override
            public void visitMethodSelectorPart(OCMethodSelectorPart part) {
                if (part.getSymbol() != null && !((OCDeclaratorSymbol)part.getSymbol()).isUnnamed()) {
                    declarators.add(part);
                }
            }
        });
        return declarators;
    }

    public static List<PsiElement> getReferences(@NotNull PsiNamedElement declarator) {
        if (declarator == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(47);
        }
        return ContainerUtil.mapNotNull((Collection)ReferencesSearch.search((PsiElement)declarator, (SearchScope)declarator.getUseScope()).findAll(), PsiReference::getElement);
    }

    public static void renameDeclaratorAndUsages(@NotNull PsiNamedElement declarator, @NotNull String newDeclaratorName, @Nullable List<? extends PsiElement> usages) {
        if (declarator == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(48);
        }
        if (newDeclaratorName == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(49);
        }
        if (newDeclaratorName.equals(declarator.getName())) {
            return;
        }
        if (usages != null) {
            for (PsiElement psiElement : usages) {
                if (!(psiElement instanceof OCReferenceElement) || OCElementUtil.isPartOfMacroSubstitution(psiElement)) continue;
                ((OCReferenceElement)psiElement).setNameOfIdentifier(newDeclaratorName);
            }
        }
        declarator.setName(newDeclaratorName);
    }

    public static boolean isOverloadedOperatorUsage(@NotNull OCExpression expression) {
        PsiReference reference;
        if (expression == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(50);
        }
        return (reference = expression.getReference()) instanceof OCOperatorReference && !((OCOperatorReference)reference).resolveToSymbolsViaClang().isEmpty();
    }

    public static boolean isStaticallyEvaluated(@NotNull PsiElement element) {
        if (element == null) {
            OCCodeInsightUtil.$$$reportNull$$$0(51);
        }
        for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof OCSizeofExpression || parent instanceof OCCppTypeidExpression || parent instanceof OCGenericSelectionExpression) {
                return true;
            }
            if (parent instanceof OCCppNamespaceQualifier && OCCodeInsightUtil.hasAnyChildOfType(parent, new IElementType[]{OCLexerTokenTypes.DECLTYPE_CPP_KEYWORD})) {
                return true;
            }
            if (!(parent instanceof OCTypeElement) || !OCCodeInsightUtil.hasAnyChildOfType(parent, new IElementType[]{OCLexerTokenTypes.TYPEOF_KEYWORD, OCLexerTokenTypes.DECLTYPE_CPP_KEYWORD})) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyChildOfType(PsiElement parent, IElementType ... types) {
        return Arrays.stream(parent.getNode().getChildren(null)).map(OCElementUtil::getElementType).anyMatch(elementType -> {
            for (IElementType type : types) {
                if (type != elementType) continue;
                return true;
            }
            return false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: 
            case 14: 
            case 17: 
            case 20: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structType";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCCodeInsightUtil";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 24: 
            case 27: 
            case 29: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 31: 
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: 
            case 34: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarator";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDeclaratorName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCCodeInsightUtil";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnTypeOfBeginEndPair";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCVQualifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementOccurrences";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasSideEffects";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUniqueInScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameInScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openInEditor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showCallableInEditorAndSelectBody";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeOfBeginEndPair";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 30: {
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCodeInsightAvailable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isKnownSignificantLongFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPreProcessable";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isNonStaticFieldAccess";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isMemberAccess";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getOuterFunctionCVQualifiers";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isStdInitializerListType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getStdInitializerListTemplateParameter";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "typeHasBeginEnd";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionElementType";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalBeginOrEnd";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDereferencedType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getOppositeOperator";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFlippedOperator";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getInversedLogicalOperator";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "insideLoopHeader";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "insideConditionalHeader";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "collectDeclarators";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "renameDeclaratorAndUsages";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isOverloadedOperatorUsage";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isStaticallyEvaluated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13, 30 -> new IllegalStateException(string);
        };
    }

    public static enum MemberBeginEndSearchResult {
        NONE,
        INVALID,
        OK;

    }
}

