/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.ui.OCFieldAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFieldAdapterForSymbolName
implements OCFieldAdapter<OCSymbolNavigationItem> {
    public static final OCFieldAdapterForSymbolName INSTANCE = new OCFieldAdapterForSymbolName();

    @NotNull
    public String getName(@NotNull OCSymbolNavigationItem symbol) {
        if (symbol == null) {
            OCFieldAdapterForSymbolName.$$$reportNull$$$0(0);
        }
        String string = symbol.getName();
        if (string == null) {
            OCFieldAdapterForSymbolName.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Icon getIcon(@NotNull OCSymbolNavigationItem item) {
        if (item == null) {
            OCFieldAdapterForSymbolName.$$$reportNull$$$0(2);
        }
        return item.getSymbol().getIcon(item.getProject());
    }

    public String getTypeText(@NotNull OCSymbolNavigationItem item) {
        VirtualFile file;
        OCSymbol symbol;
        if (item == null) {
            OCFieldAdapterForSymbolName.$$$reportNull$$$0(3);
        }
        if ((symbol = item.getSymbol()) instanceof OCSymbolWithQualifiedName) {
            OCQualifiedName name;
            OCResolveContext context = OCResolveContext.forSymbol(symbol, item.getProject());
            OCSymbolWithQualifiedName owner = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context);
            if (symbol instanceof OCFunctionSymbol && owner != null) {
                owner = owner.getResolvedOwner(context);
            }
            if (owner != null && (name = owner.getResolvedQualifiedName(context)) != null) {
                return name.getFullName(context).substring(2);
            }
        }
        return (file = symbol.getContainingFile()) != null ? file.getName() : "";
    }

    @NotNull
    public String getReadableName(@NotNull OCSymbolNavigationItem symbol) {
        if (symbol == null) {
            OCFieldAdapterForSymbolName.$$$reportNull$$$0(4);
        }
        String string = symbol.getSymbol().getPresentableName();
        if (string == null) {
            OCFieldAdapterForSymbolName.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected boolean isTopLevelOnly() {
        return true;
    }

    @NotNull
    public Collection<OCSymbolNavigationItem> collectValuesFromProject(final @NotNull Project project, final @Nullable Condition<OCSymbolNavigationItem> condition) {
        if (project == null) {
            OCFieldAdapterForSymbolName.$$$reportNull$$$0(6);
        }
        if (project.isDisposed()) {
            List<OCSymbolNavigationItem> list = Collections.emptyList();
            if (list == null) {
                OCFieldAdapterForSymbolName.$$$reportNull$$$0(7);
            }
            return list;
        }
        Collection allValues = OCFieldAdapter.collectAllValues((Project)project, Collections.emptyList(), () -> {
            if (project.isDisposed()) {
                return Collections.emptyList();
            }
            CommonProcessors.CollectProcessor allCollector = new CommonProcessors.CollectProcessor();
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project, (Processor<? super OCSymbol>)allCollector, null, this.isTopLevelOnly());
            return allCollector.getResults();
        });
        Collection collection = (Collection)OCFieldAdapter.computeWithWriteActionPriority((Project)project, indicator -> {
            final ArrayList results = new ArrayList();
            Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){
                final Set<String> uniquePresentationName = new HashSet<String>();

                public boolean process(OCSymbol symbol) {
                    OCSymbolNavigationItem item = new OCSymbolNavigationItem(symbol, project);
                    if (this.accept(item)) {
                        results.add(item);
                    }
                    return true;
                }

                private boolean accept(OCSymbolNavigationItem item) {
                    ProgressManager.checkCanceled();
                    Boolean res = null;
                    while (res == null) {
                        try {
                            res = (Boolean)ProgressManager.getInstance().runProcess(() -> (Boolean)ReadAction.compute(() -> {
                                if (project.isDisposed()) {
                                    return false;
                                }
                                String mappedSymbolName = OCFieldAdapterForSymbolName.this.getReadableName(item);
                                if (!this.uniquePresentationName.contains(mappedSymbolName) && (condition == null || condition.value((Object)item))) {
                                    this.uniquePresentationName.add(mappedSymbolName);
                                    return true;
                                }
                                return false;
                            }), indicator);
                        }
                        catch (ProcessCanceledException processCanceledException) {}
                    }
                    return res;
                }
            };
            ContainerUtil.process((Iterable)allValues, (Processor)processor2);
            return results;
        });
        if (collection == null) {
            OCFieldAdapterForSymbolName.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
        if (prefix == null) {
            OCFieldAdapterForSymbolName.$$$reportNull$$$0(9);
        }
        boolean caseSensitive = CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE != 3 && CodeInsightSettings.getInstance().COMPLETION_CASE_SENSITIVE != 2;
        return new CamelHumpMatcher(prefix, caseSensitive);
    }

    public String getPrefix(@NotNull String text, int offset) {
        if (text == null) {
            OCFieldAdapterForSymbolName.$$$reportNull$$$0(10);
        }
        int i = text.lastIndexOf(32, offset - 1) + 1;
        int j = text.lastIndexOf(10, offset - 1) + 1;
        return text.substring(Math.max(i, j), offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/ui/OCFieldAdapterForSymbolName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/ui/OCFieldAdapterForSymbolName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectValuesFromProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReadableName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectValuesFromProject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPrefixMatcher";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

