/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.Predicate;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCCompoundInitializerChecker;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_AlwaysError;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_AlwaysOk;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCArrayType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCAutoType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCBlockPointerType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCEllipsisType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCFunctionType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCIdType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCIntType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCObjectType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCPointerType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCRealType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCReferenceType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCStructType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor_OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCNumber;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCTypeCompatibilityVisitor<T extends OCType>
implements OCTypeVisitor<OCTypeCheckResult> {
    @NotNull
    protected final T mySourceType;
    @Nullable
    protected final OCTypeOwner mySource;
    @Nullable
    protected final PsiElement myContext;
    protected final boolean myAllowImplicitConversions;
    protected final boolean myAssumeNullSubstitutionsEquals;
    @NotNull
    protected final OCResolveContext myResolveContext;
    protected boolean myIsSecondStepOfCopyInit;
    protected boolean myIsCopyInitWithSameClass;

    public void setIsSecondStepOfCopyInit() {
        this.myIsSecondStepOfCopyInit = true;
    }

    public static OCTypeCheckResult checkConvertible(OCType destType, OCType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean allowImplicitConstructors, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(0);
        }
        return OCTypeCompatibilityVisitor.checkConvertibleImpl(destType, sourceType, source, context, allowImplicitConversions, allowImplicitConstructors, resolveContext);
    }

    private static OCTypeCheckResult checkConvertibleImpl(OCType destType, OCType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean allowImplicitConstructors, @NotNull OCResolveContext resolveContext) {
        OCTypeCheckResult result;
        OCTypeCheckResult check;
        if (resolveContext == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(1);
        }
        boolean usingZeroAsNil = false;
        if (sourceType instanceof OCIntType) {
            if (source instanceof OCLiteralExpression || source instanceof OCLiteralExpressionSymbol) {
                sourceType = source.getResolvedType(resolveContext);
            }
            OCPointerType destTypePtr = null;
            if (destType instanceof OCPointerType) {
                destTypePtr = (OCPointerType)destType;
            } else if (destType instanceof OCCppReferenceType && ((OCCppReferenceType)destType).getRefType() instanceof OCPointerType) {
                destTypePtr = (OCPointerType)((OCCppReferenceType)destType).getRefType();
            }
            if (destTypePtr != null) {
                OCType pointerType = OCExpressionEvaluator.getPointerType(source, resolveContext);
                if (pointerType instanceof OCUnknownType) {
                    if (destTypePtr.isPointerToPointerToObjectCompatible()) {
                        usingZeroAsNil = true;
                    } else if (!(destTypePtr instanceof OCArrayType) || !((OCArrayType)destTypePtr).hasLength()) {
                        return OCTypeCheckResult.createOK();
                    }
                } else if (pointerType != null) {
                    sourceType = pointerType;
                }
            }
        } else if (sourceType.isPointerToVoid() && OCExpressionEvaluator.isLikeNil(source, resolveContext)) {
            sourceType = destType;
        }
        if (source instanceof OCCompoundInitializer) {
            return OCCompoundInitializerChecker.checkCompoundInitializer((OCCompoundInitializer)source, destType, allowImplicitConversions && allowImplicitConstructors, resolveContext);
        }
        OCTypeCompatibilityVisitor<OCType> visitor = OCTypeCompatibilityVisitor.createOCTypeCompatibilityVisitor(sourceType, source, context, allowImplicitConversions && allowImplicitConstructors, resolveContext);
        if (destType.isCppStructType(resolveContext) && TypeProperties.hasSameUnqualifiedType(sourceType, destType, resolveContext)) {
            visitor.setIsCopyInitWithSameClass();
        }
        if ((check = destType.accept(visitor)).getState() == OCTypeCheckState.OK) {
            return check;
        }
        if (usingZeroAsNil && source instanceof OCExpression) {
            if (OCCodeInsightUtil.isLikeNull(((OCExpression)source).getTextWithMacros())) {
                return OCTypeCheckResult.createOK();
            }
            return new OCTypeCheckResult(OCTypeCheckState.WARNING);
        }
        if (allowImplicitConversions && visitor.mySourceType instanceof OCStructType && (result = OCTypeCompatibilityVisitor.checkConversionOperators(destType, (OCStructType)visitor.mySourceType, visitor.mySource, visitor.myContext, check, context instanceof OCCastExpression, resolveContext)) != null) {
            return result;
        }
        return check;
    }

    private void setIsCopyInitWithSameClass() {
        this.myIsCopyInitWithSameClass = true;
    }

    public static OCTypeCheckResult checkConversionOperators(OCType destType, OCStructType sourceType, @Nullable OCTypeOwner source, PsiElement context, @Nullable OCTypeCheckResult bestResult, boolean isExplicitCast, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(2);
        }
        Ref result = Ref.create((Object)bestResult);
        if (sourceType.isSubclassOfMagic(resolveContext)) {
            return OCTypeCheckResult.createOK();
        }
        sourceType.processMembers(null, (Processor<? super OCSymbol>)((Processor)symbol -> {
            if (!(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isCppConversionOperator() || !isExplicitCast && ((OCFunctionSymbol)symbol).isExplicit()) {
                return true;
            }
            OCType returnType = symbol.getEffectiveResolvedType(resolveContext);
            if (destType instanceof OCCppReferenceType && ((OCCppReferenceType)destType).getRefType().isScalar() && !(returnType instanceof OCCppReferenceType)) {
                return true;
            }
            OCTypeCompatibilityVisitor<OCType> visitor1 = OCTypeCompatibilityVisitor.createOCTypeCompatibilityVisitor(returnType, source, context, false, resolveContext);
            visitor1.setIsSecondStepOfCopyInit();
            OCTypeCheckResult curResult = destType.accept(visitor1);
            if (result.isNull() || curResult.getState().compareTo(((OCTypeCheckResult)result.get()).getState()) < 0 || curResult.getState() == ((OCTypeCheckResult)result.get()).getState() && OCTypeCompatibilityVisitor.getTypesDifference(returnType, destType, resolveContext) < OCTypeCompatibilityVisitor.getTypesDifference(((OCTypeCheckResult)result.get()).getTypeAfterConversion(), destType, resolveContext)) {
                if (curResult.getState() == OCTypeCheckState.OK) {
                    OCTypeCheckResult newResult = new OCTypeCheckResult(OCTypeCheckState.OK, null, returnType);
                    newResult.setImplicitConstructor((OCFunctionSymbol)symbol);
                    result.set((Object)newResult);
                } else {
                    curResult.setImplicitConstructor((OCFunctionSymbol)symbol);
                    curResult.setConversion(null, returnType);
                    result.set((Object)curResult);
                }
            }
            return true;
        }), resolveContext);
        return (OCTypeCheckResult)result.get();
    }

    public static OCTypeCheckResult checkConstructors(OCStructType destType, OCType sourceType, OCTypeOwner source, @NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(3);
        }
        OCTypeCompatibilityVisitor<OCType> visitor = OCTypeCompatibilityVisitor.createOCTypeCompatibilityVisitor(sourceType, source, context.getElement(), false, context);
        for (OCStructSymbol struct : destType.getStructs()) {
            OCTypeCheckResult result = OCTypeCompatibilityVisitor.processConstructors(struct, visitor.mySourceType, visitor.mySource, visitor.myContext, visitor.myResolveContext, visitor.myIsCopyInitWithSameClass);
            if (result == null) continue;
            return result;
        }
        return OCTypeCheckResult.createError();
    }

    @Nullable
    public static Pair<OCType, OCFunctionSymbol> convertByOperator(@NotNull OCStructType source, boolean acceptExplicitOperators, boolean removeReferences, @NotNull OCResolveContext resolveContext, @NotNull Predicate<OCType> typesAcceptor) {
        Ref conversionOp;
        Ref convertedTy;
        Processor convertingProcessor;
        boolean hasUniqueTargetType;
        if (source == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(4);
        }
        if (resolveContext == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(5);
        }
        if (typesAcceptor == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(6);
        }
        if (!(hasUniqueTargetType = source.processMembers(null, (Processor<? super OCSymbol>)(convertingProcessor = arg_0 -> OCTypeCompatibilityVisitor.lambda$convertByOperator$1(acceptExplicitOperators, resolveContext, removeReferences, typesAcceptor, convertedTy = Ref.create(), conversionOp = Ref.create(), arg_0)), resolveContext))) {
            return null;
        }
        if (convertedTy.isNull() || conversionOp.isNull()) {
            return null;
        }
        return Pair.create((Object)((OCType)convertedTy.get()), (Object)((OCFunctionSymbol)conversionOp.get()));
    }

    protected OCTypeCompatibilityVisitor(@NotNull T sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        if (sourceType == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(7);
        }
        if (resolveContext == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(8);
        }
        this.myIsSecondStepOfCopyInit = false;
        this.myIsCopyInitWithSameClass = false;
        this.mySourceType = sourceType;
        this.myResolveContext = resolveContext;
        this.mySource = source;
        this.myContext = context;
        this.myAllowImplicitConversions = allowImplicitConversions;
        this.myAssumeNullSubstitutionsEquals = assumeNullSubstitutionsEquals;
    }

    public static OCTypeCompatibilityVisitor<? extends OCType> createOCTypeCompatibilityVisitor(@Nullable OCType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(9);
        }
        if (sourceType == null) {
            sourceType = OCUnknownType.INSTANCE;
        }
        return sourceType.accept(new OCTypeCompatibilityVisitorCreator(source, context, allowImplicitConversions, true, resolveContext));
    }

    @Override
    public OCTypeCheckResult visitCppReferenceType(OCCppReferenceType type) {
        if (!(this.mySource == null || type.isReferenceToConst() || type.isRvalueRef() || type.isUnknown() || OCExprValueCategory.classify(this.mySource, this.myResolveContext).isLValue())) {
            return OCTypeCheckResult.createError();
        }
        OCType refType = type.getRefType();
        if (!(!refType.isScalar() && !((OCType)this.mySourceType).isScalar() || refType.isConst() || type.isRvalueRef() || refType instanceof OCEllipsisType || this.myContext instanceof OCCastExpression || new OCTypeEqualityVisitor((OCType)this.mySourceType, true, true, this.myResolveContext).equal(refType))) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
        }
        boolean equalOrDerivedToBase = OCTypeUtils.isSameOrDerivedFrom(this.mySourceType, type.getRefType(), this.myResolveContext);
        if (type.isRvalueRef() && equalOrDerivedToBase && !this.myIsSecondStepOfCopyInit && !(type.getTerminalType() instanceof OCMagicType) && !(type.getTerminalType() instanceof OCAutoType) && OCExprValueCategory.classify(this.mySource, this.myResolveContext).isLValue()) {
            return OCTypeCheckResult.createError();
        }
        if (!(!((OCType)this.mySourceType).isConst() || refType.isConst() || refType.isUnknown() || type.isRvalueRef() && !equalOrDerivedToBase)) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
        }
        return equalOrDerivedToBase ? OCTypeCheckResult.createOK() : this.checkRefType(type);
    }

    protected OCTypeCheckResult checkRefType(OCCppReferenceType type) {
        return type.getRefType().accept(this);
    }

    public static int getTypesDifference(@Nullable OCType type1, @Nullable OCType type2, @NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(10);
        }
        if (type1 == null || type2 == null) {
            return -1;
        }
        if (type1 instanceof OCArrayType && type2 instanceof OCPointerType || type2 instanceof OCArrayType && type1 instanceof OCPointerType) {
            return 100 + OCTypeCompatibilityVisitor.getTypesDifference(((OCPointerType)type1).getRefType(), ((OCPointerType)type2).getRefType(), context);
        }
        if (!(type2.getClass().equals(type1.getClass()) || type1.equals(OCIntType.INT, context) && type2 instanceof OCStructType && ((OCStructType)type2).isEnum() || type2.equals(OCIntType.INT, context) && type1 instanceof OCStructType && ((OCStructType)type1).isEnum())) {
            return 1000;
        }
        if (type1 instanceof OCIntType) {
            OCIntType intType1 = (OCIntType)type1;
            if (type2 instanceof OCIntType) {
                OCIntType intType2 = (OCIntType)type2;
                int rank1 = intType1.getCTypeId().ordinal() * 2 + (intType1.isSigned() ? 0 : 1);
                int rank2 = intType2.getCTypeId().ordinal() * 2 + (intType2.isSigned() ? 0 : 1);
                return Math.abs(rank1 - rank2);
            }
        }
        if (!type2.equals(type1, context)) {
            if (type1 instanceof OCCppReferenceType) {
                type1 = ((OCCppReferenceType)type1).getRefType();
            }
            if (type2 instanceof OCCppReferenceType) {
                type2 = ((OCCppReferenceType)type2).getRefType();
            }
            if (type2.equals(type1, false, context)) {
                return 50;
            }
            return type1.isUnknown() || type1.isMagicInside(context) ? 100 : 200;
        }
        return 0;
    }

    protected boolean bothTypesEquals(OCType type, OCType firstType, OCType secondType) {
        return type.equals(firstType, false, this.myResolveContext) && type.equals(secondType, false, this.myResolveContext);
    }

    protected OCTypeCheckResult visitType(OCType type) {
        boolean unknown;
        if (this.mySourceType instanceof OCMagicType || type instanceof OCAutoType || this.mySourceType instanceof OCAutoType) {
            return OCTypeCheckResult.createOK();
        }
        boolean bl = unknown = type.isUnknown() || ((OCType)this.mySourceType).isUnknown();
        if (unknown && type.getCanonicalName(this.myResolveContext).equals(((OCType)this.mySourceType).getCanonicalName(this.myResolveContext))) {
            return OCTypeCheckResult.createOK();
        }
        return OCTypeCheckResult.createError();
    }

    @NotNull
    protected OCTypeCheckResult visitNumericType(OCNumericType type) {
        if (this.mySourceType instanceof OCMagicType) {
            OCTypeCheckResult oCTypeCheckResult = OCTypeCheckResult.createOK();
            if (oCTypeCheckResult == null) {
                OCTypeCompatibilityVisitor.$$$reportNull$$$0(11);
            }
            return oCTypeCheckResult;
        }
        T t = this.mySourceType;
        if (t instanceof OCNumericType) {
            OCNumericType numericType = (OCNumericType)t;
            if (OCIntType.isBool(type, this.myResolveContext) && OCIntType.isBool(this.mySourceType, this.myResolveContext)) {
                OCTypeCheckResult oCTypeCheckResult = OCTypeCheckResult.createOK();
                if (oCTypeCheckResult == null) {
                    OCTypeCompatibilityVisitor.$$$reportNull$$$0(12);
                }
                return oCTypeCheckResult;
            }
            if (type.getRank(this.myResolveContext) < numericType.getRank(this.myResolveContext)) {
                OCTypeOwner source;
                if (this.mySource != null && this.mySourceType instanceof OCIntType && type instanceof OCIntType) {
                    Number value = OCExpressionEvaluator.evaluate(this.mySource, this.myResolveContext);
                    if (value != null && ((OCIntType)type).canRepresent(OCNumber.valueOf(value), this.myContext)) {
                        OCTypeCheckResult oCTypeCheckResult = OCTypeCheckResult.createOK();
                        if (oCTypeCheckResult == null) {
                            OCTypeCompatibilityVisitor.$$$reportNull$$$0(13);
                        }
                        return oCTypeCheckResult;
                    }
                    if (value == null && type.getCTypeId().equals((Object)((OCIntType)this.mySourceType).getCTypeId())) {
                        OCTypeCheckResult oCTypeCheckResult = OCTypeCheckResult.createOK();
                        if (oCTypeCheckResult == null) {
                            OCTypeCompatibilityVisitor.$$$reportNull$$$0(14);
                        }
                        return oCTypeCheckResult;
                    }
                    if (((OCIntType)this.mySourceType).getCTypeId() == CTypeId.SIZE_T) {
                        OCTypeCheckResult oCTypeCheckResult = OCTypeCheckResult.createOK();
                        if (oCTypeCheckResult == null) {
                            OCTypeCompatibilityVisitor.$$$reportNull$$$0(15);
                        }
                        return oCTypeCheckResult;
                    }
                }
                if (this.mySource != null && this.mySourceType instanceof OCRealType && type instanceof OCRealType && (source = OCParenthesesUtils.diveIntoParentheses(this.mySource)) instanceof OCLiteralExpression && OCRealType.narrowestLiteralType(((OCLiteralExpression)source).getUnescapedLiteralText()).getRank(this.myResolveContext) == type.getRank(this.myResolveContext)) {
                    OCTypeCheckResult oCTypeCheckResult = OCTypeCheckResult.createOK();
                    if (oCTypeCheckResult == null) {
                        OCTypeCompatibilityVisitor.$$$reportNull$$$0(16);
                    }
                    return oCTypeCheckResult;
                }
                return new OCTypeCheckResult(OCTypeCheckState.WARNING);
            }
            if (!type.isComplex() && numericType.isComplex()) {
                return new OCTypeCheckResult(OCTypeCheckState.WARNING);
            }
            if (!(type.isSigned() || !numericType.isSigned() || this.mySource != null && this.mySourceType instanceof OCIntType && OCExpressionEvaluator.isPositive(this.mySource, this.myResolveContext))) {
                return new OCTypeCheckResult(OCTypeCheckState.WARNING);
            }
            OCTypeCheckResult oCTypeCheckResult = OCTypeCheckResult.createOK();
            if (oCTypeCheckResult == null) {
                OCTypeCompatibilityVisitor.$$$reportNull$$$0(17);
            }
            return oCTypeCheckResult;
        }
        if (this.mySourceType instanceof OCStructType && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM) {
            if (((OCStructType)this.mySourceType).isEnumClass()) {
                return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
            }
            OCTypeCheckResult oCTypeCheckResult = OCTypeCheckResult.createOK();
            if (oCTypeCheckResult == null) {
                OCTypeCompatibilityVisitor.$$$reportNull$$$0(18);
            }
            return oCTypeCheckResult;
        }
        if (((OCType)this.mySourceType).isPointerCompatible(this.myResolveContext, false)) {
            if (OCIntType.isBool(type, this.myResolveContext)) {
                return new OCTypeCheckResult(OCTypeCheckState.WARNING);
            }
            if (type instanceof OCIntType) {
                return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
            }
            OCTypeCheckResult oCTypeCheckResult = this.visitType(type);
            if (oCTypeCheckResult == null) {
                OCTypeCompatibilityVisitor.$$$reportNull$$$0(19);
            }
            return oCTypeCheckResult;
        }
        OCTypeCheckResult oCTypeCheckResult = this.visitType(type);
        if (oCTypeCheckResult == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(20);
        }
        return oCTypeCheckResult;
    }

    @NotNull
    protected OCTypeCheckResult checkStructCompatibleCtor(OCStructType type) {
        for (OCStructSymbol struct : type.getStructs()) {
            OCTypeCheckResult result = this.processTransparentUnion(struct, type);
            if (result != null) {
                OCTypeCheckResult oCTypeCheckResult = result;
                if (oCTypeCheckResult == null) {
                    OCTypeCompatibilityVisitor.$$$reportNull$$$0(21);
                }
                return oCTypeCheckResult;
            }
            if (this.myAllowImplicitConversions) {
                result = OCTypeCompatibilityVisitor.processConstructors(struct, this.mySourceType, this.mySource, this.myContext, this.myResolveContext, this.myIsCopyInitWithSameClass);
            }
            if (result == null) continue;
            OCTypeCheckResult oCTypeCheckResult = result;
            if (oCTypeCheckResult == null) {
                OCTypeCompatibilityVisitor.$$$reportNull$$$0(22);
            }
            return oCTypeCheckResult;
        }
        OCTypeCheckResult oCTypeCheckResult = this.visitType(type);
        if (oCTypeCheckResult == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(23);
        }
        return oCTypeCheckResult;
    }

    @NotNull
    protected OCTypeCheckResult checkAssignToEnum(OCStructType type) {
        OCTypeCheckState state = OCTypeCheckState.ERROR_IF_CPP;
        Number value = OCExpressionEvaluator.evaluate(this.mySource, this.myResolveContext);
        if (value != null && this.mySource instanceof OCExpression) {
            OCSymbol enumConst = OCExpressionEvaluator.findMatchingEnumConst(type, value.intValue(), this.myResolveContext);
            if (enumConst != null) {
                OCExpression element = OCElementFactory.expressionFromText(enumConst.getName(), (PsiElement)this.mySource, false);
                if (element != null) {
                    return new OCTypeCheckResult(state);
                }
            } else {
                String typeName = type.getBestNameInContext(this.myResolveContext);
                if (value.intValue() == 0 && typeName.endsWith("Options")) {
                    OCTypeCheckResult oCTypeCheckResult = OCTypeCheckResult.createOK();
                    if (oCTypeCheckResult == null) {
                        OCTypeCompatibilityVisitor.$$$reportNull$$$0(24);
                    }
                    return oCTypeCheckResult;
                }
            }
        }
        return new OCTypeCheckResult(state);
    }

    @Override
    public OCTypeCheckResult visitEllipsisReferenceType(OCEllipsisType type) {
        return OCTypeCheckResult.createOK();
    }

    protected boolean isSuperTypeForFunctionChecks(OCType left, OCType right) {
        if (left.isPointerToObject() && right.isPointerToObject()) {
            return left.isCompatible(right, this.myResolveContext);
        }
        if (left instanceof OCIntType && right instanceof OCStructType && ((OCStructType)right).getKind() == OCSymbolKind.ENUM && !((OCStructType)right).isEnumClass()) {
            return true;
        }
        if (right instanceof OCIntType && left instanceof OCStructType && ((OCStructType)left).getKind() == OCSymbolKind.ENUM && !((OCStructType)left).isEnumClass()) {
            return true;
        }
        return new OCTypeEqualityAfterResolvingVisitor(right, false, true, false, true, this.myResolveContext).equal(left);
    }

    @Override
    public OCTypeCheckResult visitArrayType(OCArrayType type) {
        boolean allowArraysAssignment;
        boolean bl = allowArraysAssignment = !this.myAssumeNullSubstitutionsEquals;
        if (allowArraysAssignment && this.mySourceType instanceof OCArrayType && ((OCArrayType)this.mySourceType).getLength(this.myResolveContext) == type.getLength(this.myResolveContext)) {
            return OCTypeCheckResult.createOK();
        }
        if (!type.hasLength()) {
            return (OCTypeCheckResult)this.visitPointerType(type);
        }
        return new OCTypeCheckResult(this, OCTypeCheckState.ERROR){

            @Override
            public boolean canBeCasted(OCType lType, OCType rType, @NotNull OCResolveContext context) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor$1", "canBeCasted"));
            }
        };
    }

    protected boolean isCppClassType(OCType type) {
        return ((OCFile)this.myContext.getContainingFile()).isCpp() && type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.STRUCT;
    }

    @Nullable
    protected OCTypeCheckResult checkArcBridgeCast(OCPointerType type, boolean tollFreeBridge) {
        boolean isCast;
        boolean bl = isCast = this.mySource instanceof OCExpression && ((OCExpression)this.mySource).getParent() instanceof OCCastExpression;
        if (this.mySource instanceof OCLiteralExpression && ((OCType)this.mySourceType).isPointerToString()) {
            return null;
        }
        if (this.mySource instanceof OCSendMessageExpression && ((OCType)this.mySourceType).isPointerToVoid()) {
            return null;
        }
        if (type.getRefType().isVoid() && !((OCType)this.mySourceType).isPointerToObjectCompatible() && ((OCType)this.mySourceType).isPointerToPointerToObjectCompatible()) {
            return null;
        }
        if (isCast && ((OCType)this.mySourceType).isPointerToVoid() && !type.isPointerToObjectCompatible() && type.isPointerToPointerToObjectCompatible()) {
            return null;
        }
        if (isCast && (type.isPointerToObjectCompatible() || ((OCType)this.mySourceType).isPointerToObjectCompatible())) {
            if (type.isPointerToObject()) {
                OCSymbol symbol;
                if (this.mySource instanceof OCCallExpression) {
                    symbol = OCGetSymbolVisitor.getSymbol(((OCCallExpression)this.mySource).getFunctionReferenceExpression());
                } else if (this.mySource instanceof OCSendMessageExpression) {
                    symbol = ((OCSendMessageExpression)this.mySource).getProbableResponders().getKnownResponder();
                    if (symbol != null) {
                        symbol = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
                    }
                } else {
                    symbol = OCGetSymbolVisitor.getSymbol((OCExpression)this.mySource);
                }
                if (symbol instanceof OCFunctionSymbol && symbol.hasAttribute("ImplicitBridging")) {
                    return null;
                }
                if (symbol instanceof OCPropertySymbol) {
                    return null;
                }
                if (symbol instanceof OCDeclaratorSymbol && !OCSearchScope.isInProjectSources(symbol, this.myResolveContext.getProject()) && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION) {
                    return null;
                }
            }
            return OCTypeCheckResult.createError();
        }
        if (tollFreeBridge) {
            return OCTypeCheckResult.createError();
        }
        return OCTypeCheckResult.createError();
    }

    @Override
    public OCTypeCheckResult visitBlockPointerType(OCBlockPointerType type) {
        return (OCTypeCheckResult)this.visitPointerType(type);
    }

    @Override
    public OCTypeCheckResult visitIdType(OCIdType type) {
        return (OCTypeCheckResult)this.visitObjectType(type);
    }

    @Override
    public OCTypeCheckResult visitIntType(OCIntType type) {
        return this.visitNumericType(type);
    }

    @Override
    public OCTypeCheckResult visitRealType(OCRealType type) {
        return this.visitNumericType(type);
    }

    @Override
    public OCTypeCheckResult visitReferenceType(OCReferenceType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitAutoType(OCAutoType type) {
        return OCTypeCheckResult.createOK();
    }

    @Override
    public OCTypeCheckResult visitStructuredBindingType(OCStructuredBindingType type) {
        return OCTypeCheckResult.createOK();
    }

    @Override
    public OCTypeCheckResult visitDeferredType(OCDeferredType type) {
        return type.getActualType(this.myResolveContext).accept(this);
    }

    @Nullable
    protected static OCTypeCheckResult processConstructors(OCStructSymbol struct, OCType sourceType, OCTypeOwner source, PsiElement context, OCResolveContext resolveContext, boolean allowImplicitConversions) {
        OCArgumentsList<OCTypeOwner> arguments = new OCArgumentsList<OCTypeOwner>(Collections.singletonList(sourceType), source != null ? Collections.singletonList(source) : null);
        OCFunctionSymbol constructor = struct.findConstructor(arguments, resolveContext, context, allowImplicitConversions, () -> {
            if (context instanceof OCCallExpression) {
                OCSymbol symbol = OCGetSymbolVisitor.getSymbol(((OCCallExpression)context).getFunctionReferenceExpression());
                return symbol instanceof OCStructSymbol || symbol != null && symbol.getKind() == OCSymbolKind.TYPEDEF;
            }
            return false;
        }, false, struct.getType()).getSymbol();
        if (constructor instanceof OCFunctionGroupSymbol && ((OCFunctionGroupSymbol)constructor).getCause() != OCFunctionGroupSymbol.Cause.Magic) {
            return null;
        }
        if (constructor != null) {
            List<OCType> types = constructor.getType().getParameterTypes();
            OCType argumentType = types.get(0).resolve(resolveContext);
            return new OCTypeCheckResult(OCTypeCheckState.OK, argumentType, struct.getType()).setImplicitConstructor(constructor);
        }
        if (struct.isPredeclaration()) {
            return OCTypeCheckResult.createOK();
        }
        return null;
    }

    @Nullable
    protected OCTypeCheckResult processTransparentUnion(OCStructSymbol struct, OCStructType type) {
        if (type.getKind() != OCSymbolKind.UNION || !struct.isTransparentUnion()) {
            return null;
        }
        final Ref result = Ref.create(null);
        CommonProcessors.FindFirstProcessor<OCDeclaratorSymbol> finder = new CommonProcessors.FindFirstProcessor<OCDeclaratorSymbol>(){

            protected boolean accept(OCDeclaratorSymbol field) {
                OCTypeCheckResult curResult = field.getType().resolve(OCTypeCompatibilityVisitor.this.myResolveContext).checkCompatible((OCType)OCTypeCompatibilityVisitor.this.mySourceType, OCTypeCompatibilityVisitor.this.mySource, OCTypeCompatibilityVisitor.this.myContext, OCTypeCompatibilityVisitor.this.myResolveContext);
                if (curResult.getState() == OCTypeCheckState.OK) {
                    result.set((Object)curResult);
                    return true;
                }
                if (!curResult.getState().isError(OCTypeCompatibilityVisitor.this.myContext) && result.isNull()) {
                    result.set((Object)curResult);
                }
                return false;
            }
        };
        struct.processFields((Processor<? super OCDeclaratorSymbol>)finder);
        return (OCTypeCheckResult)result.get();
    }

    @Override
    public OCTypeCheckResult visitVariadicType(OCVariadicType type) {
        return OCTypeCheckResult.createOK();
    }

    @Override
    public OCTypeCheckResult visitExpansionPackType(OCExpansionPackType type) {
        return OCTypeCheckResult.createOK();
    }

    @Override
    public OCTypeCheckResult visitUnknownType(OCUnknownType type) {
        return this.visitMagicType(type);
    }

    @Override
    public OCTypeCheckResult visitMagicType(OCMagicType type) {
        return OCTypeCheckResult.createOK();
    }

    @Override
    public OCTypeCheckResult visitBracedInitListType(OCBracedInitListType type) {
        return OCTypeCheckResult.createOK();
    }

    @Override
    public OCTypeCheckResult visitVoidType(OCVoidType type) {
        if (((OCType)this.mySourceType).isVoid() || this.mySourceType instanceof OCMagicType || this.myContext instanceof OCCastExpression) {
            return OCTypeCheckResult.createOK();
        }
        return OCTypeCheckResult.createError();
    }

    @Override
    public OCTypeCheckResult visitTypeParameterType(OCTypeParameterType type) {
        return this.visitMagicType(type);
    }

    @NotNull
    protected OCTypeCheckResult getProtocolCompatibilityCheckResult(@NotNull OCObjectType sourceType, @NotNull OCObjectType type) {
        if (sourceType == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(25);
        }
        if (type == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(26);
        }
        for (OCProtocolSymbol protocol : type.getAllProtocols()) {
            if (sourceType.implementsProtocol(protocol)) continue;
            return new OCTypeCheckResult(OCTypeCheckState.WARNING);
        }
        OCTypeCheckResult oCTypeCheckResult = OCTypeCheckResult.createOK();
        if (oCTypeCheckResult == null) {
            OCTypeCompatibilityVisitor.$$$reportNull$$$0(27);
        }
        return oCTypeCheckResult;
    }

    private static /* synthetic */ boolean lambda$convertByOperator$1(boolean acceptExplicitOperators, OCResolveContext resolveContext, boolean removeReferences, Predicate typesAcceptor, Ref convertedTy, Ref conversionOp, OCSymbol symbol) {
        if (!(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isCppConversionOperator() || !acceptExplicitOperators && ((OCFunctionSymbol)symbol).isExplicit()) {
            return true;
        }
        OCType retType = symbol.getEffectiveResolvedType(resolveContext);
        if (removeReferences) {
            retType = OCTypeUtils.getCppReferencedType(retType);
        }
        if (typesAcceptor.apply((Object)retType)) {
            if (convertedTy.isNull()) {
                assert (conversionOp.isNull());
                convertedTy.set((Object)retType);
                conversionOp.set((Object)((OCFunctionSymbol)symbol));
                return true;
            }
            return ((OCType)convertedTy.get()).equalsAfterResolving(retType, resolveContext);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesAcceptor";
                break;
            }
            case 7: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "visitNumericType";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "checkStructCompatibleCtor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAssignToEnum";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocolCompatibilityCheckResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkConvertible";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkConvertibleImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkConversionOperators";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructors";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertByOperator";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createOCTypeCompatibilityVisitor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypesDifference";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: {
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getProtocolCompatibilityCheckResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 27 -> new IllegalStateException(string);
        };
    }

    private static class OCTypeCompatibilityVisitorCreator
    implements OCTypeVisitor<OCTypeCompatibilityVisitor<? extends OCType>> {
        private final OCTypeOwner mySource;
        @Nullable
        private final PsiElement myContext;
        private final boolean myAllowImplicitConversions;
        private final boolean myAssumeNullSubstitutionsEquals;
        @NotNull
        private final OCResolveContext myResolveContext;

        OCTypeCompatibilityVisitorCreator(@Nullable OCTypeOwner source, @Nullable PsiElement context, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
            if (resolveContext == null) {
                OCTypeCompatibilityVisitorCreator.$$$reportNull$$$0(0);
            }
            this.mySource = source;
            this.myContext = context;
            this.myAllowImplicitConversions = allowImplicitConversions;
            this.myAssumeNullSubstitutionsEquals = assumeNullSubstitutionsEquals;
            this.myResolveContext = resolveContext;
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitEllipsisReferenceType(OCEllipsisType sourceType) {
            return new OCTypeCompatibilityVisitor_OCEllipsisType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitFunctionType(OCFunctionType sourceType) {
            return new OCTypeCompatibilityVisitor_OCFunctionType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitMagicType(OCMagicType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCMagicType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitObjectType(OCObjectType sourceType) {
            return new OCTypeCompatibilityVisitor_OCObjectType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitArrayType(OCArrayType sourceType) {
            return new OCTypeCompatibilityVisitor_OCArrayType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitPointerType(OCPointerType sourceType) {
            return new OCTypeCompatibilityVisitor_OCPointerType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitBlockPointerType(OCBlockPointerType sourceType) {
            return new OCTypeCompatibilityVisitor_OCBlockPointerType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitCppReferenceType(OCCppReferenceType sourceType) {
            return sourceType.getRefType(this.myContext).accept(this);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitIdType(OCIdType sourceType) {
            return new OCTypeCompatibilityVisitor_OCIdType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitIntType(OCIntType sourceType) {
            return new OCTypeCompatibilityVisitor_OCIntType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitRealType(OCRealType sourceType) {
            return new OCTypeCompatibilityVisitor_OCRealType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitReferenceType(OCReferenceType sourceType) {
            return new OCTypeCompatibilityVisitor_OCReferenceType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitStructType(OCStructType sourceType) {
            return new OCTypeCompatibilityVisitor_OCStructType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitUnknownType(OCUnknownType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCUnknownType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitVoidType(OCVoidType sourceType) {
            return new OCTypeCompatibilityVisitor_OCVoidType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitTypeParameterType(OCTypeParameterType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCTypeParameterType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitAutoType(OCAutoType sourceType) {
            return new OCTypeCompatibilityVisitor_OCAutoType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitVariadicType(OCVariadicType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCVariadicType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitExpansionPackType(OCExpansionPackType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysOk<OCExpansionPackType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitBracedInitListType(OCBracedInitListType sourceType) {
            return new OCTypeCompatibilityVisitor_AlwaysError<OCBracedInitListType>(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitStructuredBindingType(OCStructuredBindingType sourceType) {
            return new OCTypeCompatibilityVisitor_OCStructuredBindingType(sourceType, this.mySource, this.myContext, this.myAllowImplicitConversions, this.myAssumeNullSubstitutionsEquals, this.myResolveContext);
        }

        @Override
        public OCTypeCompatibilityVisitor<? extends OCType> visitDeferredType(OCDeferredType sourceType) {
            return sourceType.getActualType(this.myResolveContext).accept(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/cidr/lang/types/visitors/OCTypeCompatibilityVisitor$OCTypeCompatibilityVisitorCreator", "<init>"));
        }
    }
}

