/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCActivityLog;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.zipcache.CidrZipBackedCache;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SymbolBuildingTask
extends DumbModeTask {
    @NotNull
    private final String myActivityName;
    @NotNull
    private final Project myProject;
    private volatile boolean myShouldCancel;

    public SymbolBuildingTask(@NotNull @NonNls String activityName, @NotNull Project project) {
        if (activityName == null) {
            SymbolBuildingTask.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SymbolBuildingTask.$$$reportNull$$$0(1);
        }
        this.myShouldCancel = true;
        this.myActivityName = activityName;
        this.myProject = project;
    }

    @Nullable
    public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
        if (taskFromQueue == null) {
            SymbolBuildingTask.$$$reportNull$$$0(2);
        }
        if (taskFromQueue.getClass().equals(((Object)((Object)this)).getClass()) && ((SymbolBuildingTask)taskFromQueue).myActivityName.equals(this.myActivityName) && ((SymbolBuildingTask)taskFromQueue).myProject.equals((Object)this.myProject)) {
            return this;
        }
        return null;
    }

    @NotNull
    public static SymbolBuildingTask scheduleSymbolActivity(@NonNls @NotNull String activityName, @NotNull Project project, final @NotNull Consumer<? super OCBuildingActivityProgressIndicator> task2) {
        if (activityName == null) {
            SymbolBuildingTask.$$$reportNull$$$0(3);
        }
        if (project == null) {
            SymbolBuildingTask.$$$reportNull$$$0(4);
        }
        if (task2 == null) {
            SymbolBuildingTask.$$$reportNull$$$0(5);
        }
        SymbolBuildingTask buildingTask = new SymbolBuildingTask(activityName, project){

            @Override
            protected void process(@NotNull OCBuildingActivityProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                task2.accept(indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/symbols/symtable/building/SymbolBuildingTask$1", "process"));
            }
        };
        buildingTask.queue(project);
        SymbolBuildingTask symbolBuildingTask = buildingTask;
        if (symbolBuildingTask == null) {
            SymbolBuildingTask.$$$reportNull$$$0(6);
        }
        return symbolBuildingTask;
    }

    @NotNull
    public static SymbolBuildingTask scheduleSymbolActivityAndWait(@NonNls @NotNull String activityName, @NotNull Project project, final @NotNull Consumer<? super OCBuildingActivityProgressIndicator> task2) {
        if (activityName == null) {
            SymbolBuildingTask.$$$reportNull$$$0(7);
        }
        if (project == null) {
            SymbolBuildingTask.$$$reportNull$$$0(8);
        }
        if (task2 == null) {
            SymbolBuildingTask.$$$reportNull$$$0(9);
        }
        final Semaphore sema = new Semaphore(1);
        SymbolBuildingTask buildingTask = new SymbolBuildingTask(activityName, project){

            @Override
            protected void process(@NotNull OCBuildingActivityProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                task2.accept(indicator);
                sema.up();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/symbols/symtable/building/SymbolBuildingTask$2", "process"));
            }
        };
        buildingTask.queue(project);
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            sema.waitFor();
        }
        SymbolBuildingTask symbolBuildingTask = buildingTask;
        if (symbolBuildingTask == null) {
            SymbolBuildingTask.$$$reportNull$$$0(10);
        }
        return symbolBuildingTask;
    }

    protected abstract void process(@NotNull OCBuildingActivityProgressIndicator var1);

    boolean shouldCancel() {
        return this.myShouldCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performInDumbMode(@NotNull ProgressIndicator original) {
        if (original == null) {
            SymbolBuildingTask.$$$reportNull$$$0(11);
        }
        OCBuildingActivityProgressIndicator indicator = new OCBuildingActivityProgressIndicator(original);
        Disposable cancelOnProjectDispose = () -> {
            if (this.myShouldCancel) {
                indicator.cancel();
            }
        };
        try {
            long start = System.currentTimeMillis();
            OCActivityLog.log(this.myProject, this.myActivityName + " " + start + ": START");
            Disposer.register((Disposable)OCSymbolTablesBuildingActivity.getInstance(this.myProject), (Disposable)cancelOnProjectDispose);
            this.process(indicator);
            this.myShouldCancel = false;
            OCActivityLog.log(this.myProject, this.myActivityName + " " + start + ": END after " + (System.currentTimeMillis() - start));
        }
        catch (ProcessCanceledException pce) {
            if (indicator.isCanceled()) {
                throw pce;
            }
            this.reportUnexpectedException(pce);
        }
        catch (Throwable t) {
            this.reportUnexpectedException(t);
        }
        finally {
            Disposer.dispose((Disposable)cancelOnProjectDispose);
        }
    }

    private void reportUnexpectedException(Throwable t) {
        if (this.myProject.isDisposed() || !this.myProject.isOpen()) {
            return;
        }
        Throwable e = t instanceof ProcessCanceledException ? new RuntimeException(t) : t;
        OCLog.LOG.error("Unexpected exception during symbol building (" + this.myActivityName + ")", e);
        if (CidrZipBackedCache.buildingCache) {
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public String toString() {
        return this.myActivityName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskFromQueue";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/building/SymbolBuildingTask";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/building/SymbolBuildingTask";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleSymbolActivity";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleSymbolActivityAndWait";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryMergeWith";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "scheduleSymbolActivity";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "scheduleSymbolActivityAndWait";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performInDumbMode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10 -> new IllegalStateException(string);
        };
    }
}

