/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.serialization.AppCodeModuleCacheBuildingSession;
import com.jetbrains.cidr.lang.symbols.symtable.building.CoolDownUpdater;
import com.jetbrains.cidr.lang.symbols.symtable.building.ImpatientDeferredException;
import com.jetbrains.cidr.lang.symbols.symtable.building.ModuleMapBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.ModuleMapDescriptor;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.RecursiveSymbolBuilding;
import com.jetbrains.cidr.lang.symbols.symtable.logging.OCBuildingLoggingService;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.List;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u0003234B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u009d\u0001\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u000b\u0010\u001a\u001a\u00070\u0014\u00a2\u0006\u0002\b\u001b2Y\b\u0004\u0010\u001c\u001aS\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110!\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\"\u0012\u0015\u0012\u0013\u0018\u00010#\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\r0\u001dj\b\u0012\u0004\u0012\u00020\u0010`%H\u0082\bJ4\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J4\u0010&\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J \u0010'\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0014\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020)0\u0016H\u0002J\"\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u00162\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u00a9\u0001\u0010+\u001a\u00020\r\"\b\b\u0000\u0010,*\u00020\u00012\u000b\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b-2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H,0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u000b\u0010\u001a\u001a\u00070\u0014\u00a2\u0006\u0002\b\u001b2W\u0010.\u001aS\u0012\u0013\u0012\u0011H,\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110!\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\"\u0012\u0015\u0012\u0013\u0018\u00010#\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\r0\u001dj\b\u0012\u0004\u0012\u0002H,`%H\u0002J\u0010\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u000201H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapBuildingActivity;", "", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityProgressIndicator;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/lang/symbols/symtable/building/OCBuildingActivityProgressIndicator;)V", "moduleMapManager", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager;", "myCoolDownUpdater", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/CoolDownUpdater;", "buildModuleMaps", "", "collectHeadersSearchRoots", "", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapDescriptor;", "descriptors", "iterateValidModuleMaps", "projectHash", "", "clusterizationMap", "Lcom/google/common/collect/ImmutableListMultimap;", "from", "", "to", "message", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "body", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "item", "Lcom/jetbrains/cidr/lang/symbols/symtable/serialization/SerializationSession;", "session", "Ljava/lang/Runnable;", "rescheduling", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/Task;", "processModuleMaps", "processModulesPerConfiguration", "setupConfigurationsClusterization", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapBuildingActivity$ConfigurationItem;", "buildClusterization", "processModuleMapBuilding", "T", "Lorg/jetbrains/annotations/NonNls;", "action", "getClusterization", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "ModuleMapBuilding", "ConfigurationItem", "Companion", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nModuleMapBuildingActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapBuildingActivity.kt\ncom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapBuildingActivity\n+ 2 CoolDownUpdater.kt\ncom/jetbrains/cidr/lang/symbols/symtable/building/CoolDownUpdater\n*L\n1#1,191:1\n65#1,3:192\n78#1:195\n65#1,3:196\n78#1:199\n21#2,7:200\n*S KotlinDebug\n*F\n+ 1 ModuleMapBuildingActivity.kt\ncom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapBuildingActivity\n*L\n86#1:192,3\n86#1:195\n97#1:196,3\n97#1:199\n112#1:200,7\n*E\n"})
public final class ModuleMapBuildingActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final OCBuildingActivityProgressIndicator indicator;
    @NotNull
    private final ModuleMapManager moduleMapManager;
    @NotNull
    private final CoolDownUpdater myCoolDownUpdater;

    public ModuleMapBuildingActivity(@NotNull Project project, @NotNull OCBuildingActivityProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)indicator), (String)"indicator");
        this.project = project;
        this.indicator = indicator;
        this.moduleMapManager = ModuleMapManager.Companion.getInstance(this.project);
        this.myCoolDownUpdater = new CoolDownUpdater(0L, 1, null);
    }

    public final void buildModuleMaps() {
        List<ModuleMapDescriptor> descriptors = this.collectHeadersSearchRoots();
        this.buildModuleMaps(descriptors);
    }

    private final List<ModuleMapDescriptor> collectHeadersSearchRoots() {
        List list = OCSymbolTableBuildingUtil.runCancelableReadAction(this.project, (ProgressIndicator)this.indicator, () -> ModuleMapBuildingActivity.collectHeadersSearchRoots$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"runCancelableReadAction(...)");
        return list;
    }

    private final void buildModuleMaps(List<ModuleMapDescriptor> descriptors) {
        String projectHash = OCSymbolTableBuildingUtil.runCancelableReadAction(this.project, (ProgressIndicator)this.indicator, () -> ModuleMapBuildingActivity.buildModuleMaps$lambda$0(this));
        ImmutableListMultimap<Object, ModuleMapDescriptor> clusterizationMap = this.buildClusterization(descriptors);
        int size = clusterizationMap.values().size();
        ModuleMapLog.LOG.info("Building module maps for " + size + " (root, configuration) pairs");
        OCBuildingLoggingService.Companion.getService(this.project).write("moduleMapDescriptors", (Sequence<String>)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)descriptors), ModuleMapBuildingActivity::buildModuleMaps$lambda$1));
        Intrinsics.checkNotNull((Object)projectHash);
        this.buildModuleMaps(projectHash, clusterizationMap, 0.1, 0.7);
        this.processModuleMaps(projectHash, clusterizationMap, 0.7, 0.85);
        if (!AppCodeModuleCacheBuildingSession.INSTANCE.isModuleMapBuildingSession()) {
            this.processModulesPerConfiguration(projectHash, 0.85, 0.9);
        }
    }

    private final void iterateValidModuleMaps(String projectHash, ImmutableListMultimap<Object, ModuleMapDescriptor> clusterizationMap, double from, double to, String message, Function3<? super ModuleMapDescriptor, ? super SerializationSession, ? super Runnable, Unit> body) {
        boolean $i$f$iterateValidModuleMaps = false;
        int size = clusterizationMap.values().size();
        AtomicInteger processedCount = new AtomicInteger(0);
        this.processModuleMapBuilding(projectHash, clusterizationMap, from, to, message, (Function3)new Function3<ModuleMapDescriptor, SerializationSession, Runnable, Unit>(processedCount, this, body, size){
            final /* synthetic */ AtomicInteger $processedCount;
            final /* synthetic */ ModuleMapBuildingActivity this$0;
            final /* synthetic */ Function3<ModuleMapDescriptor, SerializationSession, Runnable, Unit> $body;
            final /* synthetic */ int $size;
            {
                this.$processedCount = $processedCount;
                this.this$0 = $receiver;
                this.$body = $body;
                this.$size = $size;
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(ModuleMapDescriptor item, SerializationSession session, Runnable rescheduling) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                HeadersSearchRoot root = item.getModuleMapRoot().getRoot();
                int processedCountValue = this.$processedCount.getAndIncrement();
                if (!root.isValid()) {
                    return;
                }
                CoolDownUpdater coolDownUpdater = ModuleMapBuildingActivity.access$getMyCoolDownUpdater$p(this.this$0);
                ModuleMapBuildingActivity moduleMapBuildingActivity = this.this$0;
                int n = this.$size;
                boolean $i$f$updateNotTooFrequently = false;
                long curTime$iv = System.nanoTime();
                long delta$iv = curTime$iv - this_$iv.getPrevUpdate().get();
                if (delta$iv > this_$iv.getMinFrequencyInNanoSec()) {
                    this_$iv.getPrevUpdate().set(curTime$iv);
                    boolean bl = false;
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setText2(root.getPresentableName());
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setFraction((double)processedCountValue / (double)n);
                }
                this.$body.invoke((Object)item, (Object)session, (Object)rescheduling);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void buildModuleMaps(String projectHash, ImmutableListMultimap<Object, ModuleMapDescriptor> clusterizationMap, double from, double to) {
        void to$iv;
        void from$iv;
        void projectHash$iv;
        void this_$iv;
        void clusterizationMap$iv;
        ModuleMapBuildingActivity moduleMapBuildingActivity = this;
        String string = projectHash;
        ImmutableListMultimap<Object, ModuleMapDescriptor> immutableListMultimap = clusterizationMap;
        double d = from;
        double d2 = to;
        String string2 = OCBundle.message("building.module.maps", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message$iv = string2;
        boolean $i$f$iterateValidModuleMaps = false;
        int size$iv = clusterizationMap$iv.values().size();
        AtomicInteger processedCount$iv = new AtomicInteger(0);
        super.processModuleMapBuilding((String)projectHash$iv, (ImmutableListMultimap)clusterizationMap$iv, (double)from$iv, (double)to$iv, message$iv, (Function3)((Function3)new Function3<ModuleMapDescriptor, SerializationSession, Runnable, Unit>(processedCount$iv, (ModuleMapBuildingActivity)this_$iv, size$iv, this){
            final /* synthetic */ AtomicInteger $processedCount;
            final /* synthetic */ ModuleMapBuildingActivity this$0$inline_fun;
            final /* synthetic */ int $size;
            final /* synthetic */ ModuleMapBuildingActivity this$0;
            {
                this.$processedCount = $processedCount;
                this.this$0$inline_fun = $receiver;
                this.$size = $size;
                this.this$0 = moduleMapBuildingActivity;
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(ModuleMapDescriptor item, SerializationSession session, Runnable rescheduling) {
                void session2;
                void rescheduling2;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                HeadersSearchRoot root = item.getModuleMapRoot().getRoot();
                int processedCountValue = this.$processedCount.getAndIncrement();
                if (!root.isValid()) {
                    return;
                }
                CoolDownUpdater coolDownUpdater = ModuleMapBuildingActivity.access$getMyCoolDownUpdater$p(this.this$0$inline_fun);
                ModuleMapBuildingActivity moduleMapBuildingActivity = this.this$0$inline_fun;
                int n = this.$size;
                boolean $i$f$updateNotTooFrequently = false;
                long curTime$iv = System.nanoTime();
                long delta$iv = curTime$iv - this_$iv.getPrevUpdate().get();
                if (delta$iv > this_$iv.getMinFrequencyInNanoSec()) {
                    this_$iv.getPrevUpdate().set(curTime$iv);
                    boolean bl = false;
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setText2(root.getPresentableName());
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setFraction((double)processedCountValue / (double)n);
                }
                Runnable runnable = rescheduling;
                SerializationSession serializationSession = session;
                ModuleMapDescriptor item2 = item;
                boolean bl = false;
                ModuleMapBuildingActivity.access$getModuleMapManager$p(this.this$0).buildModule(item2, (Runnable)rescheduling2, (SerializationSession)session2);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void processModuleMaps(String projectHash, ImmutableListMultimap<Object, ModuleMapDescriptor> clusterizationMap, double from, double to) {
        void to$iv;
        void from$iv;
        void projectHash$iv;
        void this_$iv;
        void clusterizationMap$iv;
        ModuleMapBuildingActivity moduleMapBuildingActivity = this;
        String string = projectHash;
        ImmutableListMultimap<Object, ModuleMapDescriptor> immutableListMultimap = clusterizationMap;
        double d = from;
        double d2 = to;
        String string2 = OCBundle.message("processing.module.maps", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message$iv = string2;
        boolean $i$f$iterateValidModuleMaps = false;
        int size$iv = clusterizationMap$iv.values().size();
        AtomicInteger processedCount$iv = new AtomicInteger(0);
        super.processModuleMapBuilding((String)projectHash$iv, (ImmutableListMultimap)clusterizationMap$iv, (double)from$iv, (double)to$iv, message$iv, (Function3)((Function3)new Function3<ModuleMapDescriptor, SerializationSession, Runnable, Unit>(processedCount$iv, (ModuleMapBuildingActivity)this_$iv, size$iv, this){
            final /* synthetic */ AtomicInteger $processedCount;
            final /* synthetic */ ModuleMapBuildingActivity this$0$inline_fun;
            final /* synthetic */ int $size;
            final /* synthetic */ ModuleMapBuildingActivity this$0;
            {
                this.$processedCount = $processedCount;
                this.this$0$inline_fun = $receiver;
                this.$size = $size;
                this.this$0 = moduleMapBuildingActivity;
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(ModuleMapDescriptor item, SerializationSession session, Runnable rescheduling) {
                void session2;
                void rescheduling2;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                HeadersSearchRoot root = item.getModuleMapRoot().getRoot();
                int processedCountValue = this.$processedCount.getAndIncrement();
                if (!root.isValid()) {
                    return;
                }
                CoolDownUpdater coolDownUpdater = ModuleMapBuildingActivity.access$getMyCoolDownUpdater$p(this.this$0$inline_fun);
                ModuleMapBuildingActivity moduleMapBuildingActivity = this.this$0$inline_fun;
                int n = this.$size;
                boolean $i$f$updateNotTooFrequently = false;
                long curTime$iv = System.nanoTime();
                long delta$iv = curTime$iv - this_$iv.getPrevUpdate().get();
                if (delta$iv > this_$iv.getMinFrequencyInNanoSec()) {
                    this_$iv.getPrevUpdate().set(curTime$iv);
                    boolean bl = false;
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setText2(root.getPresentableName());
                    ModuleMapBuildingActivity.access$getIndicator$p(moduleMapBuildingActivity).setFraction((double)processedCountValue / (double)n);
                }
                Runnable runnable = rescheduling;
                SerializationSession serializationSession = session;
                ModuleMapDescriptor item2 = item;
                boolean bl = false;
                ModuleMapBuildingActivity.access$getModuleMapManager$p(this.this$0).buildDependencies(item2, (Runnable)rescheduling2, (SerializationSession)session2);
            }
        }));
    }

    private final void processModulesPerConfiguration(String projectHash, double from, double to) {
        ImmutableListMultimap<Object, ConfigurationItem> configurationsCluster = this.setupConfigurationsClusterization();
        AtomicInteger processedCount = new AtomicInteger(0);
        int size = configurationsCluster.values().size();
        String string = OCBundle.message("processing.module.maps", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.processModuleMapBuilding(projectHash, configurationsCluster, from, to, string, (arg_0, arg_1, arg_2) -> ModuleMapBuildingActivity.processModulesPerConfiguration$lambda$0(this, processedCount, size, arg_0, arg_1, arg_2));
    }

    private final ImmutableListMultimap<Object, ConfigurationItem> setupConfigurationsClusterization() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        ImmutableListMultimap.Builder builder2 = builder;
        for (OCResolveConfiguration configuration : OCWorkspace.getInstance((Project)this.project).getConfigurations()) {
            builder2.put(new Object(), (Object)new ConfigurationItem(configuration));
        }
        builder2.put(new Object(), (Object)new ConfigurationItem(null));
        ImmutableListMultimap immutableListMultimap = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableListMultimap, (String)"build(...)");
        return immutableListMultimap;
    }

    private final ImmutableListMultimap<Object, ModuleMapDescriptor> buildClusterization(List<ModuleMapDescriptor> descriptors) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        ImmutableListMultimap.Builder clusterization = builder;
        for (ModuleMapDescriptor descriptor : descriptors) {
            OCResolveConfiguration configuration = descriptor.getConfiguration();
            Object cluster = this.getClusterization(configuration);
            clusterization.put(cluster, (Object)descriptor);
        }
        ImmutableListMultimap immutableListMultimap = clusterization.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableListMultimap, (String)"build(...)");
        return immutableListMultimap;
    }

    private final <T> void processModuleMapBuilding(String projectHash, ImmutableListMultimap<Object, T> clusterizationMap, double from, double to, String message, Function3<? super T, ? super SerializationSession, ? super Runnable, Unit> action) {
        OCSymbolTableBuildingUtil.processRecursiveTasks(this.project, this.indicator, from, to, clusterizationMap, (arg_0, arg_1) -> ModuleMapBuildingActivity.processModuleMapBuilding$lambda$1((arg_0, arg_1) -> ModuleMapBuildingActivity.processModuleMapBuilding$lambda$0(this, message, projectHash, action, arg_0, arg_1), arg_0, arg_1));
    }

    private final Object getClusterization(OCResolveConfiguration configuration) {
        Object object = configuration.getCompilerSettings(ModuleMapUtil.getPreferredLanguageKind()).getIndexingCluster();
        if (object == null) {
            Object object2 = ObjectUtils.NULL;
            object = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"NULL");
        }
        return object;
    }

    private static final List collectHeadersSearchRoots$lambda$0(ModuleMapBuildingActivity this$0) {
        return this$0.moduleMapManager.getDescriptorsForInitialBuilding();
    }

    private static final String buildModuleMaps$lambda$0(ModuleMapBuildingActivity this$0) {
        return this$0.project.getLocationHash();
    }

    private static final String buildModuleMaps$lambda$1(ModuleMapDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    private static final Unit processModulesPerConfiguration$lambda$0(ModuleMapBuildingActivity this$0, AtomicInteger $processedCount, int $size, ConfigurationItem item, SerializationSession serializationSession, Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)serializationSession, (String)"<unused var>");
        OCResolveConfiguration configuration = item.getConfiguration();
        OCBuildingActivityProgressIndicator oCBuildingActivityProgressIndicator = this$0.indicator;
        Object object = configuration;
        if (object == null || (object = object.getDisplayName()) == null) {
            object = "";
        }
        oCBuildingActivityProgressIndicator.setText2((String)object);
        this$0.moduleMapManager.cacheFor(configuration).getModules();
        int processedCountValue = $processedCount.incrementAndGet();
        CoolDownUpdater this_$iv = this$0.myCoolDownUpdater;
        boolean $i$f$updateNotTooFrequently = false;
        long curTime$iv = System.nanoTime();
        long delta$iv = curTime$iv - this_$iv.getPrevUpdate().get();
        if (delta$iv > this_$iv.getMinFrequencyInNanoSec()) {
            this_$iv.getPrevUpdate().set(curTime$iv);
            boolean bl = false;
            this$0.indicator.setFraction((double)processedCountValue / (double)$size);
        }
        return Unit.INSTANCE;
    }

    private static final RecursiveSymbolBuilding processModuleMapBuilding$lambda$0(ModuleMapBuildingActivity this$0, String $message, String $projectHash, Function3 $action, ProgressIndicator global, ProgressIndicator read) {
        Intrinsics.checkNotNullParameter((Object)global, (String)"global");
        Intrinsics.checkNotNullParameter((Object)read, (String)"read");
        return new ModuleMapBuilding(this$0.project, global, read, 1, $message, $projectHash, $action);
    }

    private static final RecursiveSymbolBuilding processModuleMapBuilding$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (RecursiveSymbolBuilding)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ CoolDownUpdater access$getMyCoolDownUpdater$p(ModuleMapBuildingActivity $this) {
        return $this.myCoolDownUpdater;
    }

    public static final /* synthetic */ OCBuildingActivityProgressIndicator access$getIndicator$p(ModuleMapBuildingActivity $this) {
        return $this.indicator;
    }

    public static final /* synthetic */ ModuleMapManager access$getModuleMapManager$p(ModuleMapBuildingActivity $this) {
        return $this.moduleMapManager;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapBuildingActivity$Companion;", "", "<init>", "()V", "buildModuleMaps", "", "descriptors", "", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.c.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void buildModuleMaps(@NotNull List<ModuleMapDescriptor> descriptors, @NotNull Project project, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            new ModuleMapBuildingActivity(project, new OCBuildingActivityProgressIndicator(indicator)).buildModuleMaps(descriptors);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapBuildingActivity$ConfigurationItem;", "", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "<init>", "(Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)V", "getConfiguration", "()Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "intellij.c.core"})
    private static final class ConfigurationItem {
        @Nullable
        private final OCResolveConfiguration configuration;

        public ConfigurationItem(@Nullable OCResolveConfiguration configuration) {
            this.configuration = configuration;
        }

        @Nullable
        public final OCResolveConfiguration getConfiguration() {
            return this.configuration;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u009a\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r\u0012\u000b\u0010\u000e\u001a\u00070\f\u00a2\u0006\u0002\b\u000f\u0012W\u0010\u0010\u001aS\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0015\u0012\u0013\u0018\u00010\u0017\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0011j\b\u0012\u0004\u0012\u00028\u0000`\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ,\u0010!\u001a\f0\"R\b\u0012\u0004\u0012\u00028\u00000\u00032\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0014R_\u0010\u0010\u001aS\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0015\u0012\u0013\u0018\u00010\u0017\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0011j\b\u0012\u0004\u0012\u00028\u0000`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapBuildingActivity$ModuleMapBuilding;", "T", "", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/RecursiveSymbolBuilding;", "project", "Lcom/intellij/openapi/project/Project;", "globalIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readIndicator", "maxLeafSize", "", "indicatorText", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "projectHash", "Lorg/jetbrains/annotations/NonNls;", "task", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "item", "Lcom/jetbrains/cidr/lang/symbols/symtable/serialization/SerializationSession;", "session", "Ljava/lang/Runnable;", "rescheduling", "", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/Task;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/openapi/progress/ProgressIndicator;ILjava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function3;)V", "serializationSession", "Ljava/lang/ThreadLocal;", "isImpatient", "", "createWorkerTask", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/RecursiveSymbolBuilding$ReadActionTask;", "parent", "Ljava/util/concurrent/CountedCompleter;", "workset", "Lcom/google/common/collect/ImmutableList;", "intellij.c.core"})
    private static final class ModuleMapBuilding<T>
    extends RecursiveSymbolBuilding<T> {
        @NotNull
        private final Function3<T, SerializationSession, Runnable, Unit> task;
        @NotNull
        private final ThreadLocal<SerializationSession> serializationSession;
        private final boolean isImpatient;

        public ModuleMapBuilding(@NotNull Project project, @NotNull ProgressIndicator globalIndicator, @NotNull ProgressIndicator readIndicator, int maxLeafSize, @NotNull String indicatorText, @NotNull String projectHash, @NotNull Function3<? super T, ? super SerializationSession, ? super Runnable, Unit> task2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)globalIndicator, (String)"globalIndicator");
            Intrinsics.checkNotNullParameter((Object)readIndicator, (String)"readIndicator");
            Intrinsics.checkNotNullParameter((Object)indicatorText, (String)"indicatorText");
            Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
            Intrinsics.checkNotNullParameter(task2, (String)"task");
            super(project, globalIndicator, readIndicator, maxLeafSize, indicatorText);
            this.task = task2;
            ThreadLocal<SerializationSession> threadLocal = ThreadLocal.withInitial(() -> ModuleMapBuilding.serializationSession$lambda$0(projectHash));
            Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
            this.serializationSession = threadLocal;
            this.isImpatient = Registry.Companion.is("cidr.modulemaps.building.impatient", true);
        }

        @Override
        @NotNull
        protected RecursiveSymbolBuilding.ReadActionTask createWorkerTask(@NotNull CountedCompleter<?> parent, @NotNull ImmutableList<T> workset2) {
            Intrinsics.checkNotNullParameter(parent, (String)"parent");
            Intrinsics.checkNotNullParameter(workset2, (String)"workset");
            return new RecursiveSymbolBuilding.ReadActionTask(this, parent, workset2){
                final /* synthetic */ ModuleMapBuilding<T> this$0;
                {
                    this.this$0 = $receiver;
                    super($receiver, $parent, $workset);
                }

                protected void computeInReadAction(T item) {
                    Intrinsics.checkNotNullParameter(item, (String)"item");
                    try {
                        Function3 function3 = ModuleMapBuilding.access$getTask$p(this.this$0);
                        T t = ModuleMapBuilding.access$getSerializationSession$p(this.this$0).get();
                        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                        function3.invoke(item, t, ModuleMapBuilding.access$isImpatient$p(this.this$0) ? () -> createWorkerTask.1.computeInReadAction$lambda$0(this, item) : null);
                    }
                    catch (ImpatientDeferredException impatientDeferredException) {
                        this.addToPendingCount(1);
                    }
                }

                private static final void computeInReadAction$lambda$0(createWorkerTask.1 this$0, Object $item) {
                    ImmutableList immutableList = ImmutableList.of((Object)$item);
                    Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
                    this$0.reschedule(immutableList, 0);
                }
            };
        }

        private static final SerializationSession serializationSession$lambda$0(String $projectHash) {
            return new SerializationSession($projectHash);
        }

        public static final /* synthetic */ Function3 access$getTask$p(ModuleMapBuilding $this) {
            return $this.task;
        }

        public static final /* synthetic */ ThreadLocal access$getSerializationSession$p(ModuleMapBuilding $this) {
            return $this.serializationSession;
        }

        public static final /* synthetic */ boolean access$isImpatient$p(ModuleMapBuilding $this) {
            return $this.isImpatient;
        }
    }
}

