/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.VirtualFileChangeListener;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.serialization.AppCodeModuleCacheBuildingSession;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLazyBlockStatementElementType;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCRootKind;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.DirtyIncludesInvalidator;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableHelper;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPackListener;
import com.jetbrains.cidr.lang.symbols.symtable.OCBuildSymbolsVetoExtension;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableListener;
import com.jetbrains.cidr.lang.symbols.symtable.PeriodicSerializationTask;
import com.jetbrains.cidr.lang.symbols.symtable.ProcessingDependencyGraph;
import com.jetbrains.cidr.lang.symbols.symtable.TableBuildingItem;
import com.jetbrains.cidr.lang.symbols.symtable.building.FileSymbolTableUpdater;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityExecutionService;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolBuildingListener;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.SymbolTableUpdateMode;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationService;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import com.jetbrains.cidr.lang.workspace.OCPCHCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@Service(value={Service.Level.PROJECT})
public final class FileSymbolTablesCache
implements Disposable.Default {
    @Topic.ProjectLevel
    public static final Topic<PsiModificationTracker.Listener> OUT_OF_CODE_BLOCK_TOPIC = new Topic(PsiModificationTracker.Listener.class, Topic.BroadcastDirection.TO_PARENT);
    private static final Logger LOG = Logger.getInstance(FileSymbolTablesCache.class);
    private static volatile Boolean ourForceSymbolsLoadedInTests = null;
    private static final SymbolsProperties DEFAULT_SYMBOLS_PROPERTIES;
    private static volatile SymbolsProperties ourSymbolsProperties;
    private final ConcurrentMap<VirtualFile, FileSymbolTablesPack> myCache;
    private final FileSymbolTableUpdater myTableUpdater;
    private final Project myProject;
    private final Set<VirtualFile> myPendingReparses;
    private final Set<VirtualFile> myPendingPSIResets;
    private final Object mySerializationLock;
    private final AtomicBoolean myInitialized;
    private final SimpleModificationTracker myOutOfBlockModificationTracker;
    private final AtomicBoolean mySymbolsLoaded;
    private final ProcessingDependencyGraph<TableBuildingItem> myProcessingDependencyGraph;
    private final CoroutineScope myCoroutineScope;

    @NotNull
    public static FileSymbolTablesCache getInstance(@NotNull Project project) {
        if (project == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(0);
        }
        FileSymbolTablesCache fileSymbolTablesCache = Objects.requireNonNull(FileSymbolTablesCache.getInstanceOrNull(project));
        if (fileSymbolTablesCache == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(1);
        }
        return fileSymbolTablesCache;
    }

    @Nullable
    public static FileSymbolTablesCache getInstanceOrNull(@NotNull Project project) {
        if (project == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(2);
        }
        return (FileSymbolTablesCache)project.getService(FileSymbolTablesCache.class);
    }

    public FileSymbolTablesCache(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(3);
        }
        if (coroutineScope == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(4);
        }
        this.myCache = new ConcurrentHashMap<VirtualFile, FileSymbolTablesPack>();
        this.myPendingReparses = new HashSet<VirtualFile>();
        this.myPendingPSIResets = new HashSet<VirtualFile>();
        this.mySerializationLock = new Object();
        this.myInitialized = new AtomicBoolean(false);
        this.myOutOfBlockModificationTracker = new SimpleModificationTracker(){

            public void incModificationCount() {
                super.incModificationCount();
                PsiManager.getInstance((Project)FileSymbolTablesCache.this.myProject).dropPsiCaches();
                ((PsiModificationTracker.Listener)FileSymbolTablesCache.this.myProject.getMessageBus().syncPublisher(OUT_OF_CODE_BLOCK_TOPIC)).modificationCountChanged();
            }
        };
        this.mySymbolsLoaded = new AtomicBoolean(false);
        this.myProcessingDependencyGraph = new ProcessingDependencyGraph();
        this.myTableUpdater = new FileSymbolTableUpdater(project);
        this.myProject = project;
        this.myCoroutineScope = coroutineScope;
    }

    public void subscribeToEvents() {
        if (!this.myInitialized.compareAndSet(false, true)) {
            return;
        }
        new OCCodeBlockModificationListener(this).init();
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        this.listenOCWorkspaceChanges(connection);
        this.listenVFSChanges(connection);
        this.setupPeriodicSerialization();
    }

    private void listenOCWorkspaceChanges(MessageBusConnection connection) {
        connection.subscribe(OCWorkspaceListener.TOPIC, (Object)new OCWorkspaceListener(){

            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                OCResolveRootAndConfigurationCache.getInstance(FileSymbolTablesCache.this.myProject).invalidateForAll();
                if (event.resolveConfigurationsChanged() || event.compilerSettingsChanged()) {
                    OCSymbolTablesBuildingActivity.getInstance(FileSymbolTablesCache.this.myProject).rebuildSymbols();
                }
                FileSymbolTablesCache.this.incModificationCount();
            }

            public void selectedResolveConfigurationChanged() {
                ThreadingAssertions.assertReadAccess();
                OCResolveRootAndConfigurationCache.getInstance(FileSymbolTablesCache.this.myProject).invalidateForAll();
                FileSymbolTablesCache.this.scheduleReparseCachedPsiFiles();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$2", "workspaceChanged"));
            }
        });
    }

    private void listenVFSChanges(MessageBusConnection connection) {
        if (LanguageUtils.getInstance().isCppSupportDisabled(this.myProject)) {
            return;
        }
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new VirtualFileChangeListener(true){
            private ClearTablesAndCollectNamesVisitor visitor;

            protected void begin() {
                this.visitor = new ClearTablesAndCollectNamesVisitor();
            }

            protected void onFileChange(@NotNull VirtualFile file, @NotNull VFileEvent event) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (event.isFromSave()) {
                    return;
                }
                ClearTablesAndCollectNamesVisitor visitor = this.visitor;
                if (visitor != null) {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)visitor);
                }
            }

            protected void done() {
                Set<String> toInvalidate = this.visitor.dirtyNames;
                boolean cacheCleared = this.visitor.cacheCleared;
                this.visitor = null;
                boolean includingFilesInvalidated = FileSymbolTablesCache.this.invalidateDirtyIncludes(toInvalidate);
                if (includingFilesInvalidated || cacheCleared) {
                    FileSymbolTablesCache.this.incModificationCount();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$3";
                objectArray[2] = "onFileChange";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void setupPeriodicSerialization() {
        if (!this.myProject.isDefault() && !ApplicationManager.getApplication().isUnitTestMode()) {
            new PeriodicSerializationTask(this, this.myProject, this.myCache, CoroutineScopeKt.childScope((CoroutineScope)this.myCoroutineScope, (String)"PeriodicSerializationTask", (CoroutineContext)EmptyCoroutineContext.INSTANCE, (boolean)true)).schedule();
        }
    }

    @NotNull
    public ModificationTracker getOutOfBlockModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myOutOfBlockModificationTracker;
        if (simpleModificationTracker == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(5);
        }
        return simpleModificationTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean shouldBuild(Predicate<@NotNull SymbolsProperties> predicate) {
        boolean areSymsDisabled = Registry.is((String)"cidr.disable.symbols", (boolean)false);
        if (areSymsDisabled) {
            return false;
        }
        if (OCBuildSymbolsVetoExtension.isVetoed()) {
            return false;
        }
        boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (!isUnitTestMode && !AppCodeModuleCacheBuildingSession.INSTANCE.isModuleMapBuildingSession()) {
            return true;
        }
        if (isUnitTestMode) {
            Class<FileSymbolTablesCache> clazz = FileSymbolTablesCache.class;
            synchronized (FileSymbolTablesCache.class) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return ourSymbolsProperties == null || predicate.test(ourSymbolsProperties);
            }
        }
        return true;
    }

    public static boolean shouldBuildTables() {
        return FileSymbolTablesCache.shouldBuild(symbolProperties -> symbolProperties.buildSymbolsKind != SymbolsProperties.SymbolsKind.NO_SYMBOLS);
    }

    public static boolean shouldBuildTablesForAllSystemHeaders() {
        return FileSymbolTablesCache.shouldBuild(symbolProperties -> symbolProperties.buildSymbolsKind == SymbolsProperties.SymbolsKind.ALL_INCLUDING_UNUSED_SYSTEM_HEADERS);
    }

    static boolean isSerializationEnabled() {
        return FileSymbolTablesCache.shouldBuild(symbolProperties -> symbolProperties.serializeSymbolTables);
    }

    private static boolean isDeserializationEnabled() {
        return FileSymbolTablesCache.shouldBuild(symbolProperties -> symbolProperties.deserializeSymbolTables);
    }

    @TestOnly
    @Nullable
    public static synchronized SymbolsProperties setShouldBuildTablesInTests(@Nullable SymbolsProperties properties) {
        SymbolsProperties prev = ourSymbolsProperties;
        ourSymbolsProperties = properties != null ? properties : DEFAULT_SYMBOLS_PROPERTIES;
        return prev;
    }

    public boolean invalidateDirtyIncludes(@NotNull Set<String> dirtyNames) {
        if (dirtyNames == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(6);
        }
        return this.invalidateDirtyIncludes(dirtyNames, false);
    }

    public boolean invalidateDirtyIncludes(@NotNull Set<String> dirtyNames, boolean isRelativePath) {
        if (dirtyNames == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (dirtyNames.isEmpty()) {
            return false;
        }
        Set<VirtualFile> allCachedFiles = this.getCachedFiles();
        ImmutableList.Builder cachedFilesBuilder = ImmutableList.builderWithExpectedSize((int)allCachedFiles.size());
        for (VirtualFile cachedFile : allCachedFiles) {
            if (!cachedFile.isValid()) continue;
            cachedFilesBuilder.add((Object)cachedFile);
        }
        ImmutableList cachedFiles = cachedFilesBuilder.build();
        DirtyIncludesInvalidator invalidator = new DirtyIncludesInvalidator(this, dirtyNames, isRelativePath, cachedFiles.size());
        Collection<VirtualFile> pendingInvalidation = invalidator.collect((ImmutableList<VirtualFile>)cachedFiles);
        return this.invalidateDirtyIncludeFiles(pendingInvalidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidateDirtyIncludeFiles(@NotNull Collection<? extends VirtualFile> dirtyFiles) {
        if (dirtyFiles == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(8);
        }
        boolean result = false;
        if (!dirtyFiles.isEmpty()) {
            HashSet<VirtualFile> processedFiles = new HashSet<VirtualFile>();
            for (VirtualFile virtualFile : dirtyFiles) {
                if (!this.invalidate(virtualFile, true, processedFiles, true)) continue;
                result = true;
                Set<VirtualFile> set = this.myPendingReparses;
                synchronized (set) {
                    this.myPendingReparses.add(virtualFile);
                }
            }
            if (result) {
                OCImportGraph.getInstance(this.myProject).invalidateHeaderRootsCache();
                OCResolveRootAndConfigurationCache.getInstance(this.myProject).invalidateForAll();
            }
        }
        this.schedulePSIUpdates();
        return result;
    }

    public void compact() {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.compactSynchronized();
        }
    }

    @NotNull
    public Set<VirtualFile> getFilesToBuildTablesFor() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Set<VirtualFile> set = FileSymbolTableHelper.collectAllFilesToBuildTables(this.myProject);
        if (set == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(9);
        }
        return set;
    }

    public Set<VirtualFile> getCachedFiles() {
        return this.myCache.keySet();
    }

    public void addFileToCache(@Nullable VirtualFile file) {
        if (file == null) {
            return;
        }
        this.myTableUpdater.addFileForUpdate(file);
    }

    public void addFilesToCache(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(10);
        }
        this.myTableUpdater.addFilesForUpdate(files, false);
    }

    @NotNull
    public @NotNull List<@NotNull VirtualFile> removeFilesFromCache(@NotNull @NotNull Iterable<? extends @NotNull VirtualFile> files) {
        if (files == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(11);
        }
        List list = CollectionsKt.filter(files, this::clearCache);
        if (list == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(12);
        }
        return list;
    }

    public void removeAllChildrenFromCache(@Nullable VirtualFile root) {
        if (root == null) {
            return;
        }
        for (VirtualFile file : this.myCache.keySet()) {
            if (file == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            this.clearCache(file);
        }
    }

    @RequiresReadLock
    @Nullable
    public FileSymbolTable forFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(13);
        }
        if (context == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.softAssertReadAccess();
        return this.forFile(virtualFile, context, null);
    }

    @RequiresReadLock
    @Nullable
    public FileSymbolTable forFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context, @Nullable SerializationSession serializationSession) {
        Ref outTimeStamp;
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(15);
        }
        if (context == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.softAssertReadAccess();
        ProgressManager.checkCanceled();
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("deadlock may occur if 'FileSymbolTablesCache.forFile' is called outside of read-action");
        }
        if (!FileSymbolTablesCache.shouldBuildTables() || !virtualFile.isValid()) {
            return null;
        }
        FileSymbolTablesPack pack = this.mutablePackForFile(virtualFile, serializationSession);
        FileSymbolTable table = pack.findConformingTable(context, 0, (Ref<Integer>)(outTimeStamp = new Ref()));
        if (table != null || context.getInclusionLevel() >= OCInclusionContext.getMaxInclusionLevel()) {
            return table;
        }
        return this.buildTableForFile(virtualFile, context, pack, (Ref<Integer>)outTimeStamp);
    }

    public boolean isBuildingTableForFile(@NotNull VirtualFile virtualFile, @NotNull OCLanguageKind languageKind) {
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(17);
        }
        if (languageKind == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(18);
        }
        Thread currentThread = Thread.currentThread();
        TableBuildingItem item = new TableBuildingItem(virtualFile, languageKind);
        return this.myProcessingDependencyGraph.isAlreadyProcessing(item, currentThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private FileSymbolTable buildTableForFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context, @NotNull FileSymbolTablesPack pack, @NotNull Ref<Integer> outTimeStamp) {
        Object object;
        block39: {
            FileSymbolTablesPack fileSymbolTablesPack;
            ProcessingDependencyGraph.State state;
            TableBuildingItem item;
            block38: {
                FileSymbolTable fileSymbolTable;
                Thread currentThread;
                block37: {
                    FileSymbolTable fileSymbolTable2;
                    block36: {
                        if (virtualFile == null) {
                            FileSymbolTablesCache.$$$reportNull$$$0(19);
                        }
                        if (context == null) {
                            FileSymbolTablesCache.$$$reportNull$$$0(20);
                        }
                        if (pack == null) {
                            FileSymbolTablesCache.$$$reportNull$$$0(21);
                        }
                        if (outTimeStamp == null) {
                            FileSymbolTablesCache.$$$reportNull$$$0(22);
                        }
                        currentThread = Thread.currentThread();
                        item = new TableBuildingItem(virtualFile, context.getLanguageKind());
                        state = null;
                        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "waitForPack", (Object)item);){
                            object = pack;
                            synchronized (object) {
                                ProgressManager.checkCanceled();
                                FileSymbolTable table = pack.findConformingTable(context, (Integer)outTimeStamp.get(), outTimeStamp);
                                if (table != null) {
                                    FileSymbolTable fileSymbolTable3 = table;
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 35, 13] lbl21 : MonitorExitStatement: MONITOREXIT : var9_10
                                    fileSymbolTable2 = fileSymbolTable3;
                                    break block36;
                                }
                                state = this.myProcessingDependencyGraph.startProcessing(item, currentThread, context.getImpatientRescheduling());
                                while (state == ProcessingDependencyGraph.State.WAIT) {
                                    pack.wait(50L);
                                    ProgressManager.checkCanceled();
                                    table = pack.findConformingTable(context, (Integer)outTimeStamp.get(), outTimeStamp);
                                    if (table != null) {
                                        FileSymbolTable fileSymbolTable4 = table;
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 34, 23, 13] lbl31 : MonitorExitStatement: MONITOREXIT : var9_10
                                        fileSymbolTable = fileSymbolTable4;
                                        break block37;
                                    }
                                    if (!this.myProcessingDependencyGraph.retryStartProcessing(item, currentThread)) continue;
                                    state = ProcessingDependencyGraph.State.ACQUIRED;
                                }
                                break block38;
                            }
                        }
                        catch (InterruptedException e) {
                            throw new ProcessCanceledException((Throwable)e);
                        }
                    }
                    if (fileSymbolTable2 != null) return fileSymbolTable2;
                    FileSymbolTablesCache.$$$reportNull$$$0(23);
                    return fileSymbolTable2;
                }
                if (fileSymbolTable != null) return fileSymbolTable;
                FileSymbolTablesCache.$$$reportNull$$$0(24);
                return fileSymbolTable;
                finally {
                    if (state == ProcessingDependencyGraph.State.WAIT) {
                        this.myProcessingDependencyGraph.stopWaiting(currentThread);
                    }
                }
            }
            FileSymbolTable builtTable = null;
            try {
                if (state == ProcessingDependencyGraph.State.ACQUIRED) {
                    OCBuildingActivityExecutionService.getInstance().assertParsingAndSymbolBuildingAllowed(this.myProject);
                }
                builtTable = FileSymbolTableHelper.calculateTable(virtualFile, context);
                context.addProcessedFile(virtualFile);
                object = builtTable;
                if (state != ProcessingDependencyGraph.State.ACQUIRED && (state != ProcessingDependencyGraph.State.RECURSIVE || builtTable == null)) break block39;
                fileSymbolTablesPack = pack;
            }
            catch (Throwable throwable) {
                if (state != ProcessingDependencyGraph.State.ACQUIRED) {
                    if (state != ProcessingDependencyGraph.State.RECURSIVE) throw throwable;
                    if (builtTable == null) throw throwable;
                }
                FileSymbolTablesPack fileSymbolTablesPack2 = pack;
                synchronized (fileSymbolTablesPack2) {
                    if (state == ProcessingDependencyGraph.State.ACQUIRED) {
                        this.myProcessingDependencyGraph.finishProcessing(item);
                        pack.notifyAll();
                    }
                    if (builtTable == null) throw throwable;
                    pack.addCompactSynchronized(this.myProject, builtTable);
                    this.notifyNewTables(virtualFile);
                    throw throwable;
                }
            }
            synchronized (fileSymbolTablesPack) {
                if (state == ProcessingDependencyGraph.State.ACQUIRED) {
                    this.myProcessingDependencyGraph.finishProcessing(item);
                    pack.notifyAll();
                }
                if (builtTable != null) {
                    pack.addCompactSynchronized(this.myProject, builtTable);
                    this.notifyNewTables(virtualFile);
                }
            }
        }
        Object object2 = object;
        if (object2 != null) return object2;
        FileSymbolTablesCache.$$$reportNull$$$0(25);
        return object2;
    }

    private void notifyNewTables(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(26);
        }
        ((OCFileSymbolTableListener)this.myProject.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onFileHasNewSymbolTableInPack(virtualFile);
    }

    @Nullable
    public FileSymbolTable findForFile(@NotNull VirtualFile file, @NotNull OCInclusionContext context) {
        FileSymbolTablesPack pack;
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(27);
        }
        if (context == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(28);
        }
        return (pack = this.packForFile(file)) != null ? pack.findConformingTable(context, 0, null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleReparseFile(PsiFile file) {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            this.myPendingReparses.add(OCFileUtil.getVirtualFile(file));
        }
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCachedFilesToReparse() {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            for (PsiFile file : PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager().getAllCachedFiles()) {
                this.myPendingReparses.add(OCFileUtil.getVirtualFile(file));
            }
        }
    }

    private void scheduleReparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePSIUpdates() {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            if (!this.myPendingPSIResets.isEmpty() || !this.myPendingReparses.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> this.updateDirtyFilesPSI(), ModalityState.nonModal());
            }
        }
    }

    @RequiresEdt
    public void reparseCachedPsiFiles() {
        ThreadingAssertions.assertEventDispatchThread();
        this.addCachedFilesToReparse();
        this.updateDirtyFilesPSI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public void updateDirtyFilesPSI() {
        ArrayList<VirtualFile> toResetPSI;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        HashSet<VirtualFile> toReparse = new HashSet<VirtualFile>();
        FileManager fileManager = PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager();
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            this.myPendingPSIResets.removeAll(this.myPendingReparses);
            toResetPSI = new ArrayList<VirtualFile>(this.myPendingPSIResets);
            this.myPendingPSIResets.clear();
            for (VirtualFile virtualFile : this.myPendingReparses) {
                FileViewProvider pp;
                if (!virtualFile.isValid() || (pp = fileManager.findCachedViewProvider(virtualFile)) == null) continue;
                OCLog.LOG.assertTrue(pp instanceof AbstractFileViewProvider, (Object)pp);
                for (PsiFile cached : ((AbstractFileViewProvider)pp).getCachedPsiFiles()) {
                    FileSymbolTablesCache.processDirtyFile(toReparse, cached, virtualFile);
                }
            }
            this.myPendingReparses.clear();
        }
        if (!toResetPSI.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (VirtualFile file : toResetPSI) {
                    fileManager.setViewProvider(file, null);
                }
            });
        }
        if (!toReparse.isEmpty()) {
            FileContentUtilCore.reparseFiles(toReparse);
        }
        if (!toResetPSI.isEmpty() || !toReparse.isEmpty()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart((Object)this);
        }
    }

    private static void processDirtyFile(@NotNull Set<VirtualFile> dirty, @NotNull PsiFile file, @NotNull VirtualFile virtualFile) {
        if (dirty == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(29);
        }
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(30);
        }
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(31);
        }
        if (FileSymbolTableHelper.isSourceFile(virtualFile, file.getProject()) && file instanceof PsiFileImpl) {
            FileElement node = ((PsiFileImpl)file).getTreeElement();
            if (node != null && node.isParsed()) {
                dirty.add(virtualFile);
            } else {
                file.clearCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invalidate(@Nullable VirtualFile file, boolean reparse, Set<VirtualFile> processed, boolean withIncludingFiles) {
        if (file == null || !processed.add(file)) {
            return false;
        }
        boolean result = this.clearCache(file);
        if (file.isValid() && FileSymbolTableHelper.isSourceFile(file, this.myProject)) {
            this.myTableUpdater.addFileForUpdate(file);
        }
        if (withIncludingFiles) {
            Collection configs;
            Set<VirtualFile> dirtySet = reparse ? this.myPendingReparses : this.myPendingPSIResets;
            OCWorkspace workspace = OCWorkspace.getInstance((Project)this.myProject);
            if (OCRootKind.getRootKind(file, this.myProject) == OCRootKind.Root) {
                for (OCResolveConfiguration config : workspace.getConfigurations()) {
                    OCImportGraph.invalidateRootHeadersCache(config, file);
                }
            }
            if (!(configs = OCPCHCache.getBuildConfigurationByPchFile((VirtualFile)file, (Project)this.myProject)).isEmpty()) {
                Runnable runnable = () -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    for (OCResolveConfiguration config : configs) {
                        OCInclusionContext.onPrecompiledContextChange(config);
                    }
                    Collection<VirtualFile> sourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject);
                    List<VirtualFile> clearedFiles = this.myTableUpdater.addFilesForUpdate(sourceFiles, true);
                    if (clearedFiles.isEmpty()) {
                        return;
                    }
                    Set<VirtualFile> set = this.myPendingReparses;
                    synchronized (set) {
                        dirtySet.addAll(clearedFiles);
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    runnable.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(runnable, ModalityState.nonModal());
                }
            }
            HashSet<VirtualFile> includingFiles = new HashSet<VirtualFile>();
            boolean usePsiForInvalidation = Registry.is((String)"cidr.indexer.invalidateUsingPsi", (boolean)false);
            if (usePsiForInvalidation) {
                PsiFile psiFile = OCInclusionContextUtil.findCachedPsiFile(file, this.myProject);
                if (psiFile instanceof OCFile) {
                    Collection<VirtualFile> includingFromPsi = ((OCFile)psiFile).resetIncludingFiles();
                    includingFiles.addAll(includingFromPsi);
                }
            } else {
                Collection<VirtualFile> immediateIncludingFiles = OCImportGraph.getInstance(this.myProject).findImmediateIncludingFiles(file, false);
                includingFiles.addAll(immediateIncludingFiles);
            }
            for (VirtualFile including : includingFiles) {
                if (!this.invalidate(including, reparse, processed, true)) continue;
                result = true;
                Set<VirtualFile> set = this.myPendingReparses;
                synchronized (set) {
                    dirtySet.add(including);
                }
            }
        }
        return result;
    }

    public void ensurePendingFilesProcessed() {
        this.ensurePendingFilesProcessed(SymbolTableUpdateMode.AllFiles);
    }

    public void ensurePendingFilesProcessed(@NotNull SymbolTableUpdateMode updateMode) {
        if (updateMode == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(32);
        }
        this.myTableUpdater.ensurePendingFilesProcessed(updateMode);
    }

    @NotNull
    public @Unmodifiable List<FileSymbolTable> allTablesForFile(@NotNull PsiFile file) {
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(33);
        }
        List<FileSymbolTable> list = this.allTablesForFile(OCFileUtil.getVirtualFile(file));
        if (list == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<FileSymbolTable> allTablesForFile(@NotNull VirtualFile virtualFile) {
        FileSymbolTablesPack pack;
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(35);
        }
        List<FileSymbolTable> list = (pack = this.packForFile(virtualFile)) != null ? pack.getTablesSynchronized() : ContainerUtil.emptyList();
        if (list == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(36);
        }
        return list;
    }

    public int allTablesForFileCount(@NotNull VirtualFile virtualFile) {
        FileSymbolTablesPack pack;
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(37);
        }
        return (pack = this.packForFile(virtualFile)) != null ? pack.getTablesCountSynchronized() : 0;
    }

    @Nullable
    private FileSymbolTablesPack packForFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(38);
        }
        return (FileSymbolTablesPack)this.myCache.get(virtualFile);
    }

    @NotNull
    private FileSymbolTablesPack mutablePackForFile(@NotNull VirtualFile virtualFile, @Nullable SerializationSession serializationSession) {
        FileSymbolTablesPack pack;
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(39);
        }
        if ((pack = (FileSymbolTablesPack)this.myCache.get(virtualFile)) != null) {
            FileSymbolTablesPack fileSymbolTablesPack = pack;
            if (fileSymbolTablesPack == null) {
                FileSymbolTablesCache.$$$reportNull$$$0(40);
            }
            return fileSymbolTablesPack;
        }
        FileSymbolTablesPack deserializedPack = this.deserializePackForFile(virtualFile, serializationSession);
        FileSymbolTablesPack newPack = deserializedPack != null ? deserializedPack : new FileSymbolTablesPack();
        return this.addDeserializedPack(virtualFile, newPack);
    }

    @NotNull
    private FileSymbolTablesPack addDeserializedPack(@NotNull VirtualFile virtualFile, @NotNull FileSymbolTablesPack newPack) {
        FileSymbolTablesPack prev;
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(41);
        }
        if (newPack == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(42);
        }
        if ((prev = this.myCache.putIfAbsent(virtualFile, newPack)) == null) {
            if (newPack.getTablesCountSynchronized() > 0) {
                newPack.onThaw(this.myProject);
                this.notifyNewTables(virtualFile);
            }
            FileSymbolTablesPack fileSymbolTablesPack = newPack;
            if (fileSymbolTablesPack == null) {
                FileSymbolTablesCache.$$$reportNull$$$0(43);
            }
            return fileSymbolTablesPack;
        }
        FileSymbolTablesPack fileSymbolTablesPack = prev;
        if (fileSymbolTablesPack == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(44);
        }
        return fileSymbolTablesPack;
    }

    @Nullable
    private FileSymbolTablesPack deserializePackForFile(@NotNull VirtualFile virtualFile, @Nullable SerializationSession serializationSession) {
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(45);
        }
        if (serializationSession != null && FileSymbolTablesCache.isDeserializationEnabled() && virtualFile instanceof VirtualFileWithId) {
            return SerializationService.getService().deserializeTables(this.myProject, serializationSession, virtualFile);
        }
        return null;
    }

    public void clearAllTables() {
        ArrayList packs = new ArrayList(this.myCache.values());
        this.myCache.clear();
        for (FileSymbolTablesPack pack : packs) {
            pack.onRemove(this.myProject);
        }
        ((OCFileSymbolTableListener)this.myProject.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onAllSymbolTablesDropped();
    }

    private boolean clearCache(@NotNull VirtualFile file) {
        FileSymbolTablesPack pack;
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(46);
        }
        if ((pack = (FileSymbolTablesPack)this.myCache.remove(file)) != null) {
            pack.onRemove(this.myProject);
            ((OCFileSymbolTableListener)this.myProject.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onFileHasInvalidSymbolTableInPack(file);
        } else {
            ((FileSymbolTablesPackListener)this.myProject.getMessageBus().syncPublisher(FileSymbolTablesPackListener.TOPIC)).shouldInvalidateKtDependenciesFor(file);
        }
        return pack != null;
    }

    private int fillCache(Map<VirtualFile, FileSymbolTablesPack> packs) {
        for (FileSymbolTablesPack pack : packs.values()) {
            pack.onThaw(this.myProject);
        }
        this.myCache.putAll(packs);
        return packs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeTables(@NotNull String projectLocationHash, @NotNull Collection<VirtualFile> files, @NotNull ProgressIndicator indicator) {
        if (projectLocationHash == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(47);
        }
        if (files == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(48);
        }
        if (indicator == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(49);
        }
        Object object = this.mySerializationLock;
        synchronized (object) {
            if (!FileSymbolTablesCache.isSerializationEnabled()) {
                return;
            }
            HashMap<VirtualFile, FileSymbolTablesPack> tables = new HashMap<VirtualFile, FileSymbolTablesPack>();
            for (VirtualFile file : files) {
                FileSymbolTablesPack pack = this.packForFile(file);
                if (pack == null) continue;
                tables.put(file, pack);
            }
            SerializationService.getService().serializeTables(this.myProject, projectLocationHash, tables, indicator);
        }
    }

    public static boolean areSymbolsLoaded(@NotNull Project project) {
        if (project == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(50);
        }
        if (ourForceSymbolsLoadedInTests != null) {
            return ourForceSymbolsLoadedInTests;
        }
        FileSymbolTablesCache instance = FileSymbolTablesCache.getInstanceOrNull(project);
        return instance == null || !FileSymbolTablesCache.shouldBuildTables() || instance.mySymbolsLoaded.get();
    }

    public boolean areSymbolsLoaded() {
        if (ApplicationManager.getApplication().isUnitTestMode() && ourForceSymbolsLoadedInTests != null) {
            return ourForceSymbolsLoadedInTests;
        }
        return this.mySymbolsLoaded.get() || !FileSymbolTablesCache.shouldBuildTables();
    }

    public boolean isUpToDate() {
        return this.isUpToDate(SymbolTableUpdateMode.AllFiles);
    }

    public boolean isUpToDate(@NotNull SymbolTableUpdateMode updateMode) {
        if (updateMode == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(51);
        }
        return FileSymbolTablesCache.areSymbolsLoaded(this.myProject) && this.myTableUpdater.isUpToDate(updateMode);
    }

    @TestOnly
    public static void forceSymbolsLoadedInTests(@Nullable Boolean force) {
        ourForceSymbolsLoadedInTests = force;
    }

    @TestOnly
    public static Boolean getForceSymbolsLoadedInTests() {
        return ourForceSymbolsLoadedInTests;
    }

    public void notifySymbolsLoaded() {
        this.mySymbolsLoaded.getAndSet(true);
        OCLog.LOG.info("[Building Activity] Symbols loaded");
        ((OCSymbolBuildingListener)this.myProject.getMessageBus().syncPublisher(OCSymbolBuildingListener.TOPIC)).symbolBuildingFinished(this.myProject);
    }

    public void notifySymbolsUnloaded() {
        this.mySymbolsLoaded.getAndSet(false);
        OCLog.LOG.info("[Building Activity] Symbols unloaded");
        ((OCSymbolBuildingListener)this.myProject.getMessageBus().syncPublisher(OCSymbolBuildingListener.TOPIC)).symbolBuildingStarted(this.myProject);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(52);
        }
        return project;
    }

    public void removeJunkTables(boolean includingUnused) {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.removeJunkTables(this.myProject, includingUnused);
        }
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithChangedTables() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            if (!((FileSymbolTablesPack)entry.getValue()).isChanged()) continue;
            result.add((VirtualFile)entry.getKey());
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithNonFallbackTables(boolean withUsedTablesOnly) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            FileSymbolTablesPack pack = (FileSymbolTablesPack)entry.getValue();
            if (pack.isFallback() || withUsedTablesOnly && !pack.hasUsedTables()) continue;
            result.add((VirtualFile)entry.getKey());
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    public long deserializeTables(@NotNull String projectLocationHash, @NotNull Collection<VirtualFile> filesToLoad, @NotNull ProgressIndicator indicator, double indicatorScale) {
        if (projectLocationHash == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(55);
        }
        if (filesToLoad == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(56);
        }
        if (indicator == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(57);
        }
        if (!FileSymbolTablesCache.isDeserializationEnabled()) {
            return 0L;
        }
        Map<VirtualFile, FileSymbolTablesPack> packs = SerializationService.getService().deserializeTables(this.myProject, projectLocationHash, filesToLoad, indicator, indicatorScale);
        return this.fillCache(packs);
    }

    public void deserializeTables(@NotNull SerializationSession session, @NotNull VirtualFile file) {
        if (session == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(58);
        }
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(59);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myCache.get(file) != null) {
            return;
        }
        FileSymbolTablesPack pack = this.deserializePackForFile(file, session);
        if (pack != null) {
            this.addDeserializedPack(file, pack);
        }
    }

    public void handleOutOfCodeBlockChange(@NotNull PsiFile file, boolean hasMacro) {
        VirtualFile virtualFile;
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(60);
        }
        if (FileSymbolTableHelper.isSourceFile(virtualFile = OCFileUtil.getVirtualFile(file), file.getProject())) {
            boolean invalidated = this.invalidate(virtualFile, false, (Set<VirtualFile>)new SmartHashSet(), hasMacro);
            if (invalidated) {
                OCHeaderContextCache.invalidateHeaderContextsExcept(virtualFile, file.getProject());
            }
            if (invalidated || PluginUtils.isIdeaWithKmm()) {
                this.incModificationCount();
            }
            this.schedulePSIUpdates();
        }
        if (hasMacro) {
            OCImportGraph.getInstance(this.myProject).invalidateHeaderRootsCache();
            OCResolveRootAndConfigurationCache.getInstance(file.getProject()).invalidateForAllExcept(virtualFile);
        }
    }

    public void incModificationCount() {
        this.myOutOfBlockModificationTracker.incModificationCount();
    }

    public void dumpStats(@Nullable PrintWriter out) {
        if (out == null) {
            out = new PrintWriter(System.out);
        }
        ArrayList list = new ArrayList(this.myCache.entrySet());
        list.sort((o1, o2) -> {
            int c = Integer.compare(((FileSymbolTablesPack)o1.getValue()).getTablesCountSynchronized(), ((FileSymbolTablesPack)o2.getValue()).getTablesCountSynchronized());
            if (c != 0) {
                return c;
            }
            List<FileSymbolTable> ts1 = ((FileSymbolTablesPack)o1.getValue()).tablesView();
            List<FileSymbolTable> ts2 = ((FileSymbolTablesPack)o2.getValue()).tablesView();
            if (!ts1.isEmpty() && !ts2.isEmpty()) {
                VirtualFile f1 = ts1.get(0).getContainingFile();
                VirtualFile f2 = ts2.get(0).getContainingFile();
                int fc = Comparing.compare((Comparable)((Object)f1.getName()), (Comparable)((Object)f2.getName()));
                if (fc != 0) {
                    return fc;
                }
                return Comparing.compare((Comparable)((Object)f1.getPath()), (Comparable)((Object)f2.getPath()));
            }
            return Integer.compare(ts1.size(), ts2.size());
        });
        int totalFiles = 0;
        int multiTableFiles = 0;
        int totalSymbols = 0;
        int totalUniqueSymbols = 0;
        int totalContents = 0;
        int totalTables = 0;
        int totalUniqueContents = 0;
        int totalUniqueContentsLen = 0;
        for (Map.Entry entry : list) {
            ++totalFiles;
            VirtualFile file = (VirtualFile)entry.getKey();
            FileSymbolTablesPack pack = (FileSymbolTablesPack)entry.getValue();
            List tables = pack.getTablesSynchronized();
            if (tables.size() > 1) {
                ++multiTableFiles;
                Function tablePrinter = table -> Integer.toString(table.getUsageCount());
                int symbolCount = 0;
                int contentsCount = 0;
                ReferenceOpenHashSet uniqueSymbols = new ReferenceOpenHashSet();
                HashSet<List<OCSymbol>> uniqueContents = new HashSet<List<OCSymbol>>();
                int uniqueContentsLength = 0;
                for (FileSymbolTable table2 : tables) {
                    List<OCSymbol> contents = table2.getContents();
                    symbolCount += contents.size();
                    uniqueSymbols.addAll(contents);
                    ++contentsCount;
                    if (!uniqueContents.add(contents)) continue;
                    uniqueContentsLength += contents.size();
                }
                totalSymbols += symbolCount;
                totalUniqueSymbols += uniqueSymbols.size();
                totalTables += contentsCount;
                totalContents += contentsCount;
                totalUniqueContents += uniqueContents.size();
                totalUniqueContentsLen += uniqueContentsLength;
                double reuseFactor = (double)uniqueSymbols.size() / (double)symbolCount;
                String num = String.format("%5d", totalFiles + 1);
                Object contentsReuseInfo = "";
                if (uniqueContents.size() != contentsCount) {
                    contentsReuseInfo = ", " + uniqueContents.size() + "/" + contentsCount + " <" + uniqueContentsLength + "/" + symbolCount + ">";
                }
                String tableBaseInfo = file.getName() + " (" + tables.size() + ") -> : [" + String.format("%.4f", reuseFactor) + (String)contentsReuseInfo + "] ";
                out.println(num + " -- " + tableBaseInfo + StringUtil.join(tables, (Function)tablePrinter, (String)", "));
                tables = ContainerUtil.sorted(tables, (o1, o2) -> Integer.compare(o2.getUsageCount(), o1.getUsageCount()));
                out.println(num + "    " + tableBaseInfo + StringUtil.join((Collection)tables, (Function)tablePrinter, (String)", "));
                continue;
            }
            ++totalTables;
        }
        out.println("============================");
        out.println("multitable files: " + multiTableFiles + " / " + totalFiles + " (" + (double)multiTableFiles / (double)totalFiles + ")");
        out.println("reusedSym/totalSym = " + totalUniqueSymbols + "/" + totalSymbols);
        out.println("uniqueMultiTables/totalMultiTables = " + totalUniqueContents + "/" + totalContents);
        out.println("uniqueTablesSize/totalTablesSize = " + totalUniqueContentsLen + "/" + totalSymbols);
        out.println("uniqueTables/totalTables = " + (totalUniqueContents + totalFiles - multiTableFiles) + "/" + totalTables);
    }

    public void dumpTablePackStats(@NotNull VirtualFile file, @Nullable PrintWriter out) {
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(61);
        }
        if (out == null) {
            out = new PrintWriter(System.out);
        }
        out.println(file.getPath());
        List<FileSymbolTable> tables = this.allTablesForFile(file);
        out.println("Total: " + tables.size());
        int i = 0;
        for (FileSymbolTable table : tables) {
            out.println("=> " + i + " -> " + table.getContents().size() + " (valid: " + table.isValid() + ", fallback: " + table.isFallback() + ")");
            table.getSignature().dumpStats(out);
            ++i;
        }
    }

    static {
        ourSymbolsProperties = DEFAULT_SYMBOLS_PROPERTIES = ApplicationManager.getApplication().isUnitTestMode() ? SymbolsProperties.NO_SYMBOLS : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 9, 12, 23, 24, 25, 34, 36, 40, 43, 44, 52, 53, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: 
            case 23: 
            case 24: 
            case 25: 
            case 34: 
            case 36: 
            case 40: 
            case 43: 
            case 44: 
            case 52: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyNames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyFiles";
                break;
            }
            case 10: 
            case 11: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 31: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: 
            case 16: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outTimeStamp";
                break;
            }
            case 27: 
            case 30: 
            case 33: 
            case 46: 
            case 59: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirty";
                break;
            }
            case 32: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateMode";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPack";
                break;
            }
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLocationHash";
                break;
            }
            case 49: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToLoad";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutOfBlockModificationTracker";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToBuildTablesFor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFilesFromCache";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTableForFile";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "allTablesForFile";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "mutablePackForFile";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "addDeserializedPack";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithChangedTables";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithNonFallbackTables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: 
            case 23: 
            case 24: 
            case 25: 
            case 34: 
            case 36: 
            case 40: 
            case 43: 
            case 44: 
            case 52: 
            case 53: 
            case 54: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceOrNull";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invalidateDirtyIncludes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invalidateDirtyIncludeFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToCache";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeFilesFromCache";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isBuildingTableForFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildTableForFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "notifyNewTables";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findForFile";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processDirtyFile";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "ensurePendingFilesProcessed";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "allTablesForFile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "allTablesForFileCount";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "packForFile";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "mutablePackForFile";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addDeserializedPack";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "deserializePackForFile";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "clearCache";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "serializeTables";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "areSymbolsLoaded";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "deserializeTables";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "handleOutOfCodeBlockChange";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "dumpTablePackStats";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 9, 12, 23, 24, 25, 34, 36, 40, 43, 44, 52, 53, 54 -> new IllegalStateException(string);
        };
    }

    private static class OCCodeBlockModificationListener
    implements PsiTreeChangePreprocessor,
    BulkFileListener {
        @NotNull
        private final FileSymbolTablesCache myCache;
        private final Key<String> FILE_PREPROCESSOR_STAMP;

        private OCCodeBlockModificationListener(@NotNull FileSymbolTablesCache cache) {
            if (cache == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(0);
            }
            this.FILE_PREPROCESSOR_STAMP = Key.create((String)"FILE_PREPROCESSOR_STAMP");
            this.myCache = cache;
        }

        void init() {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myCache.myProject);
            if (psiManager instanceof PsiManagerEx) {
                ((PsiManagerEx)psiManager).addTreeChangePreprocessor((PsiTreeChangePreprocessor)this, (Disposable)this.myCache);
            }
            this.myCache.myProject.getMessageBus().connect((Disposable)this.myCache).subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(1);
            }
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileCreateEvent)) continue;
                this.processCreatedFile((VFileCreateEvent)vFileEvent);
            }
        }

        private void processCreatedFile(@NotNull VFileCreateEvent event) {
            VirtualFile file;
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(2);
            }
            if ((file = event.getFile()) == null || !FileSymbolTableHelper.isSourceFile(file, this.myCache.myProject)) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)this.myCache.myProject).findFile(file);
            if (psiFile == null || !FileSymbolTableHelper.shouldProcessPsiEvent(psiFile)) {
                return;
            }
            this.myCache.handleOutOfCodeBlockChange(psiFile, false);
        }

        public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
            String stamp;
            PsiFile file;
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(3);
            }
            if ((file = OCCodeBlockModificationListener.getFile(event)) == null) {
                return;
            }
            if (!FileSymbolTableHelper.isSourceFile(file)) {
                return;
            }
            if (!(event.getParent() instanceof PsiDirectory) && !FileSymbolTableHelper.shouldProcessPsiEvent(file)) {
                return;
            }
            boolean shouldCheckDocCreation = ApplicationManager.getApplication().isInternal();
            Document docToCheck = shouldCheckDocCreation ? PsiDocumentManager.getInstance((Project)this.myCache.myProject).getCachedDocument(file) : null;
            Delta delta = this.processChange(event, file);
            if (delta != null && delta.shift != 0) {
                this.validate(file, delta.start, delta.shift);
            }
            if (event.isGenericChange() && (stamp = (String)file.getUserData(this.FILE_PREPROCESSOR_STAMP)) != null) {
                if (!stamp.equals(OCCodeBlockModificationListener.macroStamp(file))) {
                    this.myCache.handleOutOfCodeBlockChange(file, true);
                }
                file.putUserData(this.FILE_PREPROCESSOR_STAMP, null);
            }
            if (shouldCheckDocCreation && docToCheck == null && PsiDocumentManager.getInstance((Project)this.myCache.myProject).getCachedDocument(file) != null) {
                LOG.error("documents must not be created during event processing: " + String.valueOf(event));
            }
        }

        @Nullable
        private Delta processChange(@NotNull PsiTreeChangeEventImpl event, PsiFile file) {
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(4);
            }
            switch (event.getCode()) {
                case BEFORE_CHILDREN_CHANGE: 
                case BEFORE_CHILD_REPLACEMENT: 
                case BEFORE_CHILD_ADDITION: 
                case BEFORE_CHILD_REMOVAL: {
                    this.processBeforeChange(event, file);
                    return null;
                }
                case BEFORE_CHILD_MOVEMENT: {
                    return null;
                }
                case CHILD_ADDED: 
                case CHILD_REMOVED: 
                case CHILD_REPLACED: 
                case CHILDREN_CHANGED: {
                    return this.processChildChange(event, file);
                }
                case CHILD_MOVED: 
                case BEFORE_PROPERTY_CHANGE: 
                case PROPERTY_CHANGED: {
                    this.myCache.incModificationCount();
                    return null;
                }
            }
            LOG.error("Unknown code:" + String.valueOf(event.getCode()));
            return null;
        }

        @Nullable
        private static PsiFile getFile(@NotNull PsiTreeChangeEventImpl event) {
            PsiFile childFile;
            PsiFile file;
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(5);
            }
            if ((file = event.getFile()) != null) {
                return file;
            }
            PsiElement child = event.getChild();
            PsiFile psiFile = childFile = child != null ? child.getContainingFile() : null;
            if (childFile != null) {
                return childFile;
            }
            PsiElement parent = event.getParent();
            return parent != null ? parent.getContainingFile() : null;
        }

        @Nullable
        private Delta processChildChange(@NotNull PsiTreeChangeEventImpl event, @NotNull PsiFile file) {
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(6);
            }
            if (file == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(7);
            }
            ThreadingAssertions.assertEventDispatchThread();
            if (event.isGenericChange()) {
                return null;
            }
            if (OCCodeBlockModificationListener.isOutOfCodeBlockChange(event, file)) {
                this.myCache.handleOutOfCodeBlockChange(file, false);
                return null;
            }
            PsiElement child = event.getChild();
            PsiElement parent = event.getParent();
            int offset = event.getOffset();
            switch (event.getCode()) {
                case CHILD_ADDED: {
                    assert (child != null);
                    if (OCCodeBlockModificationListener.checkInvalid((PsiTreeChangeEvent)event, child)) {
                        return null;
                    }
                    return new Delta(offset, child.getTextLength());
                }
                case CHILD_REMOVED: {
                    return new Delta(offset, -event.getOldLength());
                }
                case CHILD_REPLACED: {
                    assert (child != null);
                    if (OCCodeBlockModificationListener.checkInvalid((PsiTreeChangeEvent)event, child)) {
                        return null;
                    }
                    return new Delta(offset, child.getTextLength() - event.getOldLength());
                }
                case CHILDREN_CHANGED: {
                    assert (parent != null);
                    return new Delta(offset, parent.getTextLength() - event.getOldLength());
                }
            }
            OCLog.LOG.error("unexpected event code: " + String.valueOf(event.getCode()));
            return null;
        }

        private static boolean checkInvalid(@NotNull PsiTreeChangeEvent event, @NotNull PsiElement psi) {
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(8);
            }
            if (psi == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(9);
            }
            if (!psi.isValid()) {
                LOG.warn("Invalid PSI in OCCodeBlockModificationListener.treeChanged: " + String.valueOf(psi) + ", event: " + String.valueOf(event));
                return true;
            }
            return false;
        }

        private void processBeforeChange(@NotNull PsiTreeChangeEventImpl event, PsiFile file) {
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(10);
            }
            ThreadingAssertions.assertEventDispatchThread();
            if (event.getCode() == PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE && event.getParent() instanceof PsiFile) {
                return;
            }
            boolean isFile = event.getChild() instanceof PsiFile;
            if (!isFile && !(file instanceof OCCodeFragment) && file.getUserData(this.FILE_PREPROCESSOR_STAMP) == null) {
                file.putUserData(this.FILE_PREPROCESSOR_STAMP, (Object)OCCodeBlockModificationListener.macroStamp(file));
            }
        }

        private static boolean isOutOfCodeBlockChange(@NotNull PsiTreeChangeEventImpl event, @Nullable PsiFile file) {
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(11);
            }
            if (file instanceof OCCodeFragment) {
                return false;
            }
            PsiElement element = event.getParent();
            if (element instanceof PsiFileSystemItem) {
                return true;
            }
            if (element == null || element.getParent() == null) {
                return false;
            }
            return FileSymbolTableHelper.isOutOfCodeBlockChange(event, element.getContainingFile());
        }

        @NotNull
        private static String macroStamp(PsiFile file) {
            if (!(file instanceof OCFile)) {
                return "";
            }
            StringBuilder acc = new StringBuilder();
            OCCodeBlockModificationListener.processASTNodeForMacros((ASTNode)file.getNode(), acc);
            String string = acc.toString();
            if (string == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(12);
            }
            return string;
        }

        private static void processASTNodeForMacros(@Nullable ASTNode node, @NotNull StringBuilder acc) {
            if (acc == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(13);
            }
            if (node == null) {
                return;
            }
            IElementType elementType = node.getElementType();
            if (elementType instanceof OCLazyBlockStatementElementType) {
                return;
            }
            if (OCElementTypes.IMPORTANT_DIRECTIVES.contains(elementType)) {
                acc.append(node.getText());
            }
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                OCCodeBlockModificationListener.processASTNodeForMacros(child, acc);
            }
        }

        private void validate(@NotNull PsiFile file, int start, int lengthShift) {
            FileSymbolTablesPack pack;
            if (file == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(14);
            }
            if ((pack = this.myCache.packForFile(OCFileUtil.getVirtualFile(file))) != null) {
                pack.updateOffsetsSynchronized(start, lengthShift);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cache";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 7: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$OCCodeBlockModificationListener";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "acc";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$OCCodeBlockModificationListener";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "macroStamp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "after";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "processCreatedFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "treeChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processChange";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getFile";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processChildChange";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "checkInvalid";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "processBeforeChange";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isOutOfCodeBlockChange";
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "processASTNodeForMacros";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "validate";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 12 -> new IllegalStateException(string);
            };
        }
    }

    public static final class SymbolsProperties {
        public static final SymbolsProperties NO_SYMBOLS = new SymbolsProperties(SymbolsKind.NO_SYMBOLS, false, false);
        @NotNull
        private final SymbolsKind buildSymbolsKind;
        private final boolean deserializeSymbolTables;
        private final boolean serializeSymbolTables;

        public SymbolsProperties(@NotNull SymbolsKind buildSymbolKind, boolean deserializeSymbolTables, boolean serializeSymbolTables) {
            if (buildSymbolKind == null) {
                SymbolsProperties.$$$reportNull$$$0(0);
            }
            this.buildSymbolsKind = buildSymbolKind;
            this.deserializeSymbolTables = deserializeSymbolTables;
            this.serializeSymbolTables = serializeSymbolTables;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildSymbolKind", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$SymbolsProperties", "<init>"));
        }

        public static enum SymbolsKind {
            NO_SYMBOLS,
            ONLY_USED,
            ALL_INCLUDING_UNUSED_SYSTEM_HEADERS;

        }
    }

    private static final class Delta {
        final int start;
        final int shift;

        private Delta(int start, int shift) {
            this.start = start;
            this.shift = shift;
        }
    }

    private final class ClearTablesAndCollectNamesVisitor
    extends VirtualFileVisitor<Object> {
        @NotNull
        final Set<String> dirtyNames;
        boolean cacheCleared;

        private ClearTablesAndCollectNamesVisitor() {
            super(new VirtualFileVisitor.Option[0]);
            this.dirtyNames = CollectionFactory.createFilePathSet();
            this.cacheCleared = false;
        }

        @Nullable
        public Collection<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
            if (file == null) {
                ClearTablesAndCollectNamesVisitor.$$$reportNull$$$0(0);
            }
            return file.isDirectory() ? ((NewVirtualFile)file).getCachedChildren() : null;
        }

        public boolean visitFile(@NotNull VirtualFile file) {
            if (file == null) {
                ClearTablesAndCollectNamesVisitor.$$$reportNull$$$0(1);
            }
            if (file.isDirectory()) {
                return true;
            }
            if (FileSymbolTablesCache.this.clearCache(file)) {
                this.cacheCleared = true;
                FileSymbolTablesCache.this.addFileToCache(file);
            }
            this.dirtyNames.add(file.getName());
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "file";
            objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$ClearTablesAndCollectNamesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getChildrenIterable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

