/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMethodSymbolImpl
extends OCMemberSymbolImpl
implements OCMethodSymbol {
    private boolean myStatic;
    private boolean myOptional;
    private boolean myVararg;
    private OCType myReturnType;
    private OCSymbol myOriginalSymbol;
    private List<? extends OCMethodSymbol.SelectorPartSymbol> mySelectors;
    private OCTypeSubstitution mySubstitution;

    public OCMethodSymbolImpl() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    protected OCMethodSymbolImpl(@NotNull OCMethodSymbolImpl origin, @NotNull OCTypeSubstitution substitution) {
        if (origin == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(0);
        }
        if (substitution == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(1);
        }
        this(origin.getContainingFile(), origin.getComplexOffset(), origin.getName(), origin.getAttributes(), origin.myParent, origin.myStatic, origin.myOptional, origin.myVararg, origin.myReturnType, new ArrayList<OCMethodSymbol.SelectorPartSymbol>(origin.mySelectors), origin.myOriginalSymbol);
        this.mySubstitution = substitution;
    }

    @Override
    @NotNull
    public OCMethodSymbolImpl cloneWithSubstitution(@NotNull OCTypeSubstitution substitution) {
        if (substitution == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(2);
        }
        return new OCMethodSymbolImpl(this, substitution);
    }

    /*
     * WARNING - void declaration
     */
    public OCMethodSymbolImpl(VirtualFile file, long offset, @Nullable String name, @NotNull List<String> attributes, @NotNull OCClassSymbol parent, boolean isStatic, boolean isOptional, boolean isVararg, @NotNull OCType returnType, @NotNull List<? extends OCMethodSymbol.SelectorPartSymbol> selectors, @Nullable OCSymbol oCSymbol) {
        void originalSymbol;
        if (attributes == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(4);
        }
        if (returnType == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(5);
        }
        if (selectors == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(6);
        }
        super(file, offset, name, attributes, parent);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myStatic = isStatic;
        this.myOriginalSymbol = originalSymbol;
        this.myReturnType = returnType;
        this.myOptional = isOptional;
        this.myVararg = isVararg;
        this.mySelectors = ContainerUtil.trimToSize(selectors);
        for (OCMethodSymbol.SelectorPartSymbol selectorPartSymbol : selectors) {
            OCDeclaratorSymbol parameter = selectorPartSymbol.getParameterWithoutSubstitution();
            if (!(parameter instanceof OCDeclaratorSymbolImpl)) continue;
            ((OCDeclaratorSymbolImpl)parameter).setParentMethod(this);
        }
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(7);
        }
        if (first == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(8);
        }
        if (second == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(9);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCMethodSymbolImpl f = (OCMethodSymbolImpl)first;
        OCMethodSymbolImpl s = (OCMethodSymbolImpl)second;
        if (f.myOptional != s.myOptional) {
            return false;
        }
        if (f.myStatic != s.myStatic) {
            return false;
        }
        if (f.myVararg != s.myVararg) {
            return false;
        }
        if (!c.equalObjects(f.myOriginalSymbol, s.myOriginalSymbol)) {
            return false;
        }
        if (!c.equalObjects(f.myReturnType, s.myReturnType)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return c.equalLists(f.mySelectors, s.mySelectors);
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        for (OCMethodSymbol.SelectorPartSymbol selectorPartSymbol : this.mySelectors) {
            OCDeclaratorSymbol param = selectorPartSymbol.getParameter();
            if (param == null) continue;
            param.updateOffset(start, lengthShift);
        }
    }

    @Override
    public void compact() {
        super.compact();
        this.myReturnType.compact();
        for (OCMethodSymbol.SelectorPartSymbol selectorPartSymbol : this.mySelectors) {
            OCDeclaratorSymbol param = selectorPartSymbol.getParameter();
            if (param == null) continue;
            param.compact();
        }
    }

    @Override
    @NotNull
    public Class<? extends PsiElement> getPsiElementClass() {
        return this.getOriginalSymbol() == null ? OCMethod.class : OCDeclarator.class;
    }

    @Override
    @NotNull
    public OCType getReturnType(@Nullable OCObjectType receiverType, @NotNull Project project) {
        if (project == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(10);
        }
        return OCMethodSymbolImpl.inferReturnType(this, this.myReturnType, receiverType, project);
    }

    @NotNull
    public static OCType inferReturnType(@NotNull OCMethodSymbol self, @NotNull OCType rawReturnType, @Nullable OCObjectType receiverType, @NotNull Project project) {
        if (self == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(11);
        }
        if (rawReturnType == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(12);
        }
        if (project == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(13);
        }
        if (rawReturnType instanceof OCReferenceType && rawReturnType.getName().equals("instancetype")) {
            if (receiverType != null && receiverType.getClassSymbol() != null && receiverType.getClassSymbol().isSubclass(self.getParent(), project)) {
                OCType oCType = OCPointerType.to(receiverType).cloneWithNullability(rawReturnType.getNullability());
                if (oCType == null) {
                    OCMethodSymbolImpl.$$$reportNull$$$0(14);
                }
                return oCType;
            }
            OCPointerType type = OCPointerType.to(self.getParent().getType());
            OCType clone = type.cloneWithAliasName("instancetype");
            clone.attachNullability(rawReturnType.getNullability());
            OCType oCType = clone;
            if (oCType == null) {
                OCMethodSymbolImpl.$$$reportNull$$$0(15);
            }
            return oCType;
        }
        OCType oCType = self.getSubstitution().substitute(rawReturnType);
        if (oCType == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(16);
        }
        return oCType;
    }

    @Override
    public boolean isStatic() {
        return this.myStatic;
    }

    @Override
    public boolean isOptional() {
        return this.myOptional;
    }

    @Override
    public boolean isVararg() {
        return this.myVararg;
    }

    public static boolean isFactoryMethod(@NotNull OCMethodSymbol self) {
        if (self == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(17);
        }
        String className = StringUtil.trimStart((String)self.getParent().getName(), (String)"NS");
        String selector = self.getName();
        if (self.isStatic()) {
            List classWords = NameUtil.nameToWordsLowerCase((String)className);
            List selectorWords = NameUtil.nameToWordsLowerCase((String)selector);
            String word = (String)ContainerUtil.getFirstItem((List)selectorWords);
            if ("default".equalsIgnoreCase(word) || "common".equalsIgnoreCase(word) || "shared".equalsIgnoreCase(word) || "main".equalsIgnoreCase(word)) {
                selectorWords.remove(0);
            }
            if (classWords.isEmpty() || selectorWords.isEmpty()) {
                return false;
            }
            block0: for (int wordCount = 1; wordCount <= Math.min(classWords.size(), selectorWords.size()); ++wordCount) {
                for (int i = 0; i < wordCount; ++i) {
                    String classWord = (String)classWords.get(classWords.size() - wordCount + i);
                    String selectorWord = (String)selectorWords.get(i);
                    if (!selectorWord.equals(classWord)) continue block0;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPredeclaration() {
        return !(this.getParent() instanceof OCImplementationSymbol);
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.doComputeIcon();
    }

    @Override
    public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project) {
        Icon result;
        if (project == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(18);
        }
        if ((result = this.doComputeIconFullAndNow(project)) == null) {
            return null;
        }
        return OCTestFrameworks.isTestMethodOrFunction(this, symbolElement, project) ? OCIcons.getTestIcon(result) : result;
    }

    private Icon doComputeIcon() {
        OCPropertySymbol property = this.getGeneratedFromProperty();
        return property != null ? property.getBaseIcon() : OCIcons.getMethodIcon(this.isStatic(), this.isOptional(), false);
    }

    private Icon doComputeIconFullAndNow(@NotNull Project project) {
        OCPropertySymbol associatedProperty;
        OCMethodSymbol associatedMethod;
        OCPropertySymbol property;
        if (project == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(19);
        }
        if ((property = this.getGeneratedFromProperty()) != null) {
            return property.computeFullIconNow(null, project);
        }
        if (this.myParent instanceof OCImplementationSymbol && (associatedMethod = this.getAssociatedSymbol((PsiElement)this.myParent.getContainingPsiFile(project), project)) != null && (associatedProperty = associatedMethod.getGeneratedFromProperty()) != null) {
            return associatedProperty.computeFullIconNow(null, project);
        }
        return OCIcons.getMethodIcon(this.isStatic(), this.isOptional(), false);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.METHOD;
        if (oCSymbolKind == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(20);
        }
        return oCSymbolKind;
    }

    @Override
    public OCSymbol getOriginalSymbol() {
        return this.myOriginalSymbol;
    }

    @Override
    public boolean isSynthetic() {
        return this.getOriginalSymbol() != null;
    }

    @Override
    public boolean isForbiddenByARC(@NotNull PsiElement context) {
        if (context == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(21);
        }
        return super.isForbiddenByARC(context) || "dealloc".equals(this.myName) && OCCompilerFeaturesHelper.isArcEnabled(context.getContainingFile());
    }

    public static boolean isAccessorWithAliasedName(@NotNull OCMethodSymbol self, @NotNull Project project) {
        OCPropertySymbol property;
        if (self == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(22);
        }
        if (project == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(23);
        }
        if ((property = self.getGeneratedFromProperty()) == null) {
            return false;
        }
        OCResolveContext context = OCResolveContext.forSymbol(self, project);
        if (self.isGetter(context)) {
            return property.getAttributeValue(OCPropertySymbol.PropertyAttribute.GETTER) != null;
        }
        if (self.isSetter(context)) {
            return property.getAttributeValue(OCPropertySymbol.PropertyAttribute.SETTER) != null;
        }
        return false;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(24);
        }
        return oCTypeSubstitution;
    }

    @Override
    @NotNull
    public List<OCMethodSymbol.SelectorPartSymbol> getSelectors() {
        return this.mySubstitution == OCTypeSubstitution.ID ? Collections.unmodifiableList(this.mySelectors) : new ArrayList(ContainerUtil.map(this.mySelectors, symbol -> symbol.cloneWithSubstitution(this.mySubstitution)));
    }

    @Override
    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols() {
        return new ArrayList<OCDeclaratorSymbol>(ContainerUtil.map(this.mySelectors, symbol -> this.mySubstitution.substitute(symbol.getParameter())));
    }

    @Override
    @NotNull
    public String getNameWithParent(@NotNull OCResolveContext context) {
        if (context == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(25);
        }
        String string = (this.myStatic ? "+" : "-") + "[" + this.myParent.getName() + " " + this.getName() + "]";
        if (string == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Override
    @Nullable
    public OCMethodSymbol getAssociatedSymbol(@NotNull Project project) {
        if (project == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(27);
        }
        return this.getAssociatedSymbol(null, project);
    }

    @Nullable
    public static OCMethodSymbol getAssociatedSymbol(final @NotNull OCMethodSymbol self, @Nullable PsiElement context, @NotNull Project project) {
        OCClassSymbol parentAssociate;
        if (self == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(28);
        }
        if (project == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(29);
        }
        if ((parentAssociate = (OCClassSymbol)self.getParent().getAssociatedSymbol(project)) == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            protected boolean accept(OCMethodSymbol methodSymbol) {
                return methodSymbol.isStatic() == self.isStatic();
            }
        };
        parentAssociate.processCategories((Processor<? super OCClassSymbol>)((Processor)arg_0 -> OCMethodSymbolImpl.lambda$getAssociatedSymbol$2(self, (CommonProcessors.FindFirstProcessor)processor2, arg_0)), true, context, project);
        return (OCMethodSymbol)processor2.getFoundValue();
    }

    @Override
    public boolean processSameSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project) {
        if (processor2 == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(30);
        }
        if (project == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(31);
        }
        return this.myParent.processMembersInAllCategories(this.myName, this.getClass(), methodSymbol -> methodSymbol.isStatic() != this.isStatic() || processor2.process((Object)this.mySubstitution.substitute(methodSymbol)), false, project);
    }

    @Override
    @NotNull
    public OCType getEffectiveResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(32);
        }
        OCType oCType = this.getReturnType(context.getProject()).resolve(context);
        if (oCType == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(33);
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCType getEffectiveType(@NotNull Project project) {
        if (project == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(34);
        }
        OCType oCType = this.getReturnType(project);
        if (oCType == null) {
            OCMethodSymbolImpl.$$$reportNull$$$0(35);
        }
        return oCType;
    }

    private static /* synthetic */ boolean lambda$getAssociatedSymbol$2(OCMethodSymbol self, CommonProcessors.FindFirstProcessor processor2, OCClassSymbol symbol) {
        return self.getSubstitution().substitute(symbol).processMembers(self.getName(), OCMethodSymbol.class, processor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 16, 20, 24, 26, 33, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 17: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawReturnType";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 26: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/objc/OCMethodSymbolImpl";
                break;
            }
            case 21: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/objc/OCMethodSymbolImpl";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "inferReturnType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithParent";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveResolvedType";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithSubstitution";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "inferReturnType";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 26: 
            case 33: 
            case 35: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFactoryMethod";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeFullIconNow";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIconFullAndNow";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isForbiddenByARC";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAccessorWithAliasedName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithParent";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedSymbol";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processSameSymbols";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveResolvedType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 16, 20, 24, 26, 33, 35 -> new IllegalStateException(string);
        };
    }
}

