/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCompatibilityAlias;
import com.jetbrains.cidr.lang.psi.OCConceptDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCGenericParameter;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMacroParameter;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCUndefDirective;
import com.jetbrains.cidr.lang.psi.OCUnion;
import icons.CidrLangIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public enum OCSymbolKind {
    CATCH_EXCEPTION_VARIABLE,
    LOCAL_VARIABLE,
    PARAMETER,
    LABEL,
    STRUCT_FIELD,
    PROPERTY,
    INSTANCE_VARIABLE,
    METHOD,
    FUNCTION_PREDECLARATION,
    FUNCTION_DECLARATION,
    TYPEDEF,
    COMPATIBILITY_ALIAS,
    INTERFACE,
    PROTOCOL,
    IMPLEMENTATION,
    STRUCT,
    USING_SYMBOL_ALIAS,
    ENUM,
    UNION,
    NAMESPACE_ALIAS,
    NAMESPACE,
    NAMESPACE_USING_SYMBOL,
    SYMBOL_USING_SYMBOL,
    ENUM_CONST,
    GLOBAL_VARIABLE,
    GLOBAL_VARIABLE_PREDECLARATION,
    CPP_CONSTRUCTOR_PREDECLARATION,
    CPP_CONSTRUCTOR_DECLARATION,
    CPP_DEDUCTION_GUIDE,
    CPP_CTAD_DEDUCTION_CANDIDATE,
    CPP_CONCEPT,
    MACRO,
    MACRO_PARAMETER,
    UNDEF_MACRO,
    TEMPLATE_TYPE_PARAMETER,
    TEMPLATE_VALUE_PARAMETER,
    BUILTIN_SYMBOL,
    SYNTHESIZE,
    BLOCK,
    LAMBDA,
    IMPORT,
    LOCALIZED_STRING,
    EXPRESSION,
    ARGUMENT_LIST,
    GENERIC_PARAMETER,
    EXCEPTION_SPECIFIER,
    FOREIGN_ELEMENT,
    KEYWORD,
    FILE,
    FOLDER,
    UNKNOWN;


    @NotNull
    @Nls
    public String getName() {
        String string = switch (this.ordinal()) {
            case 10 -> OCBundle.message("symbol.kind.name.uppercase.type", new Object[0]);
            case 23 -> OCBundle.message("symbol.kind.name.uppercase.enum.constant", new Object[0]);
            case 4 -> OCBundle.message("symbol.kind.name.uppercase.field", new Object[0]);
            case 8, 9 -> OCBundle.message("symbol.kind.name.uppercase.function", new Object[0]);
            case 26, 27 -> OCBundle.message("symbol.kind.name.uppercase.constructor", new Object[0]);
            case 2 -> OCBundle.message("symbol.kind.name.uppercase.parameter", new Object[0]);
            case 24, 25 -> OCBundle.message("symbol.kind.name.uppercase.global.variable", new Object[0]);
            case 36 -> OCBundle.message("symbol.kind.name.uppercase.built.in.symbol", new Object[0]);
            case 1 -> OCBundle.message("symbol.kind.name.uppercase.local.variable", new Object[0]);
            case 0 -> OCBundle.message("symbol.kind.name.uppercase.exception.variable", new Object[0]);
            case 14 -> OCBundle.message("symbol.kind.name.uppercase.implementation", new Object[0]);
            case 6 -> OCBundle.message("symbol.kind.name.uppercase.instance.variable", new Object[0]);
            case 12 -> OCBundle.message("symbol.kind.name.uppercase.interface", new Object[0]);
            case 3 -> OCBundle.message("symbol.kind.name.uppercase.label", new Object[0]);
            case 31, 33 -> OCBundle.message("symbol.kind.name.uppercase.macro", new Object[0]);
            case 32 -> OCBundle.message("symbol.kind.name.uppercase.macro.parameter", new Object[0]);
            case 40 -> OCBundle.message("symbol.kind.name.uppercase.import", new Object[0]);
            case 11 -> OCBundle.message("symbol.kind.name.uppercase.compatibility.alias", new Object[0]);
            case 7 -> OCBundle.message("symbol.kind.name.uppercase.method1", new Object[0]);
            case 38 -> OCBundle.message("symbol.kind.name.uppercase.block", new Object[0]);
            case 39 -> OCBundle.message("symbol.kind.name.uppercase.lambda", new Object[0]);
            case 5 -> OCBundle.message("symbol.kind.name.uppercase.property", new Object[0]);
            case 37 -> OCBundle.message("symbol.kind.name.uppercase.synthesize.statement", new Object[0]);
            case 13 -> OCBundle.message("symbol.kind.name.uppercase.protocol", new Object[0]);
            case 15 -> OCBundle.message("symbol.kind.name.uppercase.struct", new Object[0]);
            case 18 -> OCBundle.message("symbol.kind.name.uppercase.union", new Object[0]);
            case 17 -> OCBundle.message("symbol.kind.name.uppercase.enum", new Object[0]);
            case 19, 20 -> OCBundle.message("symbol.kind.name.uppercase.namespace", new Object[0]);
            case 34 -> OCBundle.message("symbol.kind.name.uppercase.type.parameter", new Object[0]);
            case 35 -> OCBundle.message("symbol.kind.name.uppercase.template.parameter", new Object[0]);
            case 16, 21, 22 -> OCBundle.message("symbol.kind.name.uppercase.using", new Object[0]);
            case 41 -> OCBundle.message("symbol.kind.name.uppercase.localized.string", new Object[0]);
            case 42 -> OCBundle.message("symbol.kind.name.uppercase.expression", new Object[0]);
            case 44 -> OCBundle.message("symbol.kind.name.uppercase.generic.parameter", new Object[0]);
            case 30 -> OCBundle.message("symbol.kind.name.uppercase.concept", new Object[0]);
            case 47 -> OCBundle.message("symbol.kind.name.uppercase.keyword", new Object[0]);
            case 48 -> OCBundle.message("symbol.kind.name.uppercase.file", new Object[0]);
            case 49 -> OCBundle.message("symbol.kind.name.uppercase.folder", new Object[0]);
            default -> OCBundle.message("symbol.kind.name.uppercase.default", new Object[0]);
        };
        if (string == null) {
            OCSymbolKind.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getNameLowercase() {
        String string = switch (this.ordinal()) {
            case 10 -> OCBundle.message("symbol.kind.name.lowercase.type", new Object[0]);
            case 23 -> OCBundle.message("symbol.kind.name.lowercase.enum.constant", new Object[0]);
            case 4 -> OCBundle.message("symbol.kind.name.lowercase.field", new Object[0]);
            case 8, 9 -> OCBundle.message("symbol.kind.name.lowercase.function", new Object[0]);
            case 26, 27 -> OCBundle.message("symbol.kind.name.lowercase.constructor", new Object[0]);
            case 2 -> OCBundle.message("symbol.kind.name.lowercase.parameter", new Object[0]);
            case 24, 25 -> OCBundle.message("symbol.kind.name.lowercase.global.variable", new Object[0]);
            case 36 -> OCBundle.message("symbol.kind.name.lowercase.built.in.symbol", new Object[0]);
            case 1 -> OCBundle.message("symbol.kind.name.lowercase.local.variable", new Object[0]);
            case 0 -> OCBundle.message("symbol.kind.name.lowercase.exception.variable", new Object[0]);
            case 14 -> OCBundle.message("symbol.kind.name.lowercase.implementation", new Object[0]);
            case 6 -> OCBundle.message("symbol.kind.name.lowercase.instance.variable", new Object[0]);
            case 12 -> OCBundle.message("symbol.kind.name.lowercase.interface", new Object[0]);
            case 3 -> OCBundle.message("symbol.kind.name.lowercase.label", new Object[0]);
            case 31, 33 -> OCBundle.message("symbol.kind.name.lowercase.macro", new Object[0]);
            case 32 -> OCBundle.message("symbol.kind.name.lowercase.macro.parameter", new Object[0]);
            case 40 -> OCBundle.message("symbol.kind.name.lowercase.import", new Object[0]);
            case 11 -> OCBundle.message("symbol.kind.name.lowercase.compatibility.alias", new Object[0]);
            case 7 -> OCBundle.message("symbol.kind.name.lowercase.method1", new Object[0]);
            case 38 -> OCBundle.message("symbol.kind.name.lowercase.block", new Object[0]);
            case 39 -> OCBundle.message("symbol.kind.name.lowercase.lambda", new Object[0]);
            case 5 -> OCBundle.message("symbol.kind.name.lowercase.property", new Object[0]);
            case 37 -> OCBundle.message("symbol.kind.name.lowercase.synthesize.statement", new Object[0]);
            case 13 -> OCBundle.message("symbol.kind.name.lowercase.protocol", new Object[0]);
            case 15 -> OCBundle.message("symbol.kind.name.lowercase.struct", new Object[0]);
            case 18 -> OCBundle.message("symbol.kind.name.lowercase.union", new Object[0]);
            case 17 -> OCBundle.message("symbol.kind.name.lowercase.enum", new Object[0]);
            case 19, 20 -> OCBundle.message("symbol.kind.name.lowercase.namespace", new Object[0]);
            case 34 -> OCBundle.message("symbol.kind.name.lowercase.type.parameter", new Object[0]);
            case 35 -> OCBundle.message("symbol.kind.name.lowercase.template.parameter", new Object[0]);
            case 16, 21, 22 -> OCBundle.message("symbol.kind.name.lowercase.using", new Object[0]);
            case 41 -> OCBundle.message("symbol.kind.name.lowercase.localized.string", new Object[0]);
            case 42 -> OCBundle.message("symbol.kind.name.lowercase.expression", new Object[0]);
            case 44 -> OCBundle.message("symbol.kind.name.lowercase.generic.parameter", new Object[0]);
            case 30 -> OCBundle.message("symbol.kind.name.lowercase.concept", new Object[0]);
            case 47 -> OCBundle.message("symbol.kind.name.lowercase.keyword", new Object[0]);
            case 48 -> OCBundle.message("symbol.kind.name.lowercase.file", new Object[0]);
            case 49 -> OCBundle.message("symbol.kind.name.lowercase.folder", new Object[0]);
            default -> OCBundle.message("symbol.kind.name.lowercase.default", new Object[0]);
        };
        if (string == null) {
            OCSymbolKind.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Class<? extends PsiElement> getPsiElementClass() {
        return switch (this.ordinal()) {
            case 36 -> PsiElement.class;
            case 14 -> OCImplementation.class;
            case 12, 13 -> OCClassDeclaration.class;
            case 3 -> OCLabeledStatement.class;
            case 31 -> OCDefineDirective.class;
            case 33 -> OCUndefDirective.class;
            case 32 -> OCMacroParameter.class;
            case 40 -> OCIncludeDirective.class;
            case 11 -> OCCompatibilityAlias.class;
            case 7 -> OCMethod.class;
            case 38 -> OCBlockExpression.class;
            case 37 -> OCSynthesizeProperty.class;
            case 15 -> OCStruct.class;
            case 18 -> OCUnion.class;
            case 17 -> OCEnum.class;
            case 20 -> OCCppNamespace.class;
            case 19 -> OCCppNamespaceAlias.class;
            case 34 -> OCTypeParameterDeclaration.class;
            case 16, 21, 22 -> OCCppUsingStatement.class;
            case 41 -> OCLocalizedString.class;
            case 42 -> OCExpression.class;
            case 44 -> OCGenericParameter.class;
            case 30 -> OCConceptDeclaration.class;
            default -> OCDeclarator.class;
        };
    }

    public Icon getIcon() {
        return switch (this.ordinal()) {
            case 19, 20, 21 -> CidrLangIcons.CodeAssistantNamespace;
            case 10, 16, 22, 34 -> CidrLangIcons.CodeAssistantType;
            case 23 -> CidrLangIcons.CodeAssistantEnumConst;
            case 8, 9, 26, 27 -> CidrLangIcons.CodeAssistantFunction;
            case 4, 6 -> CidrLangIcons.CodeAssistantField;
            case 12, 14 -> CidrLangIcons.CodeAssistantClass;
            case 31, 32, 33, 40 -> CidrLangIcons.CodeAssistantMacro;
            case 11 -> CidrLangIcons.CodeAssistantClass;
            case 7 -> CidrLangIcons.CodeAssistantMember;
            case 5 -> CidrLangIcons.CodeAssistantProperty;
            case 13 -> CidrLangIcons.CodeAssistantProtocol;
            case 15 -> CidrLangIcons.CodeAssistantStruct;
            case 18 -> CidrLangIcons.CodeAssistantUnion;
            case 17 -> CidrLangIcons.CodeAssistantEnum;
            case 2, 35, 44 -> CidrLangIcons.CodeAssistantParameter;
            case 0, 1, 3 -> CidrLangIcons.CodeAssistantLocal;
            case 24, 25, 36 -> CidrLangIcons.CodeAssistantGlobal;
            case 37, 38, 39, 41, 42 -> null;
            default -> null;
        };
    }

    @NotNull
    @Nls
    public String getNameUppercase() {
        String string = this.getName();
        if (string == null) {
            OCSymbolKind.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isClass() {
        return switch (this.ordinal()) {
            case 11, 12, 13, 14 -> true;
            default -> false;
        };
    }

    public boolean isClassOrTypedef() {
        return this.isClass() || this == TYPEDEF || this == USING_SYMBOL_ALIAS;
    }

    public boolean isType() {
        return this.isClassOrTypedef() || this.isStructLike() || this == TEMPLATE_TYPE_PARAMETER || this == COMPATIBILITY_ALIAS || this == GENERIC_PARAMETER;
    }

    public boolean isStructLike() {
        return switch (this.ordinal()) {
            case 15, 17, 18 -> true;
            default -> false;
        };
    }

    @NlsSafe
    @NotNull
    public String getStructKeyword() {
        return switch (this.ordinal()) {
            case 15 -> "struct";
            case 18 -> "union";
            case 17 -> "enum";
            default -> {
                OCLog.LOG.error("getStructKeyword should be called on isStructLike symbol kind");
                yield "";
            }
        };
    }

    public boolean isStructOrUnion() {
        return this == STRUCT || this == UNION;
    }

    public boolean isFunction() {
        return this == FUNCTION_PREDECLARATION || this == FUNCTION_DECLARATION;
    }

    public boolean isFunctionOrConstructor() {
        return this.isFunction() || this.isConstructorOrDestructor();
    }

    public boolean isCallable() {
        return this.isFunction() || this == METHOD || this == BLOCK || this == CPP_CONSTRUCTOR_DECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION || this == LAMBDA;
    }

    @Contract(pure=true)
    public boolean isPredeclaration() {
        return this == FUNCTION_PREDECLARATION || this == GLOBAL_VARIABLE_PREDECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION || this == STRUCT_FIELD;
    }

    public boolean isLocal() {
        return this == LOCAL_VARIABLE || this == CATCH_EXCEPTION_VARIABLE || this == LABEL || this == PARAMETER;
    }

    public boolean isConst() {
        return this == ENUM_CONST || this == TEMPLATE_VALUE_PARAMETER || this == GENERIC_PARAMETER || this.isFunction();
    }

    public OCSymbolKind toDeclarationKind() {
        return switch (this.ordinal()) {
            case 8 -> FUNCTION_DECLARATION;
            case 26 -> CPP_CONSTRUCTOR_DECLARATION;
            case 25 -> GLOBAL_VARIABLE;
            default -> this;
        };
    }

    public boolean isExpression() {
        return switch (this.ordinal()) {
            case 0, 1, 2, 4, 5, 6, 8, 9, 23, 24, 25, 26, 27, 35, 36, 39 -> true;
            default -> false;
        };
    }

    public boolean isVariable() {
        return switch (this.ordinal()) {
            case 0, 1, 2, 5, 6, 23, 24, 25, 35 -> true;
            default -> false;
        };
    }

    public boolean isGlobalVariable() {
        return this == GLOBAL_VARIABLE || this == GLOBAL_VARIABLE_PREDECLARATION;
    }

    public boolean isConstructorOrDestructor() {
        return this == CPP_CONSTRUCTOR_DECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION;
    }

    public boolean isTemplateParameter() {
        return this == TEMPLATE_VALUE_PARAMETER || this == TEMPLATE_TYPE_PARAMETER || this == GENERIC_PARAMETER;
    }

    public boolean isTypedefOrAlias() {
        return this == TYPEDEF || this == COMPATIBILITY_ALIAS || this == USING_SYMBOL_ALIAS;
    }

    public boolean canBeNamespace() {
        return switch (this.ordinal()) {
            case 10, 15, 17, 18, 19, 20, 34 -> true;
            default -> false;
        };
    }

    public static OCSymbolKind parse(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("struct") || name.equals("class")) {
            return STRUCT;
        }
        if (name.equals("enum")) {
            return ENUM;
        }
        if (name.equals("union")) {
            return UNION;
        }
        if (name.equals("concept")) {
            return CPP_CONCEPT;
        }
        return null;
    }

    public boolean isSame(@NotNull OCSymbolKind kind) {
        if (kind == null) {
            OCSymbolKind.$$$reportNull$$$0(3);
        }
        return this == kind || this == FUNCTION_DECLARATION && kind == FUNCTION_PREDECLARATION || this == FUNCTION_PREDECLARATION && kind == FUNCTION_DECLARATION || this == CPP_CONSTRUCTOR_DECLARATION && kind == CPP_CONSTRUCTOR_PREDECLARATION || this == CPP_CONSTRUCTOR_PREDECLARATION && kind == CPP_CONSTRUCTOR_DECLARATION || this == GLOBAL_VARIABLE && kind == GLOBAL_VARIABLE_PREDECLARATION || this == GLOBAL_VARIABLE_PREDECLARATION && kind == GLOBAL_VARIABLE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolKind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameLowercase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameUppercase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolKind";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSame";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

