/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.DisposableIcon;
import com.jetbrains.cidr.lang.symbols.OCAttributes;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCSymbol
extends OCTypeOwner,
Serializable,
DeepEqual.Equality,
PsiElementNavigationItem,
Comparable {
    @NlsSafe
    public static final String UNNAMED = "<unnamed>";
    public static final Condition<OCSymbol> NON_PREDEFINITION_CONDITION = symbol -> !symbol.isPredeclaration();
    public static final Condition<OCSymbol> NON_FANTOM_SYMBOL_CONDITION = symbol -> symbol.getContainingFile() != null || symbol.getOffset() != 0;
    public static final Comparator<OCSymbol> PRESENTABLE_NAME_COMPARATOR = Comparator.comparing(OCSymbol::getPresentableName);
    public static final String ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE = "\"not available in automatic reference counting mode\"";

    @NotNull
    @NlsSafe
    public String getName();

    @Nullable
    public VirtualFile getContainingFile();

    @NotNull
    default public Class<? extends PsiElement> getPsiElementClass() {
        Class<? extends PsiElement> clazz = this.getKind().getPsiElementClass();
        if (clazz == null) {
            OCSymbol.$$$reportNull$$$0(0);
        }
        return clazz;
    }

    @Nullable
    public PsiElement locateDefinition(@NotNull Project var1);

    @NotNull
    public OCSymbolKind getKind();

    public long getComplexOffset();

    public int hashCodeExcludingOffset();

    @NotNull
    default public OCType getType() {
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            OCSymbol.$$$reportNull$$$0(1);
        }
        return oCUnknownType;
    }

    @Override
    @NotNull
    default public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbol.$$$reportNull$$$0(2);
        }
        OCType oCType = this.getType().resolve(context);
        if (oCType == null) {
            OCSymbol.$$$reportNull$$$0(3);
        }
        return oCType;
    }

    default public OCType getResolvedType(@NotNull OCResolveContext context, boolean ignoringImports) {
        if (context == null) {
            OCSymbol.$$$reportNull$$$0(4);
        }
        return this.getType().resolve(context, ignoringImports);
    }

    public boolean isGlobal();

    default public boolean isCallable() {
        return this.getKind().isCallable();
    }

    default public boolean isDefinition() {
        return !this.isPredeclaration();
    }

    @Contract(pure=true)
    default public boolean isPredeclaration() {
        return this.getKind().isPredeclaration();
    }

    @NotNull
    default public List<String> getAttributes() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            OCSymbol.$$$reportNull$$$0(5);
        }
        return list;
    }

    default public boolean isUnnamed() {
        return UNNAMED.equals(this.getName());
    }

    default public void compact() {
    }

    @NotNull
    default public String getSignature(@NotNull Project project) {
        if (project == null) {
            OCSymbol.$$$reportNull$$$0(6);
        }
        String string = this.getPresentableName();
        if (string == null) {
            OCSymbol.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    default public String getPresentableName() {
        String string = this.getName();
        if (string == null) {
            OCSymbol.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    default public String getLocationString() {
        VirtualFile file = this.getContainingFile();
        if (file != null) {
            return file.getName();
        }
        return null;
    }

    default public boolean isSynthetic() {
        return false;
    }

    @NotNull
    @Nls
    default public String getNameWithKindLowercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbol.$$$reportNull$$$0(9);
        }
        String string = this.getKindLowercase(context) + " '" + this.getPresentableName() + "'";
        if (string == null) {
            OCSymbol.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    @Nls
    default public String getNameWithKindUppercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbol.$$$reportNull$$$0(11);
        }
        String string = this.getKindUppercase(context) + " '" + this.getPresentableName() + "'";
        if (string == null) {
            OCSymbol.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nls
    default public String getKindLowercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbol.$$$reportNull$$$0(13);
        }
        return StringUtil.decapitalize((String)this.getKindUppercase(context));
    }

    @NotNull
    @Nls
    default public String getKindUppercase(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbol.$$$reportNull$$$0(14);
        }
        String string = this.getKind().getNameUppercase();
        if (string == null) {
            OCSymbol.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    default public OCSymbol getDefinitionSymbol(@NotNull Project project) {
        if (project == null) {
            OCSymbol.$$$reportNull$$$0(16);
        }
        if (this.isPredeclaration()) {
            return OCSymbolBase.findSymbolDefinition(this.getName(), this.getKind(), project, this.getContainingFile());
        }
        return this;
    }

    default public boolean processAssociatedSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project) {
        OCSymbol associatedSymbol;
        if (processor2 == null) {
            OCSymbol.$$$reportNull$$$0(17);
        }
        if (project == null) {
            OCSymbol.$$$reportNull$$$0(18);
        }
        return (associatedSymbol = this.getAssociatedSymbol(project)) == null || processor2.process((Object)associatedSymbol);
    }

    @Nullable
    default public OCSymbol getAssociatedSymbol(@NotNull Project project) {
        if (project == null) {
            OCSymbol.$$$reportNull$$$0(19);
        }
        return null;
    }

    default public boolean processSameSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project) {
        if (processor2 == null) {
            OCSymbol.$$$reportNull$$$0(20);
        }
        if (project == null) {
            OCSymbol.$$$reportNull$$$0(21);
        }
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, (Processor<? super OCSymbol>)((Processor)symbol -> symbol.getClass() != this.getClass() || processor2.process(symbol)), this.getName());
    }

    @Nullable
    default public PsiFile getContainingPsiFile(@NotNull Project project) {
        VirtualFile containingFile;
        if (project == null) {
            OCSymbol.$$$reportNull$$$0(22);
        }
        if ((containingFile = this.getContainingFile()) == null || !containingFile.isValid()) {
            return null;
        }
        return OCLanguageUtils.tryGetOCFile(OCLanguageUtils.asPsiFile(containingFile, project));
    }

    @Nullable
    default public OCFile getContainingOCFile(@NotNull Project project) {
        if (project == null) {
            OCSymbol.$$$reportNull$$$0(23);
        }
        PsiFile file = this.getContainingPsiFile(project);
        return OCLanguageUtils.asOCFile(file);
    }

    default public int getOffset() {
        return OCSymbolOffsetUtil.getTextOffset(this.getComplexOffset());
    }

    default public void setComplexOffset(long complexOffset) {
    }

    @Nullable
    default public ComplexTextRange getScope() {
        return null;
    }

    default public void setScope(@NotNull ComplexTextRange scope) {
        if (scope == null) {
            OCSymbol.$$$reportNull$$$0(24);
        }
    }

    default public void updateOffset(int start, int lengthShift) {
        if (this.getOffset() > start) {
            this.setComplexOffset(OCSymbolOffsetUtil.shift(this.getComplexOffset(), lengthShift));
        }
        if (this.getScope() != null) {
            this.setScope(OCSymbolOffsetUtil.shift(this.getScope(), start, lengthShift));
        }
    }

    @Nullable
    default public Icon getIcon(@NotNull Project project) {
        if (project == null) {
            OCSymbol.$$$reportNull$$$0(25);
        }
        if (Registry.is((String)"psi.deferIconLoading")) {
            return DisposableIcon.create(this, project);
        }
        return this.computeFullIconNow(null, project);
    }

    @Nullable
    default public Icon getBaseIcon() {
        return this.getKind().getIcon();
    }

    @Nullable
    default public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project) {
        if (project == null) {
            OCSymbol.$$$reportNull$$$0(26);
        }
        return this.getBaseIcon();
    }

    default public boolean isSameSymbol(@Nullable OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCSymbol.$$$reportNull$$$0(27);
        }
        return this.equals(symbol);
    }

    @NotNull
    default public OCType getEffectiveType(@NotNull Project project) {
        if (project == null) {
            OCSymbol.$$$reportNull$$$0(28);
        }
        OCType oCType = this.getType();
        if (oCType == null) {
            OCSymbol.$$$reportNull$$$0(29);
        }
        return oCType;
    }

    @NotNull
    default public OCType getEffectiveResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCSymbol.$$$reportNull$$$0(30);
        }
        OCType oCType = this.getResolvedType(context);
        if (oCType == null) {
            OCSymbol.$$$reportNull$$$0(31);
        }
        return oCType;
    }

    default public boolean isDeprecated() {
        return this.hasAttribute("deprecated");
    }

    @NotNull
    default public String getDeprecatedMessage(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbol.$$$reportNull$$$0(32);
        }
        String message = this.getNameWithKindUppercase(context) + " is deprecated";
        String parameters = this.getAttributeParameters("deprecated");
        String string = parameters != null ? message + ": " + StringUtil.unquoteString((String)parameters) : message;
        if (string == null) {
            OCSymbol.$$$reportNull$$$0(33);
        }
        return string;
    }

    default public boolean isUnavailable() {
        return this.hasAttribute("unavailable") && !ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE.equals(this.getAttributeParameters("unavailable"));
    }

    default public boolean isUnused() {
        return this.hasAttribute("unused") || this.hasAttribute("used") || this.hasAttribute("maybe_unused") || this.hasAttribute("constructor") || this.hasAttribute("destructor");
    }

    @NotNull
    default public String getUnavailableMessage(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCSymbol.$$$reportNull$$$0(34);
        }
        String message = this.getNameWithKindUppercase(context) + " is unavailable";
        String parameters = this.getAttributeParameters("unavailable");
        String string = parameters != null ? message + ": " + StringUtil.unquoteString((String)parameters) : message;
        if (string == null) {
            OCSymbol.$$$reportNull$$$0(35);
        }
        return string;
    }

    default public boolean isForbiddenByARC(@NotNull PsiElement context) {
        if (context == null) {
            OCSymbol.$$$reportNull$$$0(36);
        }
        return this.hasAttribute("unavailable") && ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE.equals(this.getAttributeParameters("unavailable")) && OCCompilerFeaturesHelper.isArcEnabled(context.getContainingFile());
    }

    default public boolean isTransparentUnion() {
        return this.hasAttribute("transparent_union");
    }

    default public boolean hasAttribute(@NonNls @NotNull String attribute) {
        if (attribute == null) {
            OCSymbol.$$$reportNull$$$0(37);
        }
        return OCAttributes.hasAttribute(this.getAttributes(), (String)attribute);
    }

    @Nullable
    @NlsSafe
    default public String getAttributeParameters(@NotNull String attribute) {
        if (attribute == null) {
            OCSymbol.$$$reportNull$$$0(38);
        }
        return OCAttributes.getAttributeParameter(this.getAttributes(), (String)attribute);
    }

    @NotNull
    default public OCSymbol getDelegate() {
        OCSymbol oCSymbol = this;
        if (oCSymbol == null) {
            OCSymbol.$$$reportNull$$$0(39);
        }
        return oCSymbol;
    }

    @NotNull
    default public String getPresentableText() {
        String string = this.getPresentableName();
        if (string == null) {
            OCSymbol.$$$reportNull$$$0(40);
        }
        return string;
    }

    @Deprecated
    @Nullable
    default public PsiElement getTargetElement() {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    @Nullable
    default public ItemPresentation getPresentation() {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    default public void navigate(boolean requestFocus) {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    default public boolean canNavigate() {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    default public boolean canNavigateToSource() {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    default public int compareTo(@NotNull Object o) {
        if (o == null) {
            OCSymbol.$$$reportNull$$$0(41);
        }
        throw new UnsupportedOperationException("Please provide an external comparator to wherever it's used");
    }

    @NotNull
    default public Language getLanguage() {
        throw new UnsupportedOperationException("Symbol: " + this.getClass().getName() + " does not yet define what language it is defined in");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 6, 9, 11, 13, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 32, 34, 36, 37, 38, 41 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbol";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 30: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbol";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithKindLowercase";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithKindUppercase";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindUppercase";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveType";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveResolvedType";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeprecatedMessage";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnavailableMessage";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithKindLowercase";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithKindUppercase";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getKindLowercase";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getKindUppercase";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionSymbol";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processAssociatedSymbols";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedSymbol";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processSameSymbols";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getContainingPsiFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContainingOCFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setScope";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "computeFullIconNow";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isSameSymbol";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveResolvedType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedMessage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getUnavailableMessage";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isForbiddenByARC";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeParameters";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 6, 9, 11, 13, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 32, 34, 36, 37, 38, 41 -> new IllegalArgumentException(string);
        };
    }
}

