/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.preprocessor.OCFileActiveConfigurationCache;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceRunConfigurationListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBestSymbolInSelectedConfiguration<T extends OCSymbol>
implements Condition<T>,
Processor<T> {
    @Nullable
    private final OCResolveConfiguration mySelectedConfiguration;
    @Nullable
    private final VirtualFile myContainingFile;
    @NotNull
    private final OCWorkspace myWorkspace;
    private int myBestScore;
    @Nullable
    private T myBestCandidate;

    public OCBestSymbolInSelectedConfiguration(@NotNull Project project, @Nullable VirtualFile containingFile) {
        if (project == null) {
            OCBestSymbolInSelectedConfiguration.$$$reportNull$$$0(0);
        }
        this.myBestScore = -1;
        this.myWorkspace = OCWorkspace.getInstance((Project)project);
        this.mySelectedConfiguration = containingFile == null ? OCWorkspaceRunConfigurationListener.getSelectedResolveConfiguration((Project)project) : OCFileActiveConfigurationCache.getActiveConfiguration(containingFile, project);
        this.myContainingFile = containingFile;
        this.myBestCandidate = null;
    }

    public boolean value(@NotNull T symbol) {
        boolean inSelectedConfiguration;
        if (symbol == null) {
            OCBestSymbolInSelectedConfiguration.$$$reportNull$$$0(1);
        }
        VirtualFile vtCandidate = symbol.getContainingFile();
        int scope = OCBestSymbolInSelectedConfiguration.getScore(this.myContainingFile, vtCandidate);
        boolean bl = inSelectedConfiguration = vtCandidate != null && this.mySelectedConfiguration != null && this.myWorkspace.getConfigurationsForFile(vtCandidate).contains(this.mySelectedConfiguration);
        if (scope >= this.myBestScore || inSelectedConfiguration) {
            this.myBestScore = scope;
            this.myBestCandidate = symbol;
        }
        return inSelectedConfiguration;
    }

    public boolean process(@NotNull T symbol) {
        if (symbol == null) {
            OCBestSymbolInSelectedConfiguration.$$$reportNull$$$0(2);
        }
        return !this.value(symbol);
    }

    private static int getScore(@Nullable VirtualFile base, @Nullable VirtualFile candidate) {
        int scope;
        if (base == null || candidate == null) {
            return 0;
        }
        String basePath = base.getPath();
        String candidatePath = candidate.getPath();
        int maxScope = Integer.min(basePath.length(), candidatePath.length());
        for (scope = 0; scope < maxScope && basePath.charAt(scope) == candidatePath.charAt(scope); ++scope) {
        }
        if (base.getNameWithoutExtension().equals(candidate.getNameWithoutExtension())) {
            scope *= 10;
        }
        return scope;
    }

    @Nullable
    public T getBestCandidate() {
        return this.myBestCandidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCBestSymbolInSelectedConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "value";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

