/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.CommonBundle;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.cellvalidators.ValidationUtils;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.settings.NamingConventionRule;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamingConventionRulesTable
extends ListTableWithButtons<NamingConventionRule> {
    private static final ColumnInfo<NamingConventionRule, EnumSet<NamingConventionRule.EntityKind>> ENTITY_KIND_COLUMN = new ColumnInfo<NamingConventionRule, EnumSet<NamingConventionRule.EntityKind>>(OCBundle.message("naming.convention.entity.kind", new Object[0])){

        public EnumSet<NamingConventionRule.EntityKind> valueOf(NamingConventionRule rule) {
            return rule.getEntityKind();
        }

        public TableCellRenderer getRenderer(NamingConventionRule rule) {
            return new CheckboxListTableCellRenderer(rule.getEntityKind(), (Enum[])NamingConventionRule.EntityKind.values(), (Enum)NamingConventionRule.EntityKind.ANY);
        }

        public TableCellEditor getEditor(NamingConventionRule rule) {
            return new CheckboxListTableCellRenderer(rule.getEntityKind(), (Enum[])NamingConventionRule.EntityKind.values(), (Enum)NamingConventionRule.EntityKind.ANY);
        }

        public boolean isCellEditable(NamingConventionRule rule) {
            return true;
        }

        public void setValue(NamingConventionRule rule, EnumSet<NamingConventionRule.EntityKind> entityKind) {
            rule.setEntityKind(entityKind);
        }

        public int getAdditionalWidth() {
            return OCNamingConventionRulesTable.getAdditionalTableCellWidth();
        }
    };
    private static final ColumnInfo<NamingConventionRule, NamingConventionStyle> NAMING_CONVENTION_STYLE_COLUMN = new ColumnInfo<NamingConventionRule, NamingConventionStyle>(OCBundle.message("naming.convention.title", new Object[0])){

        public NamingConventionStyle valueOf(NamingConventionRule rule) {
            return rule.getNamingConventionStyle();
        }

        public TableCellRenderer getRenderer(NamingConventionRule rule) {
            return new MyComboBoxTableRenderer<NamingConventionStyle>(new NamingConventionStyle[]{rule.getNamingConventionStyle()});
        }

        public TableCellEditor getEditor(NamingConventionRule rule) {
            return new MyComboBoxTableRenderer<NamingConventionStyle>((NamingConventionStyle[])Arrays.stream(NamingConventionStyle.values()).filter(s -> s != NamingConventionStyle.LISP_CASE).toArray(NamingConventionStyle[]::new));
        }

        public boolean isCellEditable(NamingConventionRule rule) {
            return true;
        }

        public void setValue(NamingConventionRule rule, NamingConventionStyle namingConventionStyle) {
            rule.setNamingConventionStyle(namingConventionStyle);
        }

        public int getAdditionalWidth() {
            return OCNamingConventionRulesTable.getAdditionalTableCellWidth();
        }
    };
    private static final ColumnInfo<NamingConventionRule, EnumSet<NamingConventionRule.Visibility>> VISIBILITY_COLUMN = new ColumnInfo<NamingConventionRule, EnumSet<NamingConventionRule.Visibility>>(OCBundle.message("naming.convention.visibility", new Object[0])){

        public EnumSet<NamingConventionRule.Visibility> valueOf(NamingConventionRule rule) {
            return rule.isVisibilityApplicable() ? rule.getVisibility() : null;
        }

        public TableCellRenderer getRenderer(NamingConventionRule rule) {
            return rule.isVisibilityApplicable() ? new CheckboxListTableCellRenderer(rule.getVisibility(), (Enum[])NamingConventionRule.Visibility.values(), (Enum)NamingConventionRule.Visibility.ANY) : null;
        }

        public TableCellEditor getEditor(NamingConventionRule rule) {
            return rule.isVisibilityApplicable() ? new CheckboxListTableCellRenderer(rule.getVisibility(), (Enum[])NamingConventionRule.Visibility.values(), (Enum)NamingConventionRule.Visibility.ANY) : null;
        }

        public boolean isCellEditable(NamingConventionRule rule) {
            return rule.isVisibilityApplicable();
        }

        public void setValue(NamingConventionRule rule, EnumSet<NamingConventionRule.Visibility> visibility) {
            rule.setVisibility(visibility);
        }

        public int getAdditionalWidth() {
            return OCNamingConventionRulesTable.getAdditionalTableCellWidth();
        }
    };
    private static final ColumnInfo<NamingConventionRule, EnumSet<NamingConventionRule.Specifier>> SPECIFIER_COLUMN = new ColumnInfo<NamingConventionRule, EnumSet<NamingConventionRule.Specifier>>(OCBundle.message("naming.convention.specifier", new Object[0])){

        public EnumSet<NamingConventionRule.Specifier> valueOf(NamingConventionRule rule) {
            return rule.isSpecifierApplicable() ? rule.getSpecifier() : null;
        }

        public TableCellRenderer getRenderer(NamingConventionRule rule) {
            return rule.isSpecifierApplicable() ? new CheckboxListTableCellRenderer(rule.getSpecifier(), (Enum[])NamingConventionRule.Specifier.values(), (Enum)NamingConventionRule.Specifier.ANY) : null;
        }

        public TableCellEditor getEditor(NamingConventionRule rule) {
            return rule.isSpecifierApplicable() ? new CheckboxListTableCellRenderer(rule.getSpecifier(), (Enum[])NamingConventionRule.Specifier.values(), (Enum)NamingConventionRule.Specifier.ANY) : null;
        }

        public boolean isCellEditable(NamingConventionRule rule) {
            return rule.isSpecifierApplicable();
        }

        public void setValue(NamingConventionRule rule, EnumSet<NamingConventionRule.Specifier> specifier) {
            rule.setSpecifier(specifier);
        }

        public int getAdditionalWidth() {
            return OCNamingConventionRulesTable.getAdditionalTableCellWidth();
        }
    };
    private static final ColumnInfo<NamingConventionRule, String> PREFIX_COLUMN = new ColumnInfo<NamingConventionRule, String>(OCBundle.message("naming.convention.prefix", new Object[0])){

        public String valueOf(NamingConventionRule rule) {
            return rule.getCustomPrefix();
        }

        public TableCellRenderer getRenderer(NamingConventionRule rule) {
            return new DefaultTableCellRenderer();
        }

        public TableCellEditor getEditor(NamingConventionRule rule) {
            return OCNamingConventionRulesTable.getDisposableTextFieldEditor(true);
        }

        public boolean isCellEditable(NamingConventionRule rule) {
            return true;
        }

        public void setValue(NamingConventionRule rule, String prefix) {
            if (StringUtil.isEmpty((String)OCNamingConventionRulesTable.validateTextField(prefix, true))) {
                rule.setCustomPrefix(prefix);
            }
        }

        public int getAdditionalWidth() {
            return OCNamingConventionRulesTable.getAdditionalTableCellWidth();
        }
    };
    private static final ColumnInfo<NamingConventionRule, String> SUFFIX_COLUMN = new ColumnInfo<NamingConventionRule, String>(OCBundle.message("naming.convention.suffix", new Object[0])){

        public String valueOf(NamingConventionRule rule) {
            return rule.getCustomSuffix();
        }

        public TableCellRenderer getRenderer(NamingConventionRule rule) {
            return new DefaultTableCellRenderer();
        }

        public TableCellEditor getEditor(NamingConventionRule rule) {
            return OCNamingConventionRulesTable.getDisposableTextFieldEditor(false);
        }

        public boolean isCellEditable(NamingConventionRule rule) {
            return true;
        }

        public void setValue(NamingConventionRule rule, String suffix) {
            if (StringUtil.isEmpty((String)OCNamingConventionRulesTable.validateTextField(suffix, false))) {
                rule.setCustomSuffix(suffix);
            }
        }

        public int getAdditionalWidth() {
            return OCNamingConventionRulesTable.getAdditionalTableCellWidth();
        }
    };

    public List<NamingConventionRule> getRules() {
        return NamingConventionRule.copyRules(this.getElements());
    }

    public boolean isModified(@NotNull OCCodeStyleSettings settings) {
        if (settings == null) {
            OCNamingConventionRulesTable.$$$reportNull$$$0(0);
        }
        return !settings.NAMING_CONVENTION_RULES.equals(this.getRules());
    }

    public void apply(@NotNull OCCodeStyleSettings settings) {
        if (settings == null) {
            OCNamingConventionRulesTable.$$$reportNull$$$0(1);
        }
        settings.NAMING_CONVENTION_RULES = this.getRules();
    }

    public void reset(@NotNull OCCodeStyleSettings settings) {
        if (settings == null) {
            OCNamingConventionRulesTable.$$$reportNull$$$0(2);
        }
        this.setValues(NamingConventionRule.copyRules(settings.NAMING_CONVENTION_RULES));
    }

    @Nullable
    protected AnActionButtonRunnable createAddAction() {
        return button -> {
            ListPopup<NamingConventionRule.EntityKind> popup = new ListPopup<NamingConventionRule.EntityKind>(EnumSet.noneOf(NamingConventionRule.EntityKind.class), NamingConventionRule.EntityKind.values(), NamingConventionRule.EntityKind.ANY){

                @Override
                public void onAddAction() {
                    OCNamingConventionRulesTable.this.addNewElement(new NamingConventionRule(EnumSet.copyOf(this.getSelectedPopupValues()), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.CAMEL_CASE, ""));
                }
            };
            popup.showPopup(button.getContextComponent());
        };
    }

    protected ListTableModel<NamingConventionRule> createListModel() {
        return new ListTableModel(new ColumnInfo[]{ENTITY_KIND_COLUMN, NAMING_CONVENTION_STYLE_COLUMN, VISIBILITY_COLUMN, SPECIFIER_COLUMN, PREFIX_COLUMN, SUFFIX_COLUMN});
    }

    protected NamingConventionRule createElement() {
        return new NamingConventionRule(NamingConventionRule.EntityKind.ANY, NamingConventionRule.Visibility.ANY, NamingConventionRule.Specifier.ANY, "", NamingConventionStyle.CAMEL_CASE, "");
    }

    protected boolean isEmpty(NamingConventionRule element) {
        return false;
    }

    protected NamingConventionRule cloneElement(NamingConventionRule variable) {
        return new NamingConventionRule(variable);
    }

    protected boolean canDeleteElement(NamingConventionRule selection) {
        return true;
    }

    protected ToolbarDecorator createToolbarDecorator() {
        return super.createToolbarDecorator().setToolbarPosition(ActionToolbarPosition.BOTTOM);
    }

    protected AnAction @NotNull [] createExtraToolbarActions() {
        AnAction[] anActionArray = new AnAction[]{this.createRuleDuplicationAction()};
        if (anActionArray == null) {
            OCNamingConventionRulesTable.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    protected boolean isUpDownSupported() {
        return true;
    }

    protected boolean shouldEditRowOnCreation() {
        return false;
    }

    @NotNull
    private AnAction createRuleDuplicationAction() {
        DumbAwareAction action = new DumbAwareAction(IdeBundle.message((String)"button.copy", (Object[])new Object[0]), null, AllIcons.Actions.Copy){

            public boolean isDumbAware() {
                return true;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                for (NamingConventionRule selectedRule : OCNamingConventionRulesTable.this.getSelection()) {
                    OCNamingConventionRulesTable.this.addNewElement(new NamingConventionRule(selectedRule));
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(!OCNamingConventionRulesTable.this.getSelection().isEmpty());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    8.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/settings/OCNamingConventionRulesTable$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/settings/OCNamingConventionRulesTable$8";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        action.setShortcutSet(CommonShortcuts.getDuplicate());
        DumbAwareAction dumbAwareAction = action;
        if (dumbAwareAction == null) {
            OCNamingConventionRulesTable.$$$reportNull$$$0(4);
        }
        return dumbAwareAction;
    }

    private static void installValidator(boolean isPrefix, @NotNull ExtendableTextField textField, @NotNull Disposable disposable) {
        if (textField == null) {
            OCNamingConventionRulesTable.$$$reportNull$$$0(5);
        }
        if (disposable == null) {
            OCNamingConventionRulesTable.$$$reportNull$$$0(6);
        }
        new ComponentValidator(disposable).withValidator(() -> {
            String text = textField.getText();
            String errorMessage = OCNamingConventionRulesTable.validateTextField(text, isPrefix);
            boolean hasError = StringUtil.isNotEmpty((String)errorMessage);
            ValidationUtils.setExtension((ExtendableTextComponent)textField, (ExtendableTextComponent.Extension)ValidationUtils.ERROR_EXTENSION, (boolean)hasError);
            return hasError ? new ValidationInfo(errorMessage, (JComponent)textField) : null;
        }).andRegisterOnDocumentListener((JTextComponent)textField).installOn((JComponent)textField);
    }

    @NlsContexts.HintText
    private static String validateTextField(@NotNull String text, boolean isPrefix) {
        if (text == null) {
            OCNamingConventionRulesTable.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)text)) {
            return null;
        }
        @NlsContexts.HintText String errorMessage = null;
        if (isPrefix && !Character.isLetter(text.charAt(0)) && text.charAt(0) != '_') {
            errorMessage = OCBundle.message("settings.prefix.must.start.with.letter.or.symbol", new Object[0]);
        }
        if (StringUtil.isEmpty(errorMessage) && !text.chars().allMatch(c -> Character.isLetterOrDigit(c) || c == 95)) {
            errorMessage = OCBundle.message("settings.hint.choice.prefix.suffix.must.contain.only.letters.or.digits.or.symbols", isPrefix ? 0 : 1);
        }
        return errorMessage;
    }

    private static int getAdditionalTableCellWidth() {
        return JBUIScale.scale((int)12) + AllIcons.General.ArrowDown.getIconWidth();
    }

    private static DefaultCellEditor getDisposableTextFieldEditor(boolean isPrefix) {
        final Disposable disposable = Disposer.newDisposable();
        ExtendableTextField cellEditor = new ExtendableTextField(){

            public void removeNotify() {
                super.removeNotify();
                Disposer.dispose((Disposable)disposable);
            }
        };
        cellEditor.putClientProperty((Object)"JComponent.compactHeight", (Object)Boolean.TRUE);
        OCNamingConventionRulesTable.installValidator(isPrefix, cellEditor, disposable);
        return new DefaultCellEditor((JTextField)cellEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/settings/OCNamingConventionRulesTable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/settings/OCNamingConventionRulesTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtraToolbarActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRuleDuplicationAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installValidator";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateTextField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static abstract class ListPopup<T extends Enum<T>> {
        @NotNull
        private EnumSet<T> mySelectedValues;
        private final T @NotNull [] myAllValues;
        @NotNull
        private final T myDefaultValue;
        private WeakReference<JBPopup> myPopupRef;

        ListPopup(@NotNull EnumSet<T> selectedValues, T @NotNull [] allValues, @NotNull T defaultValue) {
            if (selectedValues == null) {
                ListPopup.$$$reportNull$$$0(0);
            }
            if (defaultValue == null) {
                ListPopup.$$$reportNull$$$0(1);
            }
            if (allValues == null) {
                ListPopup.$$$reportNull$$$0(2);
            }
            this.mySelectedValues = selectedValues;
            this.myAllValues = allValues;
            this.myDefaultValue = defaultValue;
        }

        public abstract void onAddAction();

        public void showPopup(@NotNull Component targetComponent) {
            if (targetComponent == null) {
                ListPopup.$$$reportNull$$$0(3);
            }
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            final HashMap<T, JBCheckBox> selectedValuesMap = new HashMap<T, JBCheckBox>();
            final ArrayList<Object> components = new ArrayList<Object>();
            for (T value : this.myAllValues) {
                if (((Enum)value).equals(this.myDefaultValue)) continue;
                JBCheckBox checkBox = new JBCheckBox(((NamingConventionRule.TextPresentableEnum)value).toPresentableText(), this.mySelectedValues.contains(value));
                panel.add((Component)checkBox);
                components.add(checkBox);
                selectedValuesMap.put(value, checkBox);
            }
            JButton addButton = new JButton(CommonBundle.message((String)"button.add", (Object[])new Object[0]));
            components.add(addButton);
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List selectedValues = selectedValuesMap.entrySet().stream().filter(entry -> ((JCheckBox)entry.getValue()).isSelected()).map(entry -> (Enum)entry.getKey()).collect(Collectors.toList());
                    mySelectedValues = selectedValues.isEmpty() ? EnumSet.of(myDefaultValue) : EnumSet.copyOf(selectedValues);
                    this.onAddAction();
                    this.hidePopup();
                }
            });
            panel.add(addButton);
            panel.setFocusTraversalKeysEnabled(true);
            panel.setFocusCycleRoot(true);
            panel.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    ((Component)components.get(0)).requestFocus();
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
            panel.setFocusTraversalPolicy((FocusTraversalPolicy)new ComponentsListFocusTraversalPolicy(){

                @NotNull
                protected List<Component> getOrderedComponents() {
                    List list = components;
                    if (list == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCNamingConventionRulesTable$ListPopup$3", "getOrderedComponents"));
                }
            });
            panel.requestFocusInWindow();
            JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)panel).setFocusable(true).setRequestFocus(true).createPopup();
            this.myPopupRef = new WeakReference<JBPopup>(popup);
            popup.showUnderneathOf(targetComponent);
        }

        public void hidePopup() {
            if (this.myPopupRef != null) {
                JBPopup popup = (JBPopup)this.myPopupRef.get();
                if (popup != null && popup.isVisible()) {
                    popup.cancel();
                }
                this.myPopupRef = null;
            }
        }

        @NotNull
        public EnumSet<T> getSelectedPopupValues() {
            EnumSet<T> enumSet = this.mySelectedValues;
            if (enumSet == null) {
                ListPopup.$$$reportNull$$$0(4);
            }
            return enumSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedValues";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allValues";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetComponent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/settings/OCNamingConventionRulesTable$ListPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/settings/OCNamingConventionRulesTable$ListPopup";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedPopupValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "showPopup";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyComboBoxTableRenderer<T>
    extends ComboBoxTableRenderer<T> {
        MyComboBoxTableRenderer(T[] values) {
            super((Object[])values);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBorder(hasFocus ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.cellNoFocusBorder"));
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.setBorder(UIManager.getBorder("Table.focusSelectedCellHighlightBorder"));
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private static class CheckboxListTableCellRenderer<T extends Enum<T>>
    extends JLabel
    implements TableCellRenderer,
    TableCellEditor,
    JBPopupListener {
        @NotNull
        private EnumSet<T> mySelectedValues;
        private final T @NotNull [] myAllValues;
        @NotNull
        private final T myDefaultValue;
        @Nullable
        private WeakReference<ListPopup> myPopupRef;
        @Nullable
        private ChangeEvent myChangeEvent;
        @NotNull
        private final EventListenerList myListenerList;

        CheckboxListTableCellRenderer(@NotNull EnumSet<T> selectedValues, T @NotNull [] allValues, @NotNull T defaultValue) {
            if (selectedValues == null) {
                CheckboxListTableCellRenderer.$$$reportNull$$$0(0);
            }
            if (defaultValue == null) {
                CheckboxListTableCellRenderer.$$$reportNull$$$0(1);
            }
            if (allValues == null) {
                CheckboxListTableCellRenderer.$$$reportNull$$$0(2);
            }
            this.myChangeEvent = null;
            this.myListenerList = new EventListenerList();
            this.mySelectedValues = selectedValues;
            this.myAllValues = allValues;
            this.myDefaultValue = defaultValue;
            this.setFont(UIUtil.getButtonFont());
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.customizeComponent((EnumSet)value, table, isSelected, hasFocus);
            return this;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            EnumSet typedValue = (EnumSet)value;
            this.customizeComponent(typedValue, table, isSelected, true);
            ApplicationManager.getApplication().invokeLater(() -> this.showPopup(typedValue));
            return this;
        }

        private void customizeComponent(EnumSet<T> selectedValues, JTable table, boolean isSelected, boolean hasFocus) {
            this.setOpaque(true);
            @NlsSafe String valueText = selectedValues.stream().map(v -> ((NamingConventionRule.TextPresentableEnum)((Object)v)).toPresentableText()).collect(Collectors.joining(", "));
            this.setText(valueText);
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.setBorder(hasFocus ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.cellNoFocusBorder"));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!StringUtil.isEmpty((String)this.getText())) {
                Rectangle r = this.getBounds();
                Insets i = this.getInsets();
                int x = r.width - i.right - AllIcons.General.ArrowDown.getIconWidth();
                int y = i.top + (r.height - i.top - i.bottom - AllIcons.General.ArrowDown.getIconHeight()) / 2;
                AllIcons.General.ArrowDown.paintIcon(this, g, x, y);
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.mySelectedValues;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            this.hidePopup();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
            this.hidePopup();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.myListenerList.add(CellEditorListener.class, l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.myListenerList.remove(CellEditorListener.class, l);
        }

        private void fireEditingStopped() {
            Object[] listeners = this.myListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                if (this.myChangeEvent == null) {
                    this.myChangeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.myChangeEvent);
            }
        }

        private void fireEditingCanceled() {
            Object[] listeners = this.myListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != CellEditorListener.class) continue;
                if (this.myChangeEvent == null) {
                    this.myChangeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.myChangeEvent);
            }
        }

        protected void showPopup(EnumSet<T> selectedValues) {
            ListPopup popup = new ListPopup<T>(selectedValues, (Enum[])this.myAllValues, (Enum)this.myDefaultValue){

                @Override
                public void onAddAction() {
                    mySelectedValues = this.getSelectedPopupValues();
                    this.stopCellEditing();
                }
            };
            this.myPopupRef = new WeakReference<1>(popup);
            popup.showPopup(this);
        }

        private void hidePopup() {
            ListPopup popup;
            if (this.myPopupRef != null && (popup = (ListPopup)this.myPopupRef.get()) != null) {
                popup.hidePopup();
            }
            this.myPopupRef = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "selectedValues";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "allValues";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/settings/OCNamingConventionRulesTable$CheckboxListTableCellRenderer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

