/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.ClassicSlowOpsKt;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.navigation.OCSymbolPresentation;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

@Deprecated(forRemoval=true)
public class OCSearchEverywhereCellRenderer
extends OpaquePanel
implements ListCellRenderer {
    private int myRightRendererWidth = 0;

    public OCSearchEverywhereCellRenderer() {
        super((LayoutManager)new BorderLayout());
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.removeAll();
        boolean hasRightRenderer = UISettings.getInstance().getShowIconInQuickNavigation();
        ModuleRendererFactory factory = ModuleRendererFactory.findInstance((Object)value);
        LeftRenderer left = new LeftRenderer(true, MatcherHolder.getAssociatedMatcher((JComponent)list));
        Component leftCellRendererComponent = left.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        Color listBg = leftCellRendererComponent.getBackground();
        this.add(leftCellRendererComponent, "West");
        this.setBackground(isSelected ? UIUtil.getListSelectionBackground((boolean)true) : listBg);
        this.myRightRendererWidth = 0;
        if (hasRightRenderer) {
            DefaultListCellRenderer moduleRenderer = factory.getModuleRenderer();
            Component rightCellRendererComponent = moduleRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ((JComponent)rightCellRendererComponent).setOpaque(false);
            rightCellRendererComponent.setBackground(listBg);
            this.add(rightCellRendererComponent, "East");
            NonOpaquePanel spacer = new NonOpaquePanel();
            Dimension size = rightCellRendererComponent.getSize();
            spacer.setSize(new Dimension((int)((double)size.width * 0.015 + (double)leftCellRendererComponent.getSize().width * 0.015), size.height));
            spacer.setBackground(isSelected ? UIUtil.getListSelectionBackground((boolean)true) : listBg);
            this.add((Component)spacer, "Center");
            this.myRightRendererWidth = rightCellRendererComponent.getPreferredSize().width + spacer.getPreferredSize().width;
        }
        return this;
    }

    @NlsSafe
    private static String trimSymbolContainerLength(String name, OCSymbolPresentation presentation, JList list, int rightComponentWidth) {
        String right;
        boolean in;
        OCSymbol symbol = presentation.getSymbol();
        if (OCSearchEverywhereCellRenderer.isTopLevelSymbol(symbol)) {
            return null;
        }
        String text = presentation.getLocationString();
        if (list.getWidth() == 0) {
            return text;
        }
        if (text == null) {
            return null;
        }
        if (text.startsWith("(") && text.endsWith(")")) {
            text = text.substring(1, text.length() - 1);
        }
        if (in = text.startsWith("in ")) {
            text = text.substring(3);
        }
        FontMetrics fm = list.getFontMetrics(list.getFont());
        int maxWidth = list.getWidth() - fm.stringWidth(name) - 16 - rightComponentWidth - 20;
        String left = in ? "(in " : "(";
        String adjustedText = left + text + (right = ")");
        int fullWidth = fm.stringWidth(adjustedText);
        if (fullWidth < maxWidth) {
            return adjustedText;
        }
        String separator = text.contains("/") ? "/" : (SystemInfo.isWindows && text.contains("\\") ? "\\" : (text.contains("::") ? "::" : (text.contains("-") ? "-" : " ")));
        ArrayList<String> parts = new ArrayList<String>(StringUtil.split((String)text, (String)separator));
        while (parts.size() > 1) {
            int index = parts.size() / 2 - 1;
            parts.remove(index);
            if (fm.stringWidth(StringUtil.join(parts, (String)separator) + "...") >= maxWidth) continue;
            parts.add(index, "...");
            return left + StringUtil.join(parts, (String)separator) + right;
        }
        int adjustedWidth = Math.max(adjustedText.length() * maxWidth / fullWidth - 1, left.length() + right.length() + 3);
        return StringUtil.trimMiddle((String)adjustedText, (int)adjustedWidth);
    }

    private static boolean isTopLevelSymbol(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCSearchEverywhereCellRenderer.$$$reportNull$$$0(0);
        }
        if (!(symbol instanceof OCSymbolWithQualifiedName)) {
            return true;
        }
        OCSymbolWithQualifiedName qualifiedName = (OCSymbolWithQualifiedName)symbol;
        return qualifiedName.getParent() == null && qualifiedName.getQualifier() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/search/OCSearchEverywhereCellRenderer", "isTopLevelSymbol"));
    }

    private class LeftRenderer
    extends ColoredListCellRenderer {
        public final boolean myRenderLocation;
        private final Matcher myMatcher;

        LeftRenderer(boolean renderLocation, Matcher matcher) {
            this.myRenderLocation = renderLocation;
            this.myMatcher = matcher;
            this.setIpad(new Insets(0, 0, 0, this.getIpad().right));
        }

        protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
            String containerText;
            if (list == null) {
                LeftRenderer.$$$reportNull$$$0(0);
            }
            assert (value instanceof OCSymbolNavigationItem);
            Color bgColor = UIUtil.getListBackground();
            OCSymbolNavigationItem item = (OCSymbolNavigationItem)value;
            OCSymbolPresentation presentation = item.getPresentation();
            String name = presentation.getPresentableText();
            Color color = list.getForeground();
            boolean isProblemFile = false;
            OCSymbolHolderVirtualPsiElement psiElement = item.getTargetElement();
            if (psiElement.isValid()) {
                Project project = psiElement.getProject();
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
                isProblemFile = virtualFile != null && WolfTheProblemSolver.getInstance((Project)project).isProblemFile(virtualFile);
                Color fileBackgroundColor = (Color)ClassicSlowOpsKt.withSlowOpsAllowed(() -> virtualFile == null ? null : VfsPresentationUtil.getFileBackgroundColor((Project)project, (VirtualFile)virtualFile));
                if (fileBackgroundColor != null) {
                    bgColor = fileBackgroundColor;
                }
            }
            TextAttributes textAttributes = NodeRenderer.getSimpleTextAttributes((ItemPresentation)presentation).toTextAttributes();
            if (isProblemFile) {
                textAttributes.setEffectType(EffectType.WAVE_UNDERSCORE);
                textAttributes.setEffectColor((Color)JBColor.red);
            }
            textAttributes.setForegroundColor(color);
            SimpleTextAttributes nameAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
            SpeedSearchUtil.appendColoredFragmentForMatcher((String)name, (SimpleColoredComponent)this, (SimpleTextAttributes)nameAttributes, (Matcher)this.myMatcher, (Color)bgColor, (boolean)selected);
            this.setIcon(presentation.getIcon(false));
            if (this.myRenderLocation && (containerText = OCSearchEverywhereCellRenderer.trimSymbolContainerLength(name, presentation, list, OCSearchEverywhereCellRenderer.this.myRightRendererWidth)) != null && !containerText.isEmpty()) {
                this.append(" " + containerText, new SimpleTextAttributes(0, (Color)JBColor.GRAY));
            }
            this.setPaintFocusBorder(false);
            this.setBackground(selected ? UIUtil.getListSelectionBackground((boolean)true) : bgColor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/cidr/lang/search/OCSearchEverywhereCellRenderer$LeftRenderer", "customizeCellRenderer"));
        }
    }
}

