/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCDirectInheritorsSearch
extends ExtensibleQueryFactory<OCClassSymbol, SearchParameters> {
    private static final ExtensionPointName<QueryExecutor<OCClassSymbol, SearchParameters>> EP_NAME = ExtensionPointName.create((String)"cidr.lang.ocDirectInheritorsSearch");
    private static final OCDirectInheritorsSearch INSTANCE = new OCDirectInheritorsSearch();

    private OCDirectInheritorsSearch() {
        super(EP_NAME);
    }

    @NotNull
    public static Query<OCClassSymbol> search(@NotNull OCClassDeclaration aClass) {
        if (aClass == null) {
            OCDirectInheritorsSearch.$$$reportNull$$$0(0);
        }
        Project project = aClass.getProject();
        return OCDirectInheritorsSearch.search(aClass.getName(), aClass.getSymbol(), (SearchScope)GlobalSearchScope.allScope((Project)project), project, aClass instanceof OCProtocol, aClass instanceof OCImplementation);
    }

    @NotNull
    public static Query<OCClassSymbol> search(@Nullable String className, @Nullable OCClassSymbol symbol, @NotNull SearchScope scope, @NotNull Project project, boolean protocol, boolean preferImplementations) {
        if (scope == null) {
            OCDirectInheritorsSearch.$$$reportNull$$$0(1);
        }
        if (project == null) {
            OCDirectInheritorsSearch.$$$reportNull$$$0(2);
        }
        Query query = INSTANCE.createQuery(new SearchParameters(scope, className, symbol, protocol, project, preferImplementations));
        if (query == null) {
            OCDirectInheritorsSearch.$$$reportNull$$$0(3);
        }
        return query;
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultSearcher());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/OCDirectInheritorsSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/OCDirectInheritorsSearch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "search";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static class SearchParameters {
        private final OCClassSymbol mySymbol;
        private final SearchScope myScope;
        private final String myClassName;
        private final boolean isProtocol;
        private final Project myProject;
        private final boolean myPreferImplementations;

        public SearchParameters(@NotNull SearchScope scope, @Nullable String className, @Nullable OCClassSymbol symbol, boolean protocol, @NotNull Project project, boolean preferImplementations) {
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (project == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this.myScope = scope;
            this.myClassName = className;
            this.mySymbol = symbol;
            this.isProtocol = protocol;
            this.myProject = project;
            this.myPreferImplementations = preferImplementations;
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            return searchScope;
        }

        @Nullable
        public String getClassName() {
            return this.myClassName;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            return project;
        }

        public boolean isProtocol() {
            return this.isProtocol;
        }

        public boolean isPreferImplementations() {
            return this.myPreferImplementations;
        }

        @Nullable
        public OCClassSymbol getSymbol() {
            return this.mySymbol;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/search/OCDirectInheritorsSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/search/OCDirectInheritorsSearch$SearchParameters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class DefaultSearcher
    extends QueryExecutorBase<OCClassSymbol, SearchParameters> {
        private DefaultSearcher() {
        }

        public void processQuery(final @NotNull SearchParameters p, final @NotNull Processor<? super OCClassSymbol> consumer) {
            if (p == null) {
                DefaultSearcher.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                DefaultSearcher.$$$reportNull$$$0(1);
            }
            final String superName = p.getClassName();
            final SearchScope scope = p.getScope();
            final boolean isProtocol = p.isProtocol();
            final boolean preferImplementations = p.isPreferImplementations();
            OCGlobalProjectSymbolsCache.processSymbolsBySuperType(p.getProject(), superName, (Processor<? super OCSymbol>)new Processor<OCSymbol>(this){

                private boolean acceptsInterface(OCInterfaceSymbol symbol) {
                    VirtualFile file = symbol.getContainingFile();
                    if (file != null && scope.contains(file)) {
                        if (isProtocol) {
                            List<String> protocols = symbol.getProtocolNames();
                            for (String protocol : protocols) {
                                if (!Objects.equals(superName, protocol)) continue;
                                return true;
                            }
                        } else if (Objects.equals(superName, symbol.getSuperClassName())) {
                            return true;
                        }
                    }
                    return false;
                }

                public boolean process(OCSymbol symbol) {
                    ProgressManager.checkCanceled();
                    if (symbol instanceof OCInterfaceSymbol) {
                        if (!this.acceptsInterface((OCInterfaceSymbol)symbol)) {
                            return true;
                        }
                        if (preferImplementations) {
                            OCImplementationSymbol implSymbol = ((OCInterfaceSymbol)symbol).getImplementation(p.getProject());
                            if (implSymbol != null) {
                                consumer.process((Object)implSymbol);
                            } else {
                                consumer.process((Object)((OCClassSymbol)symbol));
                            }
                        } else {
                            consumer.process((Object)((OCClassSymbol)symbol));
                        }
                    } else if (symbol instanceof OCProtocolSymbol) {
                        List<String> protocols = ((OCProtocolSymbol)symbol).getProtocolNames();
                        for (String protocol : protocols) {
                            if (!Objects.equals(superName, protocol)) continue;
                            return consumer.process((Object)((OCClassSymbol)symbol));
                        }
                    }
                    return true;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "p";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/search/OCDirectInheritorsSearch$DefaultSearcher";
            objectArray[2] = "processQuery";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

