/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references.kvc;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCResolvesToSymbol;
import com.jetbrains.cidr.lang.resolve.references.kvc.KVCReferencesProvider;
import com.jetbrains.cidr.lang.resolve.references.kvc.KVCUtil;
import com.jetbrains.cidr.lang.resolve.references.kvc.KeyReference;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyPathReferenceProvider
extends KVCReferencesProvider {
    @Override
    protected KeyReference[] getReferences(@NotNull OCLiteralExpression literal, @NotNull ASTNode stringLiteral, final @NotNull OCObjectType receiverClass) {
        TextRange literalContentsRange;
        if (literal == null) {
            KeyPathReferenceProvider.$$$reportNull$$$0(0);
        }
        if (stringLiteral == null) {
            KeyPathReferenceProvider.$$$reportNull$$$0(1);
        }
        if (receiverClass == null) {
            KeyPathReferenceProvider.$$$reportNull$$$0(2);
        }
        int startOffsetInParent = stringLiteral.getPsi().getStartOffsetInParent();
        ArrayList<KeyReference> result = new ArrayList<KeyReference>();
        if (stringLiteral.getTextLength() > 0 && !(literalContentsRange = new TextRange(startOffsetInParent + 1, startOffsetInParent + stringLiteral.getTextLength() - 1)).isEmpty()) {
            String key = stringLiteral.getText().substring(1, stringLiteral.getText().length() - 1);
            String[] split = key.split("\\.");
            int offset = 0;
            OCFile context = literal.getContainingOCFile();
            OCResolvesToSymbol<OCClassSymbol> receiverClass1 = new OCResolvesToSymbol<OCClassSymbol>(this){

                @Override
                @Nullable
                public OCClassSymbol resolveToSymbol() {
                    return receiverClass.getClassSymbol();
                }
            };
            for (String aSplit : split) {
                if (!KVCUtil.isValidPairForReferring((OCClassSymbol)receiverClass1.resolveToSymbol(), aSplit, context)) break;
                int startOffset = literalContentsRange.getStartOffset() + offset;
                TextRange r = new TextRange(startOffset, startOffset + aSplit.length());
                KeyReference keyReference = new KeyReference(receiverClass1, literal, r, aSplit, literal.getProject());
                result.add(keyReference);
                receiverClass1 = new Property2ClassRef(keyReference);
                offset += aSplit.length() + 1;
            }
        }
        return result.toArray(new KeyReference[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "literal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "stringLiteral";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "receiverClass";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/resolve/references/kvc/KeyPathReferenceProvider";
        objectArray[2] = "getReferences";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Property2ClassRef
    implements OCResolvesToSymbol<OCClassSymbol> {
        private KeyReference myKeyReference;

        Property2ClassRef(KeyReference keyReference) {
            this.myKeyReference = keyReference;
        }

        @Override
        public OCClassSymbol resolveToSymbol() {
            OCMemberSymbol property = this.myKeyReference.resolveToSymbol();
            OCType returnType = null;
            if (property instanceof OCPropertySymbol) {
                returnType = property.getType();
            } else if (property instanceof OCMethodSymbol) {
                returnType = ((OCMethodSymbol)property).getReturnType(((OCLiteralExpression)this.myKeyReference.getElement()).getProject());
            }
            if (returnType != null) {
                return KVCUtil.getReceiverClass(returnType, this.myKeyReference.getElement());
            }
            return null;
        }
    }
}

