/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.impl.OCFileReference;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.OCRenameProcessorExtension;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCForeignUsagesRenameProcessor;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameUtil;
import com.jetbrains.cidr.lang.search.OCElementInMacroSubstitutionReferenceSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCRefactoringSettings;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeductionGuideSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNamesValidator;
import com.jetbrains.cidr.lang.util.OCScopeInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof OCElement && element instanceof PsiNamedElement || element instanceof OCReferenceElement && element.getParent() instanceof OCSynthesizeProperty || element instanceof OCLocalizedString;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            OCRenameProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            OCRenameProcessor.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            OCRenameProcessor.$$$reportNull$$$0(4);
        }
        OCSymbol symbol = OCRenameUtil.getSymbolToRename(element);
        Project project = element.getProject();
        PsiFile refFile = element.getContainingFile();
        if (symbol != null) {
            OCStructSymbol struct;
            if (symbol instanceof OCStructSymbol) {
                OCRenameProcessor.prepareStruct(element, (OCStructSymbol)symbol, newName, allRenames, project);
            } else if (!(symbol instanceof OCClassSymbol)) {
                symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol12 -> {
                    OCRenameProcessor.addSymbol(newName, allRenames, symbol12, project);
                    return true;
                }), project);
            }
            if (symbol instanceof OCSymbolWithParent) {
                OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)symbol, symbol1 -> {
                    OCRenameProcessor.addSymbol(newName, allRenames, symbol1, project);
                    return true;
                }, false, true, project);
            }
            if (symbol instanceof OCFunctionSymbol && symbol.getKind().isConstructorOrDestructor()) {
                OCSymbolWithQualifiedName owner = ((OCFunctionSymbol)symbol).getResolvedOwner(OCResolveContext.forPsi(element));
                if (owner instanceof OCStructSymbol) {
                    OCRenameProcessor.addSymbol(newName, allRenames, owner, project);
                    OCRenameProcessor.prepareStruct(element, (OCStructSymbol)owner, newName, allRenames, project);
                }
            } else if (symbol instanceof OCDeductionGuideSymbol && (struct = ((OCDeductionGuideSymbol)symbol).getResolvedTemplateId(OCResolveContext.forPsi(element))) != null) {
                OCRenameProcessor.addSymbol(newName, allRenames, struct, project);
                OCRenameProcessor.prepareStruct(element, struct, newName, allRenames, project);
            }
            symbol = symbol.getDefinitionSymbol(project);
            if (symbol != null) {
                element = symbol.locateDefinition(project);
                OCRenameProcessor.prepareAssociatedSymbols(symbol, newName, allRenames, scope, project, refFile);
            }
        }
        if (element instanceof OCFile) {
            OCRenameProcessor.prepareFile((OCFile)element, newName, allRenames, scope, project);
        } else if (element instanceof OCClassDeclaration) {
            clazz = (OCClassDeclaration)element;
            String category = clazz.getCategory();
            OCRenameProcessor.prepareClass(clazz.getName(), category, (String)(category != null ? newName + "+" + category : newName), allRenames, scope, element instanceof OCProtocol, project);
        } else if (element instanceof OCCategoryName) {
            clazz = (OCClassDeclaration)element.getParent();
            OCRenameProcessor.prepareClass(clazz.getName(), clazz.getCategory(), clazz.getName() + "+" + newName, allRenames, scope, false, project);
        }
        if (element != null) {
            OCForeignUsagesRenameProcessor.prepareRenaming(element, newName, allRenames, scope);
        }
        Iterator<PsiElement> iterator2 = allRenames.keySet().iterator();
        while (iterator2.hasNext()) {
            PsiElement e = iterator2.next();
            if (OCSearchScope.isInProjectSources(e) && !OCElementUtil.hasSyntheticIdentifier(e)) continue;
            iterator2.remove();
        }
    }

    public static void prepareAssociatedSymbols(@NotNull OCSymbol symbol, final @NotNull String newName, final @NotNull Map<PsiElement, String> allRenames, final @NotNull SearchScope scope, final @NotNull Project project, final @NotNull PsiFile refFile) {
        if (symbol == null) {
            OCRenameProcessor.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            OCRenameProcessor.$$$reportNull$$$0(6);
        }
        if (allRenames == null) {
            OCRenameProcessor.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            OCRenameProcessor.$$$reportNull$$$0(8);
        }
        if (project == null) {
            OCRenameProcessor.$$$reportNull$$$0(9);
        }
        if (refFile == null) {
            OCRenameProcessor.$$$reportNull$$$0(10);
        }
        OCRenameProcessor.processAssociatedSymbols(symbol, new AssociatedElementsProcessor(){

            @Override
            public boolean processIvar(OCInstanceVariableSymbol ivar, OCPropertySymbol fromProperty) {
                OCRenameProcessor.prepareInstanceVariable(newName, allRenames, fromProperty, ivar, refFile);
                return true;
            }

            @Override
            public boolean processPropertyAccessors(OCPropertySymbol property) {
                OCRenameProcessor.preparePropertyAccessors(newName, allRenames, property, project);
                return true;
            }

            @Override
            public boolean processProperty(OCPropertySymbol property, OCSymbol fromSymbol) {
                OCRenameProcessor.prepareProperty(newName, allRenames, fromSymbol, property, refFile);
                return true;
            }

            @Override
            public boolean processClassAlias(OCClassSymbol clazz, OCCompatibilityAliasSymbol alias) {
                OCRenameProcessor.prepareClassAlias(newName, allRenames, clazz, alias, refFile);
                return true;
            }

            @Override
            public boolean processClass(OCCompatibilityAliasSymbol alias, OCClassSymbol clazz) {
                OCRenameProcessor.prepareClass(newName, allRenames, alias, clazz, scope, project);
                return true;
            }
        }, scope, project);
    }

    private static void addSymbol(String newName, Map<PsiElement, String> allRenames, OCSymbol symbol, Project project) {
        PsiElement element;
        if (symbol != null && (element = symbol.locateDefinition(project)) != null) {
            allRenames.put(element, newName);
        }
    }

    public static void processAssociatedSymbols(OCSymbol symbol, AssociatedElementsProcessor processor2, SearchScope scope, Project project) {
        if (symbol instanceof OCPropertySymbol) {
            OCPropertySymbol property = (OCPropertySymbol)symbol;
            OCInstanceVariableSymbol ivar = property.getAssociatedIvar(project);
            if (ivar != null && OCElementUtil.endsWithIgnoringFirstLetterCase(ivar.getName(), symbol.getName())) {
                ivar.processSameSymbols((Processor<OCSymbol>)((Processor)symbol14 -> processor2.processIvar((OCInstanceVariableSymbol)symbol14, property)), project);
            }
            property.processSameSymbols((Processor<OCSymbol>)((Processor)symbol13 -> processor2.processPropertyAccessors((OCPropertySymbol)symbol13)), project);
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
            OCPropertySymbol property = ivar.getAssociatedProperty(project);
            if (property != null && OCElementUtil.endsWithIgnoringFirstLetterCase(symbol.getName(), property.getName())) {
                property.processSameSymbols((Processor<OCSymbol>)((Processor)symbol12 -> processor2.processProperty((OCPropertySymbol)symbol12, ivar)), project);
            }
        } else if (symbol instanceof OCMethodSymbol) {
            OCPropertySymbol property = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
            if (property == null) {
                OCMethodSymbol associatedSymbol = (OCMethodSymbol)symbol.getAssociatedSymbol(project);
                OCPropertySymbol oCPropertySymbol = property = associatedSymbol != null ? associatedSymbol.getGeneratedFromProperty() : null;
            }
            if (property != null) {
                property.processSameSymbols((Processor<OCSymbol>)((Processor)property1 -> processor2.processProperty((OCPropertySymbol)property1, symbol)), project);
            }
        } else if (symbol instanceof OCCompatibilityAliasSymbol) {
            OCClassSymbol clazz;
            OCCompatibilityAliasSymbol alias = (OCCompatibilityAliasSymbol)symbol;
            OCType type = alias.getResolvedType(OCResolveContext.forSymbol(alias, project));
            if (type instanceof OCObjectType && (clazz = ((OCObjectType)type).getClassSymbol()) != null && OCElementUtil.endsWithIgnoringFirstLetterCase(clazz.getName(), alias.getName())) {
                processor2.processClass(alias, clazz);
            }
        } else if (symbol instanceof OCClassSymbol) {
            OCClassSymbol clazz = (OCClassSymbol)symbol;
            OCGlobalProjectSymbolsCache.processAliasNamesForType(project, clazz.getName(), (Processor<String>)((Processor)s -> {
                OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, (Processor<? super OCSymbol>)((Processor)symbol1 -> {
                    if (symbol1 instanceof OCCompatibilityAliasSymbol && OCRenameProcessor.isInScope(symbol1, scope)) {
                        OCType type = symbol1.getResolvedType(OCResolveContext.forSymbol(symbol1, project));
                        if (!(type instanceof OCObjectType)) {
                            return true;
                        }
                        OCClassSymbol classSymbol = ((OCObjectType)type).getClassSymbol();
                        if (classSymbol == null || !classSymbol.equals(clazz)) {
                            return true;
                        }
                        if (OCElementUtil.endsWithIgnoringFirstLetterCase(clazz.getName(), symbol1.getName()) && !processor2.processClassAlias(clazz, (OCCompatibilityAliasSymbol)symbol1)) {
                            return false;
                        }
                    }
                    return true;
                }), s);
                return true;
            }));
        }
    }

    private static boolean isInScope(OCSymbol symbol, SearchScope scope) {
        return !(scope instanceof LocalSearchScope) || ((LocalSearchScope)scope).isInScope(symbol.getContainingFile());
    }

    private static void prepareInstanceVariable(String newName, Map<PsiElement, String> allRenames, OCPropertySymbol property, OCInstanceVariableSymbol ivar, @NotNull PsiFile refFile) {
        if (refFile == null) {
            OCRenameProcessor.$$$reportNull$$$0(11);
        }
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)refFile, OCCodeStyleSettings.class);
        String newIvarName = OCRenameProcessor.getNewIvarName(newName, ivar.getName(), property.getName());
        Project project = refFile.getProject();
        if (ivar.isClang4ImplicitIvar(refFile)) {
            allRenames.put(new OCSymbolHolderVirtualPsiElement(ivar, project), newIvarName);
        } else if (settings.REFACTOR_PROPERTIES_AND_IVARS) {
            OCRenameProcessor.addSymbol(newIvarName, allRenames, ivar, project);
        }
    }

    private static String getNewIvarName(String newPropName, String ivarName, String propName) {
        int prefixLength = ivarName.length() - propName.length();
        String suffix = newPropName;
        if (!newPropName.isEmpty() && prefixLength < ivarName.length() && Character.isUpperCase(ivarName.charAt(prefixLength)) && (!Character.isUpperCase(propName.charAt(0)) || Character.isUpperCase(newPropName.charAt(0)) || prefixLength != 0 && Character.isLetter(ivarName.charAt(prefixLength - 1)))) {
            suffix = StringUtil.capitalize((String)suffix);
        }
        return ivarName.substring(0, prefixLength) + suffix;
    }

    private static void preparePropertyAccessors(String newName, Map<PsiElement, String> allRenames, OCPropertySymbol property, Project project) {
        property.getParent().processMembers(OCMethodSymbol.class, symbol -> {
            if (symbol.getGeneratedFromProperty() == property) {
                OCResolveContext context = OCResolveContext.forSymbol(symbol, project);
                if (symbol.isGetter(context) && !property.hasAttribute(OCPropertySymbol.PropertyAttribute.GETTER)) {
                    allRenames.put(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol, project), newName);
                } else if (symbol.isSetter(context) && !property.hasAttribute(OCPropertySymbol.PropertyAttribute.SETTER)) {
                    allRenames.put(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol, project), OCNameSuggester.getObjCSetterFromGetter(newName));
                }
            }
            return true;
        });
        property.processAccessorMethods((Processor<? super OCMethodSymbol>)((Processor)method -> {
            String oldName = method.getName();
            if (oldName.equals(property.getAttributeValue(OCPropertySymbol.PropertyAttribute.GETTER)) || oldName.equals(property.getAttributeValue(OCPropertySymbol.PropertyAttribute.SETTER) + ":")) {
                return true;
            }
            OCRenameProcessor.addSymbol((String)(OCElementUtil.startsWithWord(oldName, "set") ? "set" + StringUtil.capitalize((String)newName) : newName), allRenames, method, project);
            List<OCMethodSymbol.SelectorPartSymbol> selectors = method.getSelectors();
            OCDeclaratorSymbol parameter = selectors.get(0).getParameter();
            if (parameter != null && OCElementUtil.endsWithIgnoringFirstLetterCase(parameter.getName(), property.getName())) {
                OCRenameProcessor.addSymbol(OCRenameProcessor.getNewIvarName(newName, parameter.getName(), property.getName()), allRenames, parameter, project);
            }
            return true;
        }), true, project);
    }

    private static void prepareProperty(String newName, Map<PsiElement, String> allRenames, OCSymbol fromSymbol, OCPropertySymbol property, @NotNull PsiFile refFile) {
        if (refFile == null) {
            OCRenameProcessor.$$$reportNull$$$0(12);
        }
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)refFile, OCCodeStyleSettings.class);
        Project project = refFile.getProject();
        if (fromSymbol instanceof OCInstanceVariableSymbol) {
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)fromSymbol;
            if (settings.REFACTOR_PROPERTIES_AND_IVARS || ivar.isClang4ImplicitIvar(project)) {
                String newPropertyName;
                String prefix = ivar.getName().substring(0, ivar.getName().length() - property.getName().length());
                if (newName.startsWith(prefix) && newName.length() > prefix.length()) {
                    newPropertyName = newName.substring(prefix.length());
                    if (Character.isLowerCase(property.getName().charAt(0))) {
                        newPropertyName = StringUtil.decapitalize((String)newPropertyName);
                    }
                } else {
                    newPropertyName = newName;
                }
                OCRenameProcessor.addSymbol(newPropertyName, allRenames, property, project);
                OCRenameProcessor.preparePropertyAccessors(newPropertyName, allRenames, property, project);
            }
        } else if (fromSymbol instanceof OCMethodSymbol) {
            OCMethodSymbol accessor = (OCMethodSymbol)fromSymbol;
            if (accessor.isSetter(OCResolveContext.forSymbol(accessor, project))) {
                String getter = OCNameSuggester.getObjCGetterFromSetter(newName);
                newName = getter != null ? getter : newName;
            }
            OCRenameProcessor.addSymbol(newName, allRenames, property, project);
            OCRenameProcessor.preparePropertyAccessors(newName, allRenames, property, project);
        }
    }

    private static void prepareClassAlias(String newName, Map<PsiElement, String> allRenames, @NotNull OCClassSymbol clazz, OCCompatibilityAliasSymbol alias, @NotNull PsiFile refFile) {
        if (clazz == null) {
            OCRenameProcessor.$$$reportNull$$$0(13);
        }
        if (refFile == null) {
            OCRenameProcessor.$$$reportNull$$$0(14);
        }
        int endPrefixIndex = clazz.getName().length() - alias.getName().length();
        String prefix = clazz.getName().substring(0, endPrefixIndex);
        if (newName.startsWith(prefix) && newName.length() > prefix.length()) {
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)refFile, OCCodeStyleSettings.class);
            if (settings.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES) {
                String newAliasName = newName.substring(prefix.length());
                OCRenameProcessor.addSymbol(newAliasName, allRenames, alias, refFile.getProject());
            }
        }
    }

    private static void prepareFile(OCFile file, String newName, Map<PsiElement, String> allRenames, SearchScope scope, Project project) {
        if (!FileUtilRt.extensionEquals((String)newName, (String)FileUtilRt.getExtension((String)file.getName()))) {
            allRenames.put(file, newName);
            return;
        }
        boolean renameSameNamedClass = OCRenameUtil.shouldRenameSameClassOrFileEntity(file);
        if (renameSameNamedClass) {
            OCFile headerFile;
            OCFile oCFile = headerFile = file.isHeader() ? file : file.getAssociatedFileWithSameName();
            if (headerFile != null) {
                OCSymbol mainClass = headerFile.getSameNamedClass();
                String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)newName);
                if (mainClass instanceof OCClassSymbol) {
                    OCRenameProcessor.prepareClass(mainClass.getName(), ((OCClassSymbol)mainClass).getCategoryName(), nameWithoutExtension, allRenames, scope, mainClass instanceof OCProtocolSymbol, project);
                    return;
                }
                if (mainClass instanceof OCStructSymbol) {
                    OCRenameProcessor.prepareStruct(file, (OCStructSymbol)mainClass, nameWithoutExtension, allRenames, project);
                    return;
                }
            }
        }
        OCRenameProcessor.processAssociatedFiles(file, newName, allRenames);
    }

    private static void processAssociatedFiles(OCFile file, String newName, Map<PsiElement, String> allRenames) {
        allRenames.put(file, newName);
        file = file.getAssociatedFileWithSameName();
        if (file != null && OCRefactoringSettings.getInstance().RENAME_ASSOCIATED_FILES) {
            allRenames.put(file, FileUtilRt.getNameWithoutExtension((String)newName) + "." + FileUtilRt.getExtension((String)file.getName()));
        }
    }

    private static void prepareStruct(PsiElement elementToRename, OCStructSymbol struct, String newName, Map<PsiElement, String> allRenames, Project project) {
        OCFile fileToProcess;
        OCResolveContext context = OCResolveContext.forSymbol(struct, project);
        struct.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
            OCStructSymbol struct1 = (OCStructSymbol)symbol;
            OCRenameProcessor.addSymbol(newName, allRenames, struct1, project);
            if (!struct1.isPredeclaration()) {
                Processor processor2 = symbol1 -> {
                    OCRenameProcessor.addSymbol(newName, allRenames, symbol1, project);
                    return true;
                };
                struct1.processConstructors((Processor<? super OCFunctionSymbol>)processor2, true, context);
                struct1.processDestructors((Processor<? super OCFunctionSymbol>)processor2, true, context);
                struct1.processDeductionGuides((Processor<? super OCDeductionGuideSymbol>)processor2, context);
            }
            return true;
        }), project);
        OCFile oCFile = fileToProcess = elementToRename instanceof OCFile ? (OCFile)elementToRename : struct.getContainingOCFile(project);
        if (fileToProcess != null && OCRenameUtil.shouldRenameSameClassOrFileEntity(elementToRename) && OCRenameUtil.symbolHasSameNameWithFile(struct.getName(), struct.getKind(), fileToProcess)) {
            OCRenameProcessor.processAssociatedFiles(fileToProcess, newName + "." + FileUtilRt.getExtension((String)fileToProcess.getName()), allRenames);
        }
    }

    private static void prepareClass(String newName, Map<PsiElement, String> allRenames, OCCompatibilityAliasSymbol alias, OCClassSymbol clazz, SearchScope scope, Project project) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        if (settings.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES) {
            int endPrefixIndex = clazz.getName().length() - alias.getName().length();
            String prefix = clazz.getName().substring(0, endPrefixIndex);
            String newClassName = prefix + newName;
            String categoryName = clazz.getCategoryName();
            if (categoryName != null) {
                newClassName = newClassName + "+" + categoryName;
            }
            OCRenameProcessor.prepareClass(clazz.getName(), categoryName, newClassName, allRenames, scope, clazz instanceof OCProtocolSymbol, project);
        }
    }

    private static void prepareClass(String oldClassName, String oldCategoryName, String newName, Map<PsiElement, String> allRenames, SearchScope scope, boolean isProtocol, Project project) {
        int categoryIdx = newName.lastIndexOf(43);
        String newClassName = categoryIdx > 0 ? newName.substring(0, categoryIdx) : newName;
        OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, (Processor<? super OCSymbol>)((Processor)ocSymbol -> {
            if (ocSymbol instanceof OCClassSymbol && OCRenameProcessor.isInScope(ocSymbol, scope) && isProtocol == ocSymbol instanceof OCProtocolSymbol) {
                boolean sameCategory = Objects.equals(((OCClassSymbol)ocSymbol).getCategoryName(), oldCategoryName);
                if (!sameCategory && oldClassName.equals(newClassName)) {
                    return true;
                }
                PsiElement def = ocSymbol.locateDefinition(project);
                if (def != null) {
                    if (sameCategory) {
                        allRenames.put(def, newName);
                    } else {
                        allRenames.put(def, newClassName);
                    }
                    PsiFile file = def.getContainingFile();
                    String fileName = file.getName();
                    String name = FileUtilRt.getNameWithoutExtension((String)fileName);
                    int categoryIdx1 = name.lastIndexOf(43);
                    String category = null;
                    if (categoryIdx1 > 0) {
                        category = name.substring(categoryIdx1 + 1);
                        name = name.substring(0, categoryIdx1);
                    }
                    if (name.equals(oldClassName)) {
                        if (Objects.equals(oldCategoryName, category)) {
                            allRenames.put((PsiElement)file, newName + "." + FileUtilRt.getExtension((String)fileName));
                        } else {
                            allRenames.put((PsiElement)file, newClassName + fileName.substring(name.length()));
                        }
                    }
                }
            }
            return true;
        }), oldClassName);
    }

    private static boolean isSetter(OCMethod method) {
        return method.getSelector().endsWith(":");
    }

    private static boolean isSetter(OCSendMessageExpression call) {
        return call.getMessageSelector().endsWith(":");
    }

    private static boolean isSetter(OCPropertyAttribute attribute) {
        return "setter".equals(attribute.getName());
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            OCRenameProcessor.$$$reportNull$$$0(16);
        }
        Project project = element.getProject();
        PsiElement elementToSearch = element;
        OCMethodSymbol accessor = null;
        if (OCRenameProcessor.isAccessor(element)) {
            accessor = (OCMethodSymbol)((OCSymbolHolderVirtualPsiElement)element).getSymbol();
            elementToSearch = accessor.getGeneratedFromProperty().locateDefinition(project);
        }
        if (elementToSearch == null) {
            List<PsiReference> list = Collections.emptyList();
            if (list == null) {
                OCRenameProcessor.$$$reportNull$$$0(17);
            }
            return list;
        }
        OCResolveContext context = OCResolveContext.forPsi(elementToSearch);
        if (elementToSearch instanceof OCClassDeclaration && ((OCClassDeclaration)elementToSearch).getCategoryElement() != null) {
            List<PsiReference> list = Collections.emptyList();
            if (list == null) {
                OCRenameProcessor.$$$reportNull$$$0(18);
            }
            return list;
        }
        Collection result = ReferencesSearch.search((ReferencesSearch.SearchParameters)new OCElementInMacroSubstitutionReferenceSearch.MySearchParameters(elementToSearch, searchScope, false, true)).findAll();
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            PsiReference reference = (PsiReference)itr.next();
            PsiElement usage = reference.getElement();
            ProgressManager.checkCanceled();
            if (reference instanceof OCFileReference) {
                ((OCFileReference)reference).preprocessHeaderRootsAndActiveConfiguration();
            }
            if (usage instanceof OCSendMessageExpression) {
                if (accessor != null && accessor.isSetter(context) == OCRenameProcessor.isSetter((OCSendMessageExpression)usage)) continue;
                itr.remove();
                continue;
            }
            if (usage instanceof OCMethod) {
                if (accessor != null && accessor.isSetter(context) == OCRenameProcessor.isSetter((OCMethod)usage)) continue;
                itr.remove();
                continue;
            }
            if (usage instanceof OCPropertyAttribute) {
                if (accessor != null && accessor.isSetter(context) == OCRenameProcessor.isSetter((OCPropertyAttribute)usage)) continue;
                itr.remove();
                continue;
            }
            if (accessor != null) {
                itr.remove();
                continue;
            }
            if (!(element instanceof OCDeclarator) || !(usage instanceof OCDeclarator)) continue;
            itr.remove();
        }
        Collection collection = result;
        if (collection == null) {
            OCRenameProcessor.$$$reportNull$$$0(19);
        }
        return collection;
    }

    private static boolean isAccessor(PsiElement element) {
        return element instanceof OCSymbolHolderVirtualPsiElement && ((OCSymbolHolderVirtualPsiElement)element).getSymbol() instanceof OCMethodSymbol;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(20);
        }
        if (newName == null) {
            OCRenameProcessor.$$$reportNull$$$0(21);
        }
        if (usages == null) {
            OCRenameProcessor.$$$reportNull$$$0(22);
        }
        Project project = element.getProject();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)element.getContainingFile(), OCCodeStyleSettings.class);
        ArrayList<UsageInfo> normalUsages = new ArrayList<UsageInfo>();
        MultiMap usageByLanguage = ContainerUtil.groupBy(Arrays.asList(usages), usage -> {
            PsiElement psiElement = usage.getElement();
            return psiElement == null ? null : psiElement.getLanguage();
        });
        for (Language language : usageByLanguage.keySet()) {
            Collection languageInfos;
            if (OCForeignUsagesRenameProcessor.processAll(element, newName, language, languageInfos = usageByLanguage.get((Object)language))) continue;
            for (UsageInfo usage2 : languageInfos) {
                PsiElement refElement = usage2.getElement();
                if (refElement != null && OCElementUtil.isPartOfMacroSubstitution(refElement)) {
                    OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(refElement);
                    if (macroRange != null && !macroRange.mapsToArguments() && element instanceof PsiNamedElement) {
                        PsiElement macro;
                        String name = ((PsiNamedElement)element).getName();
                        OCMacroSymbol macroSymbol = macroRange.getMacroCall().resolveToSymbol();
                        PsiElement psiElement = macro = macroSymbol != null ? macroSymbol.locateDefinition(project) : null;
                        if (macro instanceof OCDefineDirective) {
                            PsiElement macroNameId = ((OCDefineDirective)macro).getNameIdentifier();
                            for (ASTNode child : macro.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{OCLexerTokenTypes.IDENTIFIER}))) {
                                PsiElement psi = child.getPsi();
                                if (psi == macroNameId || !psi.getText().equals(name)) continue;
                                OCElementUtil.replaceWithIdentifier(psi, newName, refElement);
                            }
                        }
                    }
                    FileSymbolTablesCache.getInstance(project).scheduleReparseFile(element.getContainingFile());
                    continue;
                }
                if (!settings.REFACTOR_PROPERTIES_AND_IVARS && refElement != null && OCRenameProcessor.isSynthesizeWithoutIvar(refElement.getParent())) {
                    OCReferenceElement oldSynthezise = ((OCSynthesizeProperty)refElement.getParent()).getPropertyRef();
                    if (oldSynthezise == null) continue;
                    String propName = oldSynthezise.getName();
                    oldSynthezise.replace(OCElementFactory.synthesize(newName, propName, refElement));
                    continue;
                }
                normalUsages.add(usage2);
            }
        }
        super.renameElement(element, newName, normalUsages.toArray(UsageInfo.EMPTY_ARRAY), listener);
    }

    private static boolean isSynthesizeWithoutIvar(@Nullable PsiElement element) {
        return element instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)element).getInstanceVariableRef() == null;
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        PsiElement definition;
        OCSymbol symbol;
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(23);
        }
        if (newName == null) {
            OCRenameProcessor.$$$reportNull$$$0(24);
        }
        if (conflicts == null) {
            OCRenameProcessor.$$$reportNull$$$0(25);
        }
        Project project = element.getProject();
        OCSymbol duplicate = null;
        if (element instanceof OCCategoryName) {
            OCSymbol oCSymbol = symbol = (element = element.getParent()) instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)element).getSymbol() : null;
            if (symbol instanceof OCClassSymbol) {
                duplicate = OCCodeInsightUtil.resolveNameInScope(symbol.getKind(), symbol.getName(), newName, null, project);
            }
        } else {
            if (element instanceof OCFile) {
                if (!OCSearchUtil.getProjectVirtualFilesByName(project, newName).isEmpty()) {
                    String alreadyExistsWarning = OCRefactoringBundle.message("file.0.already.exists.in.the.project", newName);
                    conflicts.putValue((Object)element, (Object)alreadyExistsWarning);
                }
                return;
            }
            symbol = element instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)element).getSymbol() : null;
            String categoryName = symbol instanceof OCClassSymbol ? ((OCClassSymbol)symbol).getCategoryName() : null;
            PsiElement scope = symbol instanceof OCClassSymbol ? null : element;
            duplicate = OCCodeInsightUtil.resolveNameInScope(symbol != null ? symbol.getKind() : null, newName, categoryName, scope, project);
        }
        if (duplicate != null && (symbol == null || symbol.isGlobal() == duplicate.isGlobal()) && (definition = duplicate.locateDefinition(project)) != null) {
            String alreadyExistsWarning;
            String duplicateName = duplicate.getNameWithKindUppercase(OCCompilationContext.create(element));
            if (duplicate.isGlobal()) {
                String fileName = duplicate.getContainingFile().getName();
                alreadyExistsWarning = OCRefactoringBundle.message("refactoring.rename.0.already.exists.in.1", duplicateName, fileName);
            } else {
                alreadyExistsWarning = OCRefactoringBundle.message("refactoring.rename.0.already.exists.in.the.scope", duplicateName);
            }
            conflicts.putValue((Object)definition, (Object)alreadyExistsWarning);
        }
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        OCSymbolWithQualifiedName struct;
        OCSymbol symbol;
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(26);
        }
        PsiElement originalElement = element;
        if ((element = OCForeignUsagesRenameProcessor.substituteElement(element, editor)) instanceof OCClassDeclaration) {
            return element;
        }
        if (element instanceof OCDeclarator) {
            element = ((OCDeclarator)element).getExtendedContext();
        }
        if (element instanceof PsiNameIdentifierOwner) {
            element = OCElementUtil.substituteNamedElementToRename(element, false);
        }
        if (element instanceof OCFunctionDeclaration && (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)element).getSymbol()) != null && symbol.getKind().isConstructorOrDestructor() && (struct = symbol.getResolvedOwner(OCResolveContext.forPsi(element))) instanceof OCStructSymbol) {
            return struct.locateDefinition(element.getProject());
        }
        if (OCRenameProcessor.isAccessor(element) || element instanceof OCCallable) {
            OCSymbol oCSymbol = symbol = element instanceof OCCallable ? ((OCCallable)element).getSymbol() : (OCMethodSymbol)((OCSymbolHolderVirtualPsiElement)element).getSymbol();
            if (symbol instanceof OCMethodSymbol) {
                OCPropertySymbol property;
                OCPropertySymbol oCPropertySymbol = property = (symbol = symbol.getAssociatedSymbol(element.getProject())) != null ? ((OCMethodSymbol)symbol).getGeneratedFromProperty() : null;
                if (property != null) {
                    return property.locateDefinition(element.getProject());
                }
            }
        }
        return super.substituteElementToRename(originalElement, editor);
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(27);
        }
        return RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(28);
        }
        RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE = enabled;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(29);
        }
        return !OCScopeInfo.isLocalDeclarator(element) && RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(30);
        }
        RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE = enabled;
    }

    public PsiElement getElementToSearchInStringsAndComments(@NotNull PsiElement element) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(31);
        }
        if (element instanceof OCClassDeclaration && ((OCClassDeclaration)element).getCategoryElement() != null) {
            return null;
        }
        if (element instanceof OCFile) {
            return null;
        }
        return element;
    }

    @NotNull
    public static RenameUsages validateUsages(@NotNull PsiNamedElement elementToRename, @NotNull Ref<UsageInfo[]> refUsages, boolean filterCommentAndTextUsages) {
        boolean showDialog;
        if (elementToRename == null) {
            OCRenameProcessor.$$$reportNull$$$0(32);
        }
        if (refUsages == null) {
            OCRenameProcessor.$$$reportNull$$$0(33);
        }
        OCRenameProcessor.filterNonCodeUsages(elementToRename, refUsages, filterCommentAndTextUsages);
        String oldName = elementToRename.getName();
        int nonCodeUsages = 0;
        int textUsages = 0;
        OCSymbol badMacro = null;
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            if (usageInfo instanceof NonCodeUsageInfo) {
                ++nonCodeUsages;
                if (!OCRenameProcessor.isTextUsage(usageInfo)) continue;
                ++textUsages;
                continue;
            }
            if (!(usageInfo.getReference() instanceof OCElementInMacroSubstitutionReferenceSearch.BadMacroSubstitutionReference)) continue;
            badMacro = ((OCElementInMacroSubstitutionReferenceSearch.BadMacroSubstitutionReference)usageInfo.getReference()).getMacroSymbol();
        }
        if (badMacro != null) {
            String upName = badMacro.getNameWithKindUppercase(OCCompilationContext.create((PsiElement)elementToRename));
            String message = OCRefactoringBundle.message("rename.multiple.macro.usages.message", upName, oldName);
            String[] options = new String[]{OCRefactoringBundle.message("button.view.usages", new Object[0]), OCRefactoringBundle.message("button.cancel", new Object[0]), OCRefactoringBundle.message("button.rename", new Object[0])};
            int code = Messages.showDialog((String)message, (String)RefactoringBundle.message((String)"rename.title"), (String[])options, (int)0, (int)1, (Icon)Messages.getQuestionIcon(), null);
            if (code == 0) {
                RenameUsages renameUsages = RenameUsages.SHOW_USAGES;
                if (renameUsages == null) {
                    OCRenameProcessor.$$$reportNull$$$0(34);
                }
                return renameUsages;
            }
            if (code == 1 || code == -1) {
                RenameUsages renameUsages = RenameUsages.CANCEL;
                if (renameUsages == null) {
                    OCRenameProcessor.$$$reportNull$$$0(35);
                }
                return renameUsages;
            }
        }
        boolean bl = showDialog = !filterCommentAndTextUsages && nonCodeUsages > 0 || textUsages > 0;
        if (showDialog && !ApplicationManager.getApplication().isUnitTestMode()) {
            String message = OCRefactoringBundle.message("rename.non.code.usages.message", nonCodeUsages);
            String[] options = new String[]{OCRefactoringBundle.message("button.view.usages", new Object[0]), OCRefactoringBundle.message("button.cancel", new Object[0]), OCRefactoringBundle.message("button.rename.code", new Object[0]), OCRefactoringBundle.message("button.rename.all", new Object[0])};
            int code = Messages.showDialog((String)message, (String)RefactoringBundle.message((String)"rename.title"), (String[])options, (int)0, (int)2, (Icon)Messages.getQuestionIcon(), null);
            if (code == 3) {
                RenameUsages renameUsages = RenameUsages.RENAME;
                if (renameUsages == null) {
                    OCRenameProcessor.$$$reportNull$$$0(36);
                }
                return renameUsages;
            }
            if (code == 2) {
                refUsages.set((Object)ContainerUtil.filter((Object[])((UsageInfo[])refUsages.get()), info -> !(info instanceof NonCodeUsageInfo)).toArray(UsageInfo.EMPTY_ARRAY));
                RenameUsages renameUsages = RenameUsages.RENAME;
                if (renameUsages == null) {
                    OCRenameProcessor.$$$reportNull$$$0(37);
                }
                return renameUsages;
            }
            if (code == 0) {
                RenameUsages renameUsages = RenameUsages.SHOW_USAGES;
                if (renameUsages == null) {
                    OCRenameProcessor.$$$reportNull$$$0(38);
                }
                return renameUsages;
            }
            RenameUsages renameUsages = RenameUsages.CANCEL;
            if (renameUsages == null) {
                OCRenameProcessor.$$$reportNull$$$0(39);
            }
            return renameUsages;
        }
        RenameUsages renameUsages = RenameUsages.RENAME;
        if (renameUsages == null) {
            OCRenameProcessor.$$$reportNull$$$0(40);
        }
        return renameUsages;
    }

    private static void filterNonCodeUsages(@NotNull PsiNamedElement elementToRename, @NotNull Ref<UsageInfo[]> refUsages, boolean filterCommentAndTextUsages) {
        if (elementToRename == null) {
            OCRenameProcessor.$$$reportNull$$$0(41);
        }
        if (refUsages == null) {
            OCRenameProcessor.$$$reportNull$$$0(42);
        }
        ArrayList<UsageInfo> filteredUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            if (usageInfo instanceof NonCodeUsageInfo) {
                if (OCRenameProcessor.skipNonCodeUsage(elementToRename, usageInfo, filterCommentAndTextUsages)) continue;
                filteredUsages.add(usageInfo);
                continue;
            }
            filteredUsages.add(usageInfo);
        }
        refUsages.set((Object)filteredUsages.toArray(UsageInfo.EMPTY_ARRAY));
    }

    private static boolean skipNonCodeUsage(@NotNull PsiNamedElement elementToRename, @NotNull UsageInfo usageInfo, boolean filterCommentAndTextUsages) {
        PsiElement element;
        PsiElement parent;
        if (elementToRename == null) {
            OCRenameProcessor.$$$reportNull$$$0(43);
        }
        if (usageInfo == null) {
            OCRenameProcessor.$$$reportNull$$$0(44);
        }
        PsiElement psiElement = parent = (element = usageInfo.getElement()) != null ? element.getParent() : null;
        if (parent instanceof OCLocalizedString) {
            return true;
        }
        if (element != null && parent instanceof OCLiteralExpression && elementToRename instanceof OCLocalizedString) {
            OCReferenceElement macro;
            OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)parent, OCMacroCall.class);
            OCReferenceElement oCReferenceElement = macro = macroCall != null ? macroCall.getMacroReferenceElement() : null;
            if (macro != null && macro.getName().startsWith("NSLocalizedString")) {
                return true;
            }
        }
        for (OCRenameProcessorExtension each : OCRenameProcessorExtension.EP.getExtensionList()) {
            if (!each.skipNonCodeUsage(elementToRename, usageInfo)) continue;
            return true;
        }
        if (filterCommentAndTextUsages) {
            if (OCRenameProcessor.isUsageFromComment(usageInfo)) {
                return !RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE;
            }
            if (OCRenameProcessor.isTextUsage(usageInfo)) {
                return !RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE;
            }
        }
        return false;
    }

    private static boolean isUsageFromComment(@NotNull UsageInfo usageInfo) {
        PsiElement element;
        if (usageInfo == null) {
            OCRenameProcessor.$$$reportNull$$$0(45);
        }
        return (element = usageInfo.getElement()) != null && PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiComment.class}) != null;
    }

    private static boolean isTextUsage(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            OCRenameProcessor.$$$reportNull$$$0(46);
        }
        return usageInfo.getElement() instanceof PsiPlainText;
    }

    @NotNull
    public RenameDialog createRenameDialog(final @NotNull Project project, final @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, final @Nullable Editor editor) {
        PsiElement context;
        if (project == null) {
            OCRenameProcessor.$$$reportNull$$$0(47);
        }
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(48);
        }
        PsiElement psiElement = context = element instanceof OCDeclarator ? ((OCDeclarator)element).getExtendedContext() : element;
        if (OCCodeInsightUtil.isInObjC(context) && context instanceof OCMethod && !ApplicationManager.getApplication().isUnitTestMode()) {
            return new RenameDialog(this, project, element, nameSuggestionContext, editor){

                public void show() {
                    OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)context, context);
                    if (!OCChangeSignatureActionHandler.checkVariableArguments(context.getProject(), editor, handler)) {
                        handler.invoke();
                    }
                }
            };
        }
        return new RenameDialog(this, project, element, nameSuggestionContext, editor){
            private JBCheckBox myRenameAssociatedFileCheckbox;

            protected RenameProcessor createRenameProcessor(@NotNull String newName) {
                if (newName == null) {
                    3.$$$reportNull$$$0(0);
                }
                return new RenameProcessor(project, element, newName, this.getRefactoringScope(), this.isSearchInComments(), this.isSearchInNonJavaFiles()){

                    public boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
                        if (refUsages == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element instanceof PsiNamedElement) {
                            OCRenameProcessor.filterNonCodeUsages((PsiNamedElement)element, refUsages, false);
                        }
                        return super.preprocessUsages(refUsages);
                    }

                    public void doRun() {
                        if (OCRenameUtil.askToRenameSameEntityIfNeed(element)) {
                            super.doRun();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/jetbrains/cidr/lang/refactoring/rename/OCRenameProcessor$3$1", "preprocessUsages"));
                    }
                };
            }

            protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
                super.createCheckboxes(panel, gbConstraints);
                if (!(element instanceof OCFile)) {
                    return;
                }
                OCFile file = (OCFile)element;
                final OCRefactoringSettings settings = OCRefactoringSettings.getInstance();
                if (!OCRenameUtil.isInProjectSources(file)) {
                    settings.RENAME_ASSOCIATED_FILES = false;
                    return;
                }
                this.myRenameAssociatedFileCheckbox = new JBCheckBox(OCRefactoringBundle.message("refactoring.rename.associated.file", new Object[0]), settings.RENAME_ASSOCIATED_FILES);
                this.myRenameAssociatedFileCheckbox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        settings.RENAME_ASSOCIATED_FILES = myRenameAssociatedFileCheckbox.isSelected();
                    }
                });
                panel.add((Component)this.myRenameAssociatedFileCheckbox, gbConstraints);
            }

            protected boolean areButtonsValid() {
                PsiElement psiElement = this.getPsiElement();
                if (psiElement.getContainingFile() instanceof OCFile) {
                    OCLanguageKind languageKind = ((OCFile)psiElement.getContainingFile()).getKind();
                    if (OCNamesValidator.isIdentifier(this.getNewName(), languageKind)) {
                        return true;
                    }
                }
                return super.areButtonsValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/jetbrains/cidr/lang/refactoring/rename/OCRenameProcessor$3", "createRenameProcessor"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18, 19, 34, 35, 36, 37, 38, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 9: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/rename/OCRenameProcessor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 32: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 33: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/rename/OCRenameProcessor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "validateUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareAssociatedSymbols";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareInstanceVariable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareProperty";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassAlias";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getElementToSearchInStringsAndComments";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "validateUsages";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "filterNonCodeUsages";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "skipNonCodeUsage";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isUsageFromComment";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isTextUsage";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18, 19, 34, 35, 36, 37, 38, 39, 40 -> new IllegalStateException(string);
        };
    }

    static interface AssociatedElementsProcessor {
        public boolean processIvar(OCInstanceVariableSymbol var1, OCPropertySymbol var2);

        public boolean processPropertyAccessors(OCPropertySymbol var1);

        public boolean processProperty(OCPropertySymbol var1, OCSymbol var2);

        public boolean processClassAlias(OCClassSymbol var1, OCCompatibilityAliasSymbol var2);

        public boolean processClass(OCCompatibilityAliasSymbol var1, OCClassSymbol var2);
    }

    public static enum RenameUsages {
        RENAME,
        CANCEL,
        SHOW_USAGES;

    }
}

