/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardDetector;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCHeaderGuardElementManipulator
extends AbstractElementManipulator<OCReferenceElementImpl> {
    @Nullable
    public OCReferenceElementImpl handleContentChange(@NotNull OCReferenceElementImpl element, @NotNull TextRange range, String newName) throws IncorrectOperationException {
        OCHeaderGuardInfo headerGuard;
        OCDirective parentDirective;
        if (element == null) {
            OCHeaderGuardElementManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            OCHeaderGuardElementManipulator.$$$reportNull$$$0(1);
        }
        if ((parentDirective = (OCDirective)PsiTreeUtil.getParentOfType((PsiElement)element, OCDirective.class)) == null) {
            return element;
        }
        IElementType elementType = OCElementUtil.getElementType(parentDirective.getHeaderToken());
        if ((elementType == OCLexerTokenTypes.IFNDEF_DIRECTIVE || elementType == OCLexerTokenTypes.IF_DIRECTIVE) && (headerGuard = OCHeaderGuardDetector.findCachedHeaderGuard(parentDirective.getContainingFile(), false)) != null && headerGuard.getBeginIfndefDirective() == parentDirective && headerGuard.getEndifDirective() != null) {
            OCHeaderGuardElementManipulator.tryToReplaceTrailingComment(headerGuard.getEndifDirective(), headerGuard.getHeaderGuardName(), newName);
        }
        return element;
    }

    private static void tryToReplaceTrailingComment(@NotNull OCDirective endifDirective, @NotNull String oldHeaderGuardName, @NotNull String newHeaderGuardName) {
        PsiComment trailingComment;
        if (endifDirective == null) {
            OCHeaderGuardElementManipulator.$$$reportNull$$$0(2);
        }
        if (oldHeaderGuardName == null) {
            OCHeaderGuardElementManipulator.$$$reportNull$$$0(3);
        }
        if (newHeaderGuardName == null) {
            OCHeaderGuardElementManipulator.$$$reportNull$$$0(4);
        }
        if ((trailingComment = (PsiComment)PsiTreeUtil.findChildOfType((PsiElement)endifDirective, PsiComment.class)) == null) {
            return;
        }
        String oldCommentText = OCElementUtil.getCommentText(trailingComment);
        IElementType elementType = trailingComment.getNode().getElementType();
        Language language = trailingComment.getLanguage();
        if (!oldCommentText.trim().equals(oldHeaderGuardName)) {
            return;
        }
        PsiParserFacade parserFacade = PsiParserFacade.getInstance((Project)endifDirective.getProject());
        String newCommentText = oldCommentText.replace(oldHeaderGuardName, newHeaderGuardName);
        if (elementType == OCLexerTokenTypes.EOL_COMMENT) {
            PsiComment newComment = parserFacade.createLineCommentFromText(language, newCommentText);
            trailingComment.replace((PsiElement)newComment);
        } else if (elementType == OCLexerTokenTypes.BLOCK_COMMENT) {
            PsiComment newComment = parserFacade.createBlockCommentFromText(language, newCommentText);
            trailingComment.replace((PsiElement)newComment);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endifDirective";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldHeaderGuardName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHeaderGuardName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/rename/OCHeaderGuardElementManipulator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleContentChange";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "tryToReplaceTrailingComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

