/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.refactoring.move.OCCopyMoveProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class OCMoveFilesHandlerDelegate<M, R, G extends R, P, RTP, RPP>
extends MoveFilesOrDirectoriesHandler {
    private static Predicate<? super MultiMap<PsiElement, String>> ourShowConflictsFunction;

    @TestOnly
    public static void setShowConflictsFunctionInTests(Predicate<? super MultiMap<PsiElement, String>> conflictsFunction, @NotNull Disposable disposable) {
        if (disposable == null) {
            OCMoveFilesHandlerDelegate.$$$reportNull$$$0(0);
        }
        ourShowConflictsFunction = conflictsFunction;
        Disposer.register((Disposable)disposable, () -> {
            ourShowConflictsFunction = null;
        });
    }

    public void doMove(final Project project, final PsiElement[] elements, PsiElement targetContainer, final MoveCallback callback) {
        if (targetContainer == null) {
            for (PsiElement element : elements) {
                if (!this.skipElement(element)) continue;
                return;
            }
            PsiDirectory initialTargetDirectory = MoveFilesOrDirectoriesUtil.getInitialTargetDirectory(null, (PsiElement[])elements);
            new MoveFilesOrDirectoriesDialog(project, elements, initialTargetDirectory){

                protected void performMove(@NotNull PsiDirectory targetDirectory) {
                    if (targetDirectory == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    OCMoveFilesHandlerDelegate.this.doMove(project, elements, (PsiElement)targetDirectory, callback);
                    this.closeOKAction();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/jetbrains/cidr/lang/refactoring/move/handlers/OCMoveFilesHandlerDelegate$1", "performMove"));
                }
            }.show();
            return;
        }
        new OCCopyMoveProcessor<M, R, G, P>(elements){

            @Override
            protected void doActionForExternalFiles(Project project2, @NotNull P projectFile, @NotNull List<VirtualFile> notInProjectFiles, @Nullable G targetGroup, @NotNull PsiDirectory targetDirectory) {
                if (projectFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notInProjectFiles == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (targetDirectory == null) {
                    2.$$$reportNull$$$0(2);
                }
                WriteCommandAction.writeCommandAction((Project)project2).run(() -> {
                    Set paths = CollectionFactory.createFilePathSet();
                    for (VirtualFile file : notInProjectFiles) {
                        VfsUtilCore.processFilesRecursively((VirtualFile)file, file1 -> paths.add(file1.getPath()));
                    }
                    OCMoveFilesHandlerDelegate.this.removePaths(paths, projectFile);
                });
                ProjectUtil.focusProjectWindow((Project)project2, (boolean)true);
                OCMoveFilesHandlerDelegate.this.addFiles(project2, projectFile, notInProjectFiles, targetGroup, targetDirectory);
            }

            @Override
            protected void doAction(@NotNull OCCopyMoveProcessor.Helper<M, R, G, P> helper, @NotNull P projectFile, final @NotNull PsiDirectory targetDir, final @NotNull G targetGroup, @NotNull List<R> sourceRefs) {
                boolean canRefactor;
                Object targetProvider;
                if (helper == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (projectFile == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (targetDir == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (targetGroup == null) {
                    2.$$$reportNull$$$0(6);
                }
                if (sourceRefs == null) {
                    2.$$$reportNull$$$0(7);
                }
                if ((targetProvider = OCMoveFilesHandlerDelegate.this.getTargetProvider(sourceRefs, targetGroup)) == null) {
                    return;
                }
                MultiMap conflicts = new MultiMap();
                final Object manipulator = helper.getManipulator(projectFile);
                final Completer completer = new Completer(OCMoveFilesHandlerDelegate.this, helper, manipulator);
                SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)targetDir.getProject());
                for (final Object sourceRef : sourceRefs) {
                    PsiFileSystemItem sourceElement = OCMoveFilesHandlerDelegate.this.findPsiFileItemToMove(sourceRef);
                    if (OCMoveFilesHandlerDelegate.this.isValid(sourceRef) && OCMoveFilesHandlerDelegate.this.isValid(targetGroup)) {
                        final String srcPath = OCMoveFilesHandlerDelegate.this.getPath(sourceRef);
                        if (sourceElement == null || srcPath == null) continue;
                        String errorMessage = 2.checkOperationIsValid(sourceElement, targetDir, sourceElement.getName(), false, true);
                        if (errorMessage == null) {
                            SmartPsiElementPointer pointer = pointerManager.createSmartPsiElementPointer((PsiElement)sourceElement);
                            completer.addTask(() -> {
                                final PsiFileSystemItem validSourceElement = (PsiFileSystemItem)pointer.getElement();
                                if (validSourceElement == null) {
                                    return;
                                }
                                new MoveFilesOrDirectoriesProcessor(project, new PsiElement[]{validSourceElement}, targetDir, RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE, false, false, new MoveCallback(){

                                    public void refactoringCompleted() {
                                        VirtualFile dstVFile;
                                        DocumentReference ref = DocumentReferenceManager.getInstance().create(targetDir.getVirtualFile());
                                        UndoManager.getInstance((Project)project).nonundoableActionPerformed(ref, true);
                                        PsiDirectory newFile = validSourceElement.isDirectory() ? targetDir.findSubdirectory(validSourceElement.getName()) : targetDir.findFile(validSourceElement.getName());
                                        VirtualFile virtualFile = dstVFile = newFile == null ? null : newFile.getVirtualFile();
                                        if (dstVFile != null) {
                                            String dstPath = dstVFile.getPath();
                                            Object pathProvider = OCMoveFilesHandlerDelegate.this.getReferencePathProviderForCopying(dstPath, srcPath);
                                            OCMoveFilesHandlerDelegate.this.moveReference(manipulator, sourceRef, pathProvider, targetGroup, targetProvider);
                                        }
                                        WriteAction.run(() -> {
                                            completer.oneTaskExecuted();
                                            if (callback != null) {
                                                callback.refactoringCompleted();
                                            }
                                        });
                                    }
                                }, null).run();
                            });
                            continue;
                        }
                        if (OCMoveFilesHandlerDelegate.this.isFilesView(project)) {
                            conflicts.putValue((Object)sourceElement, (Object)(errorMessage + ". File won't be moved."));
                            continue;
                        }
                        conflicts.putValue((Object)sourceElement, (Object)(errorMessage + ". File won't be moved, only reference will be changed."));
                        completer.addTask(() -> WriteAction.run(() -> {
                            OCMoveFilesHandlerDelegate.this.moveReference(manipulator, sourceRef, OCMoveFilesHandlerDelegate.this.getIdPathProvider(), targetGroup, targetProvider);
                            completer.oneTaskExecuted();
                        }));
                        continue;
                    }
                    completer.addTask(() -> WriteAction.run(() -> {
                        OCMoveFilesHandlerDelegate.this.moveReference(manipulator, sourceRef, OCMoveFilesHandlerDelegate.this.getIdPathProvider(), targetGroup, targetProvider);
                        completer.oneTaskExecuted();
                    }));
                }
                boolean bl = canRefactor = !completer.isEmpty();
                if (!conflicts.isEmpty()) {
                    canRefactor = ourShowConflictsFunction != null ? (canRefactor &= ourShowConflictsFunction.test((MultiMap<PsiElement, String>)conflicts)) : (canRefactor &= new ConflictsDialog(project, conflicts, null, canRefactor, false).showAndGet());
                }
                if (canRefactor) {
                    completer.executeTasks();
                }
            }

            @Override
            protected OCCopyMoveProcessor.Helper<M, R, G, P> getHelper() {
                return OCMoveFilesHandlerDelegate.this.getHelper();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "notInProjectFiles";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetDirectory";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "helper";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetDir";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetGroup";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sourceRefs";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/move/handlers/OCMoveFilesHandlerDelegate$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doActionForExternalFiles";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doAction";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.process(project, targetContainer);
    }

    protected abstract boolean isFilesView(Project var1);

    protected abstract boolean skipElement(PsiElement var1);

    protected abstract RPP getReferencePathProviderForCopying(String var1, String var2);

    protected abstract RPP getIdPathProvider();

    protected abstract boolean isValid(R var1);

    protected abstract String getPath(R var1);

    protected abstract PsiFileSystemItem findPsiFileItemToMove(R var1);

    protected abstract void addFiles(Project var1, P var2, List<VirtualFile> var3, G var4, PsiDirectory var5);

    protected abstract void removePaths(Set<String> var1, P var2);

    protected abstract OCCopyMoveProcessor.Helper<M, R, G, P> getHelper();

    @NotNull
    protected abstract List<?> moveReference(@NotNull M var1, @NotNull R var2, @NotNull RPP var3, @NotNull G var4, @NotNull RTP var5);

    @Nullable
    protected abstract RTP getTargetProvider(@NotNull List<R> var1, @NotNull G var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/cidr/lang/refactoring/move/handlers/OCMoveFilesHandlerDelegate", "setShowConflictsFunctionInTests"));
    }

    private class Completer {
        private final ArrayList<Runnable> myRefactorings = new ArrayList();
        private volatile int myCounter = 0;
        private final OCCopyMoveProcessor.Helper<M, R, G, P> myHelper;
        private final M myManipulator;

        Completer(OCMoveFilesHandlerDelegate oCMoveFilesHandlerDelegate, OCCopyMoveProcessor.Helper<M, R, G, P> helper, M manipulator) {
            this.myHelper = helper;
            this.myManipulator = manipulator;
        }

        void addTask(Runnable refactoring) {
            this.myRefactorings.add(refactoring);
            ++this.myCounter;
        }

        boolean isEmpty() {
            return this.myCounter == 0;
        }

        void executeTasks() {
            for (Runnable refactoring : this.myRefactorings) {
                refactoring.run();
            }
        }

        void oneTaskExecuted() {
            --this.myCounter;
            if (this.myCounter == 0) {
                this.myHelper.completeManipulation(this.myManipulator);
            }
        }
    }
}

