/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.CommonBundle;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCCopyMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameProcessor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class OCCopyFilesHandlerDelegate<M, R, G extends R, P>
extends CopyFilesOrDirectoriesHandler {
    protected abstract void addTargets(Set<String> var1, R var2);

    protected abstract void addFiles(PsiDirectory var1, G var2, List<VirtualFile> var3, Set<String> var4);

    protected abstract boolean skipElement(PsiElement var1);

    protected abstract OCCopyMoveProcessor.Helper<M, R, G, P> getHelper();

    public void doCopy(PsiElement[] elements, PsiDirectory targetDirectory) {
        PsiDirectory defaultDirectory;
        if (elements.length == 0) {
            return;
        }
        String newName = null;
        PsiDirectory psiDirectory = defaultDirectory = elements[0] instanceof PsiDirectory ? ((PsiDirectory)elements[0]).getParentDirectory() : elements[0].getContainingFile().getContainingDirectory();
        if (targetDirectory == null || targetDirectory.equals((Object)defaultDirectory)) {
            CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog(elements, defaultDirectory, elements[0].getProject(), false);
            if (dialog.showAndGet()) {
                targetDirectory = dialog.getTargetDirectory();
                newName = dialog.getNewName();
            } else {
                return;
            }
        }
        new MyProcessor(elements, newName).process(elements[0].getProject(), (PsiElement)targetDirectory);
    }

    @TestOnly
    public void doCloneForTest(PsiElement element) {
        PsiDirectory targetDirectory = element instanceof PsiDirectory ? ((PsiDirectory)element).getParentDirectory() : ((PsiFile)element).getContainingDirectory();
        PsiElement[] elements = new PsiElement[]{element};
        final HashMap filesMap = new HashMap();
        final SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)element.getProject());
        new MyProcessor(this, elements, "CloneTest"){

            @Override
            protected void cloneClass(OCFile oldFile, OCFile newFile) {
                super.cloneClass(oldFile, newFile);
                filesMap.put(pointerManager.createSmartPsiElementPointer((PsiElement)oldFile), pointerManager.createSmartPsiElementPointer((PsiElement)newFile));
            }
        }.process(element.getProject(), (PsiElement)targetDirectory);
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (SmartPsiElementPointer oldFilePointer : filesMap.keySet()) {
                OCFile newFile = (OCFile)((SmartPsiElementPointer)filesMap.get(oldFilePointer)).getElement();
                OCFile oldFile = (OCFile)oldFilePointer.getElement();
                assert (newFile != null && oldFile != null);
                OCChangeUtil.changeText(element.getProject(), oldFile, 0, oldFile.getTextLength(), newFile.getText(), true);
            }
        });
    }

    public void doClone(PsiElement element) {
        PsiDirectory targetDirectory = element instanceof PsiDirectory ? ((PsiDirectory)element).getParentDirectory() : ((PsiFile)element).getContainingDirectory();
        PsiElement[] elements = new PsiElement[]{element};
        CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog(elements, null, element.getProject(), true);
        if (dialog.showAndGet()) {
            new MyProcessor(elements, dialog.getNewName()).process(element.getProject(), (PsiElement)targetDirectory);
        }
    }

    private class MyProcessor
    extends OCCopyMoveProcessor<M, R, G, P> {
        private final String myNewName;

        private MyProcessor(PsiElement[] elements, String newName) {
            super(elements);
            this.myNewName = newName;
        }

        @Override
        protected void doActionForExternalFiles(Project project, @NotNull P projectFile, @NotNull List<VirtualFile> notInProjectFiles, G targetGroup, @NotNull PsiDirectory targetDirectory) {
            if (projectFile == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            if (notInProjectFiles == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            if (targetDirectory == null) {
                MyProcessor.$$$reportNull$$$0(2);
            }
            WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                try {
                    for (VirtualFile file : notInProjectFiles) {
                        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                        if (psiFile == null) continue;
                        this.doCopy(targetDirectory, (PsiFileSystemItem)psiFile);
                    }
                }
                catch (IOException e) {
                    Messages.showErrorDialog((String)OCBundle.message("copy.files.handler.fail", targetDirectory.getName()), (String)CommonBundle.getErrorTitle());
                }
            });
        }

        @Override
        protected void doAction(@NotNull OCCopyMoveProcessor.Helper<M, R, G, P> helper, @NotNull P projectFile, @NotNull PsiDirectory targetDir, @NotNull G targetRef, @NotNull List<R> sourceRefs) {
            if (helper == null) {
                MyProcessor.$$$reportNull$$$0(3);
            }
            if (projectFile == null) {
                MyProcessor.$$$reportNull$$$0(4);
            }
            if (targetDir == null) {
                MyProcessor.$$$reportNull$$$0(5);
            }
            if (targetRef == null) {
                MyProcessor.$$$reportNull$$$0(6);
            }
            if (sourceRefs == null) {
                MyProcessor.$$$reportNull$$$0(7);
            }
            ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>();
            ArrayList<PsiFile> filesToReveal = new ArrayList<PsiFile>();
            try {
                for (PsiElement element : this.myElements) {
                    PsiFile newFile;
                    PsiManager psiManager = element.getManager();
                    if (element instanceof PsiFile) {
                        element = psiManager.findFile(((PsiFile)element).getVirtualFile());
                    }
                    if (OCCopyFilesHandlerDelegate.this.skipElement(element) || !(element instanceof PsiFile) && !(element instanceof PsiDirectory) || (newFile = this.doCopy(targetDir, (PsiFileSystemItem)element)) == null) continue;
                    if (element instanceof OCFile && this.myNewName != null && !this.myNewName.equals(((PsiFileSystemItem)element).getName()) && StringUtil.isJavaIdentifier((String)FileUtilRt.getNameWithoutExtension((String)this.myNewName))) {
                        PsiFile restoredElement = psiManager.findFile(((OCFile)element).getVirtualFile());
                        PsiFile restoredNewFile = psiManager.findFile(newFile.getVirtualFile());
                        if (restoredElement != null && restoredNewFile != null) {
                            WriteAction.run(() -> this.cloneClass((OCFile)restoredElement, (OCFile)restoredNewFile));
                        }
                    }
                    filesToReveal.add(newFile);
                    VirtualFile newVirtualFile = element instanceof PsiFile ? newFile.getVirtualFile() : newFile.getContainingDirectory().getVirtualFile();
                    if (newVirtualFile == null) continue;
                    newFiles.add(newVirtualFile);
                }
                HashSet<String> targets = new HashSet<String>();
                for (Object ref : sourceRefs) {
                    OCCopyFilesHandlerDelegate.this.addTargets(targets, ref);
                }
                if (!newFiles.isEmpty()) {
                    OCCopyFilesHandlerDelegate.this.addFiles(targetDir, targetRef, newFiles, targets);
                }
                for (PsiFile file : filesToReveal) {
                    EditorHelper.openInEditor((PsiElement)file);
                }
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)OCBundle.message("copy.files.handler.fail", targetDir.getName()), (String)CommonBundle.getErrorTitle());
            }
        }

        protected void cloneClass(OCFile oldFile, OCFile newFile) {
            OCSymbolDeclarator oldClazz = oldFile.findClass(oldFile.getMainClassName());
            Project project = oldFile.getProject();
            if (oldClazz == null) {
                OCFile associatedFile = oldFile.getAssociatedFile();
                OCSymbolDeclarator oCSymbolDeclarator = oldClazz = associatedFile != null ? associatedFile.findClass(oldFile.getMainClassName()) : null;
            }
            if (oldClazz == null) {
                return;
            }
            OCRenameProcessor processor2 = new OCRenameProcessor();
            LocalSearchScope scope = new LocalSearchScope((PsiElement)oldFile);
            ArrayList<Integer> offsets = new ArrayList<Integer>();
            VirtualFile virtualFile = oldFile.getVirtualFile();
            Object symbol = oldClazz.getSymbol();
            for (PsiReference reference : processor2.findReferences(oldClazz, (SearchScope)scope, false)) {
                offsets.add(reference.getElement().getTextOffset() + reference.getRangeInElement().getStartOffset());
            }
            for (PsiReference reference : processor2.findReferences(oldFile.getAssociatedFile(), (SearchScope)scope, false)) {
                offsets.add(reference.getElement().getTextOffset() + reference.getRangeInElement().getStartOffset());
            }
            if (symbol instanceof OCStructSymbol && virtualFile != null) {
                ((OCStructSymbol)symbol).processConstructors((Processor<? super OCFunctionSymbol>)((Processor)symbol12 -> {
                    if (virtualFile.equals(symbol12.getContainingFile())) {
                        offsets.add(symbol12.getOffset());
                    }
                    return true;
                }));
            }
            if (symbol != null && virtualFile != null) {
                symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
                    if (virtualFile.equals(symbol1.getContainingFile())) {
                        offsets.add(symbol1.getOffset());
                    }
                    return true;
                }), project);
            }
            offsets.sort(Comparator.reverseOrder());
            String oldName = ((PsiNamedElement)oldClazz).getName();
            String newName = FileUtilRt.getNameWithoutExtension((String)this.myNewName);
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)newFile);
            if (document != null) {
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                for (Integer offset : offsets) {
                    document.replaceString(offset.intValue(), offset + oldName.length(), (CharSequence)newName);
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            }
        }

        private PsiFile doCopy(PsiDirectory targetDir, PsiFileSystemItem fileSystemItem) throws IOException {
            Object newName = this.myNewName == null ? fileSystemItem.getName() : (this.isAssociatedFile(fileSystemItem) ? FileUtilRt.getNameWithoutExtension((String)this.myNewName) + "." + FileUtilRt.getExtension((String)fileSystemItem.getName()) : this.myNewName);
            Object newUniqueName = newName;
            String errorMessage = OCCopyMoveProcessor.checkOperationIsValid(fileSystemItem, targetDir, (String)newUniqueName, true, false);
            if (errorMessage != null) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)errorMessage, (String)CommonBundle.getErrorTitle()));
                return null;
            }
            int i = 1;
            while (OCCopyMoveProcessor.checkOperationIsValid(fileSystemItem, targetDir, (String)newUniqueName, false, false) != null) {
                newUniqueName = FileUtilRt.getNameWithoutExtension((String)newName) + " copy";
                if (i > 1) {
                    newUniqueName = (String)newUniqueName + " " + i;
                }
                newUniqueName = (String)newUniqueName + "." + FileUtilRt.getExtension((String)newName);
                ++i;
            }
            return CopyFilesOrDirectoriesHandler.copyToDirectory((PsiFileSystemItem)fileSystemItem, (String)newUniqueName, (PsiDirectory)targetDir);
        }

        private boolean isAssociatedFile(@Nullable PsiFileSystemItem file) {
            if (!(file instanceof OCFile)) {
                return false;
            }
            OCFile restoredFile = (OCFile)file.getManager().findFile(file.getVirtualFile());
            if (restoredFile == null) {
                return false;
            }
            OCFile associatedFile = restoredFile.getAssociatedFile();
            if (associatedFile == null) {
                return false;
            }
            VirtualFile associatedVirtualFile = associatedFile.getVirtualFile();
            return ContainerUtil.exists((Iterable)this.myElements, it -> it instanceof OCFile && associatedVirtualFile.equals(((OCFile)it).getVirtualFile()));
        }

        @Override
        protected OCCopyMoveProcessor.Helper<M, R, G, P> getHelper() {
            return OCCopyFilesHandlerDelegate.this.getHelper();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notInProjectFiles";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetDirectory";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetDir";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRef";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRefs";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/move/handlers/OCCopyFilesHandlerDelegate$MyProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doActionForExternalFiles";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

