/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineActionHandlerBase;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class OCInlineTypedefHandler
extends OCInlineActionHandlerBase<OCDeclarator> {
    @Override
    protected String getElementKind(OCDeclarator element) {
        return "typedef";
    }

    public boolean canInlineElement(PsiElement element) {
        PsiElement parent;
        if (element instanceof OCDeclarator && (parent = element.getParent()) instanceof OCDeclaration) {
            return ((OCDeclaration)parent).isTypedef();
        }
        return false;
    }

    @Override
    protected String checkUsageValid(PsiElement usage, OCDeclarator typedefDeclarator) {
        OCStructLike structDefinition;
        OCType typedefType = typedefDeclarator.getType();
        OCTypeElement usageTypeElement = (OCTypeElement)PsiTreeUtil.getParentOfType((PsiElement)usage, OCTypeElement.class);
        if (typedefType.getTerminalType() instanceof OCFunctionType) {
            return OCRefactoringBundle.message("cannot.inline.function.type", new Object[0]);
        }
        OCCallExpression callExpression = (OCCallExpression)PsiTreeUtil.getParentOfType((PsiElement)usage, OCCallExpression.class);
        if (callExpression != null && (typedefType.getCVQualifiers() != CVQualifiers.EMPTY || !(typedefType instanceof OCReferenceType) && !(typedefType instanceof OCNumericType))) {
            return OCRefactoringBundle.message("cannot.inline.constructor.expression", new Object[0]);
        }
        OCDeclaration typedefDeclaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)typedefDeclarator, OCDeclaration.class);
        if (typedefDeclaration != null && (structDefinition = (OCStructLike)ContainerUtil.getFirstItem((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)typedefDeclaration.getTypeElement(), OCStructLike.class))) != null && structDefinition.isDeclaration()) {
            return OCRefactoringBundle.message("can.t.inline.definition", StringUtil.wrapWithDoubleQuote((String)StringUtil.toLowerCase((String)structDefinition.getKind().getName())));
        }
        return null;
    }

    @Override
    protected void inlineUsage(PsiElement usage, OCDeclarator element, PsiElement elementData, Project project, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        if (usage instanceof OCCppNamespaceQualifier) {
            OCResolveContext context = OCResolveContext.forPsi(usage);
            OCCppNamespaceQualifier qualifier = OCElementFactory.declarationFromText("int " + element.getType().getCanonicalName(context) + "::x;", usage).getDeclarators().get(0).getNamespaceQualifier();
            OCChangeUtil.replaceHandlingMacros(usage, qualifier);
            return;
        }
        if (!(usage instanceof OCReferenceElement)) {
            return;
        }
        OCTypeElement usageTypeElement = (OCTypeElement)PsiTreeUtil.getParentOfType((PsiElement)usage, OCTypeElement.class);
        OCSymbol typedefSymbol = element.getSymbol();
        OCType typedefType = element.getType();
        PsiFile containingFile = element.getContainingFile();
        if (usageTypeElement == null || typedefSymbol == null) {
            OCCallExpression callExpression = (OCCallExpression)PsiTreeUtil.getParentOfType((PsiElement)usage, OCCallExpression.class);
            if (callExpression == null) {
                return;
            }
            OCExpression newExpression = OCElementFactory.expressionFromText(typedefType.getBestNameInContext(usage), usage, false);
            if (newExpression != null) {
                OCChangeUtil.replaceHandlingMacros(callExpression.getFunctionReferenceExpression(), newExpression);
            }
            return;
        }
        PsiElement psiElement = usageTypeElement.getParent();
        if (psiElement instanceof OCParameterDeclaration) {
            OCParameterDeclaration paramDeclaration = (OCParameterDeclaration)psiElement;
            paramDeclarator = paramDeclaration.getDeclarators().get(0);
            OCType newParamType = OCInlineTypedefHandler.transformType(typedefSymbol, typedefType, paramDeclarator.getType(), containingFile, project);
            OCParameterDeclaration newParamDeclaration = OCElementFactory.paramDeclarationByNameAndType(paramDeclarator.getName(), newParamType, paramDeclarator.getInitializer(), paramDeclarator);
            OCInlineTypedefHandler.replaceDeclaration(paramDeclaration, newParamDeclaration);
        } else {
            paramDeclarator = usageTypeElement.getParent();
            if (paramDeclarator instanceof OCFunctionDeclaration) {
                OCFunctionDeclaration functionDeclaration = (OCFunctionDeclaration)paramDeclarator;
                newType = OCInlineTypedefHandler.transformType(typedefSymbol, typedefType, functionDeclaration.getReturnType(), containingFile, project);
                OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(((OCType)newType).getBestNameInContext(usage), usage);
                OCInlineTypedefHandler.replaceReturnType(functionDeclaration, newTypeElement);
            } else if (usageTypeElement.getParent() instanceof OCDeclaration) {
                for (OCDeclaration declaration : OCNormalizeUtil.normalizeDeclaration((OCDeclaration)usageTypeElement.getParent())) {
                    OCDeclarator declarator = declaration.getDeclarators().get(0);
                    OCType newDeclType = OCInlineTypedefHandler.transformType(typedefSymbol, typedefType, declarator.getType(), containingFile, project);
                    OCDeclaration newDeclaration = OCElementFactory.declarationStatement(null, declarator.getName(), newDeclType, declarator.getInitializer(), declarator.getInitializerList(), declarator.getArgumentList(), declarator).getDeclaration();
                    OCInlineTypedefHandler.replaceDeclaration(declaration, newDeclaration);
                }
            } else {
                newType = OCInlineTypedefHandler.transformType(typedefSymbol, typedefType, usageTypeElement.getType(), usageTypeElement.getContainingFile(), project);
                OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(((OCType)newType).getBestNameInContext(usage), usage);
                OCChangeUtil.replaceHandlingMacros(usageTypeElement, newTypeElement);
            }
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.inlineTypedef";
    }

    private static void replaceReturnType(@NotNull OCFunctionDeclaration functionDeclaration, @NotNull OCTypeElement newReturnTypeElement) {
        ASTNode node;
        IElementType elementType;
        OCDeclarator functionDeclarator;
        if (functionDeclaration == null) {
            OCInlineTypedefHandler.$$$reportNull$$$0(0);
        }
        if (newReturnTypeElement == null) {
            OCInlineTypedefHandler.$$$reportNull$$$0(1);
        }
        if ((functionDeclarator = functionDeclaration.getDeclarator()) == null) {
            return;
        }
        ASTNode[] aSTNodeArray = functionDeclarator.getNode().getChildren(null);
        int n = aSTNodeArray.length;
        for (int i = 0; i < n && (elementType = (node = aSTNodeArray[i]).getElementType()) != OCLexerTokenTypes.IDENTIFIER && elementType != OCLexerTokenTypes.OPERATOR_CPP_KEYWORD; ++i) {
            if (!OCLexerTokenTypes.DECLARATOR_MODIFIERS.contains(elementType)) continue;
            functionDeclarator.getNode().removeChild(node);
        }
        OCChangeUtil.replaceHandlingMacros(functionDeclaration.getReturnTypeElement(), newReturnTypeElement);
    }

    private static void replaceDeclaration(@NotNull OCDeclaration oldDeclaration, @NotNull OCDeclaration newDeclaration) {
        if (oldDeclaration == null) {
            OCInlineTypedefHandler.$$$reportNull$$$0(2);
        }
        if (newDeclaration == null) {
            OCInlineTypedefHandler.$$$reportNull$$$0(3);
        }
        OCElementUtil.replaceDeclarationQualifiers(newDeclaration, oldDeclaration);
        OCElementUtil.replaceDeclarationQualifiers(newDeclaration.getTypeElement(), oldDeclaration.getTypeElement());
        OCChangeUtil.replaceHandlingMacros(oldDeclaration, newDeclaration);
    }

    private static OCType transformType(final OCSymbol symbol, final OCType elementType, OCType usageType, final PsiFile containingFile, final @NotNull Project project) {
        if (project == null) {
            OCInlineTypedefHandler.$$$reportNull$$$0(4);
        }
        return usageType.transformType(new OCTypeCloneVisitor(false){

            @Override
            public OCType visitReferenceType(OCReferenceType type) {
                List<OCSymbol> symbols = type.getReference(containingFile).resolveToSymbols(OCResolveContext.forPsi((PsiElement)containingFile));
                if (symbols.contains(symbol)) {
                    return type.isConst() ? elementType.cloneWithConstModifier(project) : elementType;
                }
                return super.visitReferenceType(type);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDeclaration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newReturnTypeElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDeclaration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDeclaration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/inline/OCInlineTypedefHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceReturnType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceDeclaration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "transformType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

