/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.ConflictsDialogBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.refactoring.OCUsageViewDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCRankedUsageInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageRank;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameProcessor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeSignatureProcessor
extends ChangeSignatureProcessorBase {
    public static final Key<Boolean> CHECK_CONFLICTS = Key.create((String)"CHECK_CONFLICTS");
    private final OCCallableKind myCallableKind;
    private final OCCallable<?> myCallable;
    private final @NlsContexts.Command String myCommandName;
    private OCRenameProcessor.RenameUsages myOption;
    private final boolean myFilterNonCodeUsages;

    protected OCChangeSignatureProcessor(Project project, OCCallableKind callableKind, OCCallable<?> callable, OCChangeInfo changeInfo, @NlsContexts.Command String commandName, boolean filterNonCodeUsages) {
        super(project, (ChangeInfo)changeInfo);
        this.myCallableKind = callableKind;
        this.myCallable = callable;
        this.myCommandName = commandName;
        this.myFilterNonCodeUsages = filterNonCodeUsages;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(0);
        }
        return new OCUsageViewDescriptor(this.myCallable, RefactoringBundle.message((String)"0.to.change.signature", (Object[])new Object[]{this.myCallableKind.toString()}));
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(1);
        }
        MultiMap conflictDescriptions = new MultiMap();
        OCChangeSignatureProcessor.collectConflictsFromExtensions(refUsages, (MultiMap)conflictDescriptions, (ChangeInfo)this.myChangeInfo);
        Object[] usagesIn = (UsageInfo[])refUsages.get();
        RenameUtil.addConflictDescriptions((UsageInfo[])usagesIn, (MultiMap)conflictDescriptions);
        HashSet usagesSet = ContainerUtil.newHashSet((Object[])usagesIn);
        RenameUtil.removeConflictUsages((Set)usagesSet);
        if (!conflictDescriptions.isEmpty() && this.myCallable.getProject().getUserData(CHECK_CONFLICTS) != Boolean.FALSE) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                StringBuilder message = new StringBuilder();
                for (String conflict : conflictDescriptions.values()) {
                    if (!message.isEmpty()) {
                        message.append("; ");
                    }
                    message.append(conflict);
                }
                throw new CommonRefactoringUtil.RefactoringErrorHintException(message.toString());
            }
            ConflictsDialogBase dialog = this.prepareConflictsDialog(conflictDescriptions, (UsageInfo[])usagesIn);
            if (!dialog.showAndGet()) {
                if (dialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        UsageInfo[] newUsages = usagesSet.toArray(UsageInfo.EMPTY_ARRAY);
        refUsages.set((Object)newUsages);
        this.prepareSuccessful();
        this.myOption = this.myChangeInfo.isNameChanged() ? OCRenameProcessor.validateUsages(this.myCallable, refUsages, this.myFilterNonCodeUsages) : OCRenameProcessor.RenameUsages.RENAME;
        return this.myOption != OCRenameProcessor.RenameUsages.CANCEL;
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(2);
        }
        return super.isPreviewUsages(usages) || this.myOption == OCRenameProcessor.RenameUsages.SHOW_USAGES;
    }

    @NotNull
    protected ConflictsDialog createConflictsDialog(final @NotNull MultiMap<PsiElement, String> conflicts, final UsageInfo[] usages) {
        if (conflicts == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(3);
        }
        return new ConflictsDialog(this.myProject, conflicts, null){

            protected Runnable getDoRefactoringRunnable(@Nullable UsageView usageView) {
                return () -> {
                    Collection<? extends UsageInfo> usagesToRefactor = OCChangeSignatureProcessor.getNonExcludedUsageInfos(usages, usageView);
                    OCChangeSignatureProcessor.this.execute(usagesToRefactor.toArray(UsageInfo.EMPTY_ARRAY));
                };
            }

            @NotNull
            protected Action getOKAction() {
                Action action = super.getOKAction();
                for (String conflict : conflicts.values()) {
                    if (OCChangeSignatureUsageProcessor.canProceedWithConflict(conflict)) continue;
                    action.setEnabled(false);
                }
                Action action2 = action;
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return action2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureProcessor$1", "getOKAction"));
            }
        };
    }

    private static Collection<? extends UsageInfo> getNonExcludedUsageInfos(UsageInfo[] usages, @Nullable UsageView usageView) {
        MultiMap result = MultiMap.createLinked();
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (element == null) continue;
            result.putValue((Object)element, (Object)usage);
        }
        if (usageView != null) {
            for (Usage usage : usageView.getExcludedUsages()) {
                if (!(usage instanceof UsageInfo2UsageAdapter)) continue;
                result.remove((Object)((UsageInfo2UsageAdapter)usage).getElement());
            }
        }
        return result.values();
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        PsiElement method;
        if (usages == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(4);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.changeSignature");
        PsiFile oldContainingFile = ((OCChangeInfo)this.myChangeInfo).getOldMethodDescriptor().getMethod().getContainingFile();
        Arrays.sort(usages, (u1, u2) -> {
            OCUsageRank rank1 = u1 instanceof OCRankedUsageInfo ? ((OCRankedUsageInfo)u1).getUsageRank() : OCUsageRank.neutral;
            OCUsageRank rank2 = u2 instanceof OCRankedUsageInfo ? ((OCRankedUsageInfo)u2).getUsageRank() : OCUsageRank.neutral;
            return rank2.compareTo(rank1);
        });
        NonCodeUsageInfo[] nonCodeUsages = ContainerUtil.filterIsInstance(Arrays.asList(usages), NonCodeUsageInfo.class).toArray(new NonCodeUsageInfo[0]);
        RenameUtil.renameNonCodeUsages((Project)this.myProject, (NonCodeUsageInfo[])nonCodeUsages);
        super.performRefactoring(usages);
        if (((OCChangeInfo)this.myChangeInfo).getGenerated().getMethodReference() == null && (method = this.myChangeInfo.getMethod()) != null && method.isValid() && !oldContainingFile.equals((Object)method.getContainingFile())) {
            OCCodeInsightUtil.selectElement(method);
        }
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(5);
        }
        ArrayList<PsiFile> elements = new ArrayList<PsiFile>();
        elements.addAll(super.getElementsToWrite(descriptor));
        elements.addAll(((OCChangeInfo)this.myChangeInfo).getGenerated().getFilesToWrite());
        ArrayList<PsiFile> arrayList = elements;
        if (arrayList == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public void runSynchronously(boolean prepare) {
        Ref refUsages = Ref.create((Object)this.findUsages());
        if (!prepare || this.preprocessUsages((Ref<UsageInfo[]>)refUsages)) {
            this.execute((UsageInfo[])refUsages.get());
        }
    }

    @NotNull
    protected String getCommandName() {
        if (this.myCommandName != null) {
            String string = this.myCommandName;
            if (string == null) {
                OCChangeSignatureProcessor.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = super.getCommandName();
        if (string == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConflictsDialog";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

