/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCConceptDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCRequiresClause;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentsOwner;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesHandler;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSafeDeleteProcessorDelegateBase
implements SafeDeleteProcessorDelegate {
    public boolean handlesElement(PsiElement element) {
        return true;
    }

    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete, @NotNull List<? super UsageInfo> result) {
        if (element == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(0);
        }
        if (result == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(1);
        }
        if (allElementsToDelete == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(2);
        }
        ArrayList usages = new ArrayList();
        SafeDeleteProcessor.findGenericElementUsages((PsiElement)element, usages, (PsiElement[])allElementsToDelete);
        result.addAll(ContainerUtil.map(usages, info -> {
            final PsiElement usageElement = info.getElement();
            if (OCSafeDeleteProcessorDelegateBase.isSafeToDelete(usageElement, element)) {
                return new SafeDeleteReferenceSimpleDeleteUsageInfo(this, usageElement, ((SafeDeleteUsageInfo)info).getReferencedElement(), true){

                    public void deleteElement() throws IncorrectOperationException {
                        OCChangeUtil.safeDeleteReference(usageElement);
                    }
                };
            }
            return info;
        }));
        if (OCSafeDeleteProcessorDelegateBase.isTemplateParameter(element)) {
            ArrayList<Pair<PsiElement, OCSymbol>> list = new ArrayList<Pair<PsiElement, OCSymbol>>();
            OCSafeDeleteProcessorDelegateBase.getElementsToDeleteForTemplateParameter(element, list);
            for (Pair pair : list) {
                result.add((UsageInfo)new SafeDeleteUsageInfo((PsiElement)pair.getFirst(), element));
            }
        }
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), element);
    }

    public static boolean isSafeToDelete(PsiElement usageElement, @Nullable PsiElement element) {
        if (usageElement instanceof OCDeclarator) {
            return true;
        }
        if (element instanceof OCStructLike || element instanceof OCCppNamespace) {
            List<OCDeclarator> declarators;
            Object structSymbol = ((OCSymbolDeclarator)element).getSymbol();
            OCElement parent = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)usageElement, (Class[])new Class[]{OCStruct.class, OCConceptDeclaration.class, OCCppNamespace.class, OCDeclarator.class, OCDeclaration.class, OCRequiresClause.class});
            if (parent instanceof OCDeclaration) {
                declarators = ((OCDeclaration)parent).getDeclarators();
            } else if (parent instanceof OCDeclarator) {
                declarators = Collections.singletonList((OCDeclarator)parent);
            } else {
                return element.equals((Object)parent);
            }
            OCResolveContext context = OCResolveContext.forPsi(element);
            for (OCDeclarator declarator : declarators) {
                OCSymbolWithQualifiedName owner;
                OCSymbol symbol = declarator.getSymbol();
                OCSymbolWithQualifiedName oCSymbolWithQualifiedName = owner = symbol instanceof OCSymbolWithQualifiedName ? ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context) : null;
                while (owner != null && !owner.equals(structSymbol)) {
                    owner = owner.getResolvedOwner(context);
                }
                if (owner != null) continue;
                return false;
            }
            return true;
        }
        if (new OCReadWriteAccessDetector().getExpressionAccess(usageElement) == ReadWriteAccessDetector.Access.Write) {
            return !(element instanceof OCMethod);
        }
        return false;
    }

    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @NotNull Collection<? extends PsiElement> allElementsToDelete) {
        if (element == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(3);
        }
        if (allElementsToDelete == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(4);
        }
        OCFindUsagesHandler handler = new OCFindUsagesHandler(element, true);
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement psiElement : handler.getPrimaryElements()) {
            if (psiElement == null) continue;
            result.add(psiElement);
        }
        for (PsiElement psiElement : handler.getSecondaryElements()) {
            if (psiElement == null) continue;
            result.add(psiElement);
        }
        result.sort(new Comparator<PsiElement>(this){

            private static int order(PsiElement element) {
                return element instanceof OCSynthesizeProperty ? 1 : 0;
            }

            @Override
            public int compare(PsiElement el1, PsiElement el2) {
                return 2.order(el1) - 2.order(el2);
            }
        });
        return result.isEmpty() ? null : result;
    }

    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<? extends PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(5);
        }
        if (allElementsToDelete == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(6);
        }
        return Collections.emptyList();
    }

    @NotNull
    public Collection<String> findConflicts(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete) {
        if (element == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(7);
        }
        if (allElementsToDelete == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(8);
        }
        if (element instanceof OCFile && ((OCFile)element).hasExtraTopLevelDefinitions()) {
            Set<CallSite> set = Collections.singleton("File \"" + ((PsiFile)element).getName() + "\" has several top level declarations.");
            if (set == null) {
                OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(9);
            }
            return set;
        }
        if (OCSafeDeleteProcessorDelegateBase.isTemplateParameter(element)) {
            ArrayList<Pair<PsiElement, OCSymbol>> list = new ArrayList<Pair<PsiElement, OCSymbol>>();
            OCSafeDeleteProcessorDelegateBase.getElementsToDeleteForTemplateParameter(element, list);
            if (!list.isEmpty()) {
                List<CallSite> list2 = Collections.singletonList(((OCSymbol)((Pair)list.get(0)).getSecond()).getNameWithKindUppercase(OCCompilationContext.create(element)) + " has usage without arguments");
                if (list2 == null) {
                    OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(10);
                }
                return list2;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(11);
        }
        return list;
    }

    public UsageInfo[] preprocessUsages(@NotNull Project project, UsageInfo @NotNull [] usages) {
        if (project == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(12);
        }
        if (usages == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(13);
        }
        return usages;
    }

    public void prepareForDeletion(@NotNull PsiElement element) throws IncorrectOperationException {
        Object symbol;
        PsiElement parent;
        if (element == null) {
            OCSafeDeleteProcessorDelegateBase.$$$reportNull$$$0(14);
        }
        if (!element.isValid()) {
            return;
        }
        if (element instanceof OCMethodSelectorPart) {
            OCMethod method = (OCMethod)element.getParent();
            OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(method, element, EnumSet.of(OCChangeSignatureActionHandler.ChangeSignatureFlags.SilentMode));
            handler.removeParameter(method.getParameters().indexOf(element));
            handler.invokeSynchronously();
        }
        if (element.getParent() instanceof OCParameterDeclaration && (parent = element.getParent().getParent()) instanceof OCParameterList) {
            OCParameterList paramList = (OCParameterList)parent;
            OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)paramList.getParent().getParent(), element, EnumSet.of(OCChangeSignatureActionHandler.ChangeSignatureFlags.SilentMode));
            handler.removeParameter(paramList.getParameters().indexOf(element));
            handler.invokeSynchronously();
        }
        if ((element instanceof OCStruct || element instanceof OCCppNamespace) && ((OCElement)element).getContainingOCFile().isCpp() && (symbol = ((OCSymbolDeclarator)element).getSymbol()) instanceof OCNamespaceSymbol) {
            ArrayList elementsToDelete = new ArrayList();
            ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol1 -> {
                PsiElement definition;
                Project project = element.getProject();
                OCSymbol definitionSymbol = symbol1.getDefinitionSymbol(project);
                PsiElement psiElement = definition = definitionSymbol != null ? definitionSymbol.locateDefinition(project) : null;
                if (definition != null && !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)definition, (boolean)true)) {
                    elementsToDelete.add(definition);
                }
                return true;
            }));
            for (PsiElement psiElement : elementsToDelete) {
                OCChangeUtil.delete(psiElement);
            }
        }
        if (OCSafeDeleteProcessorDelegateBase.isTemplateParameter(element)) {
            List<PsiElement> elementsToDelete = OCSafeDeleteProcessorDelegateBase.getElementsToDeleteForTemplateParameter(element, new ArrayList<Pair<PsiElement, OCSymbol>>());
            for (PsiElement psiElement : elementsToDelete) {
                OCChangeUtil.delete(psiElement);
            }
        }
    }

    private static List<PsiElement> getElementsToDeleteForTemplateParameter(PsiElement element, List<Pair<PsiElement, OCSymbol>> usagesWithoutArguments) {
        OCSymbol declaratorSymbol = null;
        PsiElement parameter = element instanceof OCTypeParameterDeclaration ? element : element.getParent();
        OCTemplateParameterList typeParamsList = (OCTemplateParameterList)parameter.getParent();
        PsiElement parent = typeParamsList.getParent();
        int paramIndex = typeParamsList.getParameters().indexOf(parameter);
        int paramsCnt = typeParamsList.getParameters().size();
        ArrayList<PsiElement> elementsToDelete = new ArrayList<PsiElement>();
        if (parent instanceof OCFunctionDeclaration) {
            declaratorSymbol = ((OCFunctionDeclaration)parent).getSymbol();
        } else if (parent instanceof OCDeclaration) {
            OCTypeElement typeElement = ((OCDeclaration)parent).getTypeElement();
            OCType type = typeElement != null ? typeElement.getType().resolve(element) : null;
            OCSymbol oCSymbol = declaratorSymbol = type instanceof OCStructType ? ((OCStructType)type).getSymbol() : null;
        }
        if (paramIndex != -1 && declaratorSymbol != null) {
            OCSymbol finalDeclaratorSymbol = declaratorSymbol;
            declaratorSymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
                PsiElement definition = symbol.locateDefinition(element.getProject());
                if (definition != null) {
                    ReferencesSearch.search((PsiElement)definition).forEach(reference -> {
                        PsiElement usage = reference.getElement();
                        if (!(usage instanceof OCTemplateArgumentsOwner)) {
                            OCLog.LOG.warn("Bad class: " + String.valueOf(usage.getClass()));
                            return true;
                        }
                        OCTypeArgumentList arguments = ((OCTemplateArgumentsOwner)usage).getTemplateArgumentList();
                        if (arguments == null) {
                            usagesWithoutArguments.add(Pair.create((Object)usage, (Object)finalDeclaratorSymbol));
                        } else {
                            if (paramIndex < arguments.getArguments().size()) {
                                OCElement argument = (OCElement)arguments.getArguments().get(paramIndex);
                                elementsToDelete.add(argument);
                            }
                            if (paramsCnt == 1) {
                                elementsToDelete.add(arguments);
                            }
                        }
                        return true;
                    });
                }
                return true;
            }), element.getProject());
        }
        return elementsToDelete;
    }

    private static boolean isTemplateParameter(PsiElement element) {
        return element instanceof OCTypeParameterDeclaration || element instanceof OCDeclarator && element.getParent().getParent() instanceof OCTemplateParameterList;
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElementsToDelete";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegateBase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/OCSafeDeleteProcessorDelegateBase";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findConflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToSearch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalElementsToDelete";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findConflicts";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "prepareForDeletion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

