/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Function;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCommaExpression;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;

public class OCExpressionTrimRenderer
extends OCVisitor {
    private final StringBuilder myBuf;

    public OCExpressionTrimRenderer(StringBuilder buf) {
        this.myBuf = buf;
    }

    @Override
    public void visitExpression(OCExpression expr) {
        this.myBuf.append(expr.getTextWithMacros());
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        OCTypeElement typeElement = ((OCDeclaration)declarator.getParent()).getTypeElement();
        if (typeElement != null) {
            this.myBuf.append(typeElement.getTextWithMacros()).append(' ');
        }
        this.myBuf.append(declarator.getName());
    }

    @Override
    public void visitParameterDeclaration(OCParameterDeclaration declaration) {
        OCTypeElement typeElement = declaration.getTypeElement();
        OCDeclarator declarator = declaration.getDeclarator();
        if (typeElement != null) {
            this.myBuf.append(typeElement.getTextWithMacros()).append(' ');
        }
        if (declarator != null) {
            this.myBuf.append(declarator.getName());
        }
    }

    @Override
    public void visitFunctionDefinition(OCFunctionDefinition functionDefinition) {
        this.visitFunctionDeclaration(functionDefinition);
    }

    @Override
    public void visitFunctionDeclaration(OCFunctionDeclaration declaration) {
        this.myBuf.append(declaration.getReturnTypeElement().getTextWithMacros()).append(' ');
        OCDeclarator declarator = declaration.getDeclarator();
        if (declarator != null) {
            this.myBuf.append(declarator.getName());
        }
        this.myBuf.append("(...)");
    }

    @Override
    public void visitParenthesizedExpression(OCParenthesizedExpression expression) {
        this.myBuf.append("(");
        OCExpression expr = expression.getOperand();
        if (expr != null) {
            expr.accept(this);
        }
        this.myBuf.append(")");
    }

    @Override
    public void visitCastExpression(OCCastExpression expression) {
        OCExpression operand;
        OCTypeElement castType = expression.getTypeElement();
        if (castType != null) {
            this.myBuf.append("(").append(castType.getText()).append(")");
        }
        if ((operand = expression.getOperand()) != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitArraySelectionExpression(OCArraySelectionExpression expression) {
        expression.getArrayExpression().accept(this);
        this.myBuf.append("[");
        OCExpression indexExpression = expression.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept(this);
        }
        this.myBuf.append("]");
    }

    @Override
    public void visitPrefixExpression(OCPrefixExpression expression) {
        this.myBuf.append(expression.getOperationSignNode().getText());
        OCExpression operand = expression.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitUnaryExpression(OCUnaryExpression expression) {
        this.myBuf.append(expression.getOperationSignNode().getText());
        OCExpression operand = expression.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitPostfixExpression(OCPostfixExpression expression) {
        expression.getOperand().accept(this);
        this.myBuf.append(expression.getOperationSignNode().getText());
    }

    @Override
    public void visitQualifiedExpression(OCQualifiedExpression expression) {
        expression.getQualifier().accept(this);
        this.myBuf.append('.').append(expression.getName());
    }

    @Override
    public void visitBinaryExpression(OCBinaryExpression expression) {
        OCExpression left = expression.getLeft();
        if (left != null) {
            left.accept(this);
        }
        this.myBuf.append(" ").append(expression.getOperationSignNode().getText()).append(" ");
        OCExpression rOperand = expression.getRight();
        if (rOperand != null) {
            rOperand.accept(this);
        }
    }

    @Override
    public void visitConditionalExpression(OCConditionalExpression expression) {
        expression.getCondition().accept(this);
        this.myBuf.append(" ? ");
        OCExpression thenExpression = expression.getPositiveExpression(false);
        if (thenExpression != null) {
            thenExpression.accept(this);
        }
        this.myBuf.append(" : ");
        OCExpression elseExpression = expression.getNegativeExpression();
        if (elseExpression != null) {
            elseExpression.accept(this);
        }
    }

    @Override
    public void visitAssignmentExpression(OCAssignmentExpression expression) {
        expression.getReceiverExpression().accept(this);
        this.myBuf.append(expression.getOperationSignNode().getText());
        OCExpression rExpression = expression.getSourceExpression();
        if (rExpression != null) {
            rExpression.accept(this);
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression) {
        expression.getFunctionReferenceExpression().accept(this);
        expression.getArgumentList().accept(this);
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression) {
        this.myBuf.append("[");
        OCExpression receiverExpression = expression.getReceiverExpression();
        if (receiverExpression != null) {
            receiverExpression.accept(this);
            this.myBuf.append(" ");
        }
        for (OCMessageArgument arg : expression.getArguments()) {
            String name = arg.getArgumentSelector().getSelectorName();
            if (name.isEmpty()) continue;
            this.myBuf.append(name);
            if (arg.getArgumentExpression() == null) continue;
            this.myBuf.append("... ");
        }
        this.myBuf.append("]");
    }

    @Override
    public void visitCommaExpression(OCCommaExpression expression) {
        this.myBuf.append(expression.getHeadExpression());
        this.myBuf.append(", ");
        this.myBuf.append(expression.getTailExpression());
    }

    @Override
    public void visitArgumentList(OCArgumentList list) {
        List<OCExpression> args = list.getArguments();
        if (!args.isEmpty()) {
            this.myBuf.append("(...)");
        } else {
            this.myBuf.append("()");
        }
    }

    @Override
    public void visitMacroCall(OCMacroCall macroCall) {
        OCReferenceElement refElement = macroCall.getMacroReferenceElement();
        if (refElement == null) {
            this.myBuf.append(macroCall.getText());
            return;
        }
        OCSymbol macro = refElement.resolveToSymbol();
        if (macro instanceof OCMacroSymbol) {
            this.myBuf.append(macro.getName());
            if (((OCMacroSymbol)macro).hasParameterList()) {
                this.myBuf.append("(...)");
            }
        } else {
            this.myBuf.append(macroCall.getText());
        }
    }

    public static class RenderFunction<E extends PsiElement>
    implements Function<E, String> {
        public String fun(E element) {
            StringBuilder buf = new StringBuilder();
            OCExpressionTrimRenderer visitor = new OCExpressionTrimRenderer(buf);
            OCMacroRange range = OCElementUtil.getRangeInMacroCall(element);
            if (range != null && !range.mapsToArguments()) {
                range.getMacroCall().accept(visitor);
            } else {
                element.accept((PsiElementVisitor)visitor);
            }
            return buf.toString();
        }
    }
}

