/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRemoveDeclarationIntentionAction
extends OCQuickFix {
    @IntentionName
    private final String myText;
    @IntentionFamilyName
    private final String myFamilyName;
    private final Project myProject;
    protected final OCSymbol mySymbol;
    protected final SmartPsiElementPointer<PsiElement> myElementPtr;

    public OCRemoveDeclarationIntentionAction(String whatToRemove, OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCRemoveDeclarationIntentionAction.$$$reportNull$$$0(0);
        }
        this.myElementPtr = null;
        this.mySymbol = symbol;
        this.myProject = project;
        int familyNameChoice = whatToRemove != null ? 0 : (this.parameterDeclIsRequired() ? 2 : 1);
        this.myFamilyName = OCInspectionsBundle.message((String)"intention.family.name.remove.declaration", (Object[])new Object[]{whatToRemove, familyNameChoice});
        this.myText = this.myFamilyName + " " + this.mySymbol.getNameWithKindLowercase(OCCompilationContext.create(this.mySymbol, project));
    }

    public OCRemoveDeclarationIntentionAction(String whatToRemove, @Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            OCRemoveDeclarationIntentionAction.$$$reportNull$$$0(1);
        }
        this.myElementPtr = OCElementUtil.createPsiElementPointer(element);
        this.myText = OCInspectionsBundle.message((String)"intention.name.remove", (Object[])new Object[]{whatToRemove});
        this.myFamilyName = OCInspectionsBundle.message((String)"intention.family.name.remove", (Object[])new Object[]{whatToRemove});
        this.myProject = project;
        this.mySymbol = null;
    }

    public OCRemoveDeclarationIntentionAction(OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCRemoveDeclarationIntentionAction.$$$reportNull$$$0(2);
        }
        this(null, symbol, project);
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            OCRemoveDeclarationIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean startInWriteAction() {
        return this.mySymbol == null || this.mySymbol.getKind() != OCSymbolKind.PARAMETER;
    }

    @Override
    public boolean isAvailable() {
        PsiElement element = this.getValidElementOrNull();
        if (element == null) {
            return false;
        }
        if (this.mySymbol == null) {
            return true;
        }
        if (OCCodeInsightUtil.insideConditionalHeader(element)) {
            return false;
        }
        if (OCCodeInsightUtil.insideLoopHeader(element)) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, OCForStatement.class) != null;
        }
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        PsiElement element;
        if (project == null) {
            OCRemoveDeclarationIntentionAction.$$$reportNull$$$0(4);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (this.mySymbol != null) {
            element = this.mySymbol.locateDefinition(project);
        } else {
            PsiElement el = this.myElementPtr.getElement();
            PsiElement psiElement = element = el != null ? el.getContext() : null;
        }
        if (element == null || !FileModificationService.getInstance().prepareFileForWrite(element.getContainingFile())) {
            return;
        }
        if (element instanceof OCLabeledStatement) {
            OCStatement statement = ((OCLabeledStatement)element).getStatement();
            if (statement != null) {
                element.replace((PsiElement)statement);
            } else {
                OCChangeUtil.delete(element);
            }
        } else if (this.mySymbol != null && this.mySymbol.getKind() == OCSymbolKind.PARAMETER) {
            OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
            if (callable == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> OCRemoveDeclarationIntentionAction.deleteUsages(element));
            OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(callable, callable, EnumSet.of(OCChangeSignatureActionHandler.ChangeSignatureFlags.SilentMode));
            if (this.parameterDeclIsRequired()) {
                handler.renameParameter(this.mySymbol.getName(), "");
            } else {
                handler.removeParameter(this.mySymbol.getName(), true);
            }
            handler.invoke();
        } else {
            OCRemoveDeclarationIntentionAction.deleteUsages(element);
            OCChangeUtil.delete(element);
        }
    }

    private boolean isCopyOrMoveCtor(@NotNull OCFunctionSymbol funcSymbol) {
        if (funcSymbol == null) {
            OCRemoveDeclarationIntentionAction.$$$reportNull$$$0(5);
        }
        OCResolveContext resolveContext = OCResolveContext.forSymbol(this.mySymbol, this.myProject);
        return funcSymbol.isCppConstructor() && OCResolveOverloadsUtil.isCopyOrMoveConstructorOrOperator(funcSymbol, resolveContext);
    }

    private static boolean operatorRequiresParamDecl(@NotNull OCFunctionSymbol funcSym) {
        if (funcSym == null) {
            OCRemoveDeclarationIntentionAction.$$$reportNull$$$0(6);
        }
        return funcSym.isCppOperator() && !funcSym.getName().equals("operator()");
    }

    private boolean parameterDeclIsRequired() {
        if (this.mySymbol.getKind() != OCSymbolKind.PARAMETER) {
            return false;
        }
        OCDeclaratorSymbol declSymbol = (OCDeclaratorSymbol)this.mySymbol;
        if (declSymbol.getParent() == null) {
            return false;
        }
        OCSymbolWithQualifiedName parentSymbol = declSymbol.getParent();
        if (!(parentSymbol instanceof OCFunctionSymbol)) {
            return false;
        }
        OCFunctionSymbol funcSym = (OCFunctionSymbol)parentSymbol;
        return this.isCopyOrMoveCtor(funcSym) || OCRemoveDeclarationIntentionAction.operatorRequiresParamDecl(funcSym);
    }

    protected static void deleteUsages(PsiElement element) {
        Collection usages = ReferencesSearch.search((PsiElement)element, (SearchScope)element.getUseScope()).findAll();
        for (PsiReference reference : usages) {
            OCChangeUtil.safeDeleteReference(reference.getElement());
        }
    }

    @Nullable
    protected PsiElement getValidElementOrNull() {
        if (this.mySymbol != null) {
            PsiElement element = this.mySymbol.locateDefinition(this.myProject);
            return element != null && OCSearchScope.isInProjectSources(this.mySymbol, this.myProject) && OCCodeInsightUtil.isValid(element) ? element : null;
        }
        PsiElement element = this.myElementPtr.getElement();
        return element != null && OCCodeInsightUtil.isValid(element) && element.getContext() instanceof OCStatement ? element : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCRemoveDeclarationIntentionAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funcSymbol";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funcSym";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCRemoveDeclarationIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCopyOrMoveCtor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "operatorRequiresParamDecl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

