/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.intentions.OCDeclareMethodInInterfaceIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeVisibilityIntentionAction
extends OCSymbolQuickFix<OCSymbolWithParent> {
    @IntentionName
    private final String myText;
    private final OCVisibility myNewVisibility;

    public OCChangeVisibilityIntentionAction(@NotNull OCSymbolWithParent symbol, OCVisibility newVisibility, @NotNull OCCompilationContext context) {
        if (symbol == null) {
            OCChangeVisibilityIntentionAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCChangeVisibilityIntentionAction.$$$reportNull$$$0(1);
        }
        super(context.getProject(), symbol);
        this.myNewVisibility = newVisibility;
        this.myText = OCInspectionsBundle.message((String)"intention.name.change.visibility", (Object[])new Object[]{((OCSymbolWithParent)this.mySymbol).getNameWithKindLowercase(context), this.myNewVisibility});
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.change.visibility", (Object[])new Object[0]);
        if (string == null) {
            OCChangeVisibilityIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && this.myNewVisibility != null && (!(this.mySymbol instanceof OCInstanceVariableSymbol) || ((OCInstanceVariableSymbol)this.mySymbol).getGeneratedFromProperty() == null);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor) {
        if (project == null) {
            OCChangeVisibilityIntentionAction.$$$reportNull$$$0(3);
        }
        this.invokeAndGetNewDeclaration(project);
    }

    public OCDeclaration invokeAndGetNewDeclaration(@NotNull Project project) {
        if (project == null) {
            OCChangeVisibilityIntentionAction.$$$reportNull$$$0(4);
        }
        if (this.mySymbol instanceof OCMethodSymbol && OCVisibility.shouldBeDeclaredInInterface(this.mySymbol, this.myNewVisibility)) {
            OCChangeVisibilityIntentionAction.makeMethodPublic((OCMethodSymbol)this.mySymbol, project);
        }
        if (this.mySymbol instanceof OCInstanceVariableSymbol || this.mySymbol instanceof OCSymbolWithQualifiedName) {
            PsiElement declarator = ((OCSymbolWithParent)this.mySymbol).locateDefinition(project);
            if (((OCSymbolWithParent)this.mySymbol).getKind() == OCSymbolKind.ENUM_CONST) {
                declarator = PsiTreeUtil.getParentOfType((PsiElement)declarator, OCEnum.class);
            }
            OCDeclaration newDeclaration = this.doChangeScope(declarator, (OCSymbolWithParent)this.mySymbol);
            if (this.mySymbol instanceof OCInstanceVariableSymbol) {
                OCInstanceVariableSymbol associatedSymbol = (OCInstanceVariableSymbol)((OCSymbolWithParent)this.mySymbol).getAssociatedSymbol(project);
                if (associatedSymbol != null) {
                    OCFile containingFile = associatedSymbol.getContainingOCFile(project);
                    if (containingFile != null && FileModificationService.getInstance().prepareFileForWrite((PsiFile)containingFile)) {
                        this.doChangeScope(associatedSymbol.locateDefinition(project), (OCSymbolWithParent)this.mySymbol);
                    }
                } else if (OCVisibility.shouldBeDeclaredInInterface(this.mySymbol, this.myNewVisibility)) {
                    OCInterfaceSymbol anInterface;
                    OCSymbol parent = ((OCSymbolWithParent)this.mySymbol).getParent();
                    OCInterfaceSymbol oCInterfaceSymbol = anInterface = parent instanceof OCInterfaceSymbol ? ((OCInterfaceSymbol)parent).getMainInterface(project) : ((OCImplementationSymbol)parent).getInterface(project);
                    if (anInterface != null && newDeclaration != null) {
                        OCFile containingFile = anInterface.getContainingOCFile(project);
                        OCClassDeclaration<?> intfDeclaration = OCElementUtil.resolveClassDeclaration(anInterface, project);
                        if (intfDeclaration != null && containingFile != null && FileModificationService.getInstance().prepareFileForWrite((PsiFile)containingFile)) {
                            OCDeclaration oldDeclaration = newDeclaration;
                            newDeclaration = OCChangeUtil.add(intfDeclaration.getInstanceVariablesList(), newDeclaration);
                            this.putToParent((OCSymbolWithParent)this.mySymbol, newDeclaration, intfDeclaration.getInstanceVariablesList());
                            OCChangeUtil.delete(oldDeclaration);
                        }
                    }
                }
            }
            return newDeclaration;
        }
        return null;
    }

    private static void makeMethodPublic(OCMethodSymbol symbol, Project project) {
        OCMethodSymbol implSymbol;
        if (!symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
            OCFile file = symbol1.getContainingOCFile(project);
            return file == null || !file.isHeader();
        }), project)) {
            return;
        }
        OCMethodSymbol associatedSymbol = symbol.getAssociatedSymbol(project);
        PsiElement methodToDelete = null;
        if ("".equals(symbol.getParent().getCategoryName())) {
            methodToDelete = symbol.locateDefinition(project);
            implSymbol = associatedSymbol;
        } else if (associatedSymbol != null && "".equals(associatedSymbol.getParent().getCategoryName())) {
            methodToDelete = associatedSymbol.locateDefinition(project);
            implSymbol = symbol;
        } else {
            implSymbol = symbol;
        }
        OCFile file = symbol.getContainingOCFile(project);
        if (file == null) {
            return;
        }
        new OCDeclareMethodInInterfaceIntentionAction(){

            @Override
            @Nullable
            protected OCMethodSymbol locateCandidate(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return implSymbol;
            }

            @Override
            @Nullable
            protected OCClassSymbol getParent(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(2);
                }
                return implSymbol != null ? implSymbol.getParent() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCChangeVisibilityIntentionAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "locateCandidate";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getParent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.defaultInvoke(project, null, file);
        if (methodToDelete != null) {
            OCChangeUtil.delete(methodToDelete);
        }
    }

    @Nullable
    private OCDeclaration putToBottomOfTheScope(PsiElement parent, OCDeclaration declaration, PsiElement kid, OCSymbol symbol, boolean addScopeSpecifier) {
        while (kid != null && !OCElementUtil.isVisibilityKeyword(kid.getNode()) && OCElementUtil.getElementType(kid) != OCLexerTokenTypes.RBRACE) {
            kid = kid.getNextSibling();
        }
        if (kid != null) {
            if (addScopeSpecifier) {
                if (symbol instanceof OCInstanceVariableSymbol) {
                    parent.addBefore(OCElementFactory.ivarScopeSpecifier(this.myNewVisibility, parent), kid);
                } else {
                    OCElementType elementType = this.myNewVisibility.getElementType();
                    if (elementType == null) {
                        return null;
                    }
                    parent.addBefore(OCElementFactory.create(elementType, parent), kid);
                    parent.addBefore(OCElementFactory.create((OCElementType)OCLexerTokenTypes.COLON, parent), kid);
                }
                parent.addBefore(OCElementFactory.spaceFromText(parent), kid);
            }
            OCDeclaration result = (OCDeclaration)parent.addBefore((PsiElement)declaration, kid);
            OCChangeUtil.addNewLineIfNeed(result, false);
            OCChangeUtil.delete(declaration);
            return result;
        }
        return null;
    }

    @Nullable
    private OCDeclaration doChangeScope(@Nullable PsiElement element, OCSymbolWithParent symbol) {
        Class parentClass = symbol instanceof OCInstanceVariableSymbol ? OCInstanceVariablesList.class : OCStruct.class;
        PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{parentClass});
        if (parent == null) {
            return null;
        }
        OCDeclaration declaration = null;
        if (element instanceof OCDeclarator) {
            declaration = OCNormalizeUtil.normalizeDeclarator((OCDeclarator)element);
        } else if (element instanceof OCStructLike) {
            declaration = (OCDeclaration)element.getParent().getParent();
        }
        if (declaration != null) {
            return this.putToParent(symbol, declaration, parent);
        }
        return null;
    }

    @Nullable
    public OCDeclaration putToParent(OCSymbolWithParent symbol, OCDeclaration declaration, PsiElement parent) {
        OCVisibility defaultVisibility;
        OCVisibility oCVisibility = defaultVisibility = parent instanceof OCStructLike ? ((OCStructLike)parent).getDefaultVisibility() : OCVisibility.getDefaultObjCVisibility(symbol.getKind());
        if (this.myNewVisibility == defaultVisibility) {
            return this.putToBottomOfTheScope(parent, declaration, parent.getFirstChild(), symbol, false);
        }
        for (PsiElement kid = parent.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (this.myNewVisibility != OCVisibility.getVisibilityFromElement(kid)) continue;
            return this.putToBottomOfTheScope(parent, declaration, kid.getNextSibling(), symbol, false);
        }
        return this.putToBottomOfTheScope(parent, declaration, declaration, symbol, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCChangeVisibilityIntentionAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCChangeVisibilityIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndGetNewDeclaration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

