/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCLightFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.SLRUSynchronizedCache;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileGlobalSymbolsCache {
    private static final Logger LOG = Logger.getInstance(OCFileGlobalSymbolsCache.class);
    private static final int CACHE_SIZE = 2 * Runtime.getRuntime().availableProcessors();
    private final CachedValue<Cache> myCache;

    public static OCFileGlobalSymbolsCache getInstance(Project project) {
        return (OCFileGlobalSymbolsCache)project.getService(OCFileGlobalSymbolsCache.class);
    }

    @NotNull
    public OCFileGlobalSymbols forFile(@NotNull PsiFile file) {
        if (file == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(0);
        }
        OCFileGlobalSymbols oCFileGlobalSymbols = this.getCache().main.get(file);
        if (oCFileGlobalSymbols == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(1);
        }
        return oCFileGlobalSymbols;
    }

    @NotNull
    public OCNamespaceLikeSymbol lightTableForFile(@NotNull PsiFile file) {
        if (file == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(2);
        }
        Cache cache = this.getCache();
        OCFileGlobalSymbols symbols = cache.main.getIfCached(file);
        if (symbols != null) {
            OCFileGlobalSymbols oCFileGlobalSymbols = symbols;
            if (oCFileGlobalSymbols == null) {
                OCFileGlobalSymbolsCache.$$$reportNull$$$0(3);
            }
            return oCFileGlobalSymbols;
        }
        OCNamespaceLikeSymbol oCNamespaceLikeSymbol = cache.lightCache.get(file);
        if (oCNamespaceLikeSymbol == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(4);
        }
        return oCNamespaceLikeSymbol;
    }

    @NotNull
    public OCNamespaceLikeSymbol typesOnlyTableForFile(@NotNull PsiFile file) {
        if (file == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(5);
        }
        Cache cache = this.getCache();
        OCFileGlobalSymbols symbols = cache.main.getIfCached(file);
        if (symbols != null) {
            OCFileGlobalSymbols oCFileGlobalSymbols = symbols;
            if (oCFileGlobalSymbols == null) {
                OCFileGlobalSymbolsCache.$$$reportNull$$$0(6);
            }
            return oCFileGlobalSymbols;
        }
        OCLightFileGlobalSymbols lSymbols = cache.lightCache.getIfCached(file);
        if (lSymbols != null) {
            OCLightFileGlobalSymbols oCLightFileGlobalSymbols = lSymbols;
            if (oCLightFileGlobalSymbols == null) {
                OCFileGlobalSymbolsCache.$$$reportNull$$$0(7);
            }
            return oCLightFileGlobalSymbols;
        }
        OCNamespaceLikeSymbol oCNamespaceLikeSymbol = cache.typesOnlyCache.get(file);
        if (oCNamespaceLikeSymbol == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(8);
        }
        return oCNamespaceLikeSymbol;
    }

    @NotNull
    private Cache getCache() {
        Cache cache = (Cache)this.myCache.getValue();
        if (cache == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(9);
        }
        return cache;
    }

    public OCFileGlobalSymbolsCache(@NotNull Project project) {
        if (project == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(10);
        }
        this.myCache = CachedValuesManager.getManager((Project)project).createCachedValue(() -> new CachedValueProvider.Result((Object)new Cache(), new Object[]{FileSymbolTablesCache.getInstance(project).getOutOfBlockModificationTracker()}), false);
    }

    @ApiStatus.Internal
    public static void processFile(@NotNull PsiFile file, @NotNull Processor<OCSymbol> symbols, @Nullable Map<OCSymbol, VirtualFile> importsMap) {
        if (file == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(11);
        }
        if (symbols == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(12);
        }
        if (!OCFileGlobalSymbolsCache.processFileImpl(file, symbols, importsMap) && !OCFileGlobalSymbolsCache.processFileImpl(file, symbols, importsMap)) {
            LOG.error("Symbols were collected incorrectly");
        }
    }

    private static boolean processFileImpl(@NotNull PsiFile file, @NotNull Processor<OCSymbol> symbols, @Nullable Map<OCSymbol, VirtualFile> importsMap) {
        FileSymbolTable fileSymbolTable;
        FileSymbolTable fileSymbolTable2;
        if (file == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(13);
        }
        if (symbols == null) {
            OCFileGlobalSymbolsCache.$$$reportNull$$$0(14);
        }
        if (!FileSymbolTablesCache.areSymbolsLoaded(file.getProject()) || !OCLanguageUtils.supportsResolve(file)) {
            return true;
        }
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(file);
        List<Object> precompiledHeaders = Collections.emptyList();
        OCImmutableInclusionContext precompiledContext = null;
        OCInclusionContext initial = null;
        OCImmutableInclusionContext context = OCHeaderContextCache.headerContext(file);
        PsiFile importHolder = context.getRootFile();
        OCResolveConfiguration configuration = context.getConfiguration();
        if (configuration != null) {
            precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(configuration, context.getLanguageKind(), importHolder);
            precompiledHeaders = precompiledContext.getPrecompiledHeaders();
            initial = OCInclusionContext.beforePCHFileContext(configuration, precompiledContext.getLanguageKind(), importHolder);
        }
        if (initial == null) {
            initial = OCInclusionContext.beforePCHFileContext(file);
        }
        assert (initial != null) : "file without OC resolve";
        FileSymbolTable.ProcessingState state = new FileSymbolTable.ProcessingState(initial, false);
        boolean contextWasProcessed = false;
        for (VirtualFile virtualFile2 : precompiledHeaders) {
            FileSymbolTable tableForPch = FileSymbolTable.forFile(virtualFile2, initial);
            if (tableForPch == null) continue;
            if (!precompiledContext.isProcessed(virtualFile)) {
                tableForPch.processSymbols(symbols, null, state, importsMap, virtualFile2, null);
                continue;
            }
            tableForPch.processSymbols(symbols, null, state, importsMap, virtualFile2, virtualFile);
            contextWasProcessed = true;
            break;
        }
        VirtualFile vfImportHolder = OCFileUtil.getVirtualFile(importHolder);
        if (!contextWasProcessed && !vfImportHolder.equals(virtualFile) && (fileSymbolTable2 = FileSymbolTable.forFile(importHolder, initial)) != null) {
            fileSymbolTable2.processSymbols(symbols, null, state, importsMap, null, virtualFile);
            if (initial.isProcessed(virtualFile)) {
                return false;
            }
        }
        if ((fileSymbolTable = FileSymbolTable.forFile(file, initial)) != null) {
            fileSymbolTable.processSymbols(symbols, null, state, importsMap, null, null);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "lightTableForFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "typesOnlyTableForFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lightTableForFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "typesOnlyTableForFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processFileImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    static class Cache {
        private final SLRUSynchronizedCache<PsiFile, OCFileGlobalSymbols> main = new SLRUSynchronizedCache<PsiFile, OCFileGlobalSymbols>(this, CACHE_SIZE, CACHE_SIZE){

            @Override
            @NotNull
            public OCFileGlobalSymbols createValue(@NotNull PsiFile key) {
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                OCFileGlobalSymbols oCFileGlobalSymbols = OCFileGlobalSymbols.buildSymbols(key);
                if (oCFileGlobalSymbols == null) {
                    1.$$$reportNull$$$0(1);
                }
                return oCFileGlobalSymbols;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache$Cache$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache$Cache$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createValue";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        private final SLRUSynchronizedCache<PsiFile, OCLightFileGlobalSymbols> lightCache = new SLRUSynchronizedCache<PsiFile, OCLightFileGlobalSymbols>(this, 20, 20){

            @Override
            @NotNull
            public OCLightFileGlobalSymbols createValue(@NotNull PsiFile key) {
                if (key == null) {
                    2.$$$reportNull$$$0(0);
                }
                OCLightFileGlobalSymbols oCLightFileGlobalSymbols = OCLightFileGlobalSymbols.buildSymbols(key, false);
                if (oCLightFileGlobalSymbols == null) {
                    2.$$$reportNull$$$0(1);
                }
                return oCLightFileGlobalSymbols;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache$Cache$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache$Cache$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createValue";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        private final SLRUSynchronizedCache<PsiFile, OCLightFileGlobalSymbols> typesOnlyCache = new SLRUSynchronizedCache<PsiFile, OCLightFileGlobalSymbols>(this, 150, 150){

            @Override
            @NotNull
            public OCLightFileGlobalSymbols createValue(@NotNull PsiFile key) {
                if (key == null) {
                    3.$$$reportNull$$$0(0);
                }
                OCLightFileGlobalSymbols oCLightFileGlobalSymbols = OCLightFileGlobalSymbols.buildSymbols(key, true);
                if (oCLightFileGlobalSymbols == null) {
                    3.$$$reportNull$$$0(1);
                }
                return oCLightFileGlobalSymbols;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache$Cache$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbolsCache$Cache$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createValue";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };

        Cache() {
        }
    }
}

