/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUnaryExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCUnaryExpression {
    private static final Logger LOG = Logger.getInstance(OCUnaryExpressionImpl.class);

    public OCUnaryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCUnaryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @Nullable
    protected OCOperatorReference createReference() {
        OCExpression operand = this.getOperand();
        if (operand != null) {
            return new OCOperatorReference((PsiElement)this, this.getOperationName(), OCOperatorReference.OperatorPlacement.PREFIX, this.getOperationSignNode().getPsi(), operand);
        }
        return null;
    }

    @Override
    public OCExpression getOperand() {
        return (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        OCElementType oCElementType = (OCElementType)this.getOperationSignNode().getElementType();
        if (oCElementType == null) {
            OCUnaryExpressionImpl.$$$reportNull$$$0(1);
        }
        return oCElementType;
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        ASTNode aSTNode = this.getNode().getFirstChildNode();
        if (aSTNode == null) {
            OCUnaryExpressionImpl.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    @Override
    @NotNull
    public String getOperationName() {
        String string = this.getOperationSign().getName();
        if (string == null) {
            OCUnaryExpressionImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isGetAddress() {
        return this.getOperationSign() == OCTokenTypes.AND;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCUnaryExpressionImpl.$$$reportNull$$$0(4);
        }
        visitor.visitUnaryExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCReferenceElement referenceElement;
        OCOperatorReference reference;
        if (context == null) {
            OCUnaryExpressionImpl.$$$reportNull$$$0(5);
        }
        if ((reference = (OCOperatorReference)this.getReference()) != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                OCType oCType = ((OCFunctionSymbol)operator).getEffectiveType(this);
                if (oCType == null) {
                    OCUnaryExpressionImpl.$$$reportNull$$$0(6);
                }
                return oCType;
            }
        }
        OCElementType sign = this.getOperationSign();
        OCExpression operand = this.getOperand();
        if (operand == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                OCUnaryExpressionImpl.$$$reportNull$$$0(7);
            }
            return oCUnknownType;
        }
        OCType opType = operand.getResolvedType(context);
        OCSymbolReference.LocalReference symbolReference = null;
        if (operand instanceof OCReferenceExpression && (referenceElement = ((OCReferenceExpression)operand).getReferenceElement()) != null) {
            symbolReference = OCSymbolReference.getLocalReference(referenceElement, OCSymbolReference.SymbolFilter.NONE);
        }
        OCType oCType = OCUnaryExpressionImpl.getUnaryExprType(sign, opType, symbolReference, context);
        if (oCType == null) {
            OCUnaryExpressionImpl.$$$reportNull$$$0(8);
        }
        return oCType;
    }

    public static OCType getUnaryExprType(OCElementType sign, OCType opType, @Nullable OCSymbolReference referenceElement, @NotNull OCResolveContext context) {
        OCType result;
        if (context == null) {
            OCUnaryExpressionImpl.$$$reportNull$$$0(9);
        }
        if (opType.isUnresolved(context)) {
            result = OCUnknownType.INSTANCE;
        } else if (sign == OCTokenTypes.UDL_SUFFIX || opType.isSubclassOfMagic(context)) {
            result = new OCMagicType(opType);
        } else if (sign == OCTokenTypes.MUL) {
            result = opType instanceof OCPointerType ? ((OCPointerType)opType).getRefType() : OCUnaryExpressionImpl.unknownOrMagic(opType, context);
        } else if (sign == OCTokenTypes.__REAL__KEYWORD || sign == OCTokenTypes.__IMAG__KEYWORD) {
            result = opType instanceof OCRealType ? ((OCRealType)opType).cloneWithoutComplexModifier() : opType;
        } else if (sign == OCTokenTypes.AND) {
            OCType type = OCTypeUtils.getCppReferencedType(opType);
            OCType qualifierType = null;
            if (referenceElement != null && referenceElement.getQualifiedName().getQualifier() != null) {
                OCSymbol symbol = OCReferenceElementImpl.findPredeclaration(referenceElement.resolveToSymbols(context));
                if ((symbol instanceof OCFunctionSymbol || symbol instanceof OCDeclaratorSymbol) && !((OCSymbolWithQualifiedName)symbol).isFriendOrStatic() && ((OCSymbolWithQualifiedName)symbol).getParent() instanceof OCStructSymbol) {
                    qualifierType = new OCReferenceTypeBuilder(referenceElement.getSymbolReferenceToQualifier()).build().resolve(context);
                } else if (symbol instanceof OCTypeParameterSymbol) {
                    qualifierType = new OCMagicType(referenceElement.getQualifiedName().getQualifier().toString());
                }
            }
            result = OCPointerType.to(type, null, qualifierType);
        } else if (sign == OCTokenTypes.TILDE || sign == OCTokenTypes.PLUS) {
            result = opType;
        } else if (sign == OCTokenTypes.MINUS) {
            result = opType instanceof OCIntType ? ((OCIntType)opType).promoteToSigned(context) : (opType.isNumberCompatible(context) ? opType : OCUnaryExpressionImpl.unknownOrMagic(opType, context));
        } else if (sign == OCTokenTypes.EXCL) {
            OCType type = OCTypeUtils.getCppReferencedType(opType);
            result = type.isNumberCompatible(context) || type.isPointer() ? OCIntType.getAppropriateBool(context.isObjc()) : OCUnaryExpressionImpl.unknownOrMagic(opType, context);
        } else {
            LOG.error("Unknown operation sign");
            result = OCUnknownType.INSTANCE;
        }
        if (result instanceof OCNumericType) {
            result = result.cloneWithoutCVQualifiers(context.getProject());
        }
        return result;
    }

    private static OCType unknownOrMagic(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCUnaryExpressionImpl.$$$reportNull$$$0(10);
        }
        if (type.isMagicInside(context)) {
            return new OCMagicType(type);
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        return Collections.singletonList(this.getOperand());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCUnaryExpressionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCUnaryExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSign";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSignNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUnaryExprType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unknownOrMagic";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

