/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.DelegatingItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppBaseClauseList;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeclarationContext;
import com.jetbrains.cidr.lang.symbols.OCBuilderDriver;
import com.jetbrains.cidr.lang.symbols.OCDelegatingSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCTypeBuilder;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCStructLikeImpl
extends OCElementBase
implements OCStructLike {
    public OCStructLikeImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCStructLikeImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public List<OCDeclaration> getFields() {
        return this.findChildrenByType((IElementType)OCElementTypes.DECLARATION);
    }

    @Override
    @Nullable
    public OCCppBaseClauseList getBaseClausesList() {
        return (OCCppBaseClauseList)this.findChildByType((IElementType)OCElementTypes.CPP_BASE_CLAUSE_LIST);
    }

    public String getName() {
        PsiElement nameNode = this.getNameIdentifier();
        return nameNode != null ? nameNode.getText() : null;
    }

    @Override
    public OCVisibility getDefaultVisibility() {
        return this.findChildByType((IElementType)OCLexerTokenTypes.CLASS_KEYWORD) != null ? OCVisibility.PRIVATE : OCVisibility.PUBLIC;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        PsiElement ident = this.findChildByType((IElementType)OCLexerTokenTypes.IDENTIFIER);
        if (ident == null) {
            OCReferenceElement ref = (OCReferenceElement)this.findChildByType((IElementType)OCElementTypes.REFERENCE_ELEMENT);
            return ref != null ? ref.getLastChild() : null;
        }
        return ident;
    }

    private PsiElement getFullNameElement() {
        PsiElement ident = this.findChildByType((IElementType)OCLexerTokenTypes.IDENTIFIER);
        return ident != null ? ident : this.findChildByType((IElementType)OCElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    public OCCppNamespaceQualifier getNamespaceQualifier() {
        return (OCCppNamespaceQualifier)this.findChildByType((IElementType)OCElementTypes.CPP_NAMESPACE_QUALIFIER);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            OCStructLikeImpl.$$$reportNull$$$0(1);
        }
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Override
    @Nullable
    public String getSymbolName() {
        return this.getName();
    }

    @Override
    public ItemPresentation getPresentation() {
        PsiElement templateArgs;
        ItemPresentation superPresentation = super.getPresentation();
        if (superPresentation != null && (templateArgs = (PsiElement)this.findChildByClass(OCTemplateArgumentList.class)) != null) {
            return new DelegatingItemPresentation(superPresentation).withPresentableText(this.getName() + templateArgs.getText());
        }
        return superPresentation;
    }

    @Override
    public int getTextOffset() {
        return OCSymbolOffsetUtil.getTextOffset(this.getComplexOffset());
    }

    @Override
    public long getComplexOffset() {
        PsiElement ident = this.getNameIdentifier();
        return ident == null ? super.getComplexOffset() : OCSymbolOffsetUtil.getComplexOffset(ident);
    }

    @Override
    public boolean isDeclaration() {
        return OCElementUtil.isStructTypeDeclaration(this.getNode());
    }

    @Override
    public boolean isFriendDeclaration() {
        PsiElement psiElement;
        if (this.getParent() != null && (psiElement = this.getParent().getParent()) instanceof OCDeclaration) {
            OCDeclaration decl = (OCDeclaration)psiElement;
            return decl.isFriend();
        }
        return false;
    }

    @Override
    public boolean isElaboratedTypeDeclaration() {
        return this.getParent() instanceof OCTypeElement && (!(this.getParent().getParent() instanceof OCDeclaration) || !((OCDeclaration)this.getParent().getParent()).getDeclarators().isEmpty());
    }

    @Override
    @NotNull
    public TextRange getHeaderRange() {
        PsiElement brace = this.findChildByType((IElementType)OCLexerTokenTypes.LBRACE);
        if (brace != null) {
            TextRange textRange = OCElementUtil.getTrimmedRange(new TextRange(this.getTextRange().getStartOffset(), brace.getTextOffset()), this.getContainingFile());
            if (textRange == null) {
                OCStructLikeImpl.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        PsiElement identifier = this.getNameIdentifier();
        TextRange textRange = identifier != null ? identifier.getTextRange() : this.getTextRange();
        if (textRange == null) {
            OCStructLikeImpl.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Override
    public int getFunctionsStartOffset() {
        PsiElement anchor = null;
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof OCFunctionDeclaration) {
                anchor = child;
                break;
            }
            if (anchor != null || !(child instanceof OCDeclaration) && child.getNode().getElementType() != OCLexerTokenTypes.RBRACE) continue;
            anchor = child;
        }
        if (anchor == null) {
            anchor = this.getLastChild();
        }
        return anchor.getTextRange().getStartOffset();
    }

    protected void processSymbols(Processor<OCSymbol> processor2) {
        OCFile file = this.getContainingOCFile();
        PsiElement scope = PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{OCLocalScopeable.class});
        OCSymbolWithQualifiedName parent = OCSymbolReferenceResolver.getGlobalContextFromLocal(this);
        DeclarationContext declarationContext = new DeclarationContext(this.getKind(), scope, parent, null, scope != null ? this : null, false);
        OCLanguageKind kind = file.getKind();
        Processor<OCSymbol> delegateProcessor = OCDelegatingSymbol.getDelegateProcessor(processor2);
        OCBuilderDriver<ASTNode> builderDriver = OCBuilderDriver.createForASTNode(this.getNode(), file, delegateProcessor);
        PsiElement declaration = this.getParent().getParent();
        if (declaration instanceof OCDeclaration) {
            OCTemplateParameterList templateParameterList = ((OCDeclaration)declaration).getTemplateParameterList();
            if (templateParameterList != null) {
                declarationContext.getTemplateParameters().add(templateParameterList.getNode());
            }
            if (declaration.getNode().findChildByType((IElementType)OCLexerTokenTypes.FRIEND_CPP_KEYWORD) != null) {
                declarationContext.addModifier(OCSymbolAttribute.FRIEND);
            }
        }
        OCTypeBuilder typeBuilder = builderDriver.createTypeBuilder(declarationContext);
        builderDriver.processStruct(this.getNode(), typeBuilder, delegateProcessor, declarationContext);
    }

    @Override
    public OCStructSymbol getLocalSymbol() {
        final String symbolName = this.getSymbolName();
        PsiElement nameElement = this.getFullNameElement();
        final int expectedOffset = nameElement != null ? nameElement.getTextOffset() : this.getTextOffset();
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(this){

            public boolean process(OCSymbol symbol) {
                if (symbol instanceof OCStructSymbol && symbol.getOffset() == expectedOffset && Objects.equals(symbolName, symbol.getName())) {
                    return super.process((Object)symbol);
                }
                return true;
            }
        };
        this.processSymbols((Processor<OCSymbol>)finder);
        return (OCStructSymbol)finder.getFoundValue();
    }

    @Override
    public OCStructSymbol getSymbol() {
        OCStructSymbol symbol = this.getContainingOCFile().findSymbol(this, OCStructSymbol.class);
        return symbol != null ? symbol : this.getLocalSymbol();
    }

    @Override
    @Nullable
    public PsiElement getOpeningBrace() {
        return this.findChildByType((IElementType)OCLexerTokenTypes.LBRACE);
    }

    @Override
    @Nullable
    public PsiElement getClosingBrace() {
        return this.findChildByType((IElementType)OCLexerTokenTypes.RBRACE);
    }

    @Override
    @Nullable
    public OCTypeArgumentList getTemplateArgumentList() {
        return (OCTypeArgumentList)this.findChildByType((IElementType)OCElementTypes.TEMPLATE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveTemplateDeclarations() {
        Collection<OCSymbol> collection = OCResolveUtil.resolveTemplateDeclarations(this);
        if (collection == null) {
            OCStructLikeImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCStructLikeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCStructLikeImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTemplateDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

