/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCElementWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPropertyAttributeImpl
extends OCElementWithReferenceBase
implements OCPropertyAttribute {
    public OCPropertyAttributeImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCPropertyAttributeImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCPropertyAttributeImpl.$$$reportNull$$$0(1);
        }
        visitor.visitPropertyAttribute(this);
    }

    @NotNull
    public String getName() {
        PsiElement ident = this.getNameIdentifier();
        String string = ident == null ? "<unnamed>" : ident.getText();
        if (string == null) {
            OCPropertyAttributeImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            OCPropertyAttributeImpl.$$$reportNull$$$0(3);
        }
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findChildByType((IElementType)OCLexerTokenTypes.IDENTIFIER);
    }

    @Override
    @Nullable
    public PsiElement getValueElement() {
        List names = this.findChildrenByType((IElementType)OCLexerTokenTypes.IDENTIFIER);
        return names.size() == 2 ? (PsiElement)names.get(1) : null;
    }

    @Override
    @Nullable
    public String getValue() {
        PsiElement element = this.getValueElement();
        if (element == null) {
            return null;
        }
        String result = element.getText();
        return this.getName().equals("setter") && !result.endsWith(":") ? result + ":" : result;
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType((IElementType)OCLexerTokenTypes.COLON);
    }

    @Override
    @Nullable
    public OCProperty getParentProperty() {
        PsiElement property;
        PsiElement list = this.getParent();
        if (list instanceof OCPropertyAttributesList && (property = list.getParent()) instanceof OCProperty) {
            return (OCProperty)property;
        }
        return null;
    }

    @Override
    public void setValue(String value) {
        List names = this.findChildrenByType((IElementType)OCLexerTokenTypes.IDENTIFIER);
        if (names.size() == 2) {
            ((PsiElement)names.get(1)).replace(OCElementFactory.createIdentifier(value, this));
        }
    }

    @Nullable
    protected PsiReference createReference() {
        PsiElement valueElement = this.getValueElement();
        String keyName = this.getName();
        if ((keyName.equals("getter") || keyName.equals("setter")) && valueElement != null) {
            return new AccessorMethodReference();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private class AccessorMethodReference
    implements OCReference {
        private AccessorMethodReference() {
        }

        @Override
        public OCSymbol resolveToSymbol() {
            OCImplementationSymbol classSymbol = this.getClassSymbol();
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(this){

                public boolean process(OCMethodSymbol symbol) {
                    if (!symbol.isStatic()) {
                        return super.process((Object)symbol);
                    }
                    return true;
                }
            };
            if (classSymbol != null) {
                classSymbol.processMembers(this.getCanonicalText(), OCMethodSymbol.class, finder);
            }
            return (OCSymbol)finder.getFoundValue();
        }

        @Nullable
        private OCImplementationSymbol getClassSymbol() {
            OCClassDeclaration classDeclaration = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), OCClassDeclaration.class);
            if (classDeclaration == null) {
                return null;
            }
            OCClassSymbol classSymbol = classDeclaration.getSymbol();
            if (classSymbol == null) {
                return null;
            }
            return classSymbol.getImplementation(OCPropertyAttributeImpl.this.getProject());
        }

        @NotNull
        public PsiElement getElement() {
            OCPropertyAttributeImpl oCPropertyAttributeImpl = OCPropertyAttributeImpl.this;
            if (oCPropertyAttributeImpl == null) {
                AccessorMethodReference.$$$reportNull$$$0(0);
            }
            return oCPropertyAttributeImpl;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = OCElementUtil.getRangeInParent(OCPropertyAttributeImpl.this.getValueElement());
            if (textRange == null) {
                AccessorMethodReference.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        public PsiElement resolve() {
            OCSymbol symbol = this.resolveToSymbol();
            return symbol != null ? symbol.locateDefinition(OCPropertyAttributeImpl.this.getProject()) : null;
        }

        @NotNull
        public String getCanonicalText() {
            String string = OCPropertyAttributeImpl.this.getValue();
            if (string == null) {
                AccessorMethodReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                AccessorMethodReference.$$$reportNull$$$0(3);
            }
            if (!OCPropertyAttributeImpl.this.getName().equals(newElementName)) {
                return OCPropertyAttributeImpl.this.getValueElement().replace(OCElementFactory.createIdentifier(newElementName, OCPropertyAttributeImpl.this));
            }
            return this.getElement();
        }

        @Override
        public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
            if (symbol == null) {
                AccessorMethodReference.$$$reportNull$$$0(4);
            }
            assert (symbol instanceof OCMethodSymbol);
            return this.handleElementRename(symbol.getName());
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            Object symbol;
            if (element == null) {
                AccessorMethodReference.$$$reportNull$$$0(5);
            }
            return (symbol = ((OCSymbolDeclarator)element).getSymbol()) != null ? this.bindToSymbol((OCSymbol)symbol) : element;
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                AccessorMethodReference.$$$reportNull$$$0(6);
            }
            if (!(element instanceof OCSymbolDeclarator)) {
                return false;
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            OCSymbol refSymbol = this.resolveToSymbol();
            return symbol instanceof OCMethodSymbol && (Comparing.equal((Object)refSymbol, symbol) || Comparing.equal((Object)refSymbol, (Object)((OCMethodSymbol)symbol).getAssociatedSymbol(element.getProject())));
        }

        public Object @NotNull [] getVariants() {
            OCImplementationSymbol classSymbol = this.getClassSymbol();
            boolean isSetter = OCPropertyAttributeImpl.this.getName().equals("setter");
            ArrayList result = new ArrayList();
            if (classSymbol != null) {
                classSymbol.processMembers(null, OCMethodSymbol.class, symbol -> {
                    OCResolveContext context = OCResolveContext.forSymbol(symbol, OCPropertyAttributeImpl.this.getProject());
                    if (symbol.isGetter(context) && !isSetter || symbol.isSetter(context) && isSetter) {
                        result.add(SymbolLookupBuilderUtil.lookup(symbol, OCPropertyAttributeImpl.this.getProject()).withInsertHandler((InsertHandler)new BasicInsertHandler()));
                    }
                    return true;
                });
            }
            Object[] objectArray = result.toArray();
            if (objectArray == null) {
                AccessorMethodReference.$$$reportNull$$$0(7);
            }
            return objectArray;
        }

        public boolean isSoft() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl$AccessorMethodReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCPropertyAttributeImpl$AccessorMethodReference";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToSymbol";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

