/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCFragmentVirtualFileImpl
extends LightVirtualFile
implements OCFragmentVirtualFile {
    private int myParentOffset;
    private CharSequence myParentFileContent;
    private VirtualFile myParent;
    @NonNls
    private static final String FILENAME_SEPARATOR = "_CLION_FRAGMENT_SEPARATOR_";

    public OCFragmentVirtualFileImpl(@NotNull String name) {
        if (name == null) {
            OCFragmentVirtualFileImpl.$$$reportNull$$$0(0);
        }
        super(name);
        this.myParentFileContent = "";
    }

    public OCFragmentVirtualFileImpl(@NotNull String name, @NotNull Language language, @NotNull CharSequence text) {
        if (name == null) {
            OCFragmentVirtualFileImpl.$$$reportNull$$$0(1);
        }
        if (language == null) {
            OCFragmentVirtualFileImpl.$$$reportNull$$$0(2);
        }
        if (text == null) {
            OCFragmentVirtualFileImpl.$$$reportNull$$$0(3);
        }
        super(name, language, text);
        this.myParentFileContent = "";
    }

    public CharSequence getParentFileContent() {
        return this.myParentFileContent;
    }

    public int getParentOffset() {
        return this.myParentOffset;
    }

    public void initWithContext(@NotNull PsiElement context) {
        if (context == null) {
            OCFragmentVirtualFileImpl.$$$reportNull$$$0(4);
        }
        if (context instanceof OCSymbolHolder) {
            this.myParent = ((OCSymbolHolder)context).getContainingVirtualFile();
        } else {
            this.myParent = context.getContainingFile().getVirtualFile();
            this.myParentFileContent = context.getContainingFile().getViewProvider().getContents();
        }
        this.myParentOffset = context.getTextOffset();
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    @NotNull
    public String getPath() {
        VirtualFile parent = this.getParent();
        if (parent == null || parent.isDirectory()) {
            String string = super.getPath();
            if (string == null) {
                OCFragmentVirtualFileImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        VirtualFile dirOfParent = parent.getParent();
        if (dirOfParent == null) {
            OCLog.LOG.warn("Why file doesn't have any parent?");
            String string = super.getPath();
            if (string == null) {
                OCFragmentVirtualFileImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = dirOfParent.getPath() + "/" + parent.getName() + FILENAME_SEPARATOR + this.getName();
        if (string == null) {
            OCFragmentVirtualFileImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static String getFilenameSeparator() {
        return FILENAME_SEPARATOR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCFragmentVirtualFileImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCFragmentVirtualFileImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initWithContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

