/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParsedLanguageAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.ResolveSession;
import com.jetbrains.cidr.lang.psi.impl.OCPsiFileBaseImpl;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileImpl
extends OCPsiFileBaseImpl
implements OCFile {
    private int myAnnotationSessionDepthsCounter = 0;
    private ResolveSession myCurrentResolveSession;
    private final Object myAnnotationSessionLock = new Object();
    private final Set<VirtualFile> myIncludedFrom = new HashSet<VirtualFile>();
    @Nullable
    private volatile FileSymbolTable mySymbolTableCache;
    @Nullable
    private volatile OCParsedLanguageAndConfiguration myParsedLanguageAndConfiguration;

    public OCFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, (Language)OCLanguage.getInstance());
    }

    @Override
    @NotNull
    public FileType getFileType() {
        FileType fileType = super.getFileType();
        if (fileType == null) {
            OCFileImpl.$$$reportNull$$$0(0);
        }
        return fileType;
    }

    @Override
    @NotNull
    public OCFile getOCFile() {
        OCFileImpl oCFileImpl = this;
        if (oCFileImpl == null) {
            OCFileImpl.$$$reportNull$$$0(1);
        }
        return oCFileImpl;
    }

    @Override
    @NotNull
    public PsiElement asElementFromOCFile(@NotNull PsiElement psiElementFromThisFile) {
        if (psiElementFromThisFile == null) {
            OCFileImpl.$$$reportNull$$$0(2);
        }
        assert (psiElementFromThisFile.getContainingFile() == this);
        PsiElement psiElement = psiElementFromThisFile;
        if (psiElement == null) {
            OCFileImpl.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public PsiElement findElementAt(int offset) {
        return this.getViewProvider().findElementAt(offset, LanguageUtils.getInstance().getSlowLanguage());
    }

    public void subtreeChanged() {
        super.subtreeChanged();
    }

    @Override
    @Nullable
    public OCFile getAssociatedFile() {
        class StopException
        extends RuntimeException {
            StopException() {
            }
        }
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)this.getName());
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        final OCCommonProcessors.OrderedProcessor processor2 = new OCCommonProcessors.OrderedProcessor(finder, true, (Condition<? super T>[])new Condition[]{file -> FileUtilRt.getNameWithoutExtension((String)file.getName()).equals(nameWithoutExtension), Conditions.alwaysTrue()});
        try {
            this.accept(new OCRecursiveVisitor(){

                @Override
                public void visitFunctionDeclaration(OCFunctionDeclaration declaration) {
                    this.processSymbol(declaration.getSymbol());
                    super.visitFunctionDeclaration(declaration);
                }

                @Override
                public void visitFunctionDefinition(OCFunctionDefinition definition) {
                    this.processSymbol(definition.getSymbol());
                    super.visitFunctionDefinition(definition);
                }

                @Override
                public void visitClassDeclaration(OCClassDeclaration dcl) {
                    this.processSymbol(dcl.getSymbol());
                    super.visitClassDeclaration(dcl);
                }

                private void processSymbol(OCSymbol symbol) {
                    if (symbol != null) {
                        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
                            OCFile file = symbol1.getContainingOCFile(OCFileImpl.this.getProject());
                            if (file != null && file.isHeader() != OCFileImpl.this.isHeader() && !processor2.process(file)) {
                                throw new StopException();
                            }
                            return true;
                        }), OCFileImpl.this.getProject());
                    }
                }
            });
        }
        catch (StopException stopException) {
            // empty catch block
        }
        processor2.finish();
        if (finder.isFound()) {
            OCFile fileWithSameName;
            OCFile foundFile = (OCFile)finder.getFoundValue();
            if (foundFile != null && foundFile.getName().startsWith("moc_") && (fileWithSameName = this.getAssociatedFileWithSameName()) != null) {
                return fileWithSameName;
            }
            return foundFile;
        }
        return this.getAssociatedFileWithSameName();
    }

    @Override
    @Nullable
    public OCFile getAssociatedFileWithSameName() {
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Project project = this.getProject();
        VirtualFile associated = OCSearchUtil.getAssociatedFileWithSameName(project, virtualFile);
        if (associated != null) {
            PsiFile file = PsiManager.getInstance((Project)project).findFile(associated);
            return file instanceof OCFile ? (OCFile)file : null;
        }
        return null;
    }

    @Override
    public boolean isCpp() {
        return this.getKind().isCpp();
    }

    @Override
    public void clearCaches() {
        this.mySymbolTableCache = null;
        super.clearCaches();
    }

    @Override
    public boolean processSymbolsRecursively(@NotNull Processor<OCSymbol> processor2) {
        if (processor2 == null) {
            OCFileImpl.$$$reportNull$$$0(4);
        }
        return this.processSymbolsRecursively(null, processor2);
    }

    public boolean processSymbolsRecursively(@Nullable OCImmutableInclusionContext inclusionContext, final @NotNull Processor<OCSymbol> processor2) {
        PsiElement context;
        if (processor2 == null) {
            OCFileImpl.$$$reportNull$$$0(5);
        }
        if ((context = this.getContext()) instanceof OCElement && !((OCElement)context).getContainingOCFile().processSymbolsRecursively(processor2)) {
            return false;
        }
        FileSymbolTable table = inclusionContext != null ? FileSymbolTable.forFile(this, inclusionContext.derive()) : this.getSymbolTable();
        return table == null || table.shallowProcessSymbols((Processor<? super OCSymbol>)new Processor<OCSymbol>(this){

            public boolean process(OCSymbol symbol) {
                if (!processor2.process((Object)symbol)) {
                    return false;
                }
                if (symbol instanceof OCMembersContainer) {
                    return ((OCMembersContainer)((Object)symbol)).processMembers(null, this);
                }
                return true;
            }
        });
    }

    @Override
    @Nullable
    public <T extends OCSymbol> T findSymbol(@NotNull OCElement element, @NotNull Class<T> symbolClass) {
        PsiFile containingFile;
        PsiElement context;
        if (element == null) {
            OCFileImpl.$$$reportNull$$$0(6);
        }
        if (symbolClass == null) {
            OCFileImpl.$$$reportNull$$$0(7);
        }
        if ((context = this.getContext()) != null && (containingFile = context.getContainingFile()) instanceof OCFile) {
            return ((OCFile)containingFile).findSymbol(element, symbolClass);
        }
        FileSymbolTable table = this.getSymbolTable();
        return table != null ? (T)table.findSymbol(element, symbolClass) : null;
    }

    @Override
    @Nullable
    public <T extends OCSymbol> T findSymbol(@Nullable String name, Class<T> symbolClass) {
        PsiElement context = this.getContext();
        if (context instanceof OCElement) {
            return ((OCElement)context).getContainingOCFile().findSymbol(name, symbolClass);
        }
        FileSymbolTable table = this.getSymbolTable();
        return table != null ? (T)table.findSymbol(name, symbolClass) : null;
    }

    @RequiresReadLock
    @Nullable
    public FileSymbolTable getSymbolTable() {
        ThreadingAssertions.softAssertReadAccess();
        FileSymbolTable result = this.mySymbolTableCache;
        if (result == null || !result.isValid()) {
            this.mySymbolTableCache = result = FileSymbolTable.forFile(this, OCHeaderContextCache.headerContext(this).derive());
        }
        return result;
    }

    @Override
    @NotNull
    public OCNamespaceLikeSymbol getMembersContainer(boolean onlyTypes) {
        OCFileGlobalSymbolsCache cache = OCFileGlobalSymbolsCache.getInstance(this.getProject());
        OCNamespaceLikeSymbol oCNamespaceLikeSymbol = onlyTypes ? cache.typesOnlyTableForFile(this) : cache.lightTableForFile(this);
        if (oCNamespaceLikeSymbol == null) {
            OCFileImpl.$$$reportNull$$$0(8);
        }
        return oCNamespaceLikeSymbol;
    }

    @Override
    @Nullable
    public OCSymbol getSameNamedClass() {
        final String name = this.getMainClassName();
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(this){

            protected boolean accept(OCSymbol symbol) {
                return (symbol instanceof OCClassSymbol || symbol instanceof OCStructSymbol && !((OCStructSymbol)symbol).isInnerClass()) && name.equals(symbol.getName());
            }
        };
        this.processSymbolsRecursively((Processor<OCSymbol>)finder);
        return (OCSymbol)finder.getFoundValue();
    }

    @Override
    public String getMainClassName() {
        int minus;
        String name = FileUtilRt.getNameWithoutExtension((String)this.getName());
        int plus = name.indexOf(43);
        if (plus != -1) {
            name = name.substring(0, plus);
        }
        if ((minus = name.indexOf(45)) != -1) {
            name = name.substring(0, minus);
        }
        return name;
    }

    @Override
    @Nullable
    public OCSymbolDeclarator findFirstClass() {
        return this.findClass(null);
    }

    @Override
    @Nullable
    public OCSymbolDeclarator findClass(final String name) {
        final Ref result = new Ref();
        this.accept(new OCRecursiveVisitor(this){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (!(dcl instanceof OCClassPredeclaration) && result.isNull() && (name == null || name.equals(dcl.getCanonicalName()))) {
                    result.set((Object)dcl);
                }
                super.visitClassDeclaration(dcl);
            }

            @Override
            public void visitStruct(OCStruct struct) {
                if (result.isNull() && (name == null || name.equals(struct.getName()))) {
                    result.set((Object)struct);
                }
                super.visitStruct(struct);
            }
        });
        return (OCSymbolDeclarator)result.get();
    }

    @Override
    public List<OCIncludeDirective> findIncludeDirectives() {
        final ArrayList<OCIncludeDirective> answer = new ArrayList<OCIncludeDirective>();
        this.acceptChildren(new OCRecursiveVisitor(this){

            @Override
            public void visitImportDirective(OCIncludeDirective directive) {
                answer.add(directive);
            }
        });
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T runWithResolveSession(@NotNull ResolveSession resolveSession, @NotNull Supplier<? extends T> runnable) {
        if (resolveSession == null) {
            OCFileImpl.$$$reportNull$$$0(9);
        }
        if (runnable == null) {
            OCFileImpl.$$$reportNull$$$0(10);
        }
        Object object = this.myAnnotationSessionLock;
        synchronized (object) {
            if (this.myAnnotationSessionDepthsCounter == 0) {
                this.myCurrentResolveSession = resolveSession;
            }
            ++this.myAnnotationSessionDepthsCounter;
        }
        try {
            object = runnable.get();
            return (T)object;
        }
        finally {
            Object object2 = this.myAnnotationSessionLock;
            synchronized (object2) {
                --this.myAnnotationSessionDepthsCounter;
                if (this.myAnnotationSessionDepthsCounter == 0) {
                    this.myCurrentResolveSession = null;
                }
            }
        }
    }

    @Override
    @Nullable
    public ResolveSession getCurrentResolveSession() {
        return this.myCurrentResolveSession;
    }

    @Override
    @NotNull
    public Object getAnnotationSessionLock() {
        Object object = this.myAnnotationSessionLock;
        if (object == null) {
            OCFileImpl.$$$reportNull$$$0(11);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markIncludedFrom(VirtualFile from) {
        if (OCInclusionContextUtil.isLongLived(from)) {
            Set<VirtualFile> set = this.myIncludedFrom;
            synchronized (set) {
                this.myIncludedFrom.add(from);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<VirtualFile> resetIncludingFiles() {
        Set<VirtualFile> set = this.myIncludedFrom;
        synchronized (set) {
            ArrayList<VirtualFile> answer = new ArrayList<VirtualFile>(this.myIncludedFrom);
            this.myIncludedFrom.clear();
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<VirtualFile> getIncludingFiles() {
        Set<VirtualFile> set = this.myIncludedFrom;
        synchronized (set) {
            return new ArrayList<VirtualFile>(this.myIncludedFrom);
        }
    }

    @Override
    @Nullable
    public OCIncludeDirective findIncludeDirective(@Nullable VirtualFile file) {
        if (!OCInclusionContextUtil.isLongLived(file)) {
            return null;
        }
        for (PsiElement child : this.getChildren()) {
            OCIncludeDirective directive;
            PsiFile importedFile;
            if (!(child instanceof OCIncludeDirective) || !Comparing.equal((Object)file, (Object)OCElementUtil.getFilePath(importedFile = (directive = (OCIncludeDirective)child).getIncludedFile()))) continue;
            return directive;
        }
        return null;
    }

    public String toString() {
        return "OCFile:" + this.getName();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            OCFileImpl.$$$reportNull$$$0(12);
        }
        if (visitor instanceof OCVisitor) {
            ((OCVisitor)visitor).visitOCFile(this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            OCFileImpl.$$$reportNull$$$0(13);
        }
        OCLog.LOG.assertTrue(originalFile instanceof OCFile);
        super.setOriginalFile(originalFile);
    }

    @Override
    @NotNull
    public TextRange getRangeWithMacros() {
        TextRange textRange = this.getTextRange();
        if (textRange == null) {
            OCFileImpl.$$$reportNull$$$0(14);
        }
        return textRange;
    }

    @Override
    public OCFile getContainingOCFile() {
        return this;
    }

    @Override
    public String getTextWithMacros() {
        return this.getText();
    }

    @Override
    public boolean isEmpty() {
        for (PsiElement child : this.getChildren()) {
            if (child instanceof OCDefineDirective || child instanceof OCMacroCall) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getComplexOffset() {
        return this.getTextOffset();
    }

    @Override
    public boolean hasExtraTopLevelDefinitions() {
        OCSymbol mainClass = this.getSameNamedClass();
        if (mainClass == null) {
            return false;
        }
        for (PsiElement child : this.getChildren()) {
            OCType type;
            if (child instanceof OCClassDeclaration && ((OCClassDeclaration)child).getSymbol() != mainClass) {
                return true;
            }
            if (!(child instanceof OCDeclaration) || (type = ((OCDeclaration)child).getType()) instanceof OCStructType && ((OCStructType)type).getSymbol().equals(mainClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public OCParsedLanguageAndConfiguration getParsedLanguageAndConfiguration() {
        return this.myParsedLanguageAndConfiguration;
    }

    public void setParsedLanguageAndConfiguration(@Nullable OCParsedLanguageAndConfiguration languageAndConfiguration) {
        this.myParsedLanguageAndConfiguration = languageAndConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6, 7, 9, 10, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCFileImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementFromThisFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveSession";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOCFile";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCFileImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asElementFromOCFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersContainer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationSessionLock";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeWithMacros";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "asElementFromOCFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processSymbolsRecursively";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findSymbol";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runWithResolveSession";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setOriginalFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6, 7, 9, 10, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

