/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAssignmentExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCAssignmentExpression {
    private static final Logger LOG = Logger.getInstance(OCAssignmentExpressionImpl.class);

    public OCAssignmentExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCAssignmentExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @Nullable
    protected OCOperatorReference createReference() {
        String name = this.getOperationSign().getName();
        OCExpression left = this.getReceiverExpression();
        OCExpression right = this.getSourceExpression();
        if (right != null) {
            return new OCOperatorReference((PsiElement)this, name, OCOperatorReference.OperatorPlacement.INFIX, this.getOperationSignNode().getPsi(), left, right);
        }
        return null;
    }

    @Override
    @NotNull
    public OCExpression getReceiverExpression() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (OCLexerTokenTypes.ASSIGNMENT_OPERATIONS.contains(tt)) {
                LOG.error("Cannot find receiver expression in assignment");
                if (null == null) {
                    OCAssignmentExpressionImpl.$$$reportNull$$$0(1);
                }
                return null;
            }
            if (!OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            OCExpression oCExpression = (OCExpression)child.getPsi();
            if (oCExpression == null) {
                OCAssignmentExpressionImpl.$$$reportNull$$$0(2);
            }
            return oCExpression;
        }
        LOG.error("Cannot find receiver expression in assignment");
        if (null == null) {
            OCAssignmentExpressionImpl.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Override
    public OCExpression getSourceExpression() {
        boolean passedSign = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (OCLexerTokenTypes.ASSIGNMENT_OPERATIONS.contains(tt)) {
                passedSign = true;
                continue;
            }
            if (!passedSign || !OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!OCLexerTokenTypes.ASSIGNMENT_OPERATIONS.contains(tt)) continue;
            ASTNode aSTNode = child;
            if (aSTNode == null) {
                OCAssignmentExpressionImpl.$$$reportNull$$$0(4);
            }
            return aSTNode;
        }
        throw new AssertionError((Object)"Cannot find operation sign in assignment expression");
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        OCElementType oCElementType = (OCElementType)this.getOperationSignNode().getElementType();
        if (oCElementType == null) {
            OCAssignmentExpressionImpl.$$$reportNull$$$0(5);
        }
        return oCElementType;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCAssignmentExpressionImpl.$$$reportNull$$$0(6);
        }
        visitor.visitAssignmentExpression(this);
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context) {
        OCOperatorReference reference;
        if (context == null) {
            OCAssignmentExpressionImpl.$$$reportNull$$$0(7);
        }
        if ((reference = (OCOperatorReference)this.getReference()) != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                OCType oCType = ((OCFunctionSymbol)operator).getEffectiveType(this);
                if (oCType == null) {
                    OCAssignmentExpressionImpl.$$$reportNull$$$0(8);
                }
                return oCType;
            }
        }
        OCType oCType = this.getReceiverExpression().getResolvedType(context);
        if (oCType == null) {
            OCAssignmentExpressionImpl.$$$reportNull$$$0(9);
        }
        return oCType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCAssignmentExpressionImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCAssignmentExpressionImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiverExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSignNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSign";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 8, 9 -> new IllegalStateException(string);
        };
    }
}

