/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.cidr.lang.LongLivedLightVirtualFile;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCRootKind;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.workspace.OCLibraryFileResolveConfigurationProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInclusionContextUtil {
    @Contract(value="null -> false", pure=true)
    public static boolean isLongLived(@Nullable VirtualFile file) {
        return file != null && !(file instanceof LightVirtualFile) || file instanceof LongLivedLightVirtualFile;
    }

    @RequiresReadLock
    @Nullable
    public static PsiFile findCachedPsiFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (!file.isValid()) {
            return null;
        }
        return PsiManagerEx.getInstanceEx((Project)project).getFileManager().getCachedPsiFile(file);
    }

    public static void resetUserSelectedConfigurations(@NotNull Project project) {
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(2);
        }
        OCResolveContextSettings.getInstance((Project)project).resetConfigurationPriorities();
    }

    @NotNull
    public static ConfigurationsAndRootKind getAllBuildConfigurationsForFileAndIsHeader(@NotNull PsiFile file, @Nullable ProgressIndicator progress) {
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(3);
        }
        PsiFile fileWithResolve = OCLanguageUtils.asFileWithOCResolve(file);
        OCRootKind rootKind = OCRootKind.getRootKind(file);
        if (fileWithResolve != null && rootKind == OCRootKind.Include) {
            return new ConfigurationsAndRootKind(OCImportGraph.getInstance(file.getProject()).getAllHeaderConfigurations(fileWithResolve, progress), OCRootKind.Include);
        }
        Collection<OCResolveConfiguration> customConfigurations = OCLibraryFileResolveConfigurationProvider.getConfigurations(file, progress);
        if (customConfigurations != null) {
            return new ConfigurationsAndRootKind(customConfigurations, OCRootKind.Root);
        }
        Collection configs = OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile((VirtualFile)OCFileUtil.getVirtualFile(file), (Project)file.getProject());
        return new ConfigurationsAndRootKind(configs, OCRootKind.Root);
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsForFile(@NotNull PsiFile file, @Nullable ProgressIndicator progress) {
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(4);
        }
        Collection<OCResolveConfiguration> collection = OCInclusionContextUtil.getAllBuildConfigurationsForFileAndIsHeader((PsiFile)file, (ProgressIndicator)progress).configurations;
        if (collection == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public static String pragmaOnceId(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(6);
        }
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_pragma_once");
    }

    public static String inclusionId(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(7);
        }
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_included");
    }

    @NonNls
    private static String fileGuard(@NotNull VirtualFile vFile, @NotNull @NonNls String prefix) {
        if (vFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(8);
        }
        if (prefix == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(9);
        }
        if (vFile instanceof VirtualFileWithId) {
            return prefix + "_id_" + ((VirtualFileWithId)vFile).getId();
        }
        return prefix + "_path_" + vFile.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBuildConfigurationsForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findCachedPsiFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetUserSelectedConfigurations";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllBuildConfigurationsForFileAndIsHeader";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllBuildConfigurationsForFile";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pragmaOnceId";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inclusionId";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fileGuard";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public record ConfigurationsAndRootKind(@NotNull Collection<OCResolveConfiguration> configurations, @NotNull OCRootKind rootKind) {
        @NotNull
        private final Collection<OCResolveConfiguration> configurations;
        @NotNull
        private final OCRootKind rootKind;

        public ConfigurationsAndRootKind(@NotNull Collection<OCResolveConfiguration> configurations, @NotNull OCRootKind rootKind) {
            if (configurations == null) {
                ConfigurationsAndRootKind.$$$reportNull$$$0(0);
            }
            if (rootKind == null) {
                ConfigurationsAndRootKind.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public Collection<OCResolveConfiguration> configurations() {
            Collection<OCResolveConfiguration> collection = this.configurations;
            if (collection == null) {
                ConfigurationsAndRootKind.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @NotNull
        public OCRootKind rootKind() {
            OCRootKind oCRootKind = this.rootKind;
            if (oCRootKind == null) {
                ConfigurationsAndRootKind.$$$reportNull$$$0(3);
            }
            return oCRootKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootKind";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil$ConfigurationsAndRootKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil$ConfigurationsAndRootKind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "configurations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rootKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

