/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCPragmaOnceContentElementType;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCHeaderGuardDetector
extends OCRecursiveVisitor {
    private static final Key<CachedValue<Ref<OCHeaderGuardInfo>>> HEADER_GUARD_CACHE = Key.create((String)"HEADER_GUARD_CACHE");
    @NotNull
    private State myState = State.INITIAL;
    private boolean hasPragmaOnce = false;
    private String myGuardName = null;
    private OCDirective ifndefDirective = null;
    private OCDefineDirective defineDirective = null;
    private OCDirective endifDirective = null;
    private int nestingLevel = 0;

    public boolean hasHeaderGuard(boolean maybeWithoutLastEndif) {
        return this.hasPragmaOnce || this.myState == State.AFTER_GUARD_ENDIF || maybeWithoutLastEndif && this.myState == State.AFTER_GUARD_DEFINE;
    }

    @Override
    public void visitDirective(OCDirective directive) {
        IElementType dirTokenType = OCElementUtil.getElementType(directive.getHeaderToken());
        switch (this.myState.ordinal()) {
            case 4: {
                break;
            }
            case 0: {
                if (OCLexerTokenTypes.IF_DIRECTIVE == dirTokenType) {
                    OCExpression operand;
                    PsiElement nextToken = OCElementUtil.getNextNonWhitespaceSibling(directive.getHeaderToken());
                    if (nextToken instanceof OCUnaryExpression && OCLexerTokenTypes.EXCL == ((OCUnaryExpression)nextToken).getOperationSign() && (operand = ((OCUnaryExpression)nextToken).getOperand()) != null && OCLexerTokenTypes.IDENTIFIER == OCElementUtil.getElementType(operand.getFirstChild()) && "defined".contentEquals(operand.getFirstChild().getText())) {
                        this.myGuardName = OCHeaderGuardDetector.findReferencedNameAtRight(operand.getFirstChild().getNextSibling());
                        if (this.myGuardName != null) {
                            this.myState = State.AFTER_FIRST_IFNDEF;
                            this.ifndefDirective = directive;
                            ++this.nestingLevel;
                            return;
                        }
                    }
                } else if (OCLexerTokenTypes.IFNDEF_DIRECTIVE == dirTokenType) {
                    this.myGuardName = OCHeaderGuardDetector.findReferencedNameAtRight(directive.getHeaderToken().getNextSibling());
                    if (this.myGuardName != null) {
                        this.myState = State.AFTER_FIRST_IFNDEF;
                        this.ifndefDirective = directive;
                        ++this.nestingLevel;
                        return;
                    }
                }
                this.myState = State.NO_IFNDEF_GUARD;
                break;
            }
            case 1: {
                String name;
                if (OCLexerTokenTypes.DEFINE_DIRECTIVE == dirTokenType && (name = ((OCDefineDirective)((Object)directive)).getName()) != null && this.myGuardName != null && this.myGuardName.contentEquals(name)) {
                    this.myState = State.AFTER_GUARD_DEFINE;
                    this.defineDirective = (OCDefineDirective)((Object)directive);
                    return;
                }
                this.myState = State.NO_IFNDEF_GUARD;
                break;
            }
            case 2: {
                if (OCLexerTokenTypes.IF_DIRECTIVES.contains(dirTokenType)) {
                    ++this.nestingLevel;
                } else if (OCLexerTokenTypes.ENDIF_DIRECTIVE == dirTokenType) {
                    --this.nestingLevel;
                } else if ((OCLexerTokenTypes.ELSE_DIRECTIVE == dirTokenType || OCLexerTokenTypes.ELIF_DIRECTIVE == dirTokenType || OCLexerTokenTypes.ELIFDEF_DIRECTIVE == dirTokenType || OCLexerTokenTypes.ELIFNDEF_DIRECTIVE == dirTokenType) && this.nestingLevel == 1) {
                    this.myState = State.NO_IFNDEF_GUARD;
                    return;
                }
                if (this.nestingLevel != 0) break;
                this.myState = State.AFTER_GUARD_ENDIF;
                this.endifDirective = directive;
                return;
            }
            case 3: {
                this.myState = State.NO_IFNDEF_GUARD;
            }
        }
    }

    @Override
    public void visitPragma(OCPragma pragma) {
        PsiElement pragmaKindToken;
        if (this.hasPragmaOnce) {
            return;
        }
        PsiElement pragmaToken = pragma.getHeaderToken().getNextSibling();
        if (pragmaToken != null && OCElementUtil.getElementType(pragmaKindToken = OCElementUtil.getNextNonWhitespaceSibling(pragmaToken)) instanceof OCPragmaOnceContentElementType) {
            this.hasPragmaOnce = true;
            return;
        }
        super.visitPragma(pragma);
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(0);
        }
        this.myState = switch (this.myState.ordinal()) {
            case 0, 1, 3 -> State.NO_IFNDEF_GUARD;
            default -> this.myState;
        };
        super.visitElement(element);
    }

    @Override
    public void visitOCFile(OCFile file) {
        for (PsiElement element : file.getChildren()) {
            element.accept((PsiElementVisitor)this);
        }
    }

    public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
        if (space == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(1);
        }
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(2);
        }
    }

    @Nullable
    private static String findReferencedNameAtRight(@Nullable PsiElement where) {
        if (where == null) {
            return null;
        }
        String name = null;
        boolean firstSibling = true;
        PsiElement next = where;
        while ((next = OCElementUtil.getNextNonWhitespaceSibling(next)) != null) {
            if (next instanceof OCReferenceElement) {
                PsiElement nameCandidate = PsiTreeUtil.getDeepestFirst((PsiElement)next);
                name = nameCandidate.getText();
            }
            if (!firstSibling && OCHeaderGuardDetector.isEssentialNode(next)) {
                return null;
            }
            firstSibling = false;
        }
        return name;
    }

    private static boolean isEssentialNode(@NotNull PsiElement element) {
        if (element == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(3);
        }
        return !OCLexerTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(element)) && OCElementUtil.getElementType(element) != OCLexerTokenTypes.LPAR && OCElementUtil.getElementType(element) != OCLexerTokenTypes.RPAR && !element.getTextRange().isEmpty();
    }

    public static boolean hasHeaderGuard(@NotNull PsiFile file, boolean maybeWithoutLastEndif) {
        if (file == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(4);
        }
        OCHeaderGuardDetector detector = OCHeaderGuardDetector.detect(file);
        return detector.hasHeaderGuard(maybeWithoutLastEndif);
    }

    @Nullable
    public static OCHeaderGuardInfo findHeaderGuard(@NotNull PsiFile file, boolean maybeWithoutLastEndif) {
        if (file == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(5);
        }
        OCHeaderGuardDetector detector = OCHeaderGuardDetector.detect(file);
        if (detector.myState == State.AFTER_GUARD_ENDIF || maybeWithoutLastEndif && detector.myState == State.AFTER_GUARD_DEFINE) {
            return detector.ifndefDirective != null && detector.defineDirective != null && (maybeWithoutLastEndif || detector.endifDirective != null) ? new OCHeaderGuardInfo(detector.ifndefDirective, detector.defineDirective, detector.endifDirective) : null;
        }
        return null;
    }

    @Nullable
    public static OCHeaderGuardInfo findCachedHeaderGuard(@NotNull PsiFile file, boolean maybeWithoutLastEndif) {
        Ref<OCHeaderGuardInfo> cache;
        if (file == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(6);
        }
        if (!(cache = OCHeaderGuardDetector.getHeaderGuardCache(file)).isNull()) {
            return (OCHeaderGuardInfo)cache.get();
        }
        OCHeaderGuardInfo headerGuardInfo = OCHeaderGuardDetector.findHeaderGuard(file, maybeWithoutLastEndif);
        cache.set((Object)headerGuardInfo);
        return headerGuardInfo;
    }

    @NotNull
    private static OCHeaderGuardDetector detect(@NotNull PsiFile file) {
        if (file == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(7);
        }
        OCHeaderGuardDetector detector = new OCHeaderGuardDetector();
        file = OCLanguageUtils.tryGetOCFile(file);
        file.accept((PsiElementVisitor)detector);
        OCHeaderGuardDetector oCHeaderGuardDetector = detector;
        if (oCHeaderGuardDetector == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(8);
        }
        return oCHeaderGuardDetector;
    }

    private static Ref<OCHeaderGuardInfo> getHeaderGuardCache(@NotNull PsiFile file) {
        if (file == null) {
            OCHeaderGuardDetector.$$$reportNull$$$0(9);
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)file.getProject());
        ModificationTracker modificationTracker = FileSymbolTablesCache.getInstance(file.getProject()).getOutOfBlockModificationTracker();
        CachedValueProvider provider2 = () -> new CachedValueProvider.Result((Object)Ref.create(), new Object[]{modificationTracker});
        return (Ref)manager.getCachedValue((UserDataHolder)file, HEADER_GUARD_CACHE, provider2, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "space";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCHeaderGuardDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCHeaderGuardDetector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitWhiteSpace";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitComment";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEssentialNode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasHeaderGuard";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findHeaderGuard";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findCachedHeaderGuard";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderGuardCache";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private static enum State {
        INITIAL,
        AFTER_FIRST_IFNDEF,
        AFTER_GUARD_DEFINE,
        AFTER_GUARD_ENDIF,
        NO_IFNDEF_GUARD;

    }
}

