/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.navigation.CellRenderer;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b&\u0018\u0000 +*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001+B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH&J'\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u0004\u001a\u00028\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020)\u00a2\u0006\u0002\u0010*R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u00000\n\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001f\u001a\u00020 8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020 8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0014\u0010%\u001a\u00020 8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"\u00a8\u0006,"}, d2={"Lcom/jetbrains/cidr/lang/navigation/OCGotoAction;", "Psi", "Lcom/intellij/psi/PsiElement;", "", "source", "icon", "Ljavax/swing/Icon;", "<init>", "(Lcom/intellij/psi/PsiElement;Ljavax/swing/Icon;)V", "mySource", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "value", "getIcon", "()Ljavax/swing/Icon;", "setIcon", "(Ljavax/swing/Icon;)V", "getSource", "()Lcom/intellij/psi/PsiElement;", "targets", "", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "getTargets", "()Ljava/util/Collection;", "navigate", "", "mouseEvent", "Ljava/awt/event/MouseEvent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "tooltip", "", "getTooltip", "()Ljava/lang/String;", "progressTitle", "getProgressTitle", "popupTitle", "getPopupTitle", "createRenderer", "Lcom/intellij/ide/util/PsiElementListCellRenderer;", "", "(Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/PsiElement;)Lcom/intellij/ide/util/PsiElementListCellRenderer;", "Companion", "intellij.c.core"})
public abstract class OCGotoAction<Psi extends PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SmartPsiElementPointer<Psi> mySource;
    @NotNull
    private Icon icon;
    @JvmField
    @NotNull
    protected static final Logger LOG;

    public OCGotoAction(@NotNull Psi source, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)source.getProject()).createSmartPsiElementPointer(source);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        this.mySource = smartPsiElementPointer;
        this.icon = icon;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    protected final void setIcon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"<set-?>");
        this.icon = icon;
    }

    @Nullable
    public final Psi getSource() {
        return (Psi)this.mySource.getElement();
    }

    @Nullable
    public abstract Collection<OCSymbol> getTargets();

    public abstract void navigate(@Nullable MouseEvent var1, @Nullable Editor var2);

    @NlsContexts.Tooltip
    @NotNull
    public abstract String getTooltip();

    @NlsContexts.ProgressTitle
    @VisibleForTesting
    @NotNull
    public abstract String getProgressTitle();

    @NlsContexts.PopupTitle
    @VisibleForTesting
    @NotNull
    public abstract String getPopupTitle();

    @NotNull
    public final PsiElementListCellRenderer<PsiElement> createRenderer(@NotNull Psi source, @NotNull PsiElement[] targets) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(source, targets, CollectionsKt.emptyList());
        return (PsiElementListCellRenderer)new CellRenderer(gotoData);
    }

    static {
        Logger logger = Logger.getInstance((String)OCGotoAction.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/lang/navigation/OCGotoAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.c.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

