/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.jetbrains.cidr.lang.modulemap.serialization.ModuleInfo;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleReference;
import com.jetbrains.cidr.lang.modulemap.serialization.SerializedModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/SerializedModuleMapPrinter;", "", "out", "Ljava/io/PrintWriter;", "<init>", "(Ljava/io/PrintWriter;)V", "writeSerializedPack", "", "pack", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationPack$ProjectPack;", "writeModuleMapString", "map", "Lcom/jetbrains/cidr/lang/modulemap/serialization/SerializedModuleMap;", "writeModuleInfo", "moduleInfo", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleInfo;", "prefix", "", "writeModule", "module", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nSerializedModuleMapPrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializedModuleMapPrinter.kt\ncom/jetbrains/cidr/lang/modulemap/serialization/SerializedModuleMapPrinter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1056#2:60\n1056#2:61\n1056#2:62\n1056#2:63\n*S KotlinDebug\n*F\n+ 1 SerializedModuleMapPrinter.kt\ncom/jetbrains/cidr/lang/modulemap/serialization/SerializedModuleMapPrinter\n*L\n23#1:60\n27#1:61\n36#1:62\n55#1:63\n*E\n"})
public final class SerializedModuleMapPrinter {
    @NotNull
    private final PrintWriter out;

    public SerializedModuleMapPrinter(@NotNull PrintWriter out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
    }

    public final void writeSerializedPack(@NotNull ModuleMapSerializationPack.ProjectPack pack) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        SerializedModuleMap globalMap = pack.getSerializationData().getGlobalMap();
        if (globalMap != null) {
            this.out.println("Global map:");
            this.writeModuleMapString(globalMap);
        }
        for (SerializedModuleMap projectMap : pack.getSerializationData().getProjectMaps()) {
            this.out.println("Project map:");
            this.writeModuleMapString(projectMap);
        }
        this.out.flush();
    }

    private final void writeModuleMapString(SerializedModuleMap map2) {
        Iterable $this$sortedBy$iv = map2.getModuleMap().getModules();
        boolean $i$f$sortedBy = false;
        List modules = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleMapSymbol it = (ModuleMapSymbol)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ModuleMapSymbol)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        for (ModuleMapSymbol module : modules) {
            this.writeModule(module, "  ");
        }
        Iterable $this$sortedBy$iv2 = map2.getModuleInfos();
        boolean $i$f$sortedBy2 = false;
        for (ModuleInfo moduleInfo : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleInfo it = (ModuleInfo)a;
                boolean bl = false;
                Comparable comparable = it.getModule().getModuleName();
                it = (ModuleInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getModule().getModuleName());
            }
        })) {
            this.writeModuleInfo(moduleInfo, "  ");
        }
        this.out.println();
    }

    private final void writeModuleInfo(ModuleInfo moduleInfo, String prefix) {
        this.out.print(prefix);
        this.out.println(moduleInfo.getModule().getModuleName());
        Iterable $this$sortedBy$iv = moduleInfo.getDependencies();
        boolean $i$f$sortedBy = false;
        for (ModuleReference dependency : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleReference it = (ModuleReference)a;
                boolean bl = false;
                Comparable comparable = it.getQualifiedName();
                it = (ModuleReference)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getQualifiedName());
            }
        })) {
            this.out.print(prefix);
            this.out.print("  ");
            this.out.println(dependency.getQualifiedName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeModule(ModuleMapSymbol module, String prefix) {
        void $this$writeModule_u24lambda_u240;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder;
        PrintWriter printWriter = this.out;
        boolean bl = false;
        $this$writeModule_u24lambda_u240.append(prefix);
        $this$writeModule_u24lambda_u240.append(module.getName());
        if (module.isExplicit()) {
            $this$writeModule_u24lambda_u240.append(" [");
            $this$writeModule_u24lambda_u240.append("external");
            $this$writeModule_u24lambda_u240.append("]");
        }
        printWriter.println(stringBuilder.toString());
        Iterable $this$sortedBy$iv = module.getSubModules().values();
        boolean $i$f$sortedBy = false;
        for (ModuleMapSymbol subModule : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleMapSymbol it = (ModuleMapSymbol)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ModuleMapSymbol)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        })) {
            this.writeModule(subModule, prefix + "  ");
        }
    }
}

