/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve.manager;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\bH\u0002J\u0006\u0010\u0011\u001a\u00020\u0012R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u000e*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache;", "", "<init>", "()V", "moduleMapLocationsCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRoot;", "", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "getPossibleModuleMapLocations", "moduleMapRoot", "buildPossibleModuleMapLocations", "headersSearchRoot", "searchRootPath", "", "getSearchRootPath", "(Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;)Ljava/lang/String;", "clear", "", "Companion", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nModuleMapLocationCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapLocationCache.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1869#2,2:46\n*S KotlinDebug\n*F\n+ 1 ModuleMapLocationCache.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache\n*L\n29#1:46,2\n*E\n"})
public final class ModuleMapLocationCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<ModuleMapRoot, Collection<HeadersSearchRoot>> moduleMapLocationsCache;

    public ModuleMapLocationCache() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftMap(...)");
        this.moduleMapLocationsCache = concurrentMap;
    }

    @NotNull
    public final Collection<HeadersSearchRoot> getPossibleModuleMapLocations(@NotNull ModuleMapRoot moduleMapRoot) {
        Intrinsics.checkNotNullParameter((Object)moduleMapRoot, (String)"moduleMapRoot");
        Collection collection = this.moduleMapLocationsCache.computeIfAbsent(moduleMapRoot, arg_0 -> ModuleMapLocationCache.getPossibleModuleMapLocations$lambda$1(arg_0 -> ModuleMapLocationCache.getPossibleModuleMapLocations$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"computeIfAbsent(...)");
        return collection;
    }

    private final Collection<HeadersSearchRoot> buildPossibleModuleMapLocations(HeadersSearchRoot headersSearchRoot) {
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            ModuleMapLog.LOG.trace("Collecting possible module map locations for " + this.getSearchRootPath(headersSearchRoot));
        }
        Collection<HeadersSearchRoot> possibleLocations = ModuleMapUtil.getPossibleModuleMapLocations(headersSearchRoot);
        if (ModuleMapLog.LOG.isTraceEnabled()) {
            Iterable $this$forEach$iv = possibleLocations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HeadersSearchRoot possibleLocation = (HeadersSearchRoot)element$iv;
                boolean bl = false;
                ModuleMapLog.LOG.trace("  found possible location " + this.getSearchRootPath(possibleLocation));
            }
        }
        return possibleLocations;
    }

    private final String getSearchRootPath(HeadersSearchRoot $this$searchRootPath) {
        Object object = $this$searchRootPath.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            String string = $this$searchRootPath.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        return object;
    }

    public final void clear() {
        this.moduleMapLocationsCache.clear();
    }

    private static final Collection getPossibleModuleMapLocations$lambda$0(ModuleMapLocationCache this$0, ModuleMapRoot root) {
        return this$0.buildPossibleModuleMapLocations(root.getRoot());
    }

    private static final Collection getPossibleModuleMapLocations$lambda$1(Function1 $tmp0, Object p0) {
        return (Collection)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.c.core"})
    @SourceDebugExtension(value={"SMAP\nModuleMapLocationCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapLocationCache.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,45:1\n30#2,2:46\n*S KotlinDebug\n*F\n+ 1 ModuleMapLocationCache.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapLocationCache$Companion\n*L\n43#1:46,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModuleMapLocationCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ModuleMapLocationCache> serviceClass$iv = ModuleMapLocationCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ModuleMapLocationCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

