/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve.manager;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKindProvider;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRootIDService;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapSearchRootProvider;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapSyntheticHeadersSearchRoot;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.CacheBase;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.ModuleMapLocationCache;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/CacheImpl;", "Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/CacheBase;", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "<init>", "(Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)V", "getConfiguration", "()Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "buildModuleMapRootCache", "", "Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRoot;", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nCacheImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheImpl.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/manager/CacheImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class CacheImpl
extends CacheBase {
    @NotNull
    private final OCResolveConfiguration configuration;

    public CacheImpl(@NotNull OCResolveConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
    }

    @Override
    @NotNull
    protected OCResolveConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @NotNull
    protected Project getProject() {
        Project project = this.getConfiguration().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @Override
    @NotNull
    protected List<ModuleMapRoot> buildModuleMapRootCache() {
        ModuleMapRootIDService idService = ModuleMapRootIDService.Companion.getInstance();
        ModuleMapLocationCache locationCache = ModuleMapLocationCache.Companion.getInstance(this.getProject());
        List list = OCLanguageKindProvider.getAllLanguageKinds();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllLanguageKinds(...)");
        Sequence normalHeadersSearchRoots2 = SequencesKt.flatMap((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> CacheImpl.buildModuleMapRootCache$lambda$0(this, arg_0)), (Function1)((Function1)new Function1<HeadersSearchRoot, ModuleMapRoot>(idService){
            final /* synthetic */ ModuleMapRootIDService $idService;
            {
                this.$idService = $idService;
                super(1, Intrinsics.Kotlin.class, "toModuleMapRoot", "buildModuleMapRootCache$toModuleMapRoot(Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRootIDService;Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;)Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRoot;", 0);
            }

            public final ModuleMapRoot invoke(HeadersSearchRoot p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return CacheImpl.access$buildModuleMapRootCache$toModuleMapRoot(this.$idService, p0);
            }
        }))), arg_0 -> CacheImpl.buildModuleMapRootCache$lambda$1(locationCache, arg_0));
        List list2 = OCLanguageKindProvider.getAllLanguageKinds();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllLanguageKinds(...)");
        Sequence moduleMapFilesRoots = SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list2), arg_0 -> CacheImpl.buildModuleMapRootCache$lambda$2(this, arg_0)), CacheImpl::buildModuleMapRootCache$lambda$3), CacheImpl::buildModuleMapRootCache$lambda$4), CacheImpl::buildModuleMapRootCache$lambda$5)), arg_0 -> CacheImpl.buildModuleMapRootCache$lambda$6(this, arg_0));
        Sequence<HeadersSearchRoot> extraHeadersSearchRoots = ModuleMapSearchRootProvider.Companion.getExtraHeaderSearchRoots(this.getConfiguration());
        List allRoots2 = SequencesKt.toMutableList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus(extraHeadersSearchRoots, (Sequence)normalHeadersSearchRoots2), (Sequence)moduleMapFilesRoots), (Function1)((Function1)new Function1<HeadersSearchRoot, ModuleMapRoot>(idService){
            final /* synthetic */ ModuleMapRootIDService $idService;
            {
                this.$idService = $idService;
                super(1, Intrinsics.Kotlin.class, "toModuleMapRoot", "buildModuleMapRootCache$toModuleMapRoot(Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRootIDService;Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;)Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRoot;", 0);
            }

            public final ModuleMapRoot invoke(HeadersSearchRoot p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return CacheImpl.access$buildModuleMapRootCache$toModuleMapRoot(this.$idService, p0);
            }
        }))));
        ImmutableList immutableList = ImmutableList.copyOf((Collection)allRoots2);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
        return (List)immutableList;
    }

    private static final ModuleMapRoot buildModuleMapRootCache$toModuleMapRoot(ModuleMapRootIDService idService, HeadersSearchRoot root) {
        return ModuleMapRoot.Companion.createModuleMapRoot(root, idService);
    }

    private static final Sequence buildModuleMapRootCache$lambda$0(CacheImpl this$0, OCLanguageKind kind) {
        return CollectionsKt.asSequence((Iterable)this$0.getConfiguration().getCompilerSettings(kind).getHeadersSearchRoots().getAllRoots());
    }

    private static final Sequence buildModuleMapRootCache$lambda$1(ModuleMapLocationCache $locationCache, ModuleMapRoot root) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Sequence it = sequence = CollectionsKt.asSequence((Iterable)$locationCache.getPossibleModuleMapLocations(root));
        boolean bl = false;
        ProgressManager.checkCanceled();
        return sequence;
    }

    private static final CidrCompilerSwitches buildModuleMapRootCache$lambda$2(CacheImpl this$0, OCLanguageKind kind) {
        ProgressManager.checkCanceled();
        return (CidrCompilerSwitches)ActionsKt.runReadAction(() -> CacheImpl.buildModuleMapRootCache$lambda$2$0(this$0, kind));
    }

    private static final CidrCompilerSwitches buildModuleMapRootCache$lambda$2$0(CacheImpl this$0, OCLanguageKind $kind) {
        return this$0.getConfiguration().getCompilerSettings($kind).getCompilerSwitches();
    }

    private static final Sequence buildModuleMapRootCache$lambda$3(CidrCompilerSwitches switches) {
        Intrinsics.checkNotNullParameter((Object)switches, (String)"switches");
        List list = switches.getList(CidrCompilerSwitches.Format.RAW);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    private static final boolean buildModuleMapRootCache$lambda$4(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"switch");
        return StringsKt.startsWith$default((String)string, (String)"-fmodule-map-file=", (boolean)false, (int)2, null);
    }

    private static final String buildModuleMapRootCache$lambda$5(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"switch");
        return StringUtil.unquoteString((String)StringsKt.removePrefix((String)string, (CharSequence)"-fmodule-map-file="));
    }

    private static final ModuleMapSyntheticHeadersSearchRoot buildModuleMapRootCache$lambda$6(CacheImpl this$0, String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new ModuleMapSyntheticHeadersSearchRoot(this$0.getProject(), new File(path));
    }

    public static final /* synthetic */ ModuleMapRoot access$buildModuleMapRootCache$toModuleMapRoot(ModuleMapRootIDService idService, HeadersSearchRoot root) {
        return CacheImpl.buildModuleMapRootCache$toModuleMapRoot(idService, root);
    }
}

