/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.intentions.OCBraceToggleBaseIntentionAction;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCSingleStatementWithBracesIntentionAction
extends OCBraceToggleBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(OCSingleStatementWithBracesIntentionAction.class);

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.remove.braces.statement.family", (Object[])new Object[0]);
        if (string == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message((String)"intentions.remove.braces.statement", (Object[])new Object[]{this.getStatementName()});
        if (string == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private OCBlockStatement getContainedBlockStatement(@NotNull OCStatement statement, @NotNull PsiElement element) {
        PsiElement bodyElement;
        if (statement == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(3);
        }
        if (!((bodyElement = this.getBodyElement(statement, element)) instanceof OCBlockStatement)) {
            return null;
        }
        return (OCBlockStatement)bodyElement;
    }

    @Override
    protected void doRun(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCStatement statement;
        if (project == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((statement = OCSingleStatementWithBracesIntentionAction.getParentStatement(element)) != null);
        OCBlockStatement blockStatement = this.getContainedBlockStatement(statement, element);
        LOG.assertTrue(blockStatement != null);
        List<OCStatement> statements = blockStatement.getStatements();
        LOG.assertTrue(statements.size() == 1);
        PsiElement bodyStatement = statements.get(0);
        CaretModel caretModel = editor.getCaretModel();
        int moveCaretBy = OCSingleStatementWithBracesIntentionAction.getCaretAdjustment(caretModel, bodyStatement);
        PsiElement newElement = OCSingleStatementWithBracesIntentionAction.replaceElement(blockStatement, bodyStatement);
        OCSingleStatementWithBracesIntentionAction.moveCaret(caretModel, moveCaretBy, newElement);
        OCSingleStatementWithBracesIntentionAction.reformat(project, editor.getDocument(), statement);
    }

    @Override
    protected boolean isValidElement(@NotNull OCStatement statement, @NotNull PsiElement element) {
        OCBlockStatement blockStatement;
        if (statement == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(6);
        }
        if (element == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(7);
        }
        return (blockStatement = this.getContainedBlockStatement(statement, element)) != null && OCParenthesesUtils.canStripBraces(blockStatement);
    }

    @NotNull
    private static PsiElement replaceElement(@NotNull PsiElement oldElement, @NotNull PsiElement replaceElement) {
        if (oldElement == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(8);
        }
        if (replaceElement == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(9);
        }
        PsiElement leftMostSibling = OCSingleStatementWithBracesIntentionAction.getLeftMostMacroCallOrWhiteSpaceSibling(replaceElement);
        PsiElement rightMostSibling = OCSingleStatementWithBracesIntentionAction.getRightMostMacroCallOrWhiteSpaceSibling(replaceElement);
        if (leftMostSibling != replaceElement) {
            oldElement.getParent().addRangeBefore(leftMostSibling, replaceElement.getPrevSibling(), oldElement);
            replaceElement.getParent().deleteChildRange(leftMostSibling, replaceElement.getPrevSibling());
        }
        if (rightMostSibling != replaceElement) {
            oldElement.getParent().addRangeAfter(replaceElement.getNextSibling(), rightMostSibling, oldElement);
            replaceElement.getParent().deleteChildRange(replaceElement.getNextSibling(), rightMostSibling);
        }
        PsiElement psiElement = oldElement.replace(replaceElement);
        if (psiElement == null) {
            OCSingleStatementWithBracesIntentionAction.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCSingleStatementWithBracesIntentionAction";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCSingleStatementWithBracesIntentionAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContainedBlockStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValidElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

