/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedCppInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedVisitor;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCUnusedStructInspection
extends OCUnusedCppInspection {
    private static final Set<String> specialStructNames = Set.of("tuple_size", "tuple_element");

    @Override
    @NotNull
    public OCUnusedVisitor buildVisitor() {
        return new OCUnusedVisitor(this, (OCInspection)this){

            @Override
            public void visitStructLike(OCStructLike struct) {
                OCSymbol symbol = this.getSymbol(struct);
                if (symbol != null && !struct.isElaboratedTypeDeclaration() && !specialStructNames.contains(symbol.getName())) {
                    this.checkSymbolUsed(struct, symbol);
                }
            }
        };
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = OCInspectionsBundle.message((String)"inspection.unused.struct.display.name", (Object[])new Object[0]);
        if (string == null) {
            OCUnusedStructInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean runForWholeFile() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCUnusedStructInspection", "getDisplayName"));
    }
}

