/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedObjCInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedVisitor;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCUnusedClassInspection
extends OCUnusedObjCInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = OCInspectionsBundle.message((String)"inspection.unused.class.display.name", (Object[])new Object[0]);
        if (string == null) {
            OCUnusedClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public OCUnusedVisitor buildVisitor() {
        return new OCUnusedVisitor(this, (OCInspection)this){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                OCSymbol symbol = this.getSymbol(dcl);
                if (!this.myOnTheFly && symbol != null && symbol.isPredeclaration()) {
                    return;
                }
                if (symbol instanceof OCProtocolSymbol) {
                    this.checkSymbolUsed(dcl, symbol);
                } else if (symbol instanceof OCClassSymbol) {
                    Project project = dcl.getProject();
                    OCInterfaceSymbol interfaceSymbol = ((OCClassSymbol)symbol).getMainInterface(project);
                    if (interfaceSymbol == null) {
                        this.checkSymbolUsed(dcl, symbol);
                    } else if (this.myOnTheFly || interfaceSymbol == symbol) {
                        this.checkSymbolUsed(interfaceSymbol.locateDefinition(project), dcl, interfaceSymbol);
                    }
                }
            }
        };
    }

    public boolean runForWholeFile() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCUnusedClassInspection", "getDisplayName"));
    }
}

