/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateDefinitionQuickFix;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.inspections.OCProblemRegister;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCMakeFunctionVirtualFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NotImplementedFunctions
extends OCInspections.Functions {
    public boolean runForWholeFile() {
        return true;
    }

    public boolean worksWithClangd() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = OCInspectionsBundle.message((String)"inspection.not.implemented.functions.display.name", (Object[])new Object[0]);
        if (string == null) {
            NotImplementedFunctions.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            NotImplementedFunctions.$$$reportNull$$$0(1);
        }
        if (!OCSearchScope.isInProjectSources((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
            if (psiElementVisitor == null) {
                NotImplementedFunctions.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new OCVisitor(this){

            @Override
            public void visitFunctionDeclaration(@NotNull OCFunctionDeclaration function) {
                if (function == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (function instanceof OCFunctionDefinition) {
                    return;
                }
                if (!function.isPossibleStructMember()) {
                    return;
                }
                OCDeclarator declarator = function.getDeclarator();
                if (declarator != null && declarator.getInitializer() != null) {
                    return;
                }
                OCFunctionSymbol symbol = (OCFunctionSymbol)ObjectUtils.tryCast((Object)function.getSymbol(), OCFunctionSymbol.class);
                if (symbol != null && symbol.isPredeclaration() && !symbol.isDefault() && !symbol.isDelete() && OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(symbol, true, holder.getProject()) == OCCppDefinitionsUtil.SHOULD_GENERATE_DEFINITION.REQUIRED) {
                    OCCompilationContext compilationContext = OCCompilationContext.create(function);
                    OCProblemRegister.ProblemConsumer consumer = new OCProblemRegister.ProblemConsumer(holder, null, null, isOnTheFly);
                    OCProblemRegister.registerProblem(consumer, function.getHeaderRange(), OCBundle.message("inspection.message.function.not.implemented", symbol.getNameWithKindUppercase(compilationContext)), "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NotImplementedFunctions.class, new OCGenerateDefinitionQuickFix(symbol, true, compilationContext), new OCGenerateDefinitionQuickFix(symbol, false, compilationContext), new OCMakeFunctionVirtualFix(symbol, true, holder.getProject()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/cidr/lang/inspections/NotImplementedFunctions$1", "visitFunctionDeclaration"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/NotImplementedFunctions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/NotImplementedFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

