/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.EmptyIcon;
import com.jetbrains.cidr.lang.hierarchy.structureView.OCElementNameUtil;
import com.jetbrains.cidr.lang.hierarchy.structureView.OCMark;
import com.jetbrains.cidr.lang.hierarchy.structureView.OCMarkedStructureViewElement;
import com.jetbrains.cidr.lang.hierarchy.structureView.OCStructureViewModel;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStructureViewElement
implements StructureViewTreeElement,
OCMarkedStructureViewElement {
    public static final TextAttributesKey OC_PRAGMA_MARK = TextAttributesKey.createTextAttributesKey((String)"OC_PRAGMA_MARK", (TextAttributes)new TextAttributes(JBColor.foreground(), null, null, null, 1));
    @Nullable
    private final Object myElementAnchor;
    @Nullable
    private final Object myContextAnchor;
    @Nullable
    private final Object myParentMarkAnchor;
    @Nullable
    private String myPresentableQN;
    @Nullable
    private OCStructureViewModel myViewModel;

    public OCStructureViewElement(@NotNull PsiElement element, @Nullable PsiElement context) {
        if (element == null) {
            OCStructureViewElement.$$$reportNull$$$0(0);
        }
        this(null, element, context, null);
    }

    protected OCStructureViewElement(@Nullable OCStructureViewModel viewModel, @Nullable PsiElement element, @Nullable PsiElement context, @Nullable PsiElement parentMark) {
        this.myPresentableQN = null;
        this.myViewModel = viewModel;
        TreeAnchorizer service = TreeAnchorizer.getService();
        this.myElementAnchor = element != null ? service.createAnchor((Object)element) : null;
        this.myContextAnchor = context != null ? service.createAnchor((Object)context) : null;
        this.myParentMarkAnchor = parentMark != null ? service.createAnchor((Object)parentMark) : null;
    }

    public void setViewModel(@Nullable OCStructureViewModel viewModel) {
        this.myViewModel = viewModel;
    }

    @Nullable
    public OCStructureViewModel getViewModel() {
        return this.myViewModel;
    }

    @Nullable
    public String getFullQN() {
        Pair<String, Boolean> pair = OCElementNameUtil.getPresentableNameAndQNOwnership(this.getValue(), true);
        if (!((Boolean)pair.second).booleanValue()) {
            return null;
        }
        int idSplitterPos = ((String)pair.first).lastIndexOf(" : ");
        if (idSplitterPos < 0) {
            return OCElementNameUtil.stripLastID((String)pair.first);
        }
        String idPart = OCElementNameUtil.stripLastID(((String)pair.first).substring(0, idSplitterPos));
        int pos = idPart.lastIndexOf("::");
        if (pos < 0) {
            return null;
        }
        return OCElementNameUtil.stripLastID(idPart);
    }

    @Nullable
    public PsiElement getValue() {
        return this.myElementAnchor != null ? (PsiElement)TreeAnchorizer.getService().retrieveElement(this.myElementAnchor) : null;
    }

    @Nullable
    private PsiElement getContext() {
        return this.myContextAnchor != null ? (PsiElement)TreeAnchorizer.getService().retrieveElement(this.myContextAnchor) : null;
    }

    @Override
    @Nullable
    public PsiElement getParentMarkElement() {
        return this.myParentMarkAnchor != null ? (PsiElement)TreeAnchorizer.getService().retrieveElement(this.myParentMarkAnchor) : null;
    }

    public boolean isAllowInheritorsAndCategories() {
        return this.myContextAnchor == null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new OCItemPresentation(this.getValue(), this.getPresentableQN());
    }

    public boolean showQualifiedNames() {
        if (this.myViewModel == null) {
            return false;
        }
        return this.myViewModel.showQualifiedNames();
    }

    public TreeElement @NotNull [] getChildren() {
        PsiElement element = this.getValue();
        if (element == null || element instanceof OCDeclarator || element instanceof OCFunctionDefinition || element instanceof OCMethod) {
            if (StructureViewTreeElement.EMPTY_ARRAY == null) {
                OCStructureViewElement.$$$reportNull$$$0(1);
            }
            return StructureViewTreeElement.EMPTY_ARRAY;
        }
        PsiElement context = this.getContext();
        if (this.myContextAnchor != null && context == null) {
            if (EMPTY_ARRAY == null) {
                OCStructureViewElement.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        final ArrayList children = new ArrayList();
        element.acceptChildren((PsiElementVisitor)new OCVisitor(){

            @Override
            public void visitOCElement(OCElement elem) {
                if (OCStructureViewElement.this.worthyElement(elem)) {
                    children.add(elem);
                } else if (!1.notWorthyElement(elem)) {
                    elem.acceptChildren(this);
                }
            }

            public void visitComment(@NotNull PsiComment comment) {
                if (comment == null) {
                    1.$$$reportNull$$$0(0);
                }
                children.add(comment);
            }

            @Override
            public void visitPragma(OCPragma pragma) {
                children.add(pragma);
            }

            private static boolean notWorthyElement(OCElement elem) {
                return elem instanceof OCTemplateParameterList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/jetbrains/cidr/lang/hierarchy/structureView/OCStructureViewElement$1", "visitComment"));
            }
        });
        ArrayList<OCStructureViewElement> result = new ArrayList<OCStructureViewElement>();
        PsiElement previousMark = null;
        for (PsiElement o : children) {
            Object symbol;
            if (!(o instanceof OCCppNamespace) && o instanceof PsiNamedElement && ((PsiNamedElement)o).getName() == null || o instanceof OCSymbolDeclarator && context != null && (symbol = ((OCSymbolDeclarator)o).getSymbol()) != null && !OCVisibility.isVisible(symbol, context, null, o.getProject())) continue;
            if (o instanceof OCPragma || o instanceof PsiComment) {
                OCMark mark;
                if (!this.addPragmasAndComments() || (mark = OCMark.createFromElement(o)) == null) continue;
                previousMark = o;
                if (mark.getText() == null) continue;
                result.add(this.createChildElement(o, context, o));
                continue;
            }
            result.add(this.createChildElement(o, context, previousMark));
        }
        TreeElement[] treeElementArray = result.toArray(TreeElement.EMPTY_ARRAY);
        if (treeElementArray == null) {
            OCStructureViewElement.$$$reportNull$$$0(3);
        }
        return treeElementArray;
    }

    @NotNull
    protected OCStructureViewElement createChildElement(@NotNull PsiElement element, @Nullable PsiElement context, @Nullable PsiElement previousMark) {
        if (element == null) {
            OCStructureViewElement.$$$reportNull$$$0(4);
        }
        return new OCStructureViewElement(this.myViewModel, element, context, previousMark);
    }

    protected boolean addPragmasAndComments() {
        return true;
    }

    protected boolean worthyElement(OCElement element) {
        OCCppUsingStatement usingStmt;
        OCStructLike structLike;
        return element instanceof OCDefineDirective || element instanceof OCDeclarator || element instanceof OCFunctionDefinition || element instanceof OCCppNamespace || element instanceof OCStructLike && OCStructureViewElement.shouldIncludeStructLike(structLike = (OCStructLike)element) || element instanceof OCMethod || element instanceof OCInterface || element instanceof OCImplementation || element instanceof OCProtocol || element instanceof OCCppUsingStatement && !(usingStmt = (OCCppUsingStatement)element).isNamespaceUsing();
    }

    private static boolean shouldIncludeStructLike(@NotNull OCStructLike structLike) {
        OCDeclaration declaration;
        if (structLike == null) {
            OCStructureViewElement.$$$reportNull$$$0(5);
        }
        if (structLike.isDeclaration()) {
            return true;
        }
        PsiElement typeElem = structLike.getParent();
        if (!(typeElem instanceof OCTypeElement)) {
            return false;
        }
        PsiElement decl = typeElem.getParent();
        return decl instanceof OCDeclaration && (declaration = (OCDeclaration)decl).getDeclarators().isEmpty();
    }

    public void navigate(boolean requestFocus) {
        PsiElement element = this.getValue();
        if (element instanceof Navigatable) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        PsiElement element = this.getValue();
        return element instanceof Navigatable && ((Navigatable)element).canNavigate();
    }

    public boolean canNavigateToSource() {
        PsiElement element = this.getValue();
        return element instanceof Navigatable && ((Navigatable)element).canNavigateToSource();
    }

    public void setPresentableQN(@NotNull String presentableQNAfterGrouping) {
        if (presentableQNAfterGrouping == null) {
            OCStructureViewElement.$$$reportNull$$$0(6);
        }
        this.myPresentableQN = presentableQNAfterGrouping;
    }

    @Nullable
    public String getPresentableQN() {
        return this.myPresentableQN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/hierarchy/structureView/OCStructureViewElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structLike";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableQNAfterGrouping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/hierarchy/structureView/OCStructureViewElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createChildElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldIncludeStructLike";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPresentableQN";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    protected static class OCItemPresentation
    implements ColoredItemPresentation {
        protected final PsiElement myElement;
        private final String myPresentableQN;

        protected OCItemPresentation(@Nullable PsiElement element, @Nullable String presentableQN) {
            this.myElement = element;
            this.myPresentableQN = presentableQN;
        }

        public String getPresentableText() {
            boolean withFullQN = this.myPresentableQN == null;
            Pair<String, Boolean> p = OCElementNameUtil.getPresentableNameAndQNOwnership(this.myElement, withFullQN);
            return withFullQN ? (String)p.first : (this.myPresentableQN.isEmpty() ? (String)p.first : this.myPresentableQN + "::" + (String)p.first);
        }

        public Icon getIcon(boolean open) {
            return OCElementNameUtil.isMark(this.myElement) ? EmptyIcon.ICON_16 : (this.myElement != null && this.myElement.isValid() ? this.myElement.getIcon(0) : null);
        }

        private static boolean isDeprecatedSymbol(@NotNull PsiElement element) {
            if (element == null) {
                OCItemPresentation.$$$reportNull$$$0(0);
            }
            if (!(element instanceof OCSymbolDeclarator)) {
                return false;
            }
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            return symbol != null && symbol.hasAttribute("deprecated");
        }

        public TextAttributesKey getTextAttributesKey() {
            if (this.myElement != null && OCItemPresentation.isDeprecatedSymbol(this.myElement)) {
                return CodeInsightColors.DEPRECATED_ATTRIBUTES;
            }
            return OCElementNameUtil.isMark(this.myElement) ? OC_PRAGMA_MARK : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/hierarchy/structureView/OCStructureViewElement$OCItemPresentation", "isDeprecatedSymbol"));
        }
    }
}

