/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureView;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCPragma;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/hierarchy/structureView/OCMark;", "", "isSeparatorBefore", "", "text", "", "isSeparatorAfter", "kind", "Lcom/jetbrains/cidr/lang/hierarchy/structureView/OCMark$Kind;", "<init>", "(ZLjava/lang/String;ZLcom/jetbrains/cidr/lang/hierarchy/structureView/OCMark$Kind;)V", "()Z", "getText", "()Ljava/lang/String;", "getKind", "()Lcom/jetbrains/cidr/lang/hierarchy/structureView/OCMark$Kind;", "toString", "Kind", "Companion", "intellij.c.core"})
public final class OCMark {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isSeparatorBefore;
    @Nullable
    private final String text;
    private final boolean isSeparatorAfter;
    @NotNull
    private final Kind kind;
    @NotNull
    private static final OCMark SEPARATOR = new OCMark(true, null, false, Kind.MARK);
    @NotNull
    private static final OCMark TODO_SEPARATOR = new OCMark(true, "TODO", false, Kind.TODO);
    @NotNull
    private static final OCMark FIXME_SEPARATOR = new OCMark(true, "FIXME", false, Kind.FIXME);
    @NotNull
    private static final Kind DEFAULT_MARK_KIND = Kind.MARK;
    @NotNull
    private static final Pattern COMMENT_PATTERN;
    @NotNull
    private static final Pattern MARK_PATTERN;

    public OCMark(boolean isSeparatorBefore, @NlsSafe @Nullable String text, boolean isSeparatorAfter, @NotNull Kind kind) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.isSeparatorBefore = isSeparatorBefore;
        this.text = text;
        this.isSeparatorAfter = isSeparatorAfter;
        this.kind = kind;
    }

    public final boolean isSeparatorBefore() {
        return this.isSeparatorBefore;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final boolean isSeparatorAfter() {
        return this.isSeparatorAfter;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NotNull
    public String toString() {
        Object object;
        if (this.isSeparatorBefore) {
            object = "-";
        } else {
            String string = this.text;
            if (string == null) {
                string = "";
            }
            object = string + (this.isSeparatorAfter ? "-" : "");
        }
        return object;
    }

    @NotNull
    public static final OCMark getSEPARATOR() {
        return Companion.getSEPARATOR();
    }

    @NotNull
    public static final OCMark getTODO_SEPARATOR() {
        return Companion.getTODO_SEPARATOR();
    }

    @NotNull
    public static final OCMark getFIXME_SEPARATOR() {
        return Companion.getFIXME_SEPARATOR();
    }

    @NotNull
    public static final Kind getDEFAULT_MARK_KIND() {
        return Companion.getDEFAULT_MARK_KIND();
    }

    @JvmStatic
    public static final boolean isMarkElement(@Nullable Object element) {
        return Companion.isMarkElement(element);
    }

    @JvmStatic
    @Nullable
    public static final OCMark createFromElement(@NotNull PsiElement element) {
        return Companion.createFromElement(element);
    }

    @JvmStatic
    @NotNull
    public static final OCMark createFromPragmaMarkText(@NotNull String pragmaText) {
        return Companion.createFromPragmaMarkText(pragmaText);
    }

    @JvmStatic
    @Nullable
    public static final OCMark createFromCommentText(@NotNull String commentText) {
        return Companion.createFromCommentText(commentText);
    }

    @JvmStatic
    public static final boolean isMarkCommentText(@NotNull String commentText) {
        return Companion.isMarkCommentText(commentText);
    }

    static {
        Pattern pattern = Pattern.compile(".*(MARK|TODO|FIXME):([^*]+?)\\s*(\\*|$)", 8);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        COMMENT_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("^\\s*(MARK|TODO|FIXME):(.*?)\\s*$", 8);
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        MARK_PATTERN = pattern2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u001eH\u0007J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001eH\u0007J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0018\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u001eH\u0002J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0010H\u0002R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\bR\u001c\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0003\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/cidr/lang/hierarchy/structureView/OCMark$Companion;", "", "<init>", "()V", "SEPARATOR", "Lcom/jetbrains/cidr/lang/hierarchy/structureView/OCMark;", "getSEPARATOR$annotations", "getSEPARATOR", "()Lcom/jetbrains/cidr/lang/hierarchy/structureView/OCMark;", "TODO_SEPARATOR", "getTODO_SEPARATOR$annotations", "getTODO_SEPARATOR", "FIXME_SEPARATOR", "getFIXME_SEPARATOR$annotations", "getFIXME_SEPARATOR", "DEFAULT_MARK_KIND", "Lcom/jetbrains/cidr/lang/hierarchy/structureView/OCMark$Kind;", "getDEFAULT_MARK_KIND$annotations", "getDEFAULT_MARK_KIND", "()Lcom/jetbrains/cidr/lang/hierarchy/structureView/OCMark$Kind;", "COMMENT_PATTERN", "Ljava/util/regex/Pattern;", "MARK_PATTERN", "isMarkElement", "", "element", "createFromElement", "Lcom/intellij/psi/PsiElement;", "createFromPragmaMarkText", "pragmaText", "", "createFromCommentText", "commentText", "isMarkCommentText", "extractTextUsingPattern", "pattern", "createFromText", "kind", "text", "separator", "markKind", "intellij.c.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OCMark getSEPARATOR() {
            return SEPARATOR;
        }

        @JvmStatic
        public static /* synthetic */ void getSEPARATOR$annotations() {
        }

        @NotNull
        public final OCMark getTODO_SEPARATOR() {
            return TODO_SEPARATOR;
        }

        @JvmStatic
        public static /* synthetic */ void getTODO_SEPARATOR$annotations() {
        }

        @NotNull
        public final OCMark getFIXME_SEPARATOR() {
            return FIXME_SEPARATOR;
        }

        @JvmStatic
        public static /* synthetic */ void getFIXME_SEPARATOR$annotations() {
        }

        @NotNull
        public final Kind getDEFAULT_MARK_KIND() {
            return DEFAULT_MARK_KIND;
        }

        @JvmStatic
        public static /* synthetic */ void getDEFAULT_MARK_KIND$annotations() {
        }

        @JvmStatic
        public final boolean isMarkElement(@Nullable Object element) {
            return element instanceof PsiElement && this.createFromElement((PsiElement)element) != null;
        }

        @JvmStatic
        @Nullable
        public final OCMark createFromElement(@NotNull PsiElement element) {
            ASTNode mark;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element instanceof PsiComment) {
                String string = ((PsiComment)element).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return this.createFromCommentText(string);
            }
            if (element instanceof OCPragma && (mark = ((OCPragma)element).getNode().findChildByType((IElementType)OCTokenTypes.PRAGMA_MARK_LITERAL)) != null) {
                String string = (String)((OCPragma)element).getContent((PsiElement)mark.getPsi(), (boolean)true).first;
                if (string == null) {
                    string = "";
                }
                return this.createFromPragmaMarkText(string);
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final OCMark createFromPragmaMarkText(@NotNull String pragmaText) {
            Intrinsics.checkNotNullParameter((Object)pragmaText, (String)"pragmaText");
            OCMark oCMark = this.extractTextUsingPattern(pragmaText, MARK_PATTERN);
            if (oCMark == null) {
                oCMark = this.createFromText(Kind.MARK, pragmaText);
            }
            return oCMark;
        }

        @JvmStatic
        @Nullable
        public final OCMark createFromCommentText(@NotNull String commentText) {
            Intrinsics.checkNotNullParameter((Object)commentText, (String)"commentText");
            return this.extractTextUsingPattern(commentText, COMMENT_PATTERN);
        }

        @JvmStatic
        public final boolean isMarkCommentText(@NotNull String commentText) {
            Intrinsics.checkNotNullParameter((Object)commentText, (String)"commentText");
            return COMMENT_PATTERN.matcher(commentText).find();
        }

        private final OCMark extractTextUsingPattern(String commentText, Pattern pattern) {
            Matcher matcher = pattern.matcher(commentText);
            if (matcher.find()) {
                String string = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                Kind markKind = Kind.valueOf(string);
                String origText = matcher.group(2);
                Intrinsics.checkNotNull((Object)origText);
                return this.createFromText(markKind, origText);
            }
            return null;
        }

        private final OCMark createFromText(Kind kind, String text) {
            if (StringsKt.isBlank((CharSequence)text)) {
                return this.separator(kind);
            }
            String trimmed = ((Object)StringsKt.trim((CharSequence)text)).toString();
            if (Intrinsics.areEqual((Object)"-", (Object)trimmed)) {
                return this.separator(kind);
            }
            Object label = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)trimmed, (CharSequence)"- "), (CharSequence)" -"))).toString();
            if (kind != this.getDEFAULT_MARK_KIND()) {
                label = kind + ": " + (String)label;
            }
            return new OCMark(StringsKt.startsWith$default((String)trimmed, (String)"- ", (boolean)false, (int)2, null), (String)label, StringsKt.endsWith$default((String)trimmed, (String)" -", (boolean)false, (int)2, null), kind);
        }

        private final OCMark separator(Kind markKind) {
            return switch (WhenMappings.$EnumSwitchMapping$0[markKind.ordinal()]) {
                case 1 -> this.getTODO_SEPARATOR();
                case 2 -> this.getFIXME_SEPARATOR();
                default -> this.getSEPARATOR();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Kind.values().length];
                try {
                    nArray[Kind.TODO.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Kind.FIXME.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/hierarchy/structureView/OCMark$Kind;", "", "<init>", "(Ljava/lang/String;I)V", "MARK", "TODO", "FIXME", "intellij.c.core"})
    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind MARK = new Kind();
        public static final /* enum */ Kind TODO = new Kind();
        public static final /* enum */ Kind FIXME = new Kind();
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value) {
            return Enum.valueOf(Kind.class, value);
        }

        @NotNull
        public static EnumEntries<Kind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.MARK, Kind.TODO, Kind.FIXME};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

