/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.include;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImportSuperHierarchyTreeStructure
extends HierarchyTreeStructure {
    private static final boolean DISPLAY_LOCATION = !ApplicationManager.getApplication().isUnitTestMode();

    public OCImportSuperHierarchyTreeStructure(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(1);
        }
        super(project, OCImportSuperHierarchyTreeStructure.createDescriptor(project, null, file, true, DISPLAY_LOCATION));
    }

    protected Object @NotNull [] buildChildren(@NotNull HierarchyNodeDescriptor nodeDescriptor) {
        if (nodeDescriptor == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(2);
        }
        OCClassHierarchyNodeDescriptor descriptor = (OCClassHierarchyNodeDescriptor)nodeDescriptor;
        PsiFile file = (PsiFile)descriptor.getType();
        FileSymbolTablesCache.getInstance(this.myProject).ensurePendingFilesProcessed();
        if (file == null) {
            if (HierarchyNodeDescriptor.EMPTY_ARRAY == null) {
                OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(3);
            }
            return HierarchyNodeDescriptor.EMPTY_ARRAY;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            if (HierarchyNodeDescriptor.EMPTY_ARRAY == null) {
                OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(4);
            }
            return HierarchyNodeDescriptor.EMPTY_ARRAY;
        }
        OCImportGraph importGraph = OCImportGraph.getInstance(this.myProject);
        Collection<VirtualFile> includingFiles = importGraph.findImmediateIncludingFiles(vFile, false);
        List answer = PsiUtilCore.toPsiFiles((PsiManager)PsiManager.getInstance((Project)this.myProject), includingFiles);
        return OCImportSuperHierarchyTreeStructure.convertToDescriptors(this.myProject, descriptor, answer, DISPLAY_LOCATION);
    }

    public static HierarchyNodeDescriptor @NotNull [] convertToDescriptors(@NotNull Project project, @Nullable OCClassHierarchyNodeDescriptor<PsiFile> parent, @NotNull Collection<PsiFile> files, boolean displayLocation) {
        if (project == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(5);
        }
        if (files == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(6);
        }
        HierarchyNodeDescriptor[] descriptors = new HierarchyNodeDescriptor[files.size()];
        int i = 0;
        for (PsiFile superFile : files) {
            OCFile ocFile = OCLanguageUtils.asOCFile(superFile);
            OCLog.LOG.assertTrue(ocFile != null, (Object)superFile);
            descriptors[i] = OCImportSuperHierarchyTreeStructure.createDescriptor(project, parent, ocFile, false, displayLocation);
            ++i;
        }
        if (descriptors == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(7);
        }
        return descriptors;
    }

    @NotNull
    public static HierarchyNodeDescriptor createDescriptor(@NotNull Project project, @Nullable OCClassHierarchyNodeDescriptor<PsiFile> parent, @NotNull PsiFile superFile, boolean isBase, boolean displayLocation) {
        if (project == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(8);
        }
        if (superFile == null) {
            OCImportSuperHierarchyTreeStructure.$$$reportNull$$$0(9);
        }
        return new OCClassHierarchyNodeDescriptor<PsiFile>(project, parent, superFile, isBase, displayLocation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/hierarchy/include/OCImportSuperHierarchyTreeStructure";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/hierarchy/include/OCImportSuperHierarchyTreeStructure";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertToDescriptors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7 -> new IllegalStateException(string);
        };
    }
}

