/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers.implement;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCOverrideImplementCppActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCOverrideImplementCppFunctionsHandlerBase
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCFunctionSymbol, OCOverrideImplementCppActionContext> {
    private static final OCBooleanOption INSERT_OVERRIDE = new OCBooleanOption(OCBundle.message("override.implement.cpp.action.insertOverride", new Object[0]));

    @Override
    @NotNull
    protected String getActionTitle() {
        String string = OCBundle.message("override.implement.cpp.action.title", new Object[0]);
        if (string == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCOverrideImplementCppActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        if (actionContext == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(1);
        }
        if (options == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(2);
        }
        if (OCCompilerFeaturesHelper.supportsOverrideControl(file)) {
            options.add((Pair<OCOption, Object>)new Pair((Object)INSERT_OVERRIDE, (Object)(settings == null || settings.INSERT_OVERRIDE ? 1 : 0)));
        }
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    protected void saveOptions(PsiFile file, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (settings == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(3);
        }
        if (optionValues.containsKey(INSERT_OVERRIDE)) {
            settings.INSERT_OVERRIDE = OCOverrideImplementCppFunctionsHandlerBase.getOption(optionValues, INSERT_OVERRIDE);
        }
        super.saveOptions(file, settings, optionValues);
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCFunctionSymbol> candidates, OCOverrideImplementCppActionContext actionContext, int moreNodesLevel) {
        Map<OCSymbol, OCSymbol> parentsMap = actionContext.createParentsMap(candidates);
        return (OCMemberChooserObject[])ContainerUtil.map2Array(candidates, OCMemberChooserObject.class, m -> {
            boolean isIncomplete = m.isPureVirtual() || Comparing.equal((Object)((OCSymbolWithQualifiedName)actionContext.getParent()), (Object)m.getParent());
            return new OCMemberChooserObject((OCSymbol)m, OCIcons.getFunctionIcon(m.isFriendOrStatic(), isIncomplete, !m.isVirtual(), m.getVisibility()), parentsMap, actionContext.getProject());
        });
    }

    @Override
    @NotNull
    protected String getFeatureId() {
        return "codeassists.overrideimplement";
    }

    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull OCCaretLocation location, @NotNull OCOverrideImplementCppActionContext actionContext, @NotNull List<OCFunctionSymbol> chosenCandidates) {
        if (project == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(4);
        }
        if (location == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(5);
        }
        if (actionContext == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(6);
        }
        if (chosenCandidates == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(7);
        }
        chosenCandidates = ContainerUtil.sorted(chosenCandidates, (fun1, fun2) -> {
            OCVisibility visibility2;
            OCResolveContext context = location.createContext();
            OCVisibility visibility1 = OCOverrideImplementCppFunctionsHandlerBase.getInheritorVisibility(fun1, (OCStructSymbol)actionContext.getParent(), context);
            if (visibility1 == (visibility2 = OCOverrideImplementCppFunctionsHandlerBase.getInheritorVisibility(fun2, (OCStructSymbol)actionContext.getParent(), context))) {
                int filesCmp = FileUtil.comparePaths((String)fun1.getContainingFile().getPath(), (String)fun2.getContainingFile().getPath());
                return filesCmp != 0 ? filesCmp : fun1.getOffset() - fun2.getOffset();
            }
            return visibility1.compareTo(visibility2);
        });
        super.doPerformAction(project, location, actionContext, chosenCandidates);
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(@NotNull OCCaretLocation location, @NotNull OCOverrideImplementCppActionContext actionContext, @NotNull List<OCFunctionSymbol> functions) {
        PsiElement element;
        if (location == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(8);
        }
        if (actionContext == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(9);
        }
        if (functions == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(10);
        }
        if (!((element = ((OCStructSymbol)actionContext.getParent()).locateDefinition(location.getProject())) instanceof OCStruct)) {
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(11);
            }
            return list;
        }
        OCStruct structDefinition = (OCStruct)element;
        ArrayList<OCFunctionSymbol> overriding = new ArrayList<OCFunctionSymbol>(functions.size());
        ArrayList<OCFunctionSymbol> baseFunctions = new ArrayList<OCFunctionSymbol>(functions.size());
        ArrayList<String> bodies = new ArrayList<String>(functions.size());
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)location.getFile(), OCCodeStyleSettings.class);
        boolean insertOverride = this.getOption(actionContext, INSERT_OVERRIDE) == Boolean.TRUE;
        boolean insertVirtual = !insertOverride || settings.INSERT_VIRTUAL_WITH_OVERRIDE;
        for (OCFunctionSymbol function : functions) {
            OCFunctionSymbol newFunc = OCCallableUtil.createOverridingFunction(function, (OCNamespaceSymbol)actionContext.getParent(), structDefinition, OCOverrideImplementCppFunctionsHandlerBase.getInheritorVisibility(function, (OCStructSymbol)actionContext.getParent(), location.createContext()), insertOverride, insertVirtual);
            overriding.add(newFunc);
            baseFunctions.add(function);
            bodies.add(OCCallableUtil.defaultFunctionBody(newFunc, !function.isPureVirtual() ? function : null, structDefinition));
        }
        List<OCGenerateUtil.Replacement> list = OCCppDefinitionsUtil.getNewFunctionsReplacements(location, structDefinition, actionContext.getParent(), overriding, baseFunctions, bodies, this.getInlinePolicy(actionContext));
        if (list == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static OCVisibility getInheritorVisibility(OCFunctionSymbol symbol, OCStructSymbol inheritorClassSymbol, @NotNull OCResolveContext context) {
        OCVisibility declaredVisibility;
        if (context == null) {
            OCOverrideImplementCppFunctionsHandlerBase.$$$reportNull$$$0(13);
        }
        declaredVisibility = (declaredVisibility = symbol.getVisibility()) != null ? declaredVisibility : OCVisibility.PRIVATE;
        return OCVisibility.leastVisible(declaredVisibility, OCVisibility.getMaxInheritanceVisibility((OCStructSymbol)symbol.getParent(), inheritorClassSymbol, context));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementCppFunctionsHandlerBase";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenCandidates";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/implement/OCOverrideImplementCppFunctionsHandlerBase";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadOptions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveOptions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doPerformAction";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getReplacements";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInheritorVisibility";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13 -> new IllegalArgumentException(string);
        };
    }
}

