/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateGetterSetterContext;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCFakeFunctionSymbolBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OCGenerateCppGetterSetterHandlerBase
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCGenerateGetterSetterContext> {
    @Override
    @NlsContexts.DialogTitle
    protected String getMembersChooserTitle() {
        String actionTitle = this.getActionTitle();
        return OCGenerateBundle.message("generate.cpp.getter.and.setter.members.chooser.title", actionTitle);
    }

    @Override
    protected boolean allowUnions() {
        return true;
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(@NotNull OCCaretLocation location, @NotNull OCGenerateGetterSetterContext actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        if (location == null) {
            OCGenerateCppGetterSetterHandlerBase.$$$reportNull$$$0(0);
        }
        if (actionContext == null) {
            OCGenerateCppGetterSetterHandlerBase.$$$reportNull$$$0(1);
        }
        if (fields == null) {
            OCGenerateCppGetterSetterHandlerBase.$$$reportNull$$$0(2);
        }
        Project project = actionContext.getProject();
        PsiElement element = ((OCStructSymbol)actionContext.getParent()).locateDefinition(project);
        if (!(element instanceof OCStructLike)) {
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCGenerateCppGetterSetterHandlerBase.$$$reportNull$$$0(3);
            }
            return list;
        }
        OCStructLike structLike = (OCStructLike)element;
        ArrayList<OCFunctionSymbol> symbols = new ArrayList<OCFunctionSymbol>();
        ArrayList<@NlsSafe String> bodies = new ArrayList<String>();
        for (OCDeclaratorSymbol field : fields) {
            String fieldName = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field, project);
            String paramName = OCNamingConventionUtil.applyNamingConvention(fieldName, OCSymbolKind.PARAMETER, project);
            boolean disallowConst = field.getType() instanceof OCPointerType && (!(field.getType() instanceof OCArrayType) || field.isFriendOrStatic()) || field.getType() instanceof OCCppReferenceType;
            OCType paramType = OCTypeUtils.getExtractExpressionType(field.getType(), structLike, disallowConst);
            boolean isStatic = field.isStatic();
            if (actionContext.needGetter(field)) {
                symbols.add(new OCFakeFunctionSymbolBuilder(OCNameSuggester.getUniqueCppGetterName(field, actionContext.getContext(), project)).setReturnType(paramType).setVisibility(OCVisibility.PUBLIC).setContainer((OCSymbolWithQualifiedName)actionContext.getParent()).setIsStatic(isStatic).setIsConst(!isStatic).get());
                bodies.add("{\n return " + field.getName() + ";\n}");
            }
            if (!actionContext.needSetter(field)) continue;
            symbols.add(new OCFakeFunctionSymbolBuilder(OCNameSuggester.getUniqueCppSetterName(field, actionContext.getContext(), project)).setVisibility(OCVisibility.PUBLIC).setContainer((OCSymbolWithQualifiedName)actionContext.getParent()).setIsStatic(isStatic).addParam(paramType, paramName).get());
            StringBuilder body = new StringBuilder("{\n");
            if (paramName.equals(field.getName())) {
                body.append(((OCStructSymbol)actionContext.getParent()).getName()).append("::");
            }
            body.append(field.getName()).append(" = ").append(paramName).append(";\n}");
            bodies.add(body.toString());
        }
        List<OCGenerateUtil.Replacement> list = OCCppDefinitionsUtil.getNewFunctionsReplacements(location, structLike, actionContext.getParent(), symbols, bodies, this.getInlinePolicy(actionContext));
        if (list == null) {
            OCGenerateCppGetterSetterHandlerBase.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateCppGetterSetterHandlerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateCppGetterSetterHandlerBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReplacements";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

