/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.generate.actions.OCObjCActionContext;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfoStorage;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import icons.CidrLangIcons;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclareActionContext
extends OCObjCActionContext<OCMemberSymbol> {
    private final OCClassDeclaration myClassDeclaration;
    protected final OCInterfaceSymbol myPrivateCategory;
    private Target myTarget;

    public OCDeclareActionContext(OCClassSymbol classSymbol, @NotNull OCClassDeclaration classDeclaration, @Nullable OCObjectType type) {
        if (classDeclaration == null) {
            OCDeclareActionContext.$$$reportNull$$$0(0);
        }
        super(classSymbol, classDeclaration, type);
        this.myClassDeclaration = classDeclaration;
        this.myInterfaceSymbol = this.myInterfaceSymbol != null && this.myInterfaceSymbol.getCategoryName() != null && this.myInterfaceSymbol.getCategoryName().isEmpty() ? this.myInterfaceSymbol.getMainInterface(classDeclaration.getProject()) : this.myInterfaceSymbol;
        this.myPrivateCategory = type != null ? (OCInterfaceSymbol)ContainerUtil.find(type.getCategoryInterfaces(), symbol -> symbol.getCategoryName() != null && symbol.getCategoryName().isEmpty()) : null;
    }

    @Override
    @NotNull
    public Collection<OCMemberSymbol> getMemberCandidates() {
        OCMemberInfoStorage storage = new OCMemberInfoStorage(this.myClassDeclaration, true);
        List list = ContainerUtil.mapNotNull((Collection)storage.getClassMemberInfos(this.getContext()), info -> info.getSymbol() instanceof OCMemberSymbol ? (OCMemberSymbol)info.getSymbol() : null);
        if (list == null) {
            OCDeclareActionContext.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public Map<OCSymbol, OCSymbol> createParentsMap(Collection<OCMemberSymbol> members) {
        HashMap<OCSymbol, OCSymbol> map2 = new HashMap<OCSymbol, OCSymbol>();
        for (OCMemberSymbol member : members) {
            if (member instanceof OCMethodSymbol) {
                OCMemberSymbol declaration = member.getAssociatedSymbol(this.getProject());
                map2.put(member, declaration != null && !declaration.isSynthetic() ? declaration.getParent() : member.getParent());
                continue;
            }
            map2.put(member, member.getParent());
        }
        return map2;
    }

    public OCInterfaceSymbol getPrivateCategory() {
        return this.myPrivateCategory;
    }

    public Target getTarget() {
        return this.myTarget;
    }

    public Target[] getAvailableTargets() {
        if (this.myImplementationSymbol.getCategoryName() == null) {
            return new Target[]{Target.INTERFACE, Target.PRIVATE_CATEGORY, Target.IMPLEMENTATION};
        }
        return new Target[]{Target.INTERFACE, Target.IMPLEMENTATION};
    }

    public OCClassSymbol getTargetSymbol() {
        return switch (this.myTarget.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.myInterfaceSymbol;
            case 1 -> this.myPrivateCategory;
            case 2 -> this.myImplementationSymbol;
        };
    }

    public void setTarget(Target target) {
        this.myTarget = target;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDeclaration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCDeclareActionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCDeclareActionContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum Target {
        INTERFACE("declare.action.context.interface", CidrLangIcons.CodeAssistantClass),
        PRIVATE_CATEGORY("declare.action.context.private.category", CidrLangIcons.CodeAssistantClassExtension),
        IMPLEMENTATION("declare.action.context.implementation", CidrLangIcons.CodeAssistantClass);

        @NonNls
        private final String myName;
        private final Icon myIcon;

        private Target(String name, Icon icon) {
            this.myName = name;
            this.myIcon = icon;
        }

        @NlsContexts.Label
        public String getName() {
            return OCGenerateBundle.message(this.myName, new Object[0]);
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

